/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.action;

import com.intellij.codeInsight.completion.actions.BaseCodeCompletionAction;
import com.intellij.codeInsight.inline.completion.InlineCompletion;
import com.intellij.codeInsight.inline.completion.InlineCompletionHandler;
import com.intellij.codeInsight.inline.completion.session.InlineCompletionContext;
import com.intellij.openapi.actionSystem.ActionPromoter;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.terminal.frontend.action.TerminalFrontendDataContextUtils;
import com.intellij.terminal.frontend.view.TerminalView;
import com.intellij.terminal.frontend.view.TerminalViewKt;
import com.intellij.terminal.frontend.view.completion.TerminalCommandCompletionService;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.reworked.TerminalCommandCompletion;
import org.jetbrains.plugins.terminal.block.util.TerminalDataContextUtils;
import org.jetbrains.plugins.terminal.session.ShellName;
import org.jetbrains.plugins.terminal.session.TerminalStartupOptions;
import org.jetbrains.plugins.terminal.session.TerminalStartupOptionsKt;
import org.jetbrains.plugins.terminal.util.TerminalCoroutineKt;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalOutputStatus;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalShellIntegration;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J4\u0010\n\u001a\u0011\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u000b\u00a2\u0006\u0002\b\r2\u0013\u0010\u000e\u001a\u000f\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b\u00a2\u0006\u0002\b\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/terminal/frontend/action/TerminalCommandCompletionActionGen2;", "Lcom/intellij/codeInsight/completion/actions/BaseCodeCompletionAction;", "Lcom/intellij/openapi/actionSystem/ActionPromoter;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "promote", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lorg/jetbrains/annotations/Unmodifiable;", "actions", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.terminal.frontend"})
public final class TerminalCommandCompletionActionGen2
extends BaseCodeCompletionAction
implements ActionPromoter {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Editor editor = TerminalDataContextUtils.INSTANCE.getTerminalEditor(e);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        TerminalView terminalView = TerminalFrontendDataContextUtils.INSTANCE.getTerminalView(e);
        if (terminalView == null) {
            return;
        }
        TerminalView view = terminalView;
        TerminalShellIntegration terminalShellIntegration = TerminalCoroutineKt.getNow(view.getShellIntegrationDeferred());
        if (terminalShellIntegration == null) {
            return;
        }
        TerminalShellIntegration shellIntegration = terminalShellIntegration;
        if (!TerminalDataContextUtils.INSTANCE.isSuppressCompletion(editor2)) {
            InlineCompletionHandler inlineCompletionHandler = InlineCompletion.INSTANCE.getHandlerOrNull(editor2);
            InlineCompletionContext inlineCompletionContext = InlineCompletionContext.Companion.getOrNull(editor2);
            if (inlineCompletionHandler != null && inlineCompletionContext != null) {
                InlineCompletionHandler.hide$default((InlineCompletionHandler)inlineCompletionHandler, (InlineCompletionContext)inlineCompletionContext, null, (int)2, null);
            }
            TerminalCommandCompletionService.Companion.getInstance(project2).invokeCompletion(editor2, TerminalViewKt.activeOutputModel(view), shellIntegration, false);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        Project project = e.getProject();
        Deferred<TerminalStartupOptions> terminalView = TerminalFrontendDataContextUtils.INSTANCE.getTerminalView(e);
        Object object = terminalView;
        ShellName shellName = object != null && (object = object.getStartupOptionsDeferred()) != null && (object = TerminalCoroutineKt.getNow(object)) != null ? TerminalStartupOptionsKt.guessShellName(object) : null;
        Object object2 = terminalView;
        boolean isCommandTypingMode = Intrinsics.areEqual(object2 != null && (object2 = object2.getShellIntegrationDeferred()) != null && (object2 = (TerminalShellIntegration)((Object)TerminalCoroutineKt.getNow(object2))) != null && (object2 = object2.getOutputStatus()) != null ? (TerminalOutputStatus)object2.getValue() : null, (Object)TerminalOutputStatus.TypingCommand.INSTANCE);
        Editor editor = TerminalDataContextUtils.INSTANCE.getTerminalEditor(e);
        e.getPresentation().setEnabledAndVisible((editor != null ? TerminalDataContextUtils.INSTANCE.isOutputModelEditor(editor) : false) && project != null && TerminalCommandCompletion.INSTANCE.isEnabled(project) && shellName != null && TerminalCommandCompletion.INSTANCE.isSupportedForShell(shellName) && isCommandTypingMode);
    }

    @Nullable
    public List<AnAction> promote(@NotNull List<? extends AnAction> actions, @NotNull DataContext context) {
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return CollectionsKt.listOf((Object)((Object)this));
    }
}

