/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListenerEx;
import com.intellij.openapi.externalSystem.util.ExternalSystemActivityKey;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.platform.backend.observation.ActivityKey;
import com.intellij.platform.backend.observation.TrackingUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class AbstractExternalSystemSettings<SS extends AbstractExternalSystemSettings<SS, PS, L>, PS extends ExternalProjectSettings, L extends ExternalSystemSettingsListener<PS>>
implements Disposable {
    @NotNull
    private final NullableLazyValue<ExternalSystemManager<?, ?, ?, ?, ?>> myManager;
    @NotNull
    private final Topic<L> myChangesTopic;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<String, PS> myLinkedProjectsSettings;
    @NotNull
    private final Map<String, PS> myLinkedProjectsSettingsView;

    protected AbstractExternalSystemSettings(@NotNull Topic<L> topic, @NotNull Project project) {
        if (topic == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(0);
        }
        if (project == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(1);
        }
        this.myLinkedProjectsSettings = new HashMap<String, PS>();
        this.myLinkedProjectsSettingsView = Collections.unmodifiableMap(this.myLinkedProjectsSettings);
        this.myChangesTopic = topic;
        this.myProject = project;
        this.myManager = NullableLazyValue.atomicLazyNullable(this::deduceManager);
    }

    public void dispose() {
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(2);
        }
        return project;
    }

    @Nullable
    private ExternalSystemManager<?, ?, ?, ?, ?> deduceManager() {
        return (ExternalSystemManager)ContainerUtil.find(ExternalSystemApiUtil.getAllManagers(), it -> this.equals(it.getSettingsProvider().fun((Object)this.myProject)));
    }

    public boolean showSelectiveImportDialogOnInitialImport() {
        return Boolean.getBoolean("external.system.show.selective.import.dialog");
    }

    public void subscribe(@NotNull ExternalSystemSettingsListener<PS> listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(4);
        }
        Logger.getInstance(AbstractExternalSystemSettings.class).error("Unimplemented subscribe method for " + String.valueOf(this.getClass()));
        this.subscribe(listener);
    }

    @Deprecated(forRemoval=true)
    public void subscribe(@NotNull ExternalSystemSettingsListener<PS> listener) {
        if (listener == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(5);
        }
        this.subscribe(listener, this);
    }

    protected void doSubscribe(@NotNull L listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(6);
        }
        if (parentDisposable == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(7);
        }
        MessageBus messageBus = this.myProject.getMessageBus();
        MessageBusConnection connection = messageBus.connect(parentDisposable);
        connection.subscribe(this.getChangesTopic(), listener);
    }

    public void copyFrom(@NotNull SS settings) {
        if (settings == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(8);
        }
        for (ExternalProjectSettings projectSettings : ((AbstractExternalSystemSettings)settings).getLinkedProjectsSettings()) {
            this.myLinkedProjectsSettings.put(projectSettings.getExternalProjectPath(), projectSettings);
        }
        this.copyExtraSettingsFrom(settings);
    }

    protected abstract void copyExtraSettingsFrom(@NotNull SS var1);

    @NotNull
    public Collection<PS> getLinkedProjectsSettings() {
        Collection<PS> collection = this.myLinkedProjectsSettingsView.values();
        if (collection == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @Nullable
    public PS getLinkedProjectSettings(@NotNull String linkedProjectPath) {
        ExternalProjectSettings ps;
        if (linkedProjectPath == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(10);
        }
        if ((ps = (ExternalProjectSettings)this.myLinkedProjectsSettings.get(linkedProjectPath)) == null) {
            for (ExternalProjectSettings ps1 : this.myLinkedProjectsSettings.values()) {
                if (!ps1.getModules().contains(linkedProjectPath)) continue;
                return (PS)ps1;
            }
        }
        return (PS)ps;
    }

    public void linkProject(@NotNull PS settings) throws IllegalArgumentException {
        PS existing;
        if (settings == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(11);
        }
        if ((existing = this.getLinkedProjectSettings(((ExternalProjectSettings)settings).getExternalProjectPath())) != null) {
            throw new AlreadyImportedProjectException(String.format("Can't link project '%s'. Reason: it's already linked to the IDE project", ((ExternalProjectSettings)settings).getExternalProjectPath()));
        }
        this.myLinkedProjectsSettings.put(((ExternalProjectSettings)settings).getExternalProjectPath(), settings);
        this.onProjectsLinked(Collections.singleton(settings));
    }

    public boolean unlinkExternalProject(@NotNull String linkedProjectPath) {
        ExternalProjectSettings removed;
        if (linkedProjectPath == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(12);
        }
        if ((removed = (ExternalProjectSettings)this.myLinkedProjectsSettings.remove(linkedProjectPath)) == null) {
            return false;
        }
        this.onProjectsUnlinked(Collections.singleton(linkedProjectPath));
        return true;
    }

    public void setLinkedProjectsSettings(@NotNull Collection<? extends PS> settings) {
        if (settings == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(13);
        }
        this.setLinkedProjectsSettings(settings, new ExternalSystemSettingsListener<PS>(){

            @Override
            public void onProjectsLinked(@NotNull Collection<PS> settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(0);
                }
                AbstractExternalSystemSettings.this.onProjectsLinked(settings);
            }

            @Override
            public void onProjectsUnlinked(@NotNull Set<String> linkedProjectPaths) {
                if (linkedProjectPaths == null) {
                    1.$$$reportNull$$$0(1);
                }
                AbstractExternalSystemSettings.this.onProjectsUnlinked(linkedProjectPaths);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "settings";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "linkedProjectPaths";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemSettings$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onProjectsLinked";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onProjectsUnlinked";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void setLinkedProjectsSettings(@NotNull Collection<? extends PS> settings, @NotNull ExternalSystemSettingsListener<PS> listener) {
        if (settings == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(14);
        }
        if (listener == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(15);
        }
        settings = ContainerUtil.filter(settings, ps -> ps.getExternalProjectPath() != null);
        ArrayList<ExternalProjectSettings> added = new ArrayList<ExternalProjectSettings>();
        HashMap<String, PS> removed = new HashMap<String, PS>(this.myLinkedProjectsSettings);
        this.myLinkedProjectsSettings.clear();
        for (ExternalProjectSettings current : settings) {
            this.myLinkedProjectsSettings.put(current.getExternalProjectPath(), current);
        }
        for (ExternalProjectSettings current : settings) {
            ExternalProjectSettings old = (ExternalProjectSettings)removed.remove(current.getExternalProjectPath());
            if (old == null) {
                added.add(current);
                continue;
            }
            this.checkSettings(old, current);
        }
        if (!added.isEmpty()) {
            listener.onProjectsLinked(added);
        }
        if (!removed.isEmpty()) {
            listener.onProjectsUnlinked(removed.keySet());
        }
    }

    protected abstract void checkSettings(@NotNull PS var1, @NotNull PS var2);

    @NotNull
    public Topic<L> getChangesTopic() {
        Topic<L> topic = this.myChangesTopic;
        if (topic == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(16);
        }
        return topic;
    }

    @NotNull
    public L getPublisher() {
        ExternalSystemSettingsListener externalSystemSettingsListener = (ExternalSystemSettingsListener)this.myProject.getMessageBus().syncPublisher(this.myChangesTopic);
        if (externalSystemSettingsListener == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(17);
        }
        return (L)externalSystemSettingsListener;
    }

    protected void fillState(@NotNull State<PS> state) {
        if (state == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(18);
        }
        state.setLinkedExternalProjectsSettings(new TreeSet<PS>(this.myLinkedProjectsSettings.values()));
    }

    protected void loadState(@NotNull State<PS> state) {
        if (state == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(19);
        }
        TrackingUtil.trackActivity((Project)this.myProject, (ActivityKey)ExternalSystemActivityKey.INSTANCE, () -> {
            Set settings = state.getLinkedExternalProjectsSettings();
            if (settings != null) {
                this.setLinkedProjectsSettings(settings, new ExternalSystemSettingsListener<PS>(){

                    @Override
                    public void onProjectsLinked(@NotNull Collection<PS> settings) {
                        if (settings == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        ApplicationManager.getApplication().invokeLater(() -> {
                            AbstractExternalSystemSettings.this.onProjectsLinked(settings);
                            AbstractExternalSystemSettings.this.onProjectsLoaded(settings);
                        }, AbstractExternalSystemSettings.this.myProject.getDisposed());
                    }

                    @Override
                    public void onProjectsUnlinked(@NotNull Set<String> linkedProjectPaths) {
                        if (linkedProjectPaths == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        ApplicationManager.getApplication().invokeLater(() -> AbstractExternalSystemSettings.this.onProjectsUnlinked(linkedProjectPaths), AbstractExternalSystemSettings.this.myProject.getDisposed());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "settings";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "linkedProjectPaths";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemSettings$2";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onProjectsLinked";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onProjectsUnlinked";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
        });
    }

    private void onProjectsLoaded(@NotNull Collection<PS> settings) {
        if (settings == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(20);
        }
        this.getPublisher().onProjectsLoaded(settings);
        ExternalSystemManager manager = (ExternalSystemManager)this.myManager.getValue();
        if (manager != null) {
            ExternalSystemSettingsListenerEx.EP_NAME.forEachExtensionSafe(it -> it.onProjectsLoaded(this.myProject, manager, settings));
        }
    }

    private void onProjectsLinked(@NotNull Collection<PS> settings) {
        if (settings == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(21);
        }
        this.getPublisher().onProjectsLinked(settings);
        ExternalSystemManager manager = (ExternalSystemManager)this.myManager.getValue();
        if (manager != null) {
            ExternalSystemSettingsListenerEx.EP_NAME.forEachExtensionSafe(it -> it.onProjectsLinked(this.myProject, manager, settings));
        }
    }

    private void onProjectsUnlinked(@NotNull Set<String> linkedProjectPaths) {
        if (linkedProjectPaths == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(22);
        }
        this.getPublisher().onProjectsUnlinked(linkedProjectPaths);
        ExternalSystemManager manager = (ExternalSystemManager)this.myManager.getValue();
        if (manager != null) {
            ExternalSystemSettingsListenerEx.EP_NAME.forEachExtensionSafe(it -> it.onProjectsUnlinked(this.myProject, manager, linkedProjectPaths));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 9, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topic";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 9: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemSettings";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedProjectPath";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedProjectPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinkedProjectsSettings";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesTopic";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublisher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 9: 
            case 16: 
            case 17: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "subscribe";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doSubscribe";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLinkedProjectSettings";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "linkProject";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "unlinkExternalProject";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setLinkedProjectsSettings";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fillState";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "onProjectsLoaded";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "onProjectsLinked";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "onProjectsUnlinked";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 9, 16, 17 -> new IllegalStateException(string);
        };
    }

    public static class AlreadyImportedProjectException
    extends IllegalArgumentException {
        public AlreadyImportedProjectException(String s) {
            super(s);
        }
    }

    public static interface State<S> {
        public @Unmodifiable Set<S> getLinkedExternalProjectsSettings();

        public void setLinkedExternalProjectsSettings(Set<S> var1);
    }
}

