/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.collaboration.file.ComplexPathVirtualFileWithoutContent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileEditor.FileEditorManagerKeys;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.editor.ComplexPathVirtualFileSystem;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.pullrequest.GHPRTimelineUIUtil;
import org.jetbrains.plugins.github.pullrequest.GHPRVirtualFile;
import org.jetbrains.plugins.github.pullrequest.GHPRVirtualFileSystem;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.ui.GHPRConnectedProjectViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.GHPRProjectViewModel;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0080\b\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\f\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J\r\u0010\u0017\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0018H\u0016J\r\u0010\u0019\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u0004H\u0016J\r\u0010\u001b\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0018H\u0016J\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001fH\u0016J\b\u0010#\u001a\u0004\u0018\u00010$J\u0014\u0010%\u001a\u00020\u001f2\b\u0010&\u001a\u0004\u0018\u00010'H\u0096\u0082\u0004J\n\u0010(\u001a\u00020)H\u0096\u0080\u0004J\t\u0010*\u001a\u00020\u0004H\u00c6\u0003J\t\u0010+\u001a\u00020\u0006H\u00c6\u0003J\t\u0010,\u001a\u00020\bH\u00c6\u0003J\t\u0010-\u001a\u00020\nH\u00c6\u0003J1\u0010.\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\n\u0010/\u001a\u00020\u0004H\u00d6\u0081\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00060"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRTimelineVirtualFile;", "Lcom/intellij/collaboration/file/ComplexPathVirtualFileWithoutContent;", "Lorg/jetbrains/plugins/github/pullrequest/GHPRVirtualFile;", "fileManagerId", "", "project", "Lcom/intellij/openapi/project/Project;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "pullRequest", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;)V", "getFileManagerId", "()Ljava/lang/String;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRepository", "()Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "getPullRequest", "()Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "getFileSystem", "Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem;", "getName", "Lcom/intellij/openapi/util/NlsSafe;", "getPresentableName", "getPath", "getPresentablePath", "getIcon", "Ljavax/swing/Icon;", "isValid", "", "setValid", "", "valid", "findProjectVm", "Lorg/jetbrains/plugins/github/pullrequest/ui/GHPRConnectedProjectViewModel;", "equals", "other", "", "hashCode", "", "component1", "component2", "component3", "component4", "copy", "toString", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHPRTimelineVirtualFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRTimelineVirtualFile.kt\norg/jetbrains/plugins/github/pullrequest/GHPRTimelineVirtualFile\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n30#2,2:63\n1#3:65\n*S KotlinDebug\n*F\n+ 1 GHPRTimelineVirtualFile.kt\norg/jetbrains/plugins/github/pullrequest/GHPRTimelineVirtualFile\n*L\n42#1:63,2\n*E\n"})
public final class GHPRTimelineVirtualFile
extends ComplexPathVirtualFileWithoutContent
implements GHPRVirtualFile {
    @NotNull
    private final String fileManagerId;
    @NotNull
    private final Project project;
    @NotNull
    private final GHRepositoryCoordinates repository;
    @NotNull
    private final GHPRIdentifier pullRequest;

    public GHPRTimelineVirtualFile(@NotNull String fileManagerId, @NotNull Project project, @NotNull GHRepositoryCoordinates repository, @NotNull GHPRIdentifier pullRequest) {
        Intrinsics.checkNotNullParameter((Object)fileManagerId, (String)"fileManagerId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)pullRequest, (String)"pullRequest");
        super(fileManagerId);
        this.fileManagerId = fileManagerId;
        this.project = project;
        this.repository = repository;
        this.pullRequest = pullRequest;
        this.putUserData(FileEditorManagerKeys.FORBID_TAB_SPLIT, true);
        this.setWritable(false);
    }

    @Override
    @NotNull
    public String getFileManagerId() {
        return this.fileManagerId;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final GHRepositoryCoordinates getRepository() {
        return this.repository;
    }

    @NotNull
    public final GHPRIdentifier getPullRequest() {
        return this.pullRequest;
    }

    @NotNull
    public ComplexPathVirtualFileSystem<?> getFileSystem() {
        return GHPRVirtualFileSystem.Companion.getInstance();
    }

    @NotNull
    public String getName() {
        return GHPRTimelineUIUtil.INSTANCE.getName(this.pullRequest);
    }

    @NotNull
    public String getPresentableName() {
        return GHPRTimelineUIUtil.INSTANCE.getPresentableName(this.project, this.repository, this.pullRequest);
    }

    @NotNull
    public String getPath() {
        ComplexPathVirtualFileSystem<?> complexPathVirtualFileSystem = this.getFileSystem();
        Intrinsics.checkNotNull(complexPathVirtualFileSystem, (String)"null cannot be cast to non-null type org.jetbrains.plugins.github.pullrequest.GHPRVirtualFileSystem");
        return ((GHPRVirtualFileSystem)complexPathVirtualFileSystem).getPath(this.getSessionId(), this.project, this.repository, this.pullRequest, false);
    }

    @NotNull
    public String getPresentablePath() {
        return GHPRTimelineUIUtil.INSTANCE.getPresentablePath(this.project, this.repository, this.pullRequest);
    }

    @Nullable
    public final Icon getIcon() {
        return GHPRTimelineUIUtil.INSTANCE.getIcon(this.project, this.repository, this.pullRequest);
    }

    public boolean isValid() {
        return this.findProjectVm() != null;
    }

    public void setValid(boolean valid) {
    }

    @Nullable
    public final GHPRConnectedProjectViewModel findProjectVm() {
        GHPRConnectedProjectViewModel gHPRConnectedProjectViewModel;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<GHPRProjectViewModel> serviceClass$iv = GHPRProjectViewModel.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        GHPRConnectedProjectViewModel gHPRConnectedProjectViewModel2 = (GHPRConnectedProjectViewModel)((GHPRProjectViewModel)object).getConnectedProjectVm().getValue();
        if (gHPRConnectedProjectViewModel2 != null) {
            GHPRConnectedProjectViewModel gHPRConnectedProjectViewModel3;
            GHPRConnectedProjectViewModel it = gHPRConnectedProjectViewModel3 = gHPRConnectedProjectViewModel2;
            boolean bl = false;
            gHPRConnectedProjectViewModel = Intrinsics.areEqual((Object)it.getRepository(), (Object)this.repository) ? gHPRConnectedProjectViewModel3 : null;
        } else {
            gHPRConnectedProjectViewModel = null;
        }
        return gHPRConnectedProjectViewModel;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GHPRTimelineVirtualFile)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.project, (Object)((GHPRTimelineVirtualFile)other).project)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.repository, (Object)((GHPRTimelineVirtualFile)other).repository)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.pullRequest, (Object)((GHPRTimelineVirtualFile)other).pullRequest);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.project.hashCode();
        result = 31 * result + this.repository.hashCode();
        result = 31 * result + this.pullRequest.hashCode();
        return result;
    }

    @NotNull
    public final String component1() {
        return this.fileManagerId;
    }

    @NotNull
    public final Project component2() {
        return this.project;
    }

    @NotNull
    public final GHRepositoryCoordinates component3() {
        return this.repository;
    }

    @NotNull
    public final GHPRIdentifier component4() {
        return this.pullRequest;
    }

    @NotNull
    public final GHPRTimelineVirtualFile copy(@NotNull String fileManagerId, @NotNull Project project, @NotNull GHRepositoryCoordinates repository, @NotNull GHPRIdentifier pullRequest) {
        Intrinsics.checkNotNullParameter((Object)fileManagerId, (String)"fileManagerId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)pullRequest, (String)"pullRequest");
        return new GHPRTimelineVirtualFile(fileManagerId, project, repository, pullRequest);
    }

    public static /* synthetic */ GHPRTimelineVirtualFile copy$default(GHPRTimelineVirtualFile gHPRTimelineVirtualFile, String string, Project project, GHRepositoryCoordinates gHRepositoryCoordinates, GHPRIdentifier gHPRIdentifier, int n, Object object) {
        if ((n & 1) != 0) {
            string = gHPRTimelineVirtualFile.fileManagerId;
        }
        if ((n & 2) != 0) {
            project = gHPRTimelineVirtualFile.project;
        }
        if ((n & 4) != 0) {
            gHRepositoryCoordinates = gHPRTimelineVirtualFile.repository;
        }
        if ((n & 8) != 0) {
            gHPRIdentifier = gHPRTimelineVirtualFile.pullRequest;
        }
        return gHPRTimelineVirtualFile.copy(string, project, gHRepositoryCoordinates, gHPRIdentifier);
    }

    @NotNull
    public String toString() {
        return "GHPRTimelineVirtualFile(fileManagerId=" + this.fileManagerId + ", project=" + this.project + ", repository=" + this.repository + ", pullRequest=" + this.pullRequest + ")";
    }
}

