/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.de;

import ai.grazie.nlp.langs.Language;
import ai.grazie.nlp.patterns.ext.AbbreviationPatterns;
import ai.grazie.rules.Example;
import ai.grazie.rules.LTRuleInfo;
import ai.grazie.rules.Rule;
import ai.grazie.rules.common.ChangeLemma;
import ai.grazie.rules.common.CommaLicense;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.FeatureRestriction;
import ai.grazie.rules.common.Valence;
import ai.grazie.rules.common.WordSet;
import ai.grazie.rules.de.AdjDeclination;
import ai.grazie.rules.de.AgreementSet;
import ai.grazie.rules.de.Articles;
import ai.grazie.rules.de.Capitalization;
import ai.grazie.rules.de.Case;
import ai.grazie.rules.de.GermanParameters;
import ai.grazie.rules.de.GermanTreePatterns;
import ai.grazie.rules.de.GermanValences;
import ai.grazie.rules.de.PrepositionIssues;
import ai.grazie.rules.de.PunctuationRules;
import ai.grazie.rules.de.ReflexivePronouns;
import ai.grazie.rules.de.SemanticRules;
import ai.grazie.rules.de.SpellingRules;
import ai.grazie.rules.de.StyleRules;
import ai.grazie.rules.de.VerbFormChoice;
import ai.grazie.rules.de.WordSeparation;
import ai.grazie.rules.de.WrongApostrophe;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import ai.grazie.rules.tree.NodeRange;
import ai.grazie.rules.tree.TextRange;
import ai.grazie.rules.tree.TreeSupport;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

class GrammarRules {
    private static final String VERB_TO_SECOND_PLACE_MESSAGE = "Das Verb muss grunds\u00e4tzlich an zweiter Stelle stehen";
    private static final String ARGUMENT_ORDER_MSG = "Falsche Reihenfolge der Akkusativ- und Dativargumente";
    private static final String DAS_DASS_MSG = "\u00dcberpr\u00fcfen Sie die Verwendung von \u201edas\u201c und \u201edass\u201c";
    private static final String MISSING_ZU = "Haben Sie \u201ezu\u201c vergessen?";
    private static final String SEPARABLE_VERB_MAIN_CLAUSE = "In einem Hauptsatz muss das Pr\u00e4fix eines trennbaren Verbs am Ende stehen";
    private static final String WANN_WENN_MSG = "In Nebens\u00e4tzen muss \u201ewenn\u201c und nicht \u201ewann\u201c verwendet werden";
    private static final String WENN_WANN_MSG = "In Fragen (auch indirekten) muss \u201ewann\u201c und nicht \u201ewenn\u201c verwendet werden";
    private static final String IMMER_WENN_WANN_MSG = "Verwenden Sie \u201eimmer wenn\u201c f\u00fcr \u201ejedes Mal\u201c oder \u201ewann immer\u201c f\u00fcr \u201eegal wann\u201c";
    private static final String ALS_WENN_MSG = "Die Konjunktion \u201eals\u201c wird nicht bei Verben im Futur verwendet";
    private static final String KEIN_NICHT_MSG = "Vor Eigennamen ist \u201enicht\u201c zu verwenden";
    private static final String CONJUNCTION_EXPECTED = "Am Anfang eines neuen Satzteils wird eine Konjunktion erwartet";
    private static final String MISSING_EXPL = "Fehlendes Platzhalter-Wort?";
    private static final String MISSING_ES_MSG = "Eine ungew\u00f6hnliche Verk\u00fcrzung macht den Satz unvollst\u00e4ndig";
    private static final String COMPARATIVE_FORM_MSG = "Meinten Sie die Komparativform?";
    private static final String ALS_INSTEAD_WIE_MSG = "wird standardsprachlich \u201eals\u201c und nicht \u201ewie\u201c verwendet";
    private static final String ALS_COMPARISON_MSG = "Nach einem Komparativ wird standardsprachlich \u201eals\u201c und nicht \u201ewie\u201c verwendet";
    private static final String CONJUNCTION_MISMATCH_MSG = "Die Konjunktionen passen nicht zusammen";
    private static final NodePattern directlyAfterMehr = NodePattern.N.directlyAfter(NodePattern.N.form("mehr").noDependents().andNot(NodePattern.N.withHead(NodePattern.N.form("ni(chts?|e(ma(nd|ls)?)?)|vieles"))).andNot(NodePattern.N.withHead(NodePattern.N.pos("SUB.*"))));
    static final NodePattern directlyAfterImmer = NodePattern.N.directlyAfter(NodePattern.N.form("immer"));
    private static final NodePattern multipleNmod = NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("nmod").withNextSibling(NodePattern.N.withHeadRelation("nmod").withDependent("nmod")));
    private static final NodePattern habenVerb = NodePattern.or(WordSet.loadResource((String)"de/haben_verben.txt").lemmaPattern, NodePattern.N.lemma("stehen|sitzen|liegen").and(GermanParameters.VARIANT.withValue("DE")));
    static final NodePattern lastChildPhraseBeforeClauseEnd = NodePattern.custom(node -> {
        Node head = node.head();
        if (head == null) return false;
        if (!head.isBefore((Node)node)) return false;
        if (!head.allDependents().stream().filter(n -> n.isAfter((Node)node)).allMatch(NodePattern.N.withHeadRelation("conj|punct|advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis")::matches)) return false;
        return true;
    });

    GrammarRules() {
    }

    static List<Rule> rules() {
        return List.of(Capitalization.rule(), PrepositionIssues.rule(), VerbFormChoice.rule(), new Rule.PatternRule("Grammar.DAS_DASS", "Verwechslung von \u201edas\u201c und \u201edass\u201c", "\u201eDas\u201c wird als Artikel oder Pronomen verwendet, w\u00e4hrend \u201eDass\u201c eine Konjunktion ist, die einen Nebensatz einf\u00fchrt.", "https://deutsch.lingolia.com/en/vocabulary/easily-confused-words/das-vs-dass", () -> GrammarRules.dasDassConfusion(), new Example("Peter sieht, <b>das</b> die Geldb\u00f6rse fast leer ist.", "Peter sieht, <b>dass</b> die Geldb\u00f6rse fast leer ist.")), new Rule.PatternRule("Grammar.AGREEMENT", "Kongruenz und Rektion", "Artikel, Adjektive, Substantive und Pronomen in einer Substantivgruppe m\u00fcssen in Anzahl, Fall und Geschlecht \u00fcbereinstimmen. Der Fall h\u00e4ngt vom Kontext ab, zum Beispiel von einem Verb oder einer Pr\u00e4position. Au\u00dferdem m\u00fcssen Subjekt und Pr\u00e4dikat in Person und Anzahl \u00fcbereinstimmen.", "https://de.wikipedia.org/wiki/Kongruenz_(Grammatik)", () -> NodePattern.or(NodePattern.or(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound|root|dep")), NodePattern.N.withDependent("det(:poss)?|case|amod|cop|nummod"), Case.misparsedFlatHead, ReflexivePronouns.anyReflexivePronoun.withHeadRelation("expl:pv"), AdjDeclination.substantivatedNeutralAdj).andOr(NodePattern.N.pos("(SUB|PA|PRO).*"), AgreementSet.vocative.pos("EIG.*"), NodePattern.N.pos("ADJ.*").noPos("ADV:.*").andOr(NodePattern.N.noHeadRelation("amod|xcomp"), AdjDeclination.substantivatedNeutralAdj), NodePattern.N.noPos()).and((node, match) -> {
            AgreementSet set = AgreementSet.create(node);
            return set == null ? null : set.check(match);
        }).andNot(WordSeparation.nounSeparation()), GrammarRules.restorePredicativeAdjLikeForm(), GrammarRules.alsSolcheAgreement(), GrammarRules.comparativeAfterJeDesto(), AgreementSet.agreementApposition()), new Example("Das ist <b>eine</b> Tisch.", "Das ist <b>ein</b> Tisch."), new Example("Vielen Dank f\u00fcr <b>deine Brief</b>.", "Vielen Dank f\u00fcr <b>deinen Brief</b>.", "Vielen Dank f\u00fcr <b>deine Briefe</b>."), new Example("Ich habe viele <b>Freunden</b>.", "Ich habe viele <b>Freunde</b>.")).honorCrazyParses(), new Rule.PatternRule("Grammar.VERB_WORD_ORDER", "Die Position des Verbs im Satz", "In der Grundposition eines Aussagesatzes und einer W-Frage steht das Verb an zweiter Stelle. Trennbare Pr\u00e4fixe, Hilfsverben, Modalverben und feste Pr\u00e4positionen stehen am Ende. In Nebens\u00e4tzen steht das Verb am Ende.", "https://deutschegrammatik20.de/wortposition/grundposition-und-satzklammer/", () -> NodePattern.or(GrammarRules.verbWordOrder(), GrammarRules.verbWordOrderInImperativeClause(), GrammarRules.incorrectSubjectPosition()), new Example("Leider ich <b>habe</b> keinen Hund.", "Leider <b>habe</b> ich keinen Hund."), new Example("Sie sagte, dass man vielen Krankheiten <b>kann</b> vorbeugen.", "Sie sagte, dass man vielen Krankheiten vorbeugen <b>kann</b>.")).honorCrazyParses(), new Rule.PatternRule("Grammar.WORD_REPETITION", "Wiederholtes Wort", "Ein wiederholtes Wort (z.\u00a0B. \u201eauch auch\u201c) ist oft ein Fehler.", null, () -> CommonPatterns.repeatedWord((n1, n2) -> {
            boolean um = n2.hasForm("um") && n2.headRelation().equals("compound:prt") && !n1.tree().treeSupport().isAcceptedBySpellchecker(n2.form() + Objects.requireNonNull(n2.head()).form());
            return n1.headRelation().equals(n2.headRelation()) || n1.headRelation().equals("dep") || n2.headRelation().equals("dep") || um;
        }).andNot(PunctuationRules.repeatedAdv).andOr(NodePattern.not(CommonPatterns.capitalizedMiddle).andNot(NodePattern.N.directlyAfter(CommonPatterns.capitalizedMiddle)), NodePattern.N.formCaseSensitive("Sie").directlyAfter(NodePattern.N.formCaseSensitive("Sie"))).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("halb"))).message("Haben Sie versehentlich \u201e$_\u201c wiederholt?"), new Example("Leider <b>habe habe</b> ich keinen Hund.", "Leider <b>habe</b> ich keinen Hund.")), new Rule.PatternRule("Grammar.HABEN_SEIN", "Hilfsverb im Perfekt", "Manche Verben bilden das Perfekt mit \u201esein\u201c und manche mit \u201ehaben\u201c.", null, () -> GrammarRules.habenSein(), new Example("Ich <b>habe</b> gekommen.", "Ich <b>bin</b> gekommen.")).coveringLTRules("HILFSVERB_HABEN_SEIN").coveringLTRules(new LTRuleInfo("IST_GESTANDEN", GermanParameters.VARIANT, "DE")), ReflexivePronouns.rule(), new Rule.PatternRule("Grammar.ARGUMENT_ORDER", "Falsche Reihenfolge der Verbargumente", "Akkusativ- und Dativargumente sollten in einem Satz in einer bestimmten Reihenfolge stehen.", "https://deutschegrammatik20.de/wortposition/wortposition-dativ-akkusativ/", () -> GrammarRules.verbArgumentOrder(), new Example("Ich gebe <b>ihm es</b>.", "Ich gebe <b>es ihm</b>.")), new Rule.PatternRule("Grammar.WANN_WENN_ALS", "Verwechslung von \u201ewann\u201c, \u201ewenn\u201c und \u201eals\u201c", "\u201eWann\u201c wird als Fragewort in Fragen (auch indirekten) verwendet, w\u00e4hrend \u201eWenn\u201c und \u201eAls\u201c in Nebens\u00e4tzen verwendet werden. \u201eAls\u201c wird normalerweise bei Verben im Futur nicht verwendet.", "https://deutsch.lingolia.com/de/wortschatz/wann-wenn-als", () -> GrammarRules.wannWennAlsConfusion(), new Example("<b>Wenn</b> ist endlich wieder Sommer?", "<b>Wann</b> ist endlich wieder Sommer?")), new Rule.PatternRule("Grammar.SEPARABLE_VERBS", "Falsche Verwendung von trennbaren Verben", "In einem Nebensatz wird der trennbare Teil eines Verbs direkt vor einen Verbstamm angef\u00fcgt, w\u00e4hrend er in einem Hauptsatz am Ende des Ausdrucks steht.", "https://de.wiktionary.org/wiki/Hilfe:Haupt-_und_Nebensatzkonjugation", () -> NodePattern.or(GrammarRules.prefixedVerbInMainClause(), GrammarRules.prefixedInfinitivesWithZu()), new Example("Der Zug <b>abf\u00e4hrt</b> um 6:44 Uhr vom Aachener Hauptbahnhof.", "Der Zug <b>f\u00e4hrt</b> um 6:44 Uhr vom Aachener Hauptbahnhof ab.")), Articles.rule(), new Rule.PatternRule("Grammar.ZU_INFINITIVE", "Verwendung von \u201ezu\u201c in Infinitivs\u00e4tzen", "Nach bestimmten Verben und Wendungen muss der Infinitiv mit \u201ezu\u201c verwendet werden.", "https://deutsch.lingolia.com/de/grammatik/verben/infinitiv", () -> NodePattern.or(GrammarRules.missingZuWithInfinitive(), GrammarRules.incorrectUmZu(), GrammarRules.doubleZu()), new Example("Ich lerne, geduldiger <b>sein</b>.", "Ich lerne, geduldiger <b>zu sein</b>.")), new Rule.PatternRule("Grammar.INCOMPLETE_CLAUSE", "Unvollst\u00e4ndiger Satz", "Ein Satz ohne Subjekt oder (Hilfs-)Verb ist unvollst\u00e4ndig.", null, () -> NodePattern.or(GrammarRules.incompleteClause(), GrammarRules.missingEsAfterApos(), GrammarRules.missingEsSubject(), GrammarRules.missingPronominalSubj()), new Example("Der <b>Umtausch</b> nicht mehr m\u00f6glich.", "Der <b>Umtausch</b> ist nicht mehr m\u00f6glich."), new Example("Wie <b>geht'</b> dir?", "Wie <b>geht's</b> dir?", "Wie <b>geht es</b> dir?")), new Rule.PatternRule("Grammar.KEIN_NICHT", "Falsche Verwendung von \u201ekein\u201c und \u201enicht\u201c", "Verwenden Sie \u201enicht\u201c und \u201ekein\u201c richtig.", "https://deutsch.lingolia.com/de/grammatik/satzbau/verneinung", () -> NodePattern.or(GrammarRules.keinNicht(), GrammarRules.sondernWithoutNegation()), new Example("Das ist <b>keine</b> Isabelle.", "Das ist <b>nicht</b> Isabelle.")), new Rule.PatternRule("Grammar.INCORRECT_CONJUNCTION", "Falsche Konjunktion", "Konjunktionen m\u00fcssen korrekt und vollst\u00e4ndig verwendet werden.", null, () -> NodePattern.or(GrammarRules.missingConjunction(), GrammarRules.sowohlAlsAuchMismatch(), GrammarRules.zwischenUndVonBisMismatch()), new Example("Es ist schwieriger, <b>nach</b> man im Gef\u00e4ngnis war.", "Es ist schwieriger, <b>nachdem</b> man im Gef\u00e4ngnis war.")), new Rule.PatternRule("Grammar.ALS_WIE_COMPARISON", "Falsche Vergleichspartikel", "\u201eAls\u201c dr\u00fcckt standardsprachlich Ungleichheit aus, \u201ewie\u201c dagegen Gleichheit.", "https://www.duden.de/sprachwissen/sprachratgeber/alswie", () -> GrammarRules.alsWie(), new Example("Ich habe eine h\u00fcbschere Katze <b>wie</b> deine.", "Ich habe eine h\u00fcbschere Katze <b>als</b> deine.")), WrongApostrophe.rule(), new Rule.PatternRule("Grammar.MISSING_EXPLETIVE", "Fehlendes Korrelat", "Bei manchen Verben sollten Nebens\u00e4tze durch Korrelate angek\u00fcndigt werden.", "https://studlib.de/14338/erziehung_sprachen/braucht_korrelate", () -> GrammarRules.missingExpletive(), new Example("Ich <b>liebe</b>, wie sie sich kleidet.", "Ich <b>liebe es</b>, wie sie sich kleidet.")), new Rule.PatternRule("Grammar.ADJECTIVES_WITHOUT_SUPERLATIVE", "Adjektive ohne Superlativform", "Absolutadjektive k\u00f6nnen nicht gesteigert werden.", "https://www.duden.de/sprachwissen/sprachratgeber/einzigste", () -> GrammarRules.adjWithoutSuperlative(), new Example("Das ist die <b>optimalste</b> L\u00f6sung.", "Das ist die <b>optimale</b> L\u00f6sung.", "Das ist die <b>beste</b> L\u00f6sung.")), new Rule.PatternRule("Grammar.GENITIVE_FORM_ISSUES", "Falsche Platzierung der Genitivform", "Die Genitivform sollte nach dem Bezugswort stehen.", "https://www.studysmarter.de/schule/deutsch/grammatik/genitivattribut/", () -> GrammarRules.genitiveFormBeforeHead(), new Example("Man sollte die <b>Heimatlandes Traditionen</b> nicht vergessen.", "Man sollte die Traditionen <b>des Heimatlandes</b> nicht vergessen.")), new Rule.PatternRule("Grammar.ADJECTIVE_ADVERB_FORM_CHOICE", "Falsche Verwendung von Adjektiv- oder Adverbformen", "Statt der Grundform in Verbindung mit \u201emehr\u201c die Komparativform verwenden.", "https://www.duden.de/sprachwissen/sprachratgeber/steigerung-komparation-deutsche-adjektive", () -> NodePattern.or(GrammarRules.comparativeInsteadMehrWithAdj(), GrammarRules.comparativeInsteadMehrWithAdv()), new Example("Dieses Buch ist <b>mehr interessant</b>.", "Dieses Buch ist <b>interessanter</b>.", "Dieses Buch ist <b>eher interessant</b>.")));
    }

    private static NodePattern alsWie() {
        NodePattern looksLikeComparative = NodePattern.N.pos("ADJ.*KOM.*").andOr(NodePattern.N.withDependent("cop"), NodePattern.N.withHead("advmod", NodePattern.N.withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis|root").noPos(".*AUX.*")).noDependents("advmod"), NodePattern.N.withHeadRelation("amod"));
        NodePattern withDependentComparative = NodePattern.N.withDependent("a(dv)?mod", looksLikeComparative);
        NodePattern withDependentGleichGenauso = NodePattern.N.withDependent("amod|det", NodePattern.or(NodePattern.N.lemma("gleich|derselbe"), NodePattern.N.withDependent("advmod", NodePattern.N.form("(genau)?so"))));
        NodePattern headHasDependentGenauSo = NodePattern.N.withHead("(adv|n)mod|obl", NodePattern.or(NodePattern.N.pos("ADJ:PRD:GRU|ADV:MOD").withDependent("advmod", NodePattern.N.form("(genau)?so")), withDependentGleichGenauso).directlyBefore("AlsWie"));
        NodePattern obl = NodePattern.N.withHeadRelation("obl");
        NodePattern alsToWie = NodePattern.N.form("als").includeIntoReport().correct(NodeCorrector.replace("wie"));
        return NodePattern.or(NodePattern.N.form("wie").withHead("case", NodePattern.or(NodePattern.N.withHead("nmod", NodePattern.N.form("anders|nichts").message("Bei Vergleichen nach \u201e$_\u201c wird standardsprachlich \u201eals\u201c und nicht \u201ewie\u201c verwendet")), NodePattern.or(NodePattern.N.withHead("(adv|n)mod|obl", NodePattern.or(looksLikeComparative, NodePattern.N.withDependent("obj", CommonPatterns.lowercasedHasPos("ADJ.*KOM.*").withDependent("nmod", NodePattern.N.form("nichts"))))), NodePattern.N.pos("PRO.*").andOr(NodePattern.N.withHead("(adv|n)mod|obl", withDependentComparative), obl.withPrevSibling(withDependentComparative))).message(ALS_COMPARISON_MSG))).andOr(NodePattern.N.directlyAfter(NodePattern.N.form("als")).correct(NodeCorrector.replace("")), NodePattern.N.correct(NodeCorrector.replace("als"))), NodePattern.N.form("als").markAs("AlsWie").andOr(NodePattern.N.withHead("case", NodePattern.or(obl.pos("(PRO|SUB).*").withPrevSibling(withDependentGleichGenauso.andNot(obl)), headHasDependentGenauSo)), NodePattern.N.withHeadRelation("dep").directlyBefore(NodePattern.N.form("wie").withHead("case", headHasDependentGenauSo))).andOr(NodePattern.N.directlyBefore(NodePattern.N.form("wie")).correct(NodeCorrector.replace("")), NodePattern.N.correct(NodeCorrector.replace("wie"))).message("Nach der Grundform eines Adjektivs wird standardsprachlich \u201ewie\u201c und nicht \u201eals\u201c verwendet"), NodePattern.N.form("ebenso").includeIntoReport().withHead("advmod", NodePattern.or(NodePattern.N.withDependent("conj", NodePattern.N.withDependent("cc", alsToWie)), NodePattern.N.withDependent("advcl", NodePattern.N.withDependent("mark", alsToWie)))).message("Standardsprachlich wird \u201eebenso\u00a0\u2026 wie\u201c verwendet"));
    }

    private static NodePattern comparativeAfterJeDesto() {
        return NodePattern.N.pos("ADJ:PRD:GRU").noPos("ADJ:PRD:KOM").and(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("root|advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis"))).withDependent("advmod", NodePattern.N.form("je|desto").message("Nach \u201e$_\u201c wird eine Komparativform erwartet").directlyBeforeHead()).correct(GrammarRules.inflectToComparativeForm());
    }

    private static NodePattern comparativeInsteadMehrWithAdj() {
        NodePattern kein = NodePattern.N.lemma("kein(erlei)?");
        NodeCorrector.Relative removeMehr = NodeCorrector.replace(NodePointer.neighbor(-1), "");
        NodeCorrector.Relative toComparativeRemoveMehr = GrammarRules.inflectToComparativeForm().join(removeMehr);
        NodeCorrector.Relative replaceMehrToEher = NodeCorrector.replace(NodePointer.neighbor(-1), "eher");
        return NodePattern.or(NodePattern.N.pos("ADJ.*"), NodePattern.N.pos("PA2:PRD:GRU:VER").pos("VER:[23].*").withDependent("cop")).and(directlyAfterMehr).and(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("root|advmod|advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis"))).noLemma("gemeinsam|akademisch").andNot(NodePattern.N.inFormSequence(1, "mehr", "schlecht", "als", "recht")).andNot(NodePattern.N.withDependent("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.withDependent("nmod|det", kein))).andNot(NodePattern.N.withHead(kein)).andNot(NodePattern.N.lemma("lieb").withHead("xcomp", NodePattern.N.lemma("haben"))).message(COMPARATIVE_FORM_MSG).andOr(NodePattern.N.pos("PA2:.*").correct(NodeCorrector.inflect("PA2.*", "PA2:PRD:KOM:VER").join(removeMehr)), NodePattern.N.withDependent("amod|nmod", NodePattern.N.pos("ADJ:PRD:GRU")).correct(replaceMehrToEher), NodePattern.ROOT.andNot(NodePattern.N.directlyBefore(CommonPatterns.skipForward(CommonPatterns.comma, NodePattern.N.form("als")))).andNot(NodePattern.N.noDependents("nsubj(:pass)?")).correct(toComparativeRemoveMehr).correct(NodeCorrector.inflect("ADJ:.*", "ADJ:PRD:GRU").join(replaceMehrToEher)), NodePattern.N.noDependents("amod").correct(toComparativeRemoveMehr));
    }

    private static NodePattern comparativeInsteadMehrWithAdv() {
        NodePattern mehr = NodePattern.N.form("mehr");
        return NodePattern.N.form("oft|sehr|bald|gerne?").withDependent("advmod", mehr.directlyBeforeHead().noDependents()).withOnlyDependents(mehr).message(COMPARATIVE_FORM_MSG).and((node, match) -> {
            String replacement = node.hasForm("oft") ? "\u00f6fter" : (node.hasForm("sehr") ? "mehr" : (node.hasForm("bald") ? "eher" : "lieber"));
            return match.withCorrector(NodeCorrector.replaceNodes(node.neighbor(-1), node, replacement));
        });
    }

    private static NodeCorrector.Relative inflectToComparativeForm() {
        return NodeCorrector.inflect("ADJ:.*", "ADJ:PRD:KOM");
    }

    private static NodePattern alsSolcheAgreement() {
        return NodePattern.N.lemma("solch").markAs("Solch").withDependent("case|mark", NodePattern.N.form("als")).withHead("nmod|obl", NodePattern.or(NodePattern.N.withDependent("det(:poss)?", NodePattern.N.noForm("[msd]?ein|ihr|unser|euer").and((node, match) -> {
            String detForm = node.lowForm();
            String detEnding = detForm.endsWith("r") ? "er" : (detForm.endsWith("s") ? "es" : (detForm.endsWith("m") ? "em" : (detForm.endsWith("n") ? "en" : "e")));
            String solchForm = "solch" + detEnding;
            Node solch = match.getMarkedNode("Solch");
            if (solch.lowForm().equals(solchForm)) {
                return null;
            }
            return match.withCorrector(NodeCorrector.replace(solch, solchForm));
        })), NodePattern.N.withDependent("case", AdjDeclination.anyFusedPreposition.andOr(NodePattern.N.form(".+m").and(NodePattern.markedNodeMatches("Solch", NodePattern.N.noForm("solchem").correct(NodeCorrector.replace("solchem")))), NodePattern.N.form(".+n").and(NodePattern.markedNodeMatches("Solch", NodePattern.N.noForm("solchen").correct(NodeCorrector.replace("solchen")))), NodePattern.N.form(".+r").and(NodePattern.markedNodeMatches("Solch", NodePattern.N.noForm("solcher").correct(NodeCorrector.replace("solcher")))))), NodePattern.N.withDependent("det(:poss)?", NodePattern.N.form("[msd]?ein|ihr|unser|euer")).andOr(NodePattern.N.onlyPos(".*MAS.*").and(NodePattern.markedNodeMatches("Solch", NodePattern.N.noForm("solcher").correct(NodeCorrector.replace("solcher")))), NodePattern.N.onlyPos(".*NEU.*").and(NodePattern.markedNodeMatches("Solch", NodePattern.N.noForm("solches").correct(NodeCorrector.replace("solches")))))).markAs("Head")).message("Wenn das Pronomen \u201e$_\u201c sich auf das Nomen \u201e$Head\u201c bezieht, stimmen sie in Numerus, Kasus und Genus \u00fcberein");
    }

    private static NodePattern restorePredicativeAdjLikeForm() {
        NodePattern looksLikeComparative = CommonPatterns.possiblyConj(NodePattern.or(NodePattern.N.directlyAfter(NodePattern.N.form("je|desto")), NodePattern.N.withDependent("advcl", NodePattern.not(GermanTreePatterns.clause).and(CommonPatterns.closestDepToHead.afterHead()).pos("ADV.*").withDependent("mark", NodePattern.N.form("als"))), NodePattern.N.withDependent("advmod", NodePattern.N.form("viel").directlyBeforeHead().noDependents()), NodePattern.N.markAs("Comp").withDependent("obl|nmod", NodePattern.N.withDependent("case", NodePattern.N.form("als").directlyAfter("Comp"))), NodePattern.N.withHeadRelation("advmod").form("sp\u00e4te")).noDependents("advmod", NodePattern.N.form("mehr|weniger"))).noForm("anders");
        return NodePattern.or(CommonPatterns.possiblyConj(CommonPatterns.skipUp("flat", GermanTreePatterns.clause.withDependent("cop|aux:pass", NodePattern.N.lemma("sein").markAs("Copula")))).andNot(GermanTreePatterns.clause.noDependents("cop|aux:pass", NodePattern.N.lemma("sein"))).noForm(".+er").andNot(NodePattern.N.form("lange").withDependent("advmod", GermanTreePatterns.whPhrase)), CommonPatterns.possiblyConj(NodePattern.N.withHead("advmod", NodePattern.N.withHeadRelation("root|advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis").andNot(WordSeparation.withDependentsDetCaseAmod)).noDependents("advmod", NodePattern.N.form("am"))).andOr(NodePattern.N.pos("ADJ:.*:KOM:SOL"), NodePattern.N.pos("ADJ:.*:GRU:SOL").noPos("ADJ:.*:KOM:SOL").noForm(".+er|lange|sukzessive|rigide|schicke"))).andNot(NodePattern.N.form("anderes").directlyAfter(NodePattern.N.form("(et)?was"))).andOr(NodePattern.N.form("anderes").correct(NodeCorrector.replace("anders")).message("Meinten Sie \u201eanders\u201c?"), looksLikeComparative.pos("ADJ.*").noPos("ADJ:PRD:KOM.*").correct(NodeCorrector.inflect("ADJ.*", "ADJ:PRD:KOM")).message("Hier passt eine Komparativform besser"), NodePattern.N.pos("ADJ:(NOM|GEN|DAT|AKK).*(GRU|KOM).*").noPos("ADJ:PRD.*").and(node -> node.lemmaReadings().stream().noneMatch(r -> node.form().equals(r))).correct(NodeCorrector.inflect("ADJ.*(GRU|KOM).*", "ADJ:PRD:$1")).andOptionally(NodePattern.N.form(".+e").noPos(".*KOM.*").and(CommonPatterns.trueAlsoForConjHead(NodePattern.N.noDependents("advmod", NodePattern.N.form("mehr|so|sehr|wenig|zu")).noDependents("obl|nmod", NodePattern.N.withPhraseStart(NodePattern.N.withHeadRelation("nummod")).beforeHead()))).correct(NodeCorrector.inflect("ADJ.*GRU.*", "ADJ:PRD:KOM"))).message("In Verbindung mit einem Verb wird das Adjektiv nicht gebeugt")).andNot(directlyAfterMehr).noPos("(SUB|PRO).*|.*PRD.*").markAs("Adj").noForm("spitze|folgende[rs]?|unpr\u00e4zise|einiges").andNot(NodePattern.N.inFormSequence(1, "und|oder", "(ander|\u00e4hnlich)es").withHeadRelation("conj")).andNot(NodePattern.N.form("lange").withDependent("ccomp")).noDependents("det(:poss)?|case").noDependents("nmod", Capitalization.etwasNichtsVielWenig.noDependents("det(:poss)?")).and(CommonPatterns.trueAlsoForConjHead(NodePattern.not(NodePattern.N.withDependent("nsubj|expl", NodePattern.N.form("es")).and(NodePattern.markedNodeMatches("Copula", NodePattern.N.pos(".*PLU.*")))))).andNot(NodePattern.N.pos(".*INF.*").and(CommonPatterns.possiblyConj(NodePattern.N.withDependent("mark", NodePattern.N.form("zu"))))).andNot(NodePattern.N.noSpaceAfter().directlyBefore(GermanTreePatterns.anyQuotation).noSpaceBefore().directlyAfter(GermanTreePatterns.anyQuotation));
    }

    private static NodePattern missingExpletive() {
        NodePattern dassArg = NodePattern.N.afterHead().withDependent("mark|advmod", GermanTreePatterns.firstInPhraseAfterCommasOrConj.andOr(GermanTreePatterns.whPhrase, NodePattern.N.form("wenn|dass|ob")).noDependents()).markAs("Dass");
        NodePattern zuInfArg = NodePattern.N.afterHead().andOr(NodePattern.N.onlyPos("VER:EIZ:.*"), NodePattern.N.withDependent("mark", NodePattern.N.form("zu").markAs("Zu").directlyBeforeHead())).noDependents("mark", NodePattern.N.form("um")).markAs("InfZu");
        NodePattern missingSubjExplEs = NodePattern.N.pos("VER:3:SIN:.*").noPos(".*(EIZ|[13]:SIN:KJ1).*").and(CommonPatterns.possiblySkipUp("aux", NodePattern.N.withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis|root").noHeadRelation("xcomp").withDependent("xcomp", NodePattern.N.withDependent("mark", NodePattern.N.form("zu")).markAs("XComp")).noDependents("[cn]subj(:pass)?|dep").noDependents("mark", NodePattern.N.form("zu")).noDependents(NodePattern.N.noHeadRelation("punct").after("XComp")).noHeadRelation("conj").noLemma("sein|werden|scheinen")));
        return NodePattern.or(NodePattern.or(NodePattern.N.withDependent("ccomp", dassArg), NodePattern.N.withHeadRelation("ccomp").withDependent("conj", dassArg), NodePattern.N.withDependent("xcomp", zuInfArg), NodePattern.N.withHeadRelation("xcomp").withDependent("conj", zuInfArg)).noDependents("cop|aux:pass"), NodePattern.N.withDependent("csubj", zuInfArg).onlyPos("ADJ:PRD.*").withDependent("cop", NodePattern.not(CommonPatterns.firstChildPhrase).beforeHead()).noDependents("expl|nsubj(:pass)?")).andOr(NodePattern.N.withDependent("cop", NodePattern.N.markAs("Anchor")), NodePattern.N.withDependent(".*", ReflexivePronouns.anyReflexivePronoun.markAs("Anchor")), NodePattern.N.withDependent("mark", NodePattern.N.form("zu").directlyAfter(NodePattern.N.markAs("Anchor"))), NodePattern.or(NodePattern.N.withHeadRelation("ccomp|a(dv)?cl"), NodePattern.N.withDependent("mark", GermanTreePatterns.firstInPhraseAfterCommasOrConj), NodePattern.N.withDependent("aux(:pass)?", NodePattern.N.andOptionally(missingSubjExplEs.markAs("AddExpletiveEs")))).directlyAfter(NodePattern.N.markAs("Anchor")), NodePattern.N.markAs("Anchor").andOptionally(missingSubjExplEs.markAs("AddExpletiveEs"))).andOptionally(NodePattern.markedNodeMatches("Dass", NodePattern.N.withPhraseStart(NodePattern.not(NodePattern.PUNCT).directlyAfter(NodePattern.N.alreadyMarkedAs("Anchor").markAs("InsertStartComma"))))).andOptionally(NodePattern.markedNodeMatches("Dass", NodePattern.N.withPhraseEnd(NodePattern.not(CommonPatterns.lastToken).andNot(NodePattern.PUNCT).andNot(NodePattern.N.directlyBefore(NodePattern.PUNCT)).markAs("InsertEndComma")))).andOptionally(NodePattern.markedNodeMatches("InfZu", NodePattern.N.withPhraseStart(NodePattern.not(NodePattern.PUNCT).directlyAfter(NodePattern.N.markAs("InsertStartComma"))))).andOptionally(NodePattern.markedNodeMatches("InfZu", NodePattern.N.withPhraseEnd(NodePattern.not(CommonPatterns.lastToken).andNot(NodePattern.PUNCT).andNot(NodePattern.N.directlyBefore(NodePattern.PUNCT)).markAs("InsertEndComma")))).noDependents("obj", NodePattern.not(ReflexivePronouns.anyReflexivePronoun)).noDependents(NodePattern.N.form("es|damit|davon|darauf")).noDependents("ob[lj]", NodePattern.N.withDependent("case", NodePattern.N.form("mit|von|auf"))).and((verb, match) -> {
            List<Valence> valences;
            NodeCorrector insertEndComma;
            Node anchor = match.getMarkedNode("Anchor");
            Node zu = match.findMarkedNode("Zu");
            Node startCommaAnchor = match.findMarkedNode("InsertStartComma");
            Node endCommaAnchor = match.findMarkedNode("InsertEndComma");
            NodeCorrector insertStartComma = startCommaAnchor != null ? NodeCorrector.insertAfter(startCommaAnchor, ",") : null;
            NodeCorrector nodeCorrector = insertEndComma = endCommaAnchor != null ? NodeCorrector.insertAfter(endCommaAnchor, ",") : null;
            if (match.findMarkedNode("AddExpletiveEs") != null) {
                return match.withCorrector(NodeCorrector.insertAfter(anchor, " es").join(insertStartComma).join(insertEndComma));
            }
            Set<String> expletives = Set.of("es", "damit", "davon", "darauf");
            if (match.findMarkedNode("InfZu") != null) {
                boolean isMoegenFullVerb;
                String infinitiveWithZu = match.getMarkedNode("InfZu").headRelation();
                boolean bl = isMoegenFullVerb = verb.hasLemma("m\u00f6gen") && !verb.hasPos("VER:MOD:1:.*:KJ[12]") && !verb.hasHeadRelation("aux.*");
                if (infinitiveWithZu.equals("csubj") || infinitiveWithZu.equals("xcomp") && isMoegenFullVerb) {
                    match = match.withCorrector(NodeCorrector.insertAfter(anchor, " es").join(insertStartComma).join(insertEndComma));
                    if (isMoegenFullVerb && verb.hasForm("mochte(s?t|n)?") && zu != null) {
                        match = match.withCorrector(NodeCorrector.replace(verb, verb.form().replaceFirst("mo", "m\u00f6")).join(NodeCorrector.removeNode(zu)));
                    }
                    return match;
                }
            }
            if ((valences = GermanValences.get(verb)).isEmpty()) {
                return null;
            }
            String depClauseType = match.findMarkedNode("Dass") != null ? "dass" : "zuInf";
            if ((valences = valences.stream().filter(as -> as.has(depClauseType) && as.hasAnyArgument(expletives)).toList()).isEmpty()) {
                return null;
            }
            List<NodeCorrector> correctors = valences.stream().flatMap(as -> as.arguments.stream().filter(arg -> expletives.contains(arg.presentable))).map(arg -> NodeCorrector.insertAfter(anchor, " " + arg.presentable).join(insertStartComma).join(insertEndComma)).toList();
            return match.withCorrectors(correctors);
        }).message(MISSING_EXPL);
    }

    private static NodePattern missingConjunction() {
        return GermanTreePatterns.firstInPhraseAfterCommasOrConj.withHeadRelation("mark").andOr(NodePattern.N.form("nach").correct(NodeCorrector.replace("nachdem")), NodePattern.N.form("vor").correct(NodeCorrector.replace("bevor"))).withHead(NodePattern.not(NodePattern.N.withHeadRelation("xcomp"))).message(CONJUNCTION_EXPECTED);
    }

    private static NodePattern sowohlAlsAuchMismatch() {
        NodePattern alsAuch = NodePattern.N.inFormSequence(0, "als", "auch");
        NodePattern withAlsAuch = NodePattern.N.withDependent("case|cc", alsAuch);
        return NodePattern.N.form("sowohl").includeIntoReport().andOr(NodePattern.N.directlyBefore(alsAuch.reportEverythingTouched()).noHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound").message("Meinten Sie \u201esowie\u201c?").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(2), "sowie")), NodePattern.N.withHead(NodePattern.N.withDependent("conj", NodePattern.N.withDependent("advmod", NodePattern.N.inFormSequence(1, "(und|oder|aber|sowie)", "auch").reportEverythingTouched().correct(NodeCorrector.replace(NodePointer.neighbor(-1), "als")).message(CONJUNCTION_MISMATCH_MSG)).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("conj").and(withAlsAuch))))), NodePattern.or(NodePattern.N.withHead(NodePattern.N.withHeadRelation("conj").noDependents("conj")).andNot(NodePattern.N.before(NodePattern.N.inFormSequence(0, "als", "auch"))).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("als"))).and(SpellingRules.typoReplacement("und")), NodePattern.N.withHead("advmod", NodePattern.N.noDependents("conj")).message("F\u00fcgen Sie \u201eals auch\u201c nach \u201esowohl\u201c hinzu oder \u201esowohl\u201c ist \u00fcberfl\u00fcssig").correct(NodeCorrector.replace("", "auch")), NodePattern.N.withHeadRelation("cc").withNextSibling(NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound").withNextSibling(NodePattern.N.withDependent("case", NodePattern.N.inFormSequence(0, "bis", "hin", "zu").reportEverythingTouched().message(CONJUNCTION_MISMATCH_MSG).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(2), "als auch"))))).correct(NodeCorrector.replace("von"))));
    }

    private static NodePattern zwischenUndVonBisMismatch() {
        NodePattern obl = NodePattern.N.withHeadRelation("obl");
        NodePattern withDependentBis = NodePattern.N.withDependent("case", NodePattern.N.form("bis").markAs("Bis"));
        return NodePattern.or(NodePattern.N.form("zwischen").withHead("case", NodePattern.N.withDependent("nmod", NodePattern.N.withDependent("case", NodePattern.N.form("bis").andOptionally(NodePattern.not(NodePattern.N.before(NodePattern.N.inFormSequence(0, "hin", "zu"))).correct(NodeCorrector.replace("und")))))), NodePattern.N.form("seit").directlyBeforeHead().withHead("case", NodePattern.or(obl.withNextSibling(obl.and(withDependentBis)), NodePattern.N.withDependent("nmod", withDependentBis))).correct(NodeCorrector.replace("zwischen").join(NodeCorrector.replace(NodePointer.marked("Bis"), "und")))).andOptionally(NodePattern.not(NodePattern.N.form("zwischen").withHead(NodePattern.N.withHeadRelation("nmod"))).correct(NodeCorrector.replace("von"))).message(CONJUNCTION_MISMATCH_MSG);
    }

    private static NodePattern keinNicht() {
        return NodePattern.N.form("kein(e[rmns]?)?").directlyBeforeHead().withHead("det", NodePattern.N.pos("EIG.*").andNot(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_NODE))).correct(NodeCorrector.replace("nicht")).message(KEIN_NICHT_MSG);
    }

    private static NodePattern sondernWithoutNegation() {
        NodePattern someNegation = NodePattern.or(NodePattern.N.pos("NEG"), NodePattern.N.form("(nirgend|kein|nichts|weder|weniger|mitnichten).*"), NodePattern.N.inFormSequence(0, "alles", "andere", "als"));
        return NodePattern.N.form("sondern").withHead("cc", NodePattern.N.withHead("conj", NodePattern.not(NodePattern.N.inPhrase(NodePattern.N.withDependent(".*", NodePattern.or(someNegation, NodePattern.N.withDependent(".*", NodePattern.or(someNegation, NodePattern.N.withDependent(".*", NodePattern.or(someNegation, NodePattern.N.withDependent(".*", someNegation))))))))).includeIntoReport())).message("Haben Sie die Verneinung vergessen?");
    }

    private static NodePattern looksLikeHabenVerb() {
        WordSet seinVerb = WordSet.loadResource("de/sein_verben.txt");
        WordSet habenVerbWennTransitiv = WordSet.loadResource("de/transitiv_haben_und_sein_verben.txt");
        return NodePattern.not(seinVerb.lemmaPattern).andNot(habenVerbWennTransitiv.lemmaPattern).noForm("gewohnt").withDependent("obj", NodePattern.N.pos("(SUB|EIG|PRO).*AKK.*").noPos(".*DAT.*").noDependents("case").noDependents("conj", NodePattern.N.pos(".*DAT.*"))).withDependent("nsubj(:pass)?").noDependents("expl").noDependents("aux(:pass)?", NodePattern.not(NodePattern.N.alreadyMarkedAs("Sein"))).noDependents("mark", NodePattern.N.form("zu"));
    }

    private static NodePattern missingPronominalSubj() {
        NodePattern inQuestion = NodePattern.N.inPhrase(NodePattern.N.withPhraseEnd(CommonPatterns.questionMark));
        NodePattern subjShouldPrecede = GermanTreePatterns.firstInPhraseAfterCommasOrConj.andNot(inQuestion);
        return NodePattern.or(NodePattern.N.inFormSequence(0, "habe", "mich").andOr(subjShouldPrecede.correct(NodeCorrector.replace("ich habe")), NodePattern.N.correct(NodeCorrector.insertAfter(" ich"))), NodePattern.N.inFormSequence(0, "hast", "dich").andOr(subjShouldPrecede.correct(NodeCorrector.replace("du hast")), NodePattern.N.correct(NodeCorrector.insertAfter(" du"))), NodePattern.N.inFormSequence(0, "habt", "euch").andOr(subjShouldPrecede.correct(NodeCorrector.replace("ihr habt")), NodePattern.N.correct(NodeCorrector.insertAfter(" ihr")))).andNot(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("nsubj"))).andNot(NodePattern.N.directlyAfter(CommonPatterns.lowercasedHasPos("PRO.*"))).andNot(NodePattern.N.withHead("aux", NodePattern.N.withHeadRelation("conj"))).message("Fehlendes Subjekt?");
    }

    private static NodePattern incompleteClause() {
        NodePattern withoutNominalDependents = NodePattern.N.noDependents("det|amod|case");
        NodePattern adjectiveOrAdverb = NodePattern.N.pos("ADJ.*|ADV:MOD");
        NodePattern needCopula = NodePattern.not(NodePattern.or(NodePattern.N.withDependent("ob[jl]"), NodePattern.N.withDependent("dep", NodePattern.not(GermanTreePatterns.whPhrase)), NodePattern.N.withHeadRelation("obj|dep|ccomp").andNot(adjectiveOrAdverb), NodePattern.N.withPhraseEnd(CommonPatterns.skipBack(NodePattern.PUNCT, NodePattern.N.withHeadRelation("cc"))), NodePattern.or(GermanTreePatterns.uncountableNoun, NodePattern.N.form(".+([hk]eit|ung)")).withDependent("nsubj", NodePattern.N.form("ich|du|wir|ihr|er|sie"))));
        NodePattern needPerfectHaben = NodePattern.or(habenVerb, GrammarRules.looksLikeHabenVerb()).pos(".*PA2.*");
        return NodePattern.N.anyPos().markAs("Anchor").andOr(NodePattern.N.withHeadRelation("parataxis|obj|obl|appos|root|dep|ccomp").andNot(NodePattern.N.withHeadRelation("obl|ccomp").withDependent("acl")).andNot(NodePattern.N.withHeadRelation("ccomp").withNextSibling(NodePattern.N.withHeadRelation("ccomp"))).andOr(NodePattern.N.withDependent("nsubj(:pass)?", NodePattern.not(NodePattern.N.inFormSequence(0, "was", "f\u00fcr")).andNot(NodePattern.N.inFormSequence(1, "so", "was", "von")).andNot(NodePattern.N.form("alles")).noPos("VER.*|KON:UNT").noDependents(NodePattern.PUNCT).markAs("Subj")).noPos("PA2.*").andNot(NodePattern.N.withHead("obl", GermanTreePatterns.clause.withDependent("obl", NodePattern.not(NodePattern.N.alreadyMarkedAs("Anchor")))).noDependents("mark").afterHead()), NodePattern.or(NodePattern.N.withDependent("nsubj", NodePattern.N.anyPos().markAs("Subj")).withDependent("obj"), NodePattern.N.withDependent("obj", NodePattern.N.pos(".*NOM.*").beforeHead().markAs("Subj")).noDependents("nsubj")).pos("PA2.*").noDependents("dep").noDependents(NodePattern.not(NodePattern.PUNCT).afterHead()).andNot(NodePattern.N.withOnlyDependents(NodePattern.or(NodePattern.N.alreadyMarkedAs("Subj"), NodePattern.PUNCT, NodePattern.N.pos("NEG")))), NodePattern.ROOT.withOnlyDependents(NodePattern.N.withHeadRelation("dep|punct|advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis")).onlyPos("(PRO|SUB).*").withDependent("dep", NodePattern.N.directlyBeforeHead().pos("(PRO|SUB).*").markAs("Subj"))).andOr(NodePattern.N.pos("ADJ:PRD.*").withPhraseStart(GermanTreePatterns.whPhrase).markAs("VerbAnchor"), adjectiveOrAdverb.withHeadRelation("ccomp").markAs("VerbAnchor").andNot(NodePattern.N.withDependent("advmod", NodePattern.N.afterHead())).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("als").directlyBefore(NodePattern.N.withHeadRelation("case")))).noDependents("dep", NodePattern.N.pos("VER.*")), NodePattern.N.withHeadRelation("root|parataxis|appos").withDependent(".*", GermanTreePatterns.firstInPhraseAfterCommasOrConj.noHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis").andNot(NodePattern.N.directlyBefore(NodePattern.N.pos("VER:AUX.*"))).andOr(NodePattern.N.withDependent("mark", CommonPatterns.firstChildPhrase.markAs("VerbAnchor")), NodePattern.N.withPhraseEnd(NodePattern.N.markAs("VerbAnchor")))), GermanTreePatterns.whPhrase.withOnlyDependents(NodePattern.or(NodePattern.N.afterHead(), NodePattern.PUNCT, NodePattern.N.withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis"))).markAs("VerbAnchor"), NodePattern.not(CommonPatterns.severalDependents("nsubj")).withHead("dep", NodePattern.N.noHeadRelation("dep")).noDependents("mark").withDependent("nsubj", NodePattern.N.beforeHead().markAs("VerbAnchor")), NodePattern.N.withPhraseEnd(CommonPatterns.skipBack(NodePattern.PUNCT, NodePattern.N.withPhraseEnd(NodePattern.N.markAs("VerbAnchor").andNot(NodePattern.N.withHead(NodePattern.N.pos("VER.*").noHeadRelation("root|conj|cc"))))))).andNot(NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("ccomp").pos("VER.*"))).noPos("(PRO:DEM|ART).*").andNot(NodePattern.N.withDependent("mark", NodePattern.N.form("zu")).withDependent("case")).andOr(NodePattern.ROOT.and(needPerfectHaben).withOnlyDependents(NodePattern.or(NodePattern.N.beforeHead(), NodePattern.PUNCT)).pos(".*PA2:PRD.*").noDependents(GermanTreePatterns.whPhrase).noDependents("mark"), NodePattern.not(withoutNominalDependents.andOr(NodePattern.N.pos("VER:IMP.*"), CommonPatterns.lowercasedHasPos("VER:(MOD:)?([123]|IMP).*"))).noPos("VER:(MOD:)?[123].*")).noDependents("aux(:pass)?|cop").noDependents("nsubj(:pass)?|i?obj|obl|nmod|compound|advmod|det(:poss)?", NodePattern.N.withDependent("aux(:pass)?|cop")).noDependents("punct", CommonPatterns.ellipsis).noDependents("xcomp", NodePattern.N.between("Subj", "Anchor")).noDependents("conj", NodePattern.or(NodePattern.N.pos("VER:(MOD:)?[123].*"), NodePattern.N.withDependent("aux(:pass)?|cop"))).andNot(CommonPatterns.severalDependents("conj")).andNot(NodePattern.N.withOnlyDependents(NodePattern.or(NodePattern.N.afterHead(), NodePattern.N.withHeadRelation("det|amod|case|punct|cc")))).andNot(NodePattern.N.withOnlyDependents(NodePattern.N.afterHead())).andNot(NodePattern.N.withPhraseStart(NodePattern.or(CommonPatterns.comma, NodePattern.N.directlyAfter(CommonPatterns.comma))).withPhraseEnd(NodePattern.or(CommonPatterns.comma, NodePattern.N.directlyBefore(CommonPatterns.comma)))).andNot(NodePattern.N.withHead(NodePattern.N.pos("VER:AUX.*"))).andNot(NodePattern.N.directlyBefore(NodePattern.N.pos("VER:AUX.*"))).noDependents("[an]mod|nsubj(:pass)?", NodePattern.N.withDependent("aux(:pass)?|cop")).andNot(NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("aux(:pass)?|cop").andNot(NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("nsubj(:pass)?"))))).andNot(NodePattern.N.directlyBefore(CommonPatterns.colon)).noLabel(".*").andNot(NodePattern.N.form(".*en").noDependents("det|case").and(NodePattern.markedNodeMatches("Subj", CommonPatterns.closestDepToHead.andOr(NodePattern.N.pos("(SUB|EIG).*"), NodePattern.N.form("wir|sie"))))).andNot(NodePattern.or(NodePattern.N.form(".*e"), NodePattern.N.pos("SUB.*")).noDependents("det|case").and(NodePattern.markedNodeMatches("Subj", NodePattern.N.form("ich")))).andNot(NodePattern.N.form(".*st").noDependents("det|case").and(NodePattern.markedNodeMatches("Subj", NodePattern.N.form("du")))).andNot(NodePattern.N.pos("(ADJ|SUB).*").noDependents("mark").directlyAfter("Subj").and(NodePattern.markedNodeMatches("Subj", NodePattern.N.form("ihr|du")))).andNot(NodePattern.N.noSpaceBefore().directlyAfter(CommonPatterns.HYPHEN_LIKE_NODE)).andNot(NodePattern.N.withPhraseEnd(NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.form("\\.\\.\\.|\u2026"), CommonPatterns.HYPHEN_LIKE_NODE)))).noForm("bedingt(en?)?").andNot(NodePattern.markedNodeMatches("VerbAnchor", NodePattern.N.directlyBefore(SpellingRules.secondPlRoot.form("seit")))), NodePattern.N.afterHead().markAs("Subj").withHead("nsubj(:pass)?", NodePattern.N.pos("VER.*").withDependent("nsubj(:pass)?", NodePattern.not(NodePattern.N.alreadyMarkedAs("Subj")))).withDependent("dep", NodePattern.N.markAs("VerbAnchor"))).andNot(NodePattern.N.withPhraseEnd(CommonPatterns.dot.noSpaceBefore().directlyAfter(NodePattern.or(NodePattern.N.form("\\d+"), NodePattern.custom(n -> AbbreviationPatterns.withPunctCaseSensitive((Language)Language.GERMAN).matches((CharSequence)n.form())))))).andNot(VerbFormChoice.deVerbsOnlyParticiple).andNot(NodePattern.N.pos("ADJ:PRD:GRU").withDependent("nsubj", NodePattern.N.form("\\d+"))).and((head, match) -> {
            Node anchor = match.getMarkedNode("VerbAnchor");
            if (anchor.form().length() < 2) {
                anchor = anchor.prevNode();
            }
            Node subject = match.getMarkedNode("Subj");
            String verbLemma = needCopula.matches(head) ? "sein" : (needPerfectHaben.matches(head) ? "haben" : null);
            List<NodeCorrector> correctors = verbLemma != null ? VerbFormChoice.calculatePossibleVerbReplacements(head, match, verbLemma, anchor) : List.of();
            return match.withCorrectors(correctors).withMessage("Fehlt ein Verb?").withReportedNodes(subject, anchor);
        });
    }

    private static String getHabenToSeinForm(String haben, boolean ichSubj) {
        return switch (haben) {
            case "hast" -> "bist";
            case "hat" -> "ist";
            case "haben" -> "sind";
            case "habt" -> "seid";
            case "h\u00e4tte" -> "w\u00e4re";
            case "h\u00e4ttest" -> "w\u00e4rst";
            case "h\u00e4tten" -> "w\u00e4ren";
            case "h\u00e4ttet" -> "w\u00e4rt";
            case "hatte" -> "war";
            case "hatten" -> "waren";
            case "hattest" -> "warst";
            case "hattet" -> "wart";
            case "habe", "hab" -> {
                if (ichSubj) {
                    yield "bin";
                }
                yield "sei";
            }
            default -> "";
        };
    }

    static NodeCorrector habenToSein(Node target) {
        String form = target.lowForm();
        NodePattern ichSubj = NodePattern.N.withHead(NodePattern.N.withDependent("nsubj.*", NodePattern.N.form("ich")));
        return NodeCorrector.replace(target, GrammarRules.getHabenToSeinForm(form, ichSubj.matches(target)));
    }

    private static NodePattern habenSein() {
        WordSet seinVerb = WordSet.loadResource("de/sein_verben.txt");
        WordSet habenUndSeinVerb = WordSet.loadResource("de/haben_und_sein_verben.txt");
        NodePattern seinVerbPerfekt = seinVerb.lemmaPattern.pos(".*PA2:PRD.*|VER:PA2.*").andNot(habenUndSeinVerb.lemmaPattern).noLemma("gefallen").andNot(habenVerb).andNot(NodePattern.N.withDependent("obj.*", NodePattern.not(ReflexivePronouns.accReflexivPronomen)));
        return NodePattern.or(NodePattern.N.lemma("haben").withHead("aux", seinVerbPerfekt.noDependents("aux", NodePattern.N.pos("VER:MOD.*")).message("\u201e$_\u201c bildet das Perfekt mit \u201esein\u201c")).and((node, match) -> match.withCorrector(GrammarRules.habenToSein(node))), seinVerbPerfekt.markAs("Conj").noDependents("aux(:pass)?").afterHead().withHead("conj", NodePattern.not(seinVerbPerfekt).withDependent("aux", NodePattern.N.lemma("haben").markAs("Haben")).noDependents("conj", NodePattern.not(NodePattern.N.alreadyMarkedAs("Conj")))).andOptionally(NodePattern.N.withDependent("nsubj.*", NodePattern.N.form("ich").markAs("IchSubj"))).withDependent(".*", GermanTreePatterns.firstInPhraseAfterCommasOrConj.and(NodePattern.custom((anchor, match) -> match.withCorrector(NodeCorrector.insertBefore(anchor.phraseStart(), GrammarRules.getHabenToSeinForm(match.getMarkedNode("Haben").lowForm(), match.findMarkedNode("IchSubj") != null) + " "))))).message("\u201e$_\u201c bildet das Perfekt mit \u201esein\u201c"), NodePattern.N.lemma("sein").markAs("Sein").withHead("aux(:pass)?", NodePattern.or(habenVerb, GrammarRules.looksLikeHabenVerb()).pos(".*PA2:PRD.*|VER:PA2.*").message("\u201e$_\u201c bildet das Perfekt mit \u201ehaben\u201c")).correct(ChangeLemma.to("haben")));
    }

    private static NodePattern missingZuWithInfinitive() {
        return WordSeparation.infinitiveWithZuPhraseHead.pos("VER.*").noPos(".*EIZ.*").noForm(".+zu.+").noDependents("case|aux.*|expl", NodePattern.N.withDependent("nsubj(:pass)?|i?obj|obl|nmod|compound")).noDependents("mark", SpellingRules.to.directlyBeforeHead()).andNot(CommonPatterns.possiblyConj(NodePattern.N.withHead("xcomp", SpellingRules.lehr.and(SpellingRules.beforeNounHasAux)))).andNot(NodePattern.N.directlyAfter(NodePattern.or(NodePattern.PUNCT.noSpaceAfter(), CommonPatterns.skipBack(NodePattern.PUNCT, SpellingRules.zu)))).andOptionally(NodePattern.N.directlyAfter(CommonPatterns.skipBack(NodePattern.PUNCT, NodePattern.N.form(".*[^\\p{L}]zu").markAs("BadZuToken")))).andOr(NodePattern.N.withDependent("mark", SpellingRules.zu.markAs("Zu").andNot(NodePattern.N.directlyBeforeHead())).message("Setzen Sie \u201ezu\u201c direkt vor das zugeh\u00f6rige Verb"), NodePattern.N.message(MISSING_ZU)).and((verb, match) -> {
            boolean kennenLernen;
            Node markZu = match.findMarkedNode("Zu");
            List<String> inflectionList = verb.tree().treeSupport().inflectNode(verb, "VER:INF:(.*)", "VER:EIZ:$1");
            if (!inflectionList.isEmpty() && verb.posReadings().stream().anyMatch(pos -> pos.matches("VER:[123].*") && !pos.matches(".*NEB.*")) || !verb.tree().treeSupport().isAcceptedBySpellchecker(verb.form())) {
                return null;
            }
            boolean bl = kennenLernen = verb.hasForm("lernen") && verb.prevNode() != null && verb.prevNode().hasForm("kennen");
            String replacement = kennenLernen ? "kennenzulernen" : (!inflectionList.isEmpty() ? inflectionList.getFirst() : "zu " + verb.lowForm());
            NodeCorrector resultCorrector = NodeCorrector.replace(verb, replacement);
            Node badZuToken = match.findMarkedNode("BadZuToken");
            if (badZuToken != null) {
                resultCorrector = resultCorrector.join(NodeCorrector.replace(badZuToken, badZuToken.form().replaceFirst("zu$", "")));
            }
            if (kennenLernen) {
                resultCorrector = resultCorrector.join(NodeCorrector.removeNode(verb.prevNode()));
            }
            if (markZu != null) {
                resultCorrector = resultCorrector.join(NodeCorrector.removeNode(markZu));
            }
            return match.withCorrector(resultCorrector);
        });
    }

    private static NodePattern doubleZu() {
        return NodePattern.N.inFormSequence(0, "zu", ".*", "zu").correct(NodeCorrector.replace("")).withHead("mark", NodePattern.N.withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis|root").withDependent("aux", NodePattern.N.pos(".*MOD.*").afterHead())).message("\u00dcberfl\u00fcssiges Wort?");
    }

    private static NodePattern incorrectUmZu() {
        NodePattern nounWithoutUmZu = NodePattern.N.lemma("M\u00f6glichkeit|Chance|Gelegenheit|Lust");
        NodePattern umZuClauseHead = NodePattern.N.noDependents("nsubj(:pass)?").withDependent("mark", GermanTreePatterns.firstInPhraseAfterCommasOrConj.form("um")).noDependents("mark", NodePattern.N.form("zu")).noDependents("conj", NodePattern.N.withDependent("mark", NodePattern.N.form("zu")));
        return NodePattern.or(NodePattern.N.pos("VER.*INF.*").andOr(NodePattern.N.form(".+zu.+").and(node -> node.tree().treeSupport().isAcceptedBySpellchecker(node.form().replaceFirst("(.+)zu(.+)", "$1$2"))), NodePattern.N.pos(".*EIZ.*"), NodePattern.N.withDependent("mark", NodePattern.N.form("zu").directlyBeforeHead())).noDependents("mark|case", NodePattern.N.form("um")).noDependents("aux(:pass)?|cop").withDependent("mark|case", GermanTreePatterns.firstPlaceClauseConstituent.form("f\u00fcr").correct(NodeCorrector.replace("um"))).message("Normalerweise werden Infinitivgruppen mit \u201eum\u201c eingeleitet"), NodePattern.N.form("um").withHead("mark", NodePattern.N.pos("VER:INF.*").withHead("acl", nounWithoutUmZu.afterHead().markAs("Word"))).correct(NodeCorrector.replace("")).message("Normalerweise werden Infinitivgruppen nach \u201e$Word\u201c ohne \u201eum\u201c eingeleitet"), NodePattern.N.pos("VER.*INF.*").noPos(".*EIZ.*").noForm(".+zu.+").noDependents("aux").andOr(NodePattern.N.noDependents().withHead("aux(:pass)?", umZuClauseHead), umZuClauseHead).correct(NodeCorrector.insertBefore("zu ")).message(MISSING_ZU));
    }

    private static NodePattern incorrectSubjectPosition() {
        NodePattern pronominalObjToMove = NodePattern.N.pos("PRO:PER.*").withHeadRelation("i?obj");
        return NodePattern.N.pos("PRO:PER.*").noPos("ART:DEF.*").noDependents().withHead("nsubj(:pass)?", GrammarRules.finiteClause().andNot(CommonPatterns.severalDependents("nsubj(:pass)?")).withHeadRelation("a(dv)?cl|ccomp").withDependent("mark", CommonPatterns.firstChildPhrase.form("dass").noDependents().markAs("Mark")).andNot(NodePattern.N.withDependent("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.after("Finite"))).noDependents("dep|discourse|advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis")).directlyAfter(CommonPatterns.skipBack(NodePattern.PUNCT, NodePattern.not(NodePattern.N.alreadyMarkedAs("Mark"))).noForm("auch")).andOptionally(NodePattern.N.directlyBefore(pronominalObjToMove.markAs("Second").andOptionally(NodePattern.N.directlyBefore(pronominalObjToMove.markAs("Third"))))).and((subj, match) -> {
            Node last = match.findMarkedNode("Third") != null ? match.getMarkedNode("Third") : (match.findMarkedNode("Second") != null ? match.getMarkedNode("Second") : subj);
            String replacement = " " + subj.tree().text().substring(subj.startOffset(), last.endOffset());
            return match.withCorrector(NodeCorrector.replaceNodes(subj, last, "").join(NodeCorrector.insertAfter(match.getMarkedNode("Mark"), replacement))).withReportedRange(subj.startOffset(), last.endOffset(), subj.tree());
        }).message("Ungew\u00f6hnliche Wortstellung");
    }

    private static NodePattern finiteClause() {
        NodePattern finite = GermanTreePatterns.finiteVerb.markAs("Finite").includeIntoReport();
        return NodePattern.or(finite.noDependents("cop|aux.*"), NodePattern.N.withDependent("cop|aux.*", finite).andOr(NodePattern.N.noDependents("cop|aux.*", GermanTreePatterns.finiteVerb.andNot(NodePattern.N.alreadyMarkedAs("Finite"))), NodePattern.markedNodeMatches("Finite", NodePattern.N.pos(".*MOD.*").noPos("VER.*INF.*").withHead(NodePattern.N.withDependent("cop|aux.*", GermanTreePatterns.finiteVerb.andNot(NodePattern.N.alreadyMarkedAs("Finite")).noPos(".*MOD.*"))))));
    }

    private static NodePattern verbWordOrder() {
        return GrammarRules.finiteClause().noDependents("nsubj", SpellingRules.noun.directlyBefore(SpellingRules.noun.withHeadRelation("nsubj").beforeHead())).noDependents("cop|aux.*", NodePattern.N.noPos()).noDependents("compound", NodePattern.N.directlyBeforeHead()).noDependents("parataxis", NodePattern.N.withPhraseStart(GermanTreePatterns.dashes)).noDependents("case|aux.*|expl", NodePattern.N.withDependent("nsubj(:pass)?|i?obj|obl|nmod|compound")).andOr(GrammarRules.directClauseOrder(), GrammarRules.subordinateClauseOrder(), GrammarRules.infPtcpWordOrder());
    }

    private static NodePattern verbWordOrderInImperativeClause() {
        return NodePattern.N.withHeadRelation("advmod|discourse|dep").andOr(CommonPatterns.firstWord, NodePattern.N.form("bitte").and(CommonPatterns.firstChildPhrase)).withHead(NodePattern.N.pos(".*(IMP|2:PLU:PR\u00c4).*").onlyPos("VER.*").withHeadRelation("root|parataxis").noDependents("[nc]subj|expl|ccomp").markAs("Imp")).andOr(NodePattern.N.pos("PRO:PER.*"), NodePattern.N.withHead(NodePattern.N.withDependent("iobj", NodePattern.N.markAs("Obj")))).directlyBefore(CommonPatterns.skipForward(NodePattern.N.withHeadRelation("iobj"), NodePattern.N.alreadyMarkedAs("Imp"))).message("In Aufforderungss\u00e4tzen mit Imperativ steht das Verb in Erstposition, ausgenommen nach \u201ebitte\u201c").noForm("jetzt|nun|also|dan(n|ach)").noLabel(".*").andNot(NodePattern.N.form("bitte").directlyBeforeHead()).and((node, match) -> {
            Node imp = match.getMarkedNode("Imp");
            Node obj = match.findMarkedNode("Obj");
            NodeCorrector removeImp = NodeCorrector.removeNode(imp);
            if (node.form().matches("bitte")) {
                return match.withCorrector(removeImp.join(NodeCorrector.insertAfter(node, " " + imp.form())));
            }
            if (obj != null && imp == obj.nextNode()) {
                return match.withCorrector(NodeCorrector.replaceNodes(obj, imp, "").join(NodeCorrector.insertBefore(node, imp.form() + " " + obj.form() + " ")));
            }
            return match.withCorrector(removeImp.join(NodeCorrector.insertBefore(node, imp.form() + " ")));
        });
    }

    private static NodePattern infPtcpWordOrder() {
        return NodePattern.N.pos(".*(PA2|INF).*").withDependent("cop|aux.*", NodePattern.N.alreadyMarkedAs("Finite").beforeHead()).markAs("Head").includeIntoReport().withDependent("nsubj(:pass)?|i?obj|obl|nmod|compound", lastChildPhraseBeforeClauseEnd.afterHead().noDependents("punct|advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis").andNot(GrammarRules.unlikelyAusklammerable()).andNot(NodePattern.N.withDependent("case").noLabel(".*")).andNot(NodePattern.N.withHeadRelation("obl").noDependents("case")).noDependents("case|nmod", NodePattern.N.pos("ABK.*")).noDependents("nmod", NodePattern.N.withDependent("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis")).noPos("PRP.*").markAs("LastChild").includeIntoReport()).noDependents("punct", CommonPatterns.ellipsis).noDependents("det(:poss)?|[na]mod|case").noMatchUntil("LastChild", NodePattern.PUNCT).andNot(CommonPatterns.severalDependents("obj")).and((node, match) -> match.withCorrector(NodeCorrector.replace(node, "").join(NodeCorrector.insertAfter(match.getMarkedNode("LastChild").phraseEnd(), " " + node.form())))).message("Im Hauptsatz steht ein Infinitiv oder ein Partizip an letzter Stelle");
    }

    private static NodePattern directClauseOrder() {
        NodePattern finishingInfinitiveAllowed = NodePattern.N.pos("VER:(MOD:)?INF:.*|PA2.*").andOr(NodePattern.ROOT.andOr(NodePattern.N.directlyBefore(NodePattern.N.form(".*[?!].*")), NodePattern.N.directlyBefore(CommonPatterns.skipForward(NodePattern.N.form("[,.?!]"), GermanTreePatterns.closingQuotation)), NodePattern.N.noDependents(NodePattern.not(NodePattern.PUNCT).afterHead()).noDependents("aux"), NodePattern.N.withDependent("advcl|xcomp", NodePattern.N.afterHead()), NodePattern.N.withDependent("conj", NodePattern.N.withDependent("cc", NodePattern.N.form("noch|sondern")))), NodePattern.N.noDependents("nsubj.*"));
        NodePattern possibleAttachmentAmbiguity = NodePattern.or(NodePattern.N.withHeadRelation("advmod").withPrevSibling(NodePattern.N.pos("(ADV:MOD|SUB).*")), NodePattern.N.pos("ADV:.*").withPrevSibling(NodePattern.N.withHeadRelation("advmod").noPos("ADV:CAU")), NodePattern.N.withHeadRelation("obl").andOr(NodePattern.N.withPrevSiblingIncludingOtherSide(NodePattern.N.pos("ADJ.*")), NodePattern.N.withDependent("case", NodePattern.N.pos("PRP.*LOK.*")).withPrevSibling(NodePattern.N.withHeadRelation("advmod").pos("ADV:LOK")), CommonPatterns.withNumberLikeForm.withPrevSibling(NodePattern.N.withHeadRelation("obl"))), NodePattern.N.withHeadRelation("flat"), NodePattern.N.withDependent("case").withPrevSibling(NodePattern.N.pos("(SUB|PRO).*")), NodePattern.N.inFormSequence(1, "dar(ue|\u00fc)ber", "hinaus"), NodePattern.N.pos(".*NOM.*").withDependent("amod|det", NodePattern.N.pos(".*NOM.*")).withPrevSibling(SemanticRules.timeUnit.pos(".*PLU.*")), NodePattern.N.pos("ADJ.*").withPrevSibling(NodePattern.N.pos("ADV.*")).noDependents(NodePattern.N.beforeHead()));
        NodePattern interveningChildAllowed = NodePattern.or(GermanTreePatterns.clause, NodePattern.PUNCT, NodePattern.N.form("&"), possibleAttachmentAmbiguity, NodePattern.N.pos("ADV:MOD|ZUS"), NodePattern.N.lemma("der").withPrevSibling(CommonPatterns.phraseEndsWithComma), NodePattern.N.form("dann|unterdessen"), NodePattern.or(NodePattern.N.withPhraseStart(NodePattern.N.form("desto|umso")), NodePattern.N.pos("ADJ:PRD:KOM").directlyAfter(NodePattern.N.form("desto|umso"))).and(conj -> conj.back().anyMatch(n -> "je".equalsIgnoreCase(n.form()))), NodePattern.N.withPhraseStart(CommonPatterns.capitalized.noPos().and(CommonPatterns.lowercasedHasPos(".*"))).withPrevSibling(NodePattern.N.withHeadRelation("a(dv)?cl|ccomp|parataxis")));
        NodePattern invertedCopula = NodePattern.N.withDependent("cop").noDependents("nsubj.*|csubj", NodePattern.N.before("Finite"));
        return NodePattern.N.withDependent(".*", CommonPatterns.letterWord.markAs("FirstChild").noMatchUntil("Finite", NodePattern.PUNCT.andNot(CommonPatterns.comma)).withPhraseEnd(NodePattern.N.noMatchUntil("Finite", NodePattern.or(CommonPatterns.comma.withPrevSiblingIncludingOtherSide(NodePattern.N), NodePattern.N.withHeadRelation("dep")))).and(GermanTreePatterns.firstPlaceClauseConstituent).andNot(NodePattern.N.withHeadRelation("discourse|advmod|parataxis|vocative").and(CommonPatterns.phraseEndsWithComma)).noForm("ja|nein").andNot(NodePattern.N.form("gesagt").noDependents("aux(:pass)?|nsubj")).noHeadRelation("dep").noDependents("dep|discourse").andNot(NodePattern.N.pos("ART:DEF.*").noDependents(".*").withHead(NodePattern.ROOT)).andNot(NodePattern.N.pos("ART:.*").withDependent("case")).andNot(NodePattern.N.withPhraseStart(GermanTreePatterns.whPhrase.withHead(NodePattern.N.withDependent("advmod", NodePattern.N.form("auch"))))).andNot(NodePattern.N.withPhraseStart(NodePattern.N.form("ob")).withHeadRelation("obl")).andNot(NodePattern.N.withPhraseStart(NodePattern.N.form("egal").withHead(NodePattern.or(GermanTreePatterns.whPhrase, NodePattern.N.form("ob"))))).andNot(NodePattern.N.withPhraseStart(NodePattern.or(NodePattern.N.form("soviel"), NodePattern.N.inFormSequence(0, "so", "viel"))).withDependent("advmod", NodePattern.N.form("auch")))).withDependent(".*", NodePattern.N.between("FirstChild", "Finite").andNot(interveningChildAllowed).markAs("InterveningChild")).andOr(NodePattern.N.withHeadRelation("root|parataxis").andNot(NodePattern.N.noDependents("nsubj.*").pos("VER:IMP:SIN.*")), NodePattern.N.withHeadRelation("advcl").and(NodePattern.markedNodeMatches("FirstChild", NodePattern.N.form("dann"))), NodePattern.N.withHeadRelation("ccomp").noDependents("mark").withDependent("nsubj(:pass)?", CommonPatterns.firstChildPhrase.andOr(NodePattern.N.pos("EIG.*"), NodePattern.N.withDependent("det(:poss)?", NodePattern.N.pos("(ART|PRO:POS):.*").noForm("de([rn]|ss)en"))).withPhraseStart(NodePattern.N.includeIntoReport().andOr(NodePattern.N.form("das").markAs("Das").correct(NodeCorrector.replace("dass")), NodePattern.N.correct(NodeCorrector.insertBefore("dass ")))))).andNot(finishingInfinitiveAllowed).noDependents("discourse", NodePattern.N.beforeHead()).noDependents("advmod|mark", NodePattern.or(NodePattern.N.form("zu"), NodePattern.N.pos("KON:(UNT|NEB)"), CommonPatterns.firstChildPhrase.andOr(NodePattern.N.noPos(), NodePattern.N.directlyBefore(NodePattern.N.pos("ADV.*").directlyBefore(CommonPatterns.comma))))).noDependents("nsubj", NodePattern.N.withDependent("cop").trace("cop on nsubj")).andNot(NodePattern.N.withDependent("acl", NodePattern.N.markAs("Acl")).withDependent("nmod|obl", NodePattern.N.after("Acl"))).noDependents(GermanTreePatterns.whPhrase).noDependents("cc", NodePattern.N.between("FirstChild", "Finite").form("aber")).andNot(invertedCopula).noDependents(NodePattern.or(CommonPatterns.ellipsis, CommonPatterns.HYPHEN_LIKE_NODE).before("FirstChild").and(CommonPatterns.skipBack(NodePattern.PUNCT, CommonPatterns.firstToken))).andNot(NodePattern.N.withDependent("punct", NodePattern.N.form("!")).withDependent("parataxis", SemanticRules.directSpeechVerb).and(NodePattern.markedNodeMatches("FirstChild", NodePattern.N.withDependent("punct", CommonPatterns.comma)))).and(NodePattern.markedNodeMatches("Finite", NodePattern.N.noPos(".*NEB.*"))).message(VERB_TO_SECOND_PLACE_MESSAGE).and((clause, match) -> {
            if (match.findMarkedNode("Das") != null) {
                return match;
            }
            Node anchor = match.getMarkedNode("FirstChild");
            Node verb = match.getMarkedNode("Finite");
            return match.withCorrector(NodeCorrector.replace(verb, "").join(NodeCorrector.insertAfter(anchor.phraseEnd(), " " + verb.form())));
        });
    }

    private static NodePattern unlikelyAusklammerable() {
        NodePattern ppVerbPart = NodePattern.or(NodePattern.N.inFormSequence(1, "zu|nach", "Hause"), NodePattern.N.inFormSequence(1, "zur", "Seite").withHead("obl", NodePattern.N.lemma("stehen")), NodePattern.N.inFormSequence(1, "under", "Druck").withHead("obl", NodePattern.N.lemma("geraten")), NodePattern.N.inFormSequence(1, "ins", "Rolle").withHead("obl", NodePattern.N.lemma("bringen")));
        return NodePattern.N.markAs("Ausklammerable").withHead("obl", NodePattern.or(NodePattern.N.withDependent("ob[jl]|iobj|advmod|nmod", NodePattern.not(NodePattern.N.alreadyMarkedAs("Ausklammerable"))), NodePattern.markedNodeMatches("Ausklammerable", NodePattern.or(CommonPatterns.severalDependents("amod"), NodePattern.N.withDependent("(a(dv)?|n)mod", NodePattern.N.withDependent("conj")), NodePattern.N.withDependent("conj"), NodePattern.N.withDependent("case", NodePattern.N.form("als|wie|statt")), NodePattern.not(NodePattern.N.withOnlyDependents(NodePattern.or(NodePattern.N.beforeHead(), NodePattern.PUNCT))))))).withDependent("case").andNot(ppVerbPart);
    }

    private static NodePattern subordinateClauseOrder() {
        NodePattern auxSharingConj = GermanTreePatterns.infinitive.noDependents("aux").withDependent("cc").withHead("conj", NodePattern.N.withDependent("aux"));
        NodePattern withFiniteVerbOutsideQuotes = NodePattern.or(NodePattern.N.withDependent("cop|aux(:pass)?", NodePattern.not(CommonPatterns.insideQuotes)), NodePattern.not(CommonPatterns.insideQuotes).noDependents("cop|aux(:pass)?"));
        NodePattern ausklammerable = NodePattern.or(NodePattern.N.withHeadRelation("advcl|acl|ccomp|csubj|appos|conj|parataxis").andNot(auxSharingConj), GermanTreePatterns.clause.withHeadRelation("xcomp").andNot(CommonPatterns.insideQuotes.withHead("xcomp", withFiniteVerbOutsideQuotes)), NodePattern.N.withHeadRelation("nmod|obl").withDependent("case", NodePattern.N.form("als|wie")), GrammarRules.unlikelyAusklammerable(), NodePattern.N.inFormSequence(0, 1, "oder", "nicht"), NodePattern.N.inFormSequence(1, "zum?", "beispiel"), GermanTreePatterns.whPhrase.withHeadRelation("conj").withNextSibling(NodePattern.N.form("nicht")), NodePattern.N.form("nicht").withPrevSibling(GermanTreePatterns.whPhrase.withHeadRelation("conj")), NodePattern.or(NodePattern.N.withPhraseStart(NodePattern.PUNCT), NodePattern.PUNCT).andNot(GermanTreePatterns.anyQuotation.withHead(withFiniteVerbOutsideQuotes).andNot(NodePattern.N.directlyAfter(CommonPatterns.dot))), NodePattern.N.withHeadRelation("amod").withDependent("case", NodePattern.N.form("als").directlyBeforeHead()), NodePattern.N.withHeadRelation("advmod|iobj").withDependent("case", NodePattern.N.form("wie")));
        NodePattern doubleInfinitive = GermanTreePatterns.infinitive.withDependent("xcomp", GermanTreePatterns.infinitive.after("Finite"));
        NodePattern konjunktiv = NodePattern.N.pos(".*KJ.*");
        NodePattern beforeVerb = NodePattern.N.directlyBefore(NodePattern.or(GermanTreePatterns.verbalClause.noPos("ADJ.*"), NodePattern.N.withHeadRelation("cop|aux.*")));
        NodePattern contractedEs = NodePattern.N.form("['`\u00b4\u2019]s");
        NodePattern zuInf = NodePattern.N.withDependent("mark", NodePattern.N.form("zu").directlyBeforeHead());
        NodePattern possibleMisparsedClauseEnd = NodePattern.N.form(".+\\..+");
        NodePattern anotherAux = NodePattern.N.withHeadRelation("aux(:pass)?").andNot(NodePattern.N.alreadyMarkedAs("Finite"));
        NodePattern hasDependentClauseAfter = NodePattern.N.markAs("Head").withDependent("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis", NodePattern.N.withPhraseStart(NodePattern.N.directlyAfter("Head")));
        NodePattern hasSubject = NodePattern.N.withDependent("nsubj(:pass)?|expl");
        return NodePattern.N.markAs("Anchor").andOr(NodePattern.or(NodePattern.ROOT, CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("a(dv)?cl|ccomp|csubj")), NodePattern.N.withHeadRelation("parataxis").withDependent("mark", NodePattern.N.form("weil")), NodePattern.N.withHead("conj", NodePattern.not(NodePattern.N.withHeadRelation("parataxis"))).withPhraseStart(CommonPatterns.skipForward(NodePattern.PUNCT, NodePattern.N.pos("KON:UNT")))).andOr(NodePattern.N.withDependent("mark|cc|case|advmod", NodePattern.or(CommonPatterns.firstChildPhrase, NodePattern.N.directlyAfter(CommonPatterns.comma.inPhrase(NodePattern.N.withHeadRelation("advcl")))).andOr(NodePattern.N.form("weil|dass|da\u00df|wenn|als|obwohl").markAs("Conj"), NodePattern.N.form("damit").markAs("Conj").andNot(NodePattern.N.directlyBefore("Finite")), CommonPatterns.skipForward(NodePattern.N.form("nur"), GermanTreePatterns.whWord.markAs("Conj").withHead(NodePattern.N.alreadyMarkedAs("Anchor")).andNot(PunctuationRules.afterIrgend).andOr(NodePattern.N.noForm("wie"), beforeVerb.andNot(NodePattern.N.inSentenceWith(NodePattern.N.form("\\?")))).andOr(NodePattern.not(CommonPatterns.firstToken), NodePattern.not(NodePattern.N.withHead(NodePattern.ROOT.noDependents("ccomp|parataxis|a(dv)?cl|conj"))))), NodePattern.N.form("und").markAs("Und").withHead("cc", NodePattern.N.withHead("conj", NodePattern.N.withDependent("mark", NodePattern.N.markAs("Conj"))).andOr(NodePattern.not(hasSubject).andNot(NodePattern.N.withPrevSibling(NodePattern.N.afterHead())).and(NodePattern.markedNodeMatches("Und", NodePattern.not(NodePattern.N.directlyBeforeHead()))), hasSubject.withDependent(".*", GermanTreePatterns.verbalClause.afterHead()).withNeighbor(-1, NodePattern.N.alreadyMarkedAs("Und"))).noDependents("mark", NodePattern.N.form("zu")).andNot(CommonPatterns.inParentheses)))), NodePattern.N.withDependent("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.withDependent("det", NodePattern.N.lemma("welch").markAs("Conj").directlyAfter(CommonPatterns.comma.inPhrase(NodePattern.N.withHeadRelation("ccomp"))))).andNot(NodePattern.N.withDependent("xcomp", NodePattern.N.noDependents("mark", SpellingRules.zu)))).andNot(NodePattern.or(konjunktiv, NodePattern.N.withDependent("aux.*|cop", konjunktiv)).and(NodePattern.markedNodeMatches("Conj", NodePattern.N.form("als")))).andNot(NodePattern.ROOT.and(NodePattern.markedNodeMatches("Conj", NodePattern.N.form("damit|als")))).andNot(NodePattern.N.withDependent("punct", NodePattern.N.form("[?!]")).and(NodePattern.markedNodeMatches("Conj", NodePattern.or(GermanTreePatterns.whWord, NodePattern.N.form("wenn"))))).noDependents("parataxis", SemanticRules.directSpeechVerb).andNot(NodePattern.N.withDependent("advcl", NodePattern.N.between("Conj", "Anchor")).and(NodePattern.markedNodeMatches("Conj", NodePattern.N.form("obwohl")))).andNot(NodePattern.N.withNextSibling(NodePattern.N.form("[?!]")).withDependent("mark|cc|case|advmod", GermanTreePatterns.whWord.alreadyMarkedAs("Conj"))).andNot(NodePattern.ROOT.withDependent("mark|cc|case|advmod", GermanTreePatterns.whWord.alreadyMarkedAs("Conj").directlyBefore("Finite")).noDependents("ccomp")).andNot(NodePattern.N.directlyBefore(NodePattern.PUNCT.noForm("[.,?!-]"))).andNot(NodePattern.markedNodeMatches("Finite", NodePattern.or(NodePattern.N.directlyBefore(PunctuationRules.misparsedClauseEndPrev), multipleNmod))).noPos(".*ART.*").message("In einem Nebensatz mit \u201e$Conj\u201c muss das Verb an letzter Stelle stehen"), NodePattern.or(NodePattern.N.withHeadRelation("acl").withDependent("nsubj(:pass)?|i?obj|obl|nmod|compound|det", CommonPatterns.firstChildPhrase.pos("PRO:DEM.*").andNot(NodePattern.N.directlyBefore(NodePattern.N.form("hier")))), NodePattern.N.withHeadRelation("conj").withPhraseStart(NodePattern.N.directlyAfter(NodePattern.N.pos("SUB.*").markAs("NounHead").withDependent("det", NodePattern.N.pos(".*:IND:.*")).noDependents(NodePattern.N.afterHead())).and(CommonPatterns.skipForward(NodePattern.PUNCT, CommonPatterns.skipUp("case|[an]mod", NodePattern.N.markAs("RelativePronoun"))))).and((node, match) -> {
            boolean numberCompatible;
            Node nounHead = match.getMarkedNode("NounHead");
            Node relativePronoun = match.getMarkedNode("RelativePronoun");
            boolean bl = numberCompatible = nounHead.hasPos(".*SIN.*") && relativePronoun.hasPos(".*SIN.*") || nounHead.hasPos(".*PLU.*") && relativePronoun.hasPos(".*PLU.*");
            if (!numberCompatible) {
                return null;
            }
            if (nounHead.hasPos(".*PLU.*")) {
                return match;
            }
            boolean genderCompatible = nounHead.hasPos(".*MAS.*") && relativePronoun.hasPos(".*MAS.*") || nounHead.hasPos(".*FEM.*") && relativePronoun.hasPos(".*FEM.*") || nounHead.hasPos(".*NEU.*") && relativePronoun.hasPos(".*NEU.*");
            return genderCompatible ? match : null;
        })).withDependent(".*", CommonPatterns.firstChildPhrase.and(NodePattern.N.lemma("der|wo"))).message("In einem Relativsatz muss das Verb an letzter Stelle stehen")).andNot(doubleInfinitive).andOr(NodePattern.N.withDependent(".*", NodePattern.N.after("Finite").andNot(ausklammerable).noHeadRelation("conj")), NodePattern.N.withDependent("cop").after("Finite"), NodePattern.N.after("Finite")).andNot(NodePattern.N.withDependent("cc", NodePattern.N.after("Finite"))).andNot(NodePattern.N.withDependent("cop").withDependent("case", NodePattern.N.form("wie"))).andNot(NodePattern.N.withDependent("advmod", NodePattern.N.withDependent("case", NodePattern.N.form("als")).andNot(NodePattern.N.withNextSibling(NodePattern.N)))).andNot(NodePattern.markedNodeMatches("Finite", NodePattern.or(NodePattern.N.noSpaceBefore().directlyAfter(CommonPatterns.HYPHEN_LIKE_NODE), NodePattern.N.withDependent("punct", GermanTreePatterns.anyQuotation)))).and((clause, match) -> {
            Node verb = match.getMarkedNode("Finite");
            Node anchor = StreamEx.of((Collection)Lists.reverse(clause.allDependents())).findFirst(n -> !ausklammerable.matches((Node)n) || GrammarRules.unlikelyAusklammerable().matches((Node)n)).orElse(null);
            if (anchor == null || hasDependentClauseAfter.matches(anchor) && anchor.phraseStart().prevNode() == verb) {
                return null;
            }
            anchor = anchor.isBefore(clause) ? clause : (hasDependentClauseAfter.matches(anchor) ? anchor : anchor.phraseEnd());
            if (verb.nextUntil(anchor).anyMatch(NodePattern.PUNCT.andNot(GermanTreePatterns.anyQuotation).andNot(NodePattern.N.directlyAfter(NodePattern.N.pos("ABK.*").andNot(NodePattern.N.inFormSequence(0, "z", "\\.", "B", "\\.")))).andNot(CommonPatterns.dot.directlyAfter(CommonPatterns.withNumberLikeForm).noSpaceBefore()).andNot(CommonPatterns.HYPHEN_LIKE_NODE)::matches) || possibleMisparsedClauseEnd.matches(anchor)) {
                return null;
            }
            NodeCorrector remove = NodeCorrector.replace(verb, "");
            if (contractedEs.matches(verb.nextNode())) {
                remove = remove.join(NodeCorrector.replace(verb.neighbor(1), "es"));
            }
            Object toInsert = verb.form();
            boolean participle = clause.hasPos("VER:PA2:(SFT|NON)");
            if (verb.neighbor(-1).equals(clause) && participle && !anotherAux.matches(verb.neighbor(1))) {
                toInsert = clause.form() + " " + verb.form();
                remove = NodeCorrector.replaceNodes(clause, verb, "");
            }
            if (verb != clause && !clause.hasDependent("cop") && !zuInf.matches(clause) && anchor != clause && (clause.allDependents().stream().noneMatch(n -> n.isAfter(clause) && NodePattern.or(auxSharingConj, anotherAux).matches((Node)n)) || clause.nextNode() != null && clause.nextNode().equals(verb) && clause.allDependents().stream().anyMatch(n -> n.isAfter(clause) && n.hasHeadRelation("obl|i?obj")))) {
                remove = remove.join(NodeCorrector.replace(clause, ""));
                toInsert = clause.form() + " " + (String)toInsert;
                match = match.withReportedNode(clause);
            }
            if (!anchor.hasHeadRelation("compound:prt")) {
                toInsert = " " + (String)toInsert;
            }
            return match.withCorrector(remove.join(NodeCorrector.insertAfter(anchor, (String)toInsert)));
        }).andOptionally(NodePattern.markedNodeMatches("Conj", GermanTreePatterns.whWord.withPhraseEnd(beforeVerb)).and(NodePattern.N.noDependents("parataxis").withDependent("punct", NodePattern.N.form("[.!]").correct(NodeCorrector.replace("?")).includeIntoReport().directlyAfter(NodePattern.N.includeIntoReport()))));
    }

    private static NodePattern verbArgumentOrder() {
        NodePattern datPronArg = NodePattern.N.pos("PRO:PER:DAT:.*");
        NodePattern switchNodes = NodePattern.custom((node, match) -> {
            Node anchor = match.getMarkedNode("anchor");
            return match.withCorrector(NodeCorrector.replaceNodes(node.phraseStart(), node.phraseEnd(), "").join(NodeCorrector.insertAfter(anchor, " " + node.phraseText())));
        });
        return NodePattern.or(NodePattern.N.markAs("adverb").includeIntoReport().withHead("advmod", NodePattern.N.onlyPos("VER:IMP.*").withDependent("obj", datPronArg.directlyAfter(NodePattern.N.alreadyMarkedAs("adverb")).markAs("anchor").includeIntoReport())).message("Das Personalpronomen steht \u00fcblicherweise vor anderen Argumenten"), NodePattern.or(datPronArg.markAs("dat").includeIntoReport().withHead("iobj", NodePattern.N.pos("VER:.*").withDependent("obj", NodePattern.N.pos("PRO:PER:AKK:.*").noPos("PRO:DEM:AKK.*").withPrevSibling(NodePattern.N.alreadyMarkedAs("dat")).markAs("anchor").includeIntoReport())), NodePattern.N.pos("PRO:DEM:AKK:.*").directlyAfter(NodePattern.not(NodePattern.PUNCT)).markAs("demAkk").includeIntoReport().withHead("obj", NodePattern.N.pos("VER:.*").noHeadRelation("acl").withDependent("iobj", datPronArg.withPrevSibling(NodePattern.N.alreadyMarkedAs("demAkk")).markAs("anchor").includeIntoReport())), NodePattern.N.pos("SUB:AKK:.*").afterHead().withDependent("det", NodePattern.N.pos("ART:IND:.*")).noDependents(NodePattern.N.afterHead()).markAs("indAkk").includeIntoReport().withHead("obj", NodePattern.N.pos("VER:.*").withDependent("iobj", NodePattern.or(datPronArg, NodePattern.N.pos("SUB:DAT:.*").afterHead().withDependent("det", NodePattern.N.pos("ART:DEF:.*"))).withPrevSibling(NodePattern.N.alreadyMarkedAs("indAkk")).andNot(NodePattern.N.directlyAfterHead()).markAs("anchor").includeIntoReport())), NodePattern.N.pos("SUB:DAT:.*").withDependent("det").noDependents(NodePattern.N.afterHead()).markAs("nomDat").includeIntoReport().withHead("iobj", NodePattern.N.pos("VER:.*").withDependent("obj", NodePattern.N.pos("PRO:PER:AKK:.*").withPrevSibling(NodePattern.N.alreadyMarkedAs("nomDat")).markAs("anchor").includeIntoReport()))).message(ARGUMENT_ORDER_MSG)).and(switchNodes);
    }

    private static NodePattern prefixedVerbInMainClause() {
        NodePattern looksLikeMainClause = NodePattern.N.noDependents(NodePattern.or(GermanTreePatterns.whPhrase, NodePattern.N.pos("ART:DEF.*"), NodePattern.N.withHeadRelation("mark|aux.*|nmod|appos|dep|cop"))).andOr(NodePattern.N.withDependent("nsubj(:pass)?|expl"), NodePattern.N.withHeadRelation("conj"), NodePattern.N.pos("VER:1:SIN:PR\u00c4.*").withOnlyDependents(NodePattern.or(NodePattern.N.afterHead(), NodePattern.N.withHeadRelation("punct|discourse|vocative"))));
        NodePattern outsideClauseDependent = NodePattern.or(NodePattern.N.withHeadRelation("[cx]comp|csubj|a(dv)?cl|parataxis"), PunctuationRules.commaOrStronger);
        return NodePattern.N.form("(r?(ab|an|auf|aus(einander)?|unter)|bei|da(bei)?|dar(an|zwischen)?|ein|empor|ent(gegen|lang|zwei)?|fehl|fern|fest|fort|frei|gegen\u00fcber|gleich|heim|her(ab|an|auf|aus|bei|ein|um|unter|vor|\u00fcber)?|hin(ab|auf|aus|ein|terher|unter|weg|zu)?|hoch|los|mit|nach|nebenher|nieder|statt|vor(an|aus|bei|weg|\u00fcber)?|weg|weiter|zu(recht|r\u00fcck|sammen)?).{3,}").includeIntoReport().andOr(NodePattern.N.onlyPos("VER.*NEB"), NodePattern.N.pos("VER.*NEB").andOr(NodePattern.N.pos("VER:IMP.*"), CommonPatterns.firstToken)).noPos("PA2:.*").and(CommonPatterns.skipConjUp(looksLikeMainClause.withHeadRelation("parataxis|root"))).and(looksLikeMainClause).andOr(NodePattern.N.withDependent("conj", looksLikeMainClause.pos("VER.*")), NodePattern.N.noDependents("conj")).andOr(NodePattern.N.withDependent("nsubj"), NodePattern.N.withHead("conj", NodePattern.N.withDependent("nsubj")), NodePattern.N.pos("VER:1:SIN:PR\u00c4.*|VER:IMP:SIN")).andNot(NodePattern.N.pos("SUB.*").withDependent("acl").noDependents("cop|nsubj(:pass)?|i?obj|obl|nmod|compound")).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("a(dv)?cl|ccomp|csubj"))).andNot(NodePattern.N.noDependents(NodePattern.not(NodePattern.PUNCT).afterHead()).withDependent("nsubj", NodePattern.or(NodePattern.N.pos(".*AKK.*"), NodePattern.N.noPos()))).andNot(NodePattern.ROOT.withDependent(".*", NodePattern.N.beforeHead().markAs("FirstDependent")).withDependent(".*", NodePattern.N.beforeHead().andNot(NodePattern.N.alreadyMarkedAs("FirstDependent")))).andNot(CommonPatterns.insideQuotes).andNot(NodePattern.N.form("hinaus.+").directlyAfter(NodePattern.N.form("dar\u00fcber"))).andNot(NodePattern.ROOT.andOr(NodePattern.N.pos("SUB.*"), CommonPatterns.capitalizedHasPos("SUB.*")).noDependents()).message(SEPARABLE_VERB_MAIN_CLAUSE).and((verb, match) -> {
            List<Node> nodes = verb.tree().nodes().stream().filter(n -> n.isAfter(verb)).toList();
            Node clauseEnd = nodes.stream().filter(outsideClauseDependent::matches).findFirst().orElse(null);
            Node node = nodes.isEmpty() ? verb : (clauseEnd = clauseEnd == null ? nodes.getLast() : clauseEnd.phraseStart().prevNode());
            if (clauseEnd == null) {
                return null;
            }
            String prefix = verb.lowForm().replaceFirst("(r?(ab|an|auf|aus(einander)?|unter)|bei|da(bei)?|dar(an|zwischen)?|ein|empor|ent(gegen|lang|zwei)?|fehl|fern|fest|fort|frei|gegen\u00fcber|gleich|heim|her(ab|an|auf|aus|bei|ein|um|unter|vor|\u00fcber)?|hin(ab|auf|aus|ein|terher|unter|weg|zu)?|hoch|los|mit|nach|nebenher|nieder|statt|vor(an|aus|bei|weg|\u00fcber)?|weg|weiter|zu(recht|r\u00fcck|sammen)?).{3,}", "$1");
            String verbReplacement = verb.lowForm().substring(prefix.length());
            if (verb.hasHeadRelation("conj") && CommonPatterns.lastWord.matches(verb) && verb.hasDependent("cc")) {
                return GrammarRules.correctVerbAndPrefixPlacement(verb, match, prefix, verbReplacement);
            }
            return match.withCorrector(NodeCorrector.replace(verb, verbReplacement).join(NodeCorrector.insertAfter(clauseEnd, " " + prefix)));
        });
    }

    @Nullable
    private static NodeMatch correctVerbAndPrefixPlacement(Node verb, NodeMatch match, String prefix, String verbReplacement) {
        NodePattern conjunction = CommonPatterns.possiblySkipUp(NodePattern.PUNCT, NodePattern.N.withHeadRelation("cc").withNextSibling(NodePattern.N.noDependents("conj")));
        Node ccBoundary = ((StreamEx)verb.phraseStart().forward().filter(conjunction::matches)).findFirst().orElse(null);
        if (ccBoundary != null && ccBoundary.nextSibling() != null) {
            return match.withCorrector(NodeCorrector.replace(verb, " " + prefix).join(NodeCorrector.insertAfter(Objects.requireNonNull(ccBoundary.nextSibling()), " " + verbReplacement)));
        }
        return null;
    }

    private static NodePattern prefixedInfinitivesWithZu() {
        return NodePattern.N.pos("VER.*INF.*").noPos(".*EIZ.*").noForm(".+zu.+").form("(r?(ab|an|auf|aus(einander)?|unter)|bei|da(bei)?|dar(an|zwischen)?|ein|empor|ent(gegen|lang|zwei)?|fehl|fern|fest|fort|frei|gegen\u00fcber|gleich|heim|her(ab|an|auf|aus|bei|ein|um|unter|vor|\u00fcber)?|hin(ab|auf|aus|ein|terher|unter|weg|zu)?|hoch|los|mit|nach|nebenher|nieder|statt|vor(an|aus|bei|weg|\u00fcber)?|weg|weiter|zu(recht|r\u00fcck|sammen)?).{3,}").withDependent("mark", SpellingRules.zu.directlyBeforeHead()).noForm("(durch|\u00fcber|um|unter|voll|wider|hinter|ent|zu).+").noDependents("aux").message("\u201eZu\u201c steht bei Infinitiven mit trennbaren Pr\u00e4fixen zwischen dem Pr\u00e4fix und dem Verbstamm").and((node, match) -> {
            String prefix = node.lowForm().replaceFirst("(r?(ab|an|auf|aus(einander)?|unter)|bei|da(bei)?|dar(an|zwischen)?|ein|empor|ent(gegen|lang|zwei)?|fehl|fern|fest|fort|frei|gegen\u00fcber|gleich|heim|her(ab|an|auf|aus|bei|ein|um|unter|vor|\u00fcber)?|hin(ab|auf|aus|ein|terher|unter|weg|zu)?|hoch|los|mit|nach|nebenher|nieder|statt|vor(an|aus|bei|weg|\u00fcber)?|weg|weiter|zu(recht|r\u00fcck|sammen)?).{3,}", "$1");
            String stem = node.form().substring(prefix.length());
            if (!node.tree().treeSupport().tagToken(stem).hasPos("VER.*")) {
                return null;
            }
            return match.withCorrector(NodeCorrector.replaceNodes(node.neighbor(-1), node, prefix + "zu" + stem));
        });
    }

    private static NodePattern wannWennAlsConfusion() {
        NodePattern pastForm = NodePattern.or(NodePattern.N.pos("VER:.*(PRT|PA2).*").noPos(".*(PR\u00c4|KJ2).*"), NodePattern.N.pos("VER:INF:SFT").withDependent("aux", NodePattern.N.pos("VER:MOD.*PRT.*")));
        NodeCorrector.Relative toWenn = NodeCorrector.replace("wenn");
        return NodePattern.or(NodePattern.N.form("wann").andOr(NodePattern.N.withHead("mark|advmod", NodePattern.N.withHead("acl", NodePattern.N.withDependent("det", NodePattern.N.form("jede[rs]?"))).andNot(NodePattern.N.withHead(NodePattern.N.withDependent("advmod", NodePattern.or(NodePattern.N.pos("ZUS"), GermanTreePatterns.whPhrase))))).andNot(NodePattern.N.directlyBefore(CommonPatterns.possiblySkipUp(NodePattern.N.form("auch"), NodePattern.N.form("immer")))).correct(toWenn).message(WANN_WENN_MSG), directlyAfterImmer.message(IMMER_WENN_WANN_MSG).correct(toWenn).andOptionally(NodePattern.N.noDependents("conj").correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "wann immer")))), NodePattern.N.form("wenn").andOr(NodePattern.or(NodePattern.ROOT.withPhraseEnd(NodePattern.N.form("\\?")), GermanTreePatterns.firstInPhraseAfterCommasOrConj.withHead("mark|advmod", NodePattern.N.withDependent("punct", NodePattern.N.form("\\?"))).directlyBeforeHead(), NodePattern.N.withHead("mark", NodePattern.N.withHead("ccomp", NodePattern.ROOT.withPhraseEnd(NodePattern.N.form("\\?")).lemma("wissen")).noDependents("advmod", NodePattern.N.form("nun"))).andNot(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("cc")))).correct(NodeCorrector.replace("wann")).message(WENN_WANN_MSG), NodePattern.N.withHead("mark", NodePattern.or(pastForm, NodePattern.N.withDependent("cop", pastForm), NodePattern.N.pos("VER:INF:NON").withDependent("aux", pastForm)).withHead("advcl", pastForm).andNot(NodePattern.N.withDependent("xcomp", NodePattern.N.directlyAfter(NodePattern.N.form("zu")))).noDependents("advmod", NodePattern.N.form("immer")).noDependents("aux(:pass)?", NodePattern.N.pos(".*KJ2.*")).andOr(NodePattern.N.withDependent("obl", NodePattern.or(NodePattern.or(SemanticRules.timeUnit, NodePattern.N.form("Uhr|Mal")).withDependent("case", NodePattern.N.form("vor")), NodePattern.N.inFormSequence(2, "das", "eine", "Mal"), NodePattern.N.withDependent("amod", NodePattern.N.lemma("(aller){0,2}?(erste|letzte)")))), NodePattern.N.form("alt").directlyAfter(NodePattern.N.form("Jahre?")), NodePattern.N.withDependent("advmod", SemanticRules.gesternLike), NodePattern.N.onlyPos("SUB.*").withDependent("cop").withDependent("nsubj", NodePattern.or(NodePattern.N.pos("PRO.*"), NodePattern.N.withDependent("det(:poss)?", NodePattern.N.noPos(".*IND.*")))))).message("Bei einmaligen Ereignissen oder l\u00e4ngeren Zeitr\u00e4umen in der Vergangenheit verwenden Sie \u201eals\u201c").correct(NodeCorrector.replace("als"))), NodePattern.N.form("als").markAs("Als").withHead("mark", NodePattern.N.pos("VER:INF.*").withDependent("aux", NodePattern.N.lemma("werden").pos("VER.*PR\u00c4.*")).withDependent("nsubj").withHead("advcl", NodePattern.N.noPos("ADV:MOD|ADJ.*KOM.*"))).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("ob"))).correct(toWenn).message(ALS_WENN_MSG));
    }

    private static NodePattern dasDassConfusion() {
        NodePattern alsDasEtc = NodePattern.N.inFormSequence(1, "als|statt|kaum|au\u00dfer|ohne|so", "das");
        NodePattern needCommaBefore = NodePattern.not(CommonPatterns.firstToken).andNot(alsDasEtc).andNot(NodePattern.N.directlyAfter(NodePattern.or(CommonPatterns.punctOrEmoji, NodePattern.N.withHeadRelation("cc"))));
        NodePattern firstPersonPredicate = NodePattern.or(NodePattern.N.pos("VER:(MOD:)?1.*"), NodePattern.N.withDependent("cop|aux.*", NodePattern.N.pos("VER:(MOD:)?1.*")));
        NodePattern secondPersonPredicate = NodePattern.or(NodePattern.N.pos("VER:(MOD:)?2.*"), NodePattern.N.withDependent("cop|aux.*", NodePattern.N.pos("VER:(MOD:)?2.*")));
        return NodePattern.or(NodePattern.N.form("das").includeIntoReport().markAs("das").andOr(NodePattern.or(GermanTreePatterns.firstInPhraseAfterCommasOrConj.andOr(NodePattern.N.withHead("mark", NodePattern.or(NodePattern.ROOT, CommonPatterns.skipConjUp(NodePattern.N.withHeadRelation("ccomp|csubj")), NodePattern.N.withHead("conj", NodePattern.N.withHeadRelation("ccomp").withDependent("mark", NodePattern.N.form("dass?"))), NodePattern.N.withDependent("nsubj.*").withHeadRelation("acl")).markAs("Clause")), NodePattern.N.withHead("obj|nsubj.*", NodePattern.or(NodePattern.N.withDependent("nsubj.*").andNot(CommonPatterns.severalDependents("nsubj.*")).withHead("acl", NodePattern.or(NodePattern.N.pos("NEG"), NodePattern.N.pos("SUB.*SIN.*").noPos(".*:NEU.*").noDependents("det", NodePattern.N.pos(".*AKK:SIN:NEU.*")).noDependents("flat|conj").directlyBefore("das"))).markAs("Clause"), NodePattern.N.withHead("acl", NodePattern.or(NodePattern.N.form("Sinn").withHead("nsubj|obj", NodePattern.N.form("macht|ergibt")), NodePattern.N.form("macht|ergibt").withDependent("nsubj|obj", NodePattern.N.form("Sinn")))).markAs("Clause"))), NodePattern.N.withHead(NodePattern.N.markAs("Clause")).directlyAfter(CommonPatterns.skipBack(NodePattern.PUNCT, NodePattern.N.form("da.+").pos("ZUS").withHead("advmod", GermanTreePatterns.clause.withDependent("ccomp|acl", NodePattern.N.alreadyMarkedAs("Clause")))))), NodePattern.N.withHead("det", GermanTreePatterns.firstInPhraseAfterCommasOrConj.noPos("(SUB|ADJ):(NOM|AKK):SIN:NEU.*").noDependents("case").withHead(NodePattern.or(NodePattern.N.withHead("conj", NodePattern.N.withHeadRelation("ccomp").withDependent("mark", NodePattern.N.form("dass?"))), NodePattern.N.withHeadRelation("parataxis|acl|csubj.*").withDependent("nsubj.*").noPos(".*EIZ.*").noDependents("mark").noDependents("cop|aux.*", NodePattern.N.beforeHead()).andOr(NodePattern.N.noDependents(".*", NodePattern.not(NodePattern.N.withHeadRelation("punct|cop|aux.*")).afterHead()).withPhraseStart(NodePattern.or(NodePattern.not(NodePattern.PUNCT), NodePattern.N.form(","))), NodePattern.N.withHead(NodePattern.N.withDependent("xcomp", NodePattern.N.pos("ADJ:PRD:GRU"))))).markAs("Clause"))), alsDasEtc.withHead(NodePattern.or(NodePattern.N.withHeadRelation("advcl"), NodePattern.N.withHead("acl", NodePattern.not(NodePattern.N.pos("SUB.*")))).markAs("Clause")).noHeadRelation("det")).and((node, match) -> {
            Node prev = node.prevNode();
            Node dassClause = match.getMarkedNode("Clause");
            NodeCorrector punctuationCorrector = null;
            if (PunctuationRules.needCoordinationComma.matches(dassClause)) {
                Node clauseStart = dassClause.phraseStart();
                if (PunctuationRules.noPunctAroundBefore.matches(clauseStart)) {
                    punctuationCorrector = CommaLicense.addCommaBefore(clauseStart, PunctuationRules.commaOrOpening);
                }
            } else if (PunctuationRules.needSubordinationComma.matches(dassClause)) {
                NodeRange range = PunctuationRules.getNodeRangesForSubordinationComma(dassClause).getFirst();
                punctuationCorrector = CommaLicense.getCorrectorForSurroundWithCommas(range, PunctuationRules.commaOrOpening, PunctuationRules.commaOrClosing);
            } else if (needCommaBefore.matches(node)) {
                punctuationCorrector = CommaLicense.addCommaBefore(node, PunctuationRules.commaOrOpening);
            }
            int punctChangeStart = punctuationCorrector == null ? -1 : punctuationCorrector.calcChangeRange().start();
            NodeCorrector dassCorrector = prev != null && prev.hasForm("so") && !new TextRange(prev.startOffset(), node.endOffset()).containsInclusive(punctChangeStart) ? NodeCorrector.replaceNodes(prev, node, "sodass") : NodeCorrector.replace(node, "dass");
            return match.withCorrector(dassCorrector.join(punctuationCorrector));
        }), NodePattern.N.directlyBefore(NodePattern.N.form("dass")).correct(NodeCorrector.replace("dass").join(NodeCorrector.replace(NodePointer.neighbor(1), "das")))), NodePattern.N.form("dass").markAs("Dass").andOr(NodePattern.N.noDependents(NodePattern.PUNCT), NodePattern.ROOT).andOr(NodePattern.N.withHead(NodePattern.or(NodePattern.N.pos("VER.*"), NodePattern.N.withDependent(".*", NodePattern.N.pos(".*AUX.*"))).andOr(NodePattern.ROOT, NodePattern.N.withHeadRelation("acl|ccomp|csubj")).andOr(NodePattern.N.noDependents("nsubj.*", NodePattern.not(NodePattern.N.alreadyMarkedAs("Dass"))).noDependents(".*", NodePattern.N.withDependent("nsubj.*")).andOr(NodePattern.not(NodePattern.N.withOnlyDependents(NodePattern.or(NodePattern.N.beforeHead(), NodePattern.PUNCT, NodePattern.N.withHeadRelation("aux(:pass)?")))), NodePattern.N.withDependent("mark", NodePattern.N.form("zu").directlyBeforeHead()), NodePattern.N.withOnlyDependents(NodePattern.N.withHeadRelation("mark|cop(:pass)?|punct")), NodePattern.N.withHead(NodePattern.or(NodePattern.N.pos("(SUB|PRO:DEM).*"), NodePattern.N.withDependent("nsubj(:pass)?|ob[jl]|iobj|nmod", AgreementSet.misparsedRelHead.onlyPos("(SUB|PRO:DEM).*"))))).noDependents("iobj", SpellingRules.reflexiveProEndsWithEs).andNot(firstPersonPredicate.withHead(firstPersonPredicate)).andNot(secondPersonPredicate.withHead(secondPersonPredicate)), NodePattern.N.withDependent("nsubj.*", NodePattern.not(NodePattern.N.alreadyMarkedAs("Dass")).pos("SUB:NOM:SIN:NEU").directlyAfter("Dass").markAs("NSubj")).noDependents(NodePattern.N.beforeHead().andNot(NodePattern.or(NodePattern.N.alreadyMarkedAs("Dass"), NodePattern.N.alreadyMarkedAs("NSubj")))), NodePattern.N.withHead("acl", NodePattern.ROOT.pos("SUB.*").andNot(GermanTreePatterns.clause).directlyBefore(CommonPatterns.skipForward(NodePattern.PUNCT, NodePattern.N.alreadyMarkedAs("Dass")))), NodePattern.N.withDependent(".*", NodePattern.N.pos(".*AUX.*").directlyAfter("Dass")).noDependents("nsubj(:pass)?", NodePattern.N.pos("(SUB|EIG|PRO).*")), NodePattern.N.withOnlyDependents(NodePattern.or(NodePattern.N.alreadyMarkedAs("Dass"), NodePattern.PUNCT, NodePattern.N.afterHead())).andOr(NodePattern.N.noDependents("nsubj(:pass)?"), NodePattern.N.noDependents("obj"), NodePattern.N.withDependent("nsubj(:pass)?|obj", NodePattern.N.alreadyMarkedAs("Dass")))).noDependents("csubj|expl|orphan", NodePattern.not(NodePattern.N.alreadyMarkedAs("Dass"))).noDependents("xcomp", NodePattern.N.withDependent("mark", NodePattern.N.form("zu"))).noDependents(".*", GermanTreePatterns.whPhrase).andNot(NodePattern.or(NodePattern.N.noPos(), NodePattern.N.pos("PA2.*")).andOr(NodePattern.N.withDependent("aux:pass").noDependents("nsubj:pass", NodePattern.N.alreadyMarkedAs("Dass")), NodePattern.N.noDependents("aux.*"))).andNot(NodePattern.N.withHead(NodePattern.N.withDependent("a(dv)?mod", NodePattern.or(NodePattern.N.form("so"), NodePattern.N.withDependent("advmod", NodePattern.N.form("so"))))))), NodePattern.N.withHeadRelation("root|nsubj.*|i?obj|obl|det"), NodePattern.N.withHead("mark", NodePattern.or(NodePattern.N.withHeadRelation("xcomp"), NodePattern.N.withHead("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis", NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound")).noDependents("nsubj(:pass)?|csubj|aux:pass|expl")))).correct(NodeCorrector.replace("das"))).message(DAS_DASS_MSG);
    }

    private static NodePattern missingEsAfterApos() {
        return NodePattern.N.form("['`\u00b4\u2019]").noSpaceBefore().andNot(GermanTreePatterns.afterOpeningApos).includeIntoReport().directlyAfter(NodePattern.N.pos("(KON|VER|PRO).*").andOr(NodePattern.ROOT, NodePattern.N.withHead("aux(:pass)?|nsubj|mark", NodePattern.N.withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis|root"))).noPos(".*SFT").includeIntoReport()).andOr(NodePattern.N.withHeadRelation("nsubj|det|obj"), NodePattern.N.withHead("punct", NodePattern.or(NodePattern.N.noDependents("nsubj(:pass)?"), NodePattern.N.withDependent("nsubj", NodePattern.or(NodePattern.N.directlyBeforeHead(), NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("aux"))))))).correct(NodeCorrector.insertAfter("s")).correct(NodeCorrector.replace(" es")).message(MISSING_ES_MSG);
    }

    private static NodePattern missingEsSubject() {
        return NodePattern.N.inFormSequence(0, "geht", "ist").withNeighbor(1, NodePattern.N.correct(NodeCorrector.replace("es"))).noDependents("nsubj(:pass)?").message("Fehlt ein Subjekt?");
    }

    private static NodePattern adjWithoutSuperlative() {
        String prefixes = "best|schnellst|meist|geeignet|geringst";
        String endings = "e?s?te[nmrs]?";
        NodePattern common = NodePattern.N.includeIntoReport().withOptionalDependent("advmod|case", NodePattern.N.form("am").markAs("Am"));
        return NodePattern.or(NodePattern.or(NodePattern.N.form("(.*(einzig|eckig)|erstklassig)" + endings), NodePattern.N.form("n\u00e4chstm\u00f6glichst.*"), NodePattern.N.form("(total|perfekt|minimal|entscheidend|ideal|kein|golden|h\u00f6lzern|stumm|leblos|voll(kommen|endet)|steinreich|mordsschwer|knochentrocken|blitzschnell|butterweich|halb|ganz|schwanger|voll|rund|leichenblass|giftgr\u00fcn|eiskalt|letzt|optimal|lauw\u00e4rm|kinderlos|absolut|heutig|dortig|entscheiden|leer|falsch|unnahbar|tot|(schrift|m\u00fcnd|w\u00f6rt)lich|ledig|sterblich|nackt|maximal|unvergleichbar|fertig|gleich)" + endings).and(common)).noPos("VER.*").noHeadRelation("aux").and((node, match) -> {
            Node am = match.findMarkedNode("Am");
            String basicFormWithEnding = node.hasForm("erstklassig.*") ? node.lowForm().replaceFirst("(.*klassig)st(.*)", "$1$2") : (node.hasForm("n\u00e4chstm\u00f6glich.*") ? node.lowForm().replaceFirst("(.*m\u00f6glich)st(.*)", "$1$2") : node.lowForm().replaceFirst("e?st(.*)", "$1"));
            String basicFormNoEnding = node.lowForm().replaceFirst("(.*)st.*", "$1");
            String optimalToBest = node.lowForm().replaceFirst(".*st(.*)", "best$1");
            NodeCorrector insertBasicFormWithEnding = NodeCorrector.replace(node, basicFormWithEnding);
            NodeCorrector insertBasicFormNoEnding = NodeCorrector.replace(node, basicFormNoEnding);
            Node head = node.head();
            if (node.hasHeadRelation("amod") && head != null && head.hasHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound|root") && node.hasForm("optimal.*")) {
                return match.withCorrector(insertBasicFormWithEnding).withCorrector(NodeCorrector.replace(node, optimalToBest));
            }
            if (node.hasHeadRelation("root|advmod") && am != null) {
                match = match.withCorrector(insertBasicFormNoEnding.join(NodeCorrector.replace(am, "")));
                if (node.hasForm("optimal.*")) {
                    return match.withCorrector(NodeCorrector.replace(node, optimalToBest));
                }
                return match;
            }
            return match.withCorrector(insertBasicFormWithEnding);
        }), NodePattern.N.form("(" + prefixes + ").*(ste?[nmrs]?)$").and(common).and((node, match) -> {
            String firstPart = node.lowForm().replaceFirst("(" + prefixes + ").*", "$1");
            String secondPart = node.lowForm().substring(firstPart.length());
            Node am = match.findMarkedNode("Am");
            Node det = node.findSingleDependent("det.*");
            if (node.hasForm("geeignet.*")) {
                if (node.hasHeadRelation("root") && (am != null || det != null)) {
                    NodeCorrector geeignetToBest = NodeCorrector.replace(node, " besten " + firstPart);
                    return am != null ? match.withCorrector(geeignetToBest) : match.withCorrector(geeignetToBest.join(NodeCorrector.replace(det, "am")));
                }
                String newAdj = firstPart + secondPart.replaceFirst("st(.*)", "$1");
                return match.withCorrector(NodeCorrector.replace(node, " am besten " + newAdj));
            }
            String removeSuffix = secondPart.replaceFirst("e?st?(.*)", "$1");
            if ((node.hasPos("ADJ.*") || node.hasHeadRelation("advmod")) && am != null) {
                String newAdj = node.lowForm().replaceFirst("(.*)st.*", "$1");
                return match.withCorrector(NodeCorrector.removeNode(am).join(NodeCorrector.replace(node, newAdj)));
            }
            String newAdvmod = firstPart + removeSuffix;
            if (node.tree().treeSupport().tagToken(newAdvmod).hasPos("ADJ.*")) {
                return match.withCorrector(NodeCorrector.replace(node, newAdvmod));
            }
            if (node.tree().treeSupport().tagToken(secondPart).hasPos("ADJ.*|PA1.*")) {
                String newAdj = secondPart.replaceFirst("st(.*)", "$1");
                return match.withCorrector(NodeCorrector.replace(node, firstPart + newAdj));
            }
            String newAdj = secondPart.replaceFirst("s(.*)", "$1");
            if (node.tree().treeSupport().tagToken(newAdj).hasPos("PA2.*")) {
                return match.withCorrector(NodeCorrector.replace(node, firstPart + newAdj));
            }
            return null;
        })).andNot(CommonPatterns.quotedWord).message("Der Superlativ \u201e$_\u201c ist im Standarddeutschen un\u00fcblich");
    }

    private static NodePattern genitiveFormBeforeHead() {
        NodePattern withPossessivePronoun = NodePattern.N.withDependent("det:poss", NodePattern.N.directlyBeforeHead().markAs("PossPron"));
        return NodePattern.or(NodePattern.N.form(".*s").directlyBeforeHead().markAs("GenNoun").withHead(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound|root")).markAs("Head").andOptionally(NodePattern.N.withDependent("det", NodePattern.N.directlyBefore(NodePattern.N.alreadyMarkedAs("GenNoun"))))).andOr(NodePattern.N.withHeadRelation("nmod").and(withPossessivePronoun), NodePattern.N.withHeadRelation("compound|nmod").pos("SUB.*GEN.*").noDependents()).noForm("Gottes|Fangs").andNot(NodePattern.N.inFormSequence(0, ".*s", "willen")).andNot(NodePattern.N.label(".*").noLabel("MISC")).andNot(GermanTreePatterns.englishWord.directlyBefore(GermanTreePatterns.englishWord)), NodePattern.or(NodePattern.N.pos(".*GEN.*"), NodePattern.N.onlyPos(".*DAT.*").withNextSibling(NodePattern.N.withHeadRelation("nsubj"))).withHeadRelation("iobj").and(withPossessivePronoun).markAs("GenNoun").withNextSibling(NodePattern.N.pos("SUB.*").markAs("Head").withDependent("det:poss", NodePattern.N.directlyBeforeHead().markAs("SecondPossPron"))).directlyBefore(NodePattern.N.alreadyMarkedAs("SecondPossPron")), NodePattern.N.formCaseSensitive("\\p{Lu}+s").andOr(NodePattern.N.pos("SUB:GEN.*"), NodePattern.N.label("ORGANIZATION|PRODUCT")).withDependent("appos|flat", NodePattern.N.pos("SUB.*").directlyAfterHead().markAs("Head"))).andNot(WordSeparation.severalMisc).and(NodePattern.custom((genNoun, match) -> {
            Node head = match.getMarkedNode("Head");
            Node possPron = match.findMarkedNode("PossPron");
            Node secondPossPron = match.findMarkedNode("SecondPossPron");
            TreeSupport support = genNoun.tree().treeSupport();
            String baseForm = GrammarRules.getBaseForm(genNoun);
            if (baseForm.matches("\\p{Lu}+")) {
                return GrammarRules.abbrGenitiveConstructions(genNoun, match, baseForm);
            }
            if (!support.tagToken(baseForm).hasPos("SUB.*")) {
                return null;
            }
            AgreementSet headSet = AgreementSet.create(head);
            if (headSet == null) {
                return null;
            }
            AgreementSet.Gender headGender = StyleRules.pickGender(head);
            AgreementSet.Number headNumber = StyleRules.pickNumber(head, headSet);
            FeatureRestriction<Case> cases = AgreementSet.calcPossibleCases(head);
            ArrayList<String> articleVariants = new ArrayList<String>();
            for (Case caze : cases.allowed()) {
                String articleHead = Articles.getDefArticleForm(head, caze, headNumber, headGender);
                if (articleHead == null) {
                    return match;
                }
                articleVariants.add(articleHead);
            }
            AgreementSet genNounSet = AgreementSet.create(genNoun);
            if (genNounSet == null && !genNoun.hasPos(".*") && support.tagToken(baseForm).hasPos(".*SIN:FEM")) {
                return GrammarRules.makeGenitiveWithFemaleNouns(genNoun, match, possPron, articleVariants, head, baseForm);
            }
            if (genNounSet == null) {
                return null;
            }
            AgreementSet.Gender gender = StyleRules.pickGender(genNoun);
            AgreementSet.Number number = StyleRules.pickNumber(genNoun, genNounSet);
            String genArticle = Articles.getDefArticleForm(genNoun, Case.GEN, number, gender);
            if (genArticle == null) {
                return match;
            }
            if (secondPossPron != null && (gender != AgreementSet.Gender.FEM && number != AgreementSet.Number.PLU || !secondPossPron.hasForm("ihr.*")) && (gender != AgreementSet.Gender.MAS && gender != AgreementSet.Gender.NEU || !secondPossPron.hasForm("sein.*"))) {
                return null;
            }
            NodeCorrector insertArticleAndRelocateGenitive = NodeCorrector.insertAfter(head, " " + genArticle + " " + genNoun.form()).join(NodeCorrector.removeNode(genNoun));
            String genitiveAfterHead = "Setzen Sie \u201e" + genNoun.form() + "\u201c nach \u201e" + head.form() + "\u201c";
            String obsoletMsg = genitiveAfterHead + ", da die vorangestellte Genitivform veraltet ist";
            if (genNoun.prevNode() != null && !genNoun.prevNode().hasHeadRelation("det")) {
                Object baseFormPron;
                List<String> genitiveAttribute = support.synthesize(baseForm, baseForm, "SUB.*", "SUB:GEN:" + String.valueOf((Object)number) + ":" + String.valueOf((Object)gender));
                List<String> synthProns = null;
                if (possPron != null && (synthProns = support.synthesize((String)(baseFormPron = possPron.lowForm().replaceAll("(.*)e[rsmn]?", "$1")), (String)baseFormPron, "PRO:POS:.*(BEG|STV)", "PRO:POS:GEN:" + String.valueOf((Object)number) + ":" + String.valueOf((Object)gender) + ":.*")).isEmpty()) {
                    return match;
                }
                for (String variant : articleVariants) {
                    if (possPron != null) {
                        String articleOrPrep = possPron.prevNode() != null && AdjDeclination.anyFusedPreposition.matches(possPron.neighbor(-1)) ? "" : variant;
                        Node endBoundary = secondPossPron != null ? secondPossPron : genNoun;
                        for (String pron : synthProns) {
                            match = match.withCorrector(NodeCorrector.replaceNodes(possPron, endBoundary, articleOrPrep).join(NodeCorrector.insertAfter(head, " " + pron + " " + genitiveAttribute.getFirst())));
                        }
                        continue;
                    }
                    match = match.withCorrector(NodeCorrector.insertBefore(head, variant + " ").join(insertArticleAndRelocateGenitive));
                }
                String message = SemanticRules.animate.matches(genNoun) && secondPossPron == null ? obsoletMsg : genitiveAfterHead + ", um die umgangssprachliche Genitivform zu vermeiden";
                return match.withMessage(message);
            }
            return match.withCorrector(insertArticleAndRelocateGenitive).withMessage(!SemanticRules.animate.matches(genNoun) ? genitiveAfterHead + ", um den Satz standardsprachlich zu halten" : obsoletMsg);
        }));
    }

    private static NodeMatch makeGenitiveWithFemaleNouns(Node genNoun, NodeMatch match, Node possPron, List<String> articleVariants, Node head, String baseForm) {
        if (possPron != null && genNoun.prevNode() != null) {
            String baseFormPron = possPron.lowForm().replaceAll("(.*)e[rsmn]?", "$1");
            List<String> synthProns = genNoun.tree().treeSupport().synthesize(baseFormPron, baseFormPron, "PRO:POS:.*(BEG|STV)", "PRO:POS:GEN:SIN:FEM:.*");
            if (synthProns.isEmpty()) {
                return match;
            }
            Iterator<String> iterator = articleVariants.iterator();
            if (iterator.hasNext()) {
                String variant = iterator.next();
                for (String pron : synthProns) {
                    match = match.withCorrector(NodeCorrector.insertAfter(head, " " + pron + " " + baseForm).join(NodeCorrector.replaceNodes(genNoun.prevNode(), genNoun, variant + " ")));
                }
                return match.withMessage("Setzen Sie \u201e" + baseForm + "\u201c nach \u201e" + head.form() + "\u201c, um die umgangssprachliche Genitivform zu vermeiden");
            }
        }
        return null;
    }

    private static String getBaseForm(Node genNoun) {
        String baseForm = genNoun.form();
        if (genNoun.form().endsWith("s")) {
            baseForm = genNoun.form().substring(0, genNoun.form().length() - 1);
            if (baseForm.matches("\\p{Lu}+")) {
                return baseForm;
            }
            boolean candidate = genNoun.tree().treeSupport().tagToken(baseForm).hasPos("SUB:NOM:SIN.*");
            baseForm = candidate ? baseForm : baseForm.substring(0, baseForm.length() - 1);
        }
        return baseForm;
    }

    private static NodeMatch abbrGenitiveConstructions(Node genNoun, NodeMatch match, String nounWithoutEs) {
        String article;
        String next = genNoun.neighbor(1).form();
        String string = genNoun.hasPos(".*SIN:FEM|.*PLU.*") ? "der" : (article = genNoun.hasPos(".*SIN:(NEU|MAS)") ? "des" : null);
        if (article != null) {
            match = match.withCorrector(NodeCorrector.replaceNodes(genNoun, genNoun.neighbor(1), next + " " + article + " " + nounWithoutEs));
        }
        return match.withCorrector(NodeCorrector.replaceNodes(genNoun, genNoun.neighbor(1), nounWithoutEs + "-" + next)).withMessage("Verwenden Sie \u201e-\u201c oder setzen Sie die Genitivform \u201e" + nounWithoutEs + "\u201c nach \u201e" + next + "\u201c");
    }
}

