/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.editorconfig.frontend.highlighting;

import com.intellij.editorconfig.common.EditorConfigBundle;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigAsteriskPattern;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigCharClassExclamation;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigCharClassLetter;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigDoubleAsteriskPattern;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigElementTypes;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigFlatOptionKey;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigFlatPattern;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigOption;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigOptionValueIdentifier;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigQualifiedOptionKey;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigQuestionPattern;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigRawOptionValue;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigRootDeclarationKey;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigRootDeclarationValue;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigVisitor;
import com.intellij.editorconfig.frontend.highlighting.EditorConfigSyntaxHighlighter;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.containers.JBIterable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00072\u0006\u0010 \u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\rH\u0002J\u0010\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00072\u0006\u0010 \u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u000201H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/editorconfig/frontend/highlighting/EditorConfigAnnotatorVisitor;", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "<init>", "(Lcom/intellij/lang/annotation/AnnotationHolder;)V", "visitQualifiedOptionKey", "", "key", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigQualifiedOptionKey;", "checkInnerDots", "checkEdgeDots", "edgeElement", "Lcom/intellij/psi/PsiElement;", "neighbourElement", "visitOption", "option", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigOption;", "checkLineBreaks", "visitFlatOptionKey", "flatKey", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigFlatOptionKey;", "visitOptionValueIdentifier", "identifier", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigOptionValueIdentifier;", "visitRawOptionValue", "rawOptionValue", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigRawOptionValue;", "visitFlatPattern", "flatPattern", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigFlatPattern;", "visitAsteriskPattern", "pattern", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigAsteriskPattern;", "visitDoubleAsteriskPattern", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigDoubleAsteriskPattern;", "special", "visitCharClassExclamation", "exclamation", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigCharClassExclamation;", "visitQuestionPattern", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigQuestionPattern;", "visitCharClassLetter", "letter", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigCharClassLetter;", "visitRootDeclarationKey", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigRootDeclarationKey;", "visitRootDeclarationValue", "value", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigRootDeclarationValue;", "intellij.editorconfig.frontend"})
@SourceDebugExtension(value={"SMAP\nEditorConfigAnnotatorVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigAnnotatorVisitor.kt\ncom/intellij/editorconfig/frontend/highlighting/EditorConfigAnnotatorVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n1915#2,2:141\n*S KotlinDebug\n*F\n+ 1 EditorConfigAnnotatorVisitor.kt\ncom/intellij/editorconfig/frontend/highlighting/EditorConfigAnnotatorVisitor\n*L\n24#1:141,2\n*E\n"})
public final class EditorConfigAnnotatorVisitor
extends EditorConfigVisitor {
    @NotNull
    private final AnnotationHolder holder;

    public EditorConfigAnnotatorVisitor(@NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }

    public void visitQualifiedOptionKey(@NotNull EditorConfigQualifiedOptionKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        PsiElement psiElement = key.getFirstChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getFirstChild(...)");
        this.checkEdgeDots(psiElement, key.getFirstChild().getNextSibling());
        PsiElement psiElement2 = key.getLastChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getLastChild(...)");
        this.checkEdgeDots(psiElement2, key.getLastChild().getPrevSibling());
        this.checkInnerDots(key);
    }

    private final void checkInnerDots(EditorConfigQualifiedOptionKey key) {
        PsiElement firstDot = null;
        PsiElement lastDot = null;
        JBIterable jBIterable = SyntaxTraverser.psiTraverser().children((Object)key);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"children(...)");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)EditorConfigElementTypes.DOT)) {
                if (firstDot == null) {
                    firstDot = it;
                }
                lastDot = it;
                continue;
            }
            if (!Intrinsics.areEqual(firstDot, lastDot)) {
                TextRange range;
                String message = EditorConfigBundle.INSTANCE.get("annotator.error.multiple-dots", new Object[0]);
                PsiElement psiElement = firstDot;
                Intrinsics.checkNotNull((Object)psiElement);
                int start = psiElement.getTextRange().getStartOffset();
                PsiElement psiElement2 = lastDot;
                Intrinsics.checkNotNull((Object)psiElement2);
                int end = psiElement2.getTextRange().getEndOffset();
                Intrinsics.checkNotNullExpressionValue((Object)TextRange.create((int)start, (int)end), (String)"create(...)");
                this.holder.newAnnotation(HighlightSeverity.ERROR, message).range(range).create();
                firstDot = null;
                lastDot = null;
                continue;
            }
            firstDot = null;
            lastDot = null;
        }
    }

    private final void checkEdgeDots(PsiElement edgeElement, PsiElement neighbourElement) {
        if (!Intrinsics.areEqual((Object)edgeElement.getNode().getElementType(), (Object)EditorConfigElementTypes.DOT)) {
            return;
        }
        PsiElement psiElement = neighbourElement;
        if (Intrinsics.areEqual((Object)(psiElement != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : null), (Object)EditorConfigElementTypes.DOT)) {
            return;
        }
        String message = EditorConfigBundle.INSTANCE.get("annotator.error.key.dangling-dot", new Object[0]);
        this.holder.newAnnotation(HighlightSeverity.ERROR, message).range(edgeElement).create();
    }

    public void visitOption(@NotNull EditorConfigOption option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        this.checkLineBreaks(option);
    }

    private final void checkLineBreaks(EditorConfigOption option) {
        if (!option.textContains('\n')) {
            return;
        }
        String message = EditorConfigBundle.INSTANCE.get("annotator.error.option.suspicious.line.break", new Object[0]);
        this.holder.newAnnotation(HighlightSeverity.ERROR, message).range((PsiElement)option).create();
    }

    public void visitFlatOptionKey(@NotNull EditorConfigFlatOptionKey flatKey) {
        Intrinsics.checkNotNullParameter((Object)flatKey, (String)"flatKey");
        this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range((PsiElement)flatKey).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getPROPERTY_KEY()).create();
    }

    public void visitOptionValueIdentifier(@NotNull EditorConfigOptionValueIdentifier identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range((PsiElement)identifier).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getPROPERTY_VALUE()).create();
    }

    public void visitRawOptionValue(@NotNull EditorConfigRawOptionValue rawOptionValue) {
        Intrinsics.checkNotNullParameter((Object)rawOptionValue, (String)"rawOptionValue");
        this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range((PsiElement)rawOptionValue).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getPROPERTY_VALUE()).create();
    }

    public void visitFlatPattern(@NotNull EditorConfigFlatPattern flatPattern) {
        Intrinsics.checkNotNullParameter((Object)flatPattern, (String)"flatPattern");
        this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range((PsiElement)flatPattern).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getPATTERN()).create();
        if (!flatPattern.textContains('\\')) {
            return;
        }
        String text = flatPattern.getText();
        int offset = flatPattern.getTextOffset();
        for (int index = 0; index < text.length(); ++index) {
            if (text.charAt(index) != '\\') continue;
            TextRange range = new TextRange(offset + index, offset + index + 2);
            if (StringsKt.contains$default((CharSequence)" \r\n\t\\#;!?*[]{}", (char)text.charAt(++index), (boolean)false, (int)2, null)) {
                this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(range).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getVALID_CHAR_ESCAPE()).create();
                continue;
            }
            String message = EditorConfigBundle.INSTANCE.get("annotator.error.illegal.char.escape", new Object[0]);
            this.holder.newAnnotation(HighlightSeverity.INFORMATION, message).range(range).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getINVALID_CHAR_ESCAPE()).create();
        }
    }

    public void visitAsteriskPattern(@NotNull EditorConfigAsteriskPattern pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        this.special((PsiElement)pattern);
    }

    public void visitDoubleAsteriskPattern(@NotNull EditorConfigDoubleAsteriskPattern pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        this.special((PsiElement)pattern);
    }

    private final void special(PsiElement pattern) {
        this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(pattern).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getSPECIAL_SYMBOL()).create();
    }

    public void visitCharClassExclamation(@NotNull EditorConfigCharClassExclamation exclamation) {
        Intrinsics.checkNotNullParameter((Object)exclamation, (String)"exclamation");
        this.special((PsiElement)exclamation);
    }

    public void visitQuestionPattern(@NotNull EditorConfigQuestionPattern pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        this.special((PsiElement)pattern);
    }

    public void visitCharClassLetter(@NotNull EditorConfigCharClassLetter letter) {
        Intrinsics.checkNotNullParameter((Object)letter, (String)"letter");
        if (!letter.isEscape()) {
            this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range((PsiElement)letter).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getPATTERN()).create();
        } else if (letter.isValidEscape()) {
            this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range((PsiElement)letter).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getVALID_CHAR_ESCAPE()).create();
        } else {
            this.holder.newAnnotation(HighlightSeverity.INFORMATION, EditorConfigBundle.INSTANCE.get("annotator.error.illegal.char.escape", new Object[0])).range((PsiElement)letter).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getINVALID_CHAR_ESCAPE()).create();
        }
    }

    public void visitRootDeclarationKey(@NotNull EditorConfigRootDeclarationKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range((PsiElement)key).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getPROPERTY_KEY()).create();
    }

    public void visitRootDeclarationValue(@NotNull EditorConfigRootDeclarationValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range((PsiElement)value).textAttributes(EditorConfigSyntaxHighlighter.INSTANCE.getPROPERTY_VALUE()).create();
    }
}

