/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project.model.impl.module.content;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.project.model.impl.module.JpsRootModel;
import com.intellij.project.model.impl.module.content.JpsExcludeFolder;
import com.intellij.project.model.impl.module.content.JpsSourceFolder;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsExcludePattern;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class JpsContentEntry
implements ContentEntry,
Disposable {
    private final VirtualFilePointer myRoot;
    private final JpsModule myModule;
    private final JpsRootModel myRootModel;
    private final List<JpsSourceFolder> mySourceFolders;
    private final List<JpsExcludeFolder> myExcludeFolders;
    private final List<String> myExcludePatterns;

    public JpsContentEntry(JpsModule module, JpsRootModel rootModel, String rootUrl) {
        this.myModule = module;
        this.myRootModel = rootModel;
        this.myRoot = VirtualFilePointerManager.getInstance().create(rootUrl, (Disposable)this, null);
        this.mySourceFolders = new ArrayList<JpsSourceFolder>();
        String rootPath = VfsUtilCore.urlToPath((String)this.getUrl());
        for (JpsModuleSourceRoot root : this.myModule.getSourceRoots()) {
            if (!FileUtil.isAncestor((String)rootPath, (String)VfsUtilCore.urlToPath((String)root.getUrl()), (boolean)false)) continue;
            this.mySourceFolders.add(new JpsSourceFolder(root, this));
        }
        this.myExcludeFolders = new ArrayList<JpsExcludeFolder>();
        for (String excludedUrl : this.myModule.getExcludeRootsList().getUrls()) {
            if (!FileUtil.isAncestor((String)rootPath, (String)VfsUtilCore.urlToPath((String)excludedUrl), (boolean)false)) continue;
            this.myExcludeFolders.add(new JpsExcludeFolder(excludedUrl, this));
        }
        this.myExcludePatterns = new SmartList();
        for (JpsExcludePattern pattern : this.myModule.getExcludePatterns()) {
            if (!pattern.getBaseDirUrl().equals(rootUrl)) continue;
            this.myExcludePatterns.add(pattern.getPattern());
        }
    }

    public VirtualFile getFile() {
        return this.myRoot.getFile();
    }

    @NotNull
    public String getUrl() {
        String string = this.myRoot.getUrl();
        if (string == null) {
            JpsContentEntry.$$$reportNull$$$0(0);
        }
        return string;
    }

    public SourceFolder @NotNull [] getSourceFolders() {
        SourceFolder[] sourceFolderArray = this.mySourceFolders.toArray(new SourceFolder[0]);
        if (sourceFolderArray == null) {
            JpsContentEntry.$$$reportNull$$$0(1);
        }
        return sourceFolderArray;
    }

    @NotNull
    public List<SourceFolder> getSourceFolders(@NotNull JpsModuleSourceRootType<?> rootType) {
        if (rootType == null) {
            JpsContentEntry.$$$reportNull$$$0(2);
        }
        List<SourceFolder> list = this.getSourceFolders(Collections.singleton(rootType));
        if (list == null) {
            JpsContentEntry.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<SourceFolder> getSourceFolders(@NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        if (rootTypes == null) {
            JpsContentEntry.$$$reportNull$$$0(4);
        }
        SmartList folders = new SmartList();
        for (JpsSourceFolder folder : this.mySourceFolders) {
            if (!rootTypes.contains(folder.getRootType())) continue;
            folders.add(folder);
        }
        SmartList smartList = folders;
        if (smartList == null) {
            JpsContentEntry.$$$reportNull$$$0(5);
        }
        return smartList;
    }

    public VirtualFile @NotNull [] getSourceFolderFiles() {
        VirtualFile[] virtualFileArray = JpsContentEntry.getFiles((ContentFolder[])this.getSourceFolders());
        if (virtualFileArray == null) {
            JpsContentEntry.$$$reportNull$$$0(6);
        }
        return virtualFileArray;
    }

    private static VirtualFile[] getFiles(ContentFolder[] sourceFolders) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>(sourceFolders.length);
        for (ContentFolder sourceFolder : sourceFolders) {
            VirtualFile file = sourceFolder.getFile();
            if (file == null) continue;
            result.add(file);
        }
        return VfsUtilCore.toVirtualFileArray(result);
    }

    public ExcludeFolder @NotNull [] getExcludeFolders() {
        ExcludeFolder[] excludeFolderArray = this.myExcludeFolders.toArray(new ExcludeFolder[0]);
        if (excludeFolderArray == null) {
            JpsContentEntry.$$$reportNull$$$0(7);
        }
        return excludeFolderArray;
    }

    @NotNull
    public List<String> getExcludeFolderUrls() {
        ArrayList<String> excluded = new ArrayList<String>();
        for (JpsExcludeFolder folder : this.myExcludeFolders) {
            excluded.add(folder.getUrl());
        }
        for (DirectoryIndexExcludePolicy excludePolicy : DirectoryIndexExcludePolicy.EP_NAME.getExtensions((AreaInstance)this.myRootModel.getProject())) {
            for (VirtualFilePointer pointer : excludePolicy.getExcludeRootsForModule(this.myRootModel)) {
                excluded.add(pointer.getUrl());
            }
        }
        ArrayList<String> arrayList = excluded;
        if (arrayList == null) {
            JpsContentEntry.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    public VirtualFile @NotNull [] getExcludeFolderFiles() {
        ArrayList excluded = new ArrayList();
        for (JpsExcludeFolder folder : this.myExcludeFolders) {
            ContainerUtil.addIfNotNull(excluded, (Object)folder.getFile());
        }
        for (DirectoryIndexExcludePolicy excludePolicy : DirectoryIndexExcludePolicy.EP_NAME.getExtensions((AreaInstance)this.myRootModel.getProject())) {
            for (VirtualFilePointer pointer : excludePolicy.getExcludeRootsForModule(this.myRootModel)) {
                ContainerUtil.addIfNotNull(excluded, (Object)pointer.getFile());
            }
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(excluded);
        if (virtualFileArray == null) {
            JpsContentEntry.$$$reportNull$$$0(9);
        }
        return virtualFileArray;
    }

    @NotNull
    public SourceFolder addSourceFolder(@NotNull VirtualFile file, boolean isTestSource) {
        if (file == null) {
            JpsContentEntry.$$$reportNull$$$0(10);
        }
        SourceFolder sourceFolder = this.addSourceFolder(file, isTestSource, "");
        if (sourceFolder == null) {
            JpsContentEntry.$$$reportNull$$$0(11);
        }
        return sourceFolder;
    }

    @NotNull
    public SourceFolder addSourceFolder(@NotNull VirtualFile file, boolean isTestSource, @NotNull String packagePrefix) {
        if (file == null) {
            JpsContentEntry.$$$reportNull$$$0(12);
        }
        if (packagePrefix == null) {
            JpsContentEntry.$$$reportNull$$$0(13);
        }
        SourceFolder sourceFolder = this.addSourceFolder(file.getUrl(), isTestSource, packagePrefix);
        if (sourceFolder == null) {
            JpsContentEntry.$$$reportNull$$$0(14);
        }
        return sourceFolder;
    }

    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull VirtualFile file, @NotNull JpsModuleSourceRootType<P> type, @NotNull P properties) {
        if (file == null) {
            JpsContentEntry.$$$reportNull$$$0(15);
        }
        if (type == null) {
            JpsContentEntry.$$$reportNull$$$0(16);
        }
        if (properties == null) {
            JpsContentEntry.$$$reportNull$$$0(17);
        }
        JpsModuleSourceRoot sourceRoot = this.myModule.addSourceRoot(file.getUrl(), type, properties);
        JpsSourceFolder sourceFolder = new JpsSourceFolder(sourceRoot, this);
        this.mySourceFolders.add(sourceFolder);
        JpsSourceFolder jpsSourceFolder = sourceFolder;
        if (jpsSourceFolder == null) {
            JpsContentEntry.$$$reportNull$$$0(18);
        }
        return jpsSourceFolder;
    }

    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull VirtualFile file, @NotNull JpsModuleSourceRootType<P> type) {
        if (file == null) {
            JpsContentEntry.$$$reportNull$$$0(19);
        }
        if (type == null) {
            JpsContentEntry.$$$reportNull$$$0(20);
        }
        SourceFolder sourceFolder = this.addSourceFolder(file, type, (JpsElement)type.createDefaultProperties());
        if (sourceFolder == null) {
            JpsContentEntry.$$$reportNull$$$0(21);
        }
        return sourceFolder;
    }

    private SourceFolder addSourceFolder(String url, boolean isTestSource, String packagePrefix) {
        JavaSourceRootType rootType = isTestSource ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE;
        JavaSourceRootProperties properties = JpsJavaExtensionService.getInstance().createSourceRootProperties(packagePrefix);
        return this.addSourceFolder(url, (JpsModuleSourceRootType)rootType, (JpsElement)properties);
    }

    @NotNull
    public SourceFolder addSourceFolder(@NotNull String url, boolean isTestSource) {
        if (url == null) {
            JpsContentEntry.$$$reportNull$$$0(22);
        }
        SourceFolder sourceFolder = this.addSourceFolder(url, isTestSource, "");
        if (sourceFolder == null) {
            JpsContentEntry.$$$reportNull$$$0(23);
        }
        return sourceFolder;
    }

    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull String url, @NotNull JpsModuleSourceRootType<P> type) {
        if (url == null) {
            JpsContentEntry.$$$reportNull$$$0(24);
        }
        if (type == null) {
            JpsContentEntry.$$$reportNull$$$0(25);
        }
        SourceFolder sourceFolder = this.addSourceFolder(url, type, (JpsElement)type.createDefaultProperties());
        if (sourceFolder == null) {
            JpsContentEntry.$$$reportNull$$$0(26);
        }
        return sourceFolder;
    }

    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull String url, @NotNull JpsModuleSourceRootType<P> type, @NotNull ProjectModelExternalSource externalSource) {
        if (url == null) {
            JpsContentEntry.$$$reportNull$$$0(27);
        }
        if (type == null) {
            JpsContentEntry.$$$reportNull$$$0(28);
        }
        if (externalSource == null) {
            JpsContentEntry.$$$reportNull$$$0(29);
        }
        SourceFolder sourceFolder = this.addSourceFolder(url, type, (JpsElement)type.createDefaultProperties());
        if (sourceFolder == null) {
            JpsContentEntry.$$$reportNull$$$0(30);
        }
        return sourceFolder;
    }

    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull String url, @NotNull JpsModuleSourceRootType<P> type, boolean isAutomaticallyImported) {
        if (url == null) {
            JpsContentEntry.$$$reportNull$$$0(31);
        }
        if (type == null) {
            JpsContentEntry.$$$reportNull$$$0(32);
        }
        SourceFolder sourceFolder = this.addSourceFolder(url, type, (JpsElement)type.createDefaultProperties());
        if (sourceFolder == null) {
            JpsContentEntry.$$$reportNull$$$0(33);
        }
        return sourceFolder;
    }

    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull String url, @NotNull JpsModuleSourceRootType<P> type, @NotNull P properties) {
        if (url == null) {
            JpsContentEntry.$$$reportNull$$$0(34);
        }
        if (type == null) {
            JpsContentEntry.$$$reportNull$$$0(35);
        }
        if (properties == null) {
            JpsContentEntry.$$$reportNull$$$0(36);
        }
        JpsModuleSourceRoot sourceRoot = this.myModule.addSourceRoot(url, type, properties);
        JpsSourceFolder sourceFolder = new JpsSourceFolder(sourceRoot, this);
        this.mySourceFolders.add(sourceFolder);
        JpsSourceFolder jpsSourceFolder = sourceFolder;
        if (jpsSourceFolder == null) {
            JpsContentEntry.$$$reportNull$$$0(37);
        }
        return jpsSourceFolder;
    }

    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull String url, @NotNull JpsModuleSourceRootType<P> type, @NotNull P properties, boolean isAutomaticallyImported) {
        if (url == null) {
            JpsContentEntry.$$$reportNull$$$0(38);
        }
        if (type == null) {
            JpsContentEntry.$$$reportNull$$$0(39);
        }
        if (properties == null) {
            JpsContentEntry.$$$reportNull$$$0(40);
        }
        SourceFolder sourceFolder = this.addSourceFolder(url, type, properties);
        if (sourceFolder == null) {
            JpsContentEntry.$$$reportNull$$$0(41);
        }
        return sourceFolder;
    }

    @NotNull
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull String url, @NotNull JpsModuleSourceRootType<P> type, @NotNull P properties, @Nullable ProjectModelExternalSource externalSource) {
        if (url == null) {
            JpsContentEntry.$$$reportNull$$$0(42);
        }
        if (type == null) {
            JpsContentEntry.$$$reportNull$$$0(43);
        }
        if (properties == null) {
            JpsContentEntry.$$$reportNull$$$0(44);
        }
        SourceFolder sourceFolder = this.addSourceFolder(url, type, properties);
        if (sourceFolder == null) {
            JpsContentEntry.$$$reportNull$$$0(45);
        }
        return sourceFolder;
    }

    public void removeSourceFolder(@NotNull SourceFolder sourceFolder) {
        if (sourceFolder == null) {
            JpsContentEntry.$$$reportNull$$$0(46);
        }
        JpsSourceFolder folder = (JpsSourceFolder)sourceFolder;
        this.mySourceFolders.remove(folder);
        this.myModule.removeSourceRoot(folder.getSourceRoot().getUrl(), folder.getSourceRoot().getRootType());
        Disposer.dispose((Disposable)folder);
    }

    public void clearSourceFolders() {
        ArrayList<JpsModuleSourceRoot> toRemove = new ArrayList<JpsModuleSourceRoot>();
        for (JpsSourceFolder folder : this.mySourceFolders) {
            toRemove.add(folder.getSourceRoot());
            Disposer.dispose((Disposable)folder);
        }
        this.mySourceFolders.clear();
        for (JpsModuleSourceRoot root : toRemove) {
            this.myModule.removeSourceRoot(root.getUrl(), root.getRootType());
        }
    }

    @NotNull
    public ExcludeFolder addExcludeFolder(@NotNull VirtualFile file) {
        if (file == null) {
            JpsContentEntry.$$$reportNull$$$0(47);
        }
        ExcludeFolder excludeFolder = this.addExcludeFolder(file.getUrl());
        if (excludeFolder == null) {
            JpsContentEntry.$$$reportNull$$$0(48);
        }
        return excludeFolder;
    }

    @NotNull
    public ExcludeFolder addExcludeFolder(@NotNull String url) {
        if (url == null) {
            JpsContentEntry.$$$reportNull$$$0(49);
        }
        JpsExcludeFolder folder = new JpsExcludeFolder(url, this);
        this.myModule.getExcludeRootsList().addUrl(url);
        this.myExcludeFolders.add(folder);
        JpsExcludeFolder jpsExcludeFolder = folder;
        if (jpsExcludeFolder == null) {
            JpsContentEntry.$$$reportNull$$$0(50);
        }
        return jpsExcludeFolder;
    }

    @NotNull
    public ExcludeFolder addExcludeFolder(@NotNull String url, boolean isAutomaticallyImported) {
        if (url == null) {
            JpsContentEntry.$$$reportNull$$$0(51);
        }
        ExcludeFolder excludeFolder = this.addExcludeFolder(url);
        if (excludeFolder == null) {
            JpsContentEntry.$$$reportNull$$$0(52);
        }
        return excludeFolder;
    }

    public void removeExcludeFolder(@NotNull ExcludeFolder excludeFolder) {
        if (excludeFolder == null) {
            JpsContentEntry.$$$reportNull$$$0(53);
        }
        JpsExcludeFolder folder = (JpsExcludeFolder)excludeFolder;
        this.myExcludeFolders.remove(folder);
        this.myModule.getExcludeRootsList().removeUrl(folder.getUrl());
        Disposer.dispose((Disposable)folder);
    }

    public boolean removeExcludeFolder(@NotNull String url) {
        if (url == null) {
            JpsContentEntry.$$$reportNull$$$0(54);
        }
        for (JpsExcludeFolder folder : this.myExcludeFolders) {
            if (!folder.getUrl().equals(url)) continue;
            this.myExcludeFolders.remove(folder);
            this.myModule.getExcludeRootsList().removeUrl(url);
            Disposer.dispose((Disposable)folder);
            return true;
        }
        return false;
    }

    public void clearExcludeFolders() {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (JpsExcludeFolder folder : this.myExcludeFolders) {
            toRemove.add(folder.getUrl());
            Disposer.dispose((Disposable)folder);
        }
        this.myExcludeFolders.clear();
        for (String url : toRemove) {
            this.myModule.getExcludeRootsList().removeUrl(url);
        }
    }

    @NotNull
    public List<String> getExcludePatterns() {
        List<String> list = this.myExcludePatterns;
        if (list == null) {
            JpsContentEntry.$$$reportNull$$$0(55);
        }
        return list;
    }

    public void addExcludePattern(@NotNull String pattern) {
        if (pattern == null) {
            JpsContentEntry.$$$reportNull$$$0(56);
        }
        this.myExcludePatterns.add(pattern);
        this.myModule.addExcludePattern(this.getUrl(), pattern);
    }

    public void removeExcludePattern(@NotNull String pattern) {
        if (pattern == null) {
            JpsContentEntry.$$$reportNull$$$0(57);
        }
        this.myExcludePatterns.remove(pattern);
        this.myModule.removeExcludePattern(this.getUrl(), pattern);
    }

    public void setExcludePatterns(@NotNull List<String> patterns) {
        if (patterns == null) {
            JpsContentEntry.$$$reportNull$$$0(58);
        }
        for (String pattern : this.myExcludePatterns) {
            this.myModule.removeExcludePattern(this.getUrl(), pattern);
        }
        this.myExcludePatterns.clear();
        for (String pattern : patterns) {
            this.addExcludePattern(pattern);
        }
    }

    @NotNull
    public ModuleRootModel getRootModel() {
        JpsRootModel jpsRootModel = this.myRootModel;
        if (jpsRootModel == null) {
            JpsContentEntry.$$$reportNull$$$0(59);
        }
        return jpsRootModel;
    }

    public boolean isSynthetic() {
        return false;
    }

    public void dispose() {
        for (JpsSourceFolder jpsSourceFolder : this.mySourceFolders) {
            Disposer.dispose((Disposable)jpsSourceFolder);
        }
        for (JpsExcludeFolder jpsExcludeFolder : this.myExcludeFolders) {
            Disposer.dispose((Disposable)jpsExcludeFolder);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 10, 12, 13, 15, 16, 17, 19, 20, 22, 24, 25, 27, 28, 29, 31, 32, 34, 35, 36, 38, 39, 40, 42, 43, 44, 46, 47, 49, 51, 53, 54, 56, 57, 58 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/project/model/impl/module/content/JpsContentEntry";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypes";
                break;
            }
            case 10: 
            case 12: 
            case 15: 
            case 19: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packagePrefix";
                break;
            }
            case 16: 
            case 20: 
            case 25: 
            case 28: 
            case 32: 
            case 35: 
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 17: 
            case 36: 
            case 40: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 22: 
            case 24: 
            case 27: 
            case 31: 
            case 34: 
            case 38: 
            case 42: 
            case 49: 
            case 51: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSource";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFolder";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludeFolder";
                break;
            }
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFolders";
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/project/model/impl/module/content/JpsContentEntry";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFolderFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeFolders";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeFolderUrls";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeFolderFiles";
                break;
            }
            case 11: 
            case 14: 
            case 18: 
            case 21: 
            case 23: 
            case 26: 
            case 30: 
            case 33: 
            case 37: 
            case 41: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "addSourceFolder";
                break;
            }
            case 48: 
            case 50: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "addExcludeFolder";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludePatterns";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFolders";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "addSourceFolder";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "removeSourceFolder";
                break;
            }
            case 47: 
            case 49: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "addExcludeFolder";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "removeExcludeFolder";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "addExcludePattern";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "removeExcludePattern";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "setExcludePatterns";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 10, 12, 13, 15, 16, 17, 19, 20, 22, 24, 25, 27, 28, 29, 31, 32, 34, 35, 36, 38, 39, 40, 42, 43, 44, 46, 47, 49, 51, 53, 54, 56, 57, 58 -> new IllegalArgumentException(string);
        };
    }
}

