/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.ui.codereview.reactions;

import com.intellij.collaboration.ui.codereview.reactions.PillButton;
import com.intellij.collaboration.ui.codereview.reactions.PillButtonBorder;
import com.intellij.collaboration.ui.codereview.reactions.UIResourceBorder;
import com.intellij.collaboration.ui.util.CodeReviewColorUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonUI;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\f\u001a\u00020\u0012H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/collaboration/ui/codereview/reactions/PillButtonUI;", "Ljavax/swing/plaf/basic/BasicButtonUI;", "<init>", "()V", "getPropertyPrefix", "", "installDefaults", "", "b", "Ljavax/swing/AbstractButton;", "getPreferredSize", "Ljava/awt/Dimension;", "c", "Ljavax/swing/JComponent;", "paint", "g", "Ljava/awt/Graphics;", "paintBackground", "Lcom/intellij/collaboration/ui/codereview/reactions/PillButton;", "getBackgroundColor", "Ljava/awt/Color;", "Companion", "intellij.platform.collaborationTools"})
final class PillButtonUI
extends BasicButtonUI {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String PROPERTY_PREFIX = "PillButton.";

    @Override
    @NotNull
    protected String getPropertyPrefix() {
        return PROPERTY_PREFIX;
    }

    @Override
    protected void installDefaults(@NotNull AbstractButton b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        LookAndFeel.installProperty(b, "opaque", false);
        LookAndFeel.installProperty(b, "rolloverEnabled", true);
        LookAndFeel.installProperty(b, "iconTextGap", 4);
        if (b.getFont() == null || b.getFont() instanceof UIResource) {
            b.setFont(UIUtil.getLabelFont());
        }
        b.setBackground((Color)CodeReviewColorUtil.Reaction.INSTANCE.getBackground());
        if (b.getBorder() == null || b.getBorder() instanceof UIResource) {
            b.setBorder(new UIResourceBorder(new PillButtonBorder(null, 1, null)));
        }
        if (!(b instanceof PillButton)) {
            return;
        }
        if (((PillButton)b).getMargin() == null || ((PillButton)b).getMargin() instanceof UIResource) {
            ((PillButton)b).setMargin((Insets)JBInsets.create((int)1, (int)6).asUIResource());
        }
        ((PillButton)b).setRolloverBackground((Color)CodeReviewColorUtil.Reaction.INSTANCE.getBackgroundHovered());
        ((PillButton)b).setPressedBackground((Color)CodeReviewColorUtil.Reaction.INSTANCE.getBackgroundPressed());
    }

    @Override
    @NotNull
    public Dimension getPreferredSize(@NotNull JComponent c) {
        Dimension dimension;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Dimension it = dimension = super.getPreferredSize(c);
        boolean bl = false;
        if (c instanceof AbstractButton) {
            JBInsets.addTo((Dimension)it, (Insets)((AbstractButton)c).getMargin());
        }
        Dimension dimension2 = dimension;
        Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"also(...)");
        return dimension2;
    }

    @Override
    public void paint(@NotNull Graphics g, @NotNull JComponent c) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        PillButton pillButton = c instanceof PillButton ? (PillButton)c : null;
        if (pillButton == null) {
            return;
        }
        PillButton button = pillButton;
        if (button.isContentAreaFilled()) {
            this.paintBackground(g, (PillButton)c);
        }
        super.paint(g, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void paintBackground(Graphics g, PillButton c) {
        Rectangle r = new Rectangle(c.getSize());
        JBInsets.removeFrom((Rectangle)r, (Insets)c.getInsets());
        Graphics graphics = g.create(r.x, r.y, r.width, r.height);
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2d = (Graphics2D)graphics;
        try {
            GraphicsUtil.setupAAPainting((Graphics)g2d);
            int arc = r.height;
            g2d.setColor(this.getBackgroundColor(c));
            g2d.fill(new RoundRectangle2D.Float(0.0f, 0.0f, r.width, r.height, arc, arc));
        }
        finally {
            g2d.dispose();
        }
    }

    private final Color getBackgroundColor(PillButton c) {
        Color color;
        ButtonModel buttonModel = c.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)buttonModel, (String)"getModel(...)");
        ButtonModel model = buttonModel;
        Color background = null;
        if (c.isRolloverEnabled() && c.isEnabled()) {
            if (model.isRollover()) {
                background = c.getRolloverBackground();
            } else if (model.isArmed() && model.isPressed()) {
                background = c.getPressedBackground();
            }
        }
        if ((color = background) == null) {
            color = c.getBackground();
        }
        return color;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/collaboration/ui/codereview/reactions/PillButtonUI$Companion;", "", "<init>", "()V", "PROPERTY_PREFIX", "", "intellij.platform.collaborationTools"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

