/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.connection.audit;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.connection.audit.ListenerAuditService;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementData;
import com.intellij.database.dataSource.connection.statements.SmartStatementMark;
import com.intellij.database.dataSource.connection.statements.SmartStatementsUtil;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\bf\u0018\u0000 \u00042\u00020\u00012\u00060\u0002j\u0002`\u0003:\u000b\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService;", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "Companion", "Printer", "Service", "Block", "TextBlock", "DataSourceBlock", "BlockType", "LogInfo", "DatabaseLogRecord", "DatabaseLogBlockRecord", "Counter", "intellij.database.core.impl"})
public interface DatabaseGlobalAuditService
extends ListenerAuditService,
AutoCloseable {
    @NotNull
    public static final Companion Companion = com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.$$INSTANCE;

    @JvmStatic
    @NotNull
    public static java.util.logging.Logger logger(@Nullable Project project, @NotNull DatabaseConnectionCore connection2) {
        return Companion.logger(project, connection2);
    }

    @JvmStatic
    @NotNull
    public static java.util.logging.Logger logger(@Nullable Project project, @NotNull DasDataSource dataSource, @Nullable String sessionId) {
        return Companion.logger(project, dataSource, sessionId);
    }

    @JvmStatic
    @NotNull
    public static java.util.logging.Logger logger(@Nullable Project project, @NotNull String dataSourceId, @Nullable String sessionId) {
        return Companion.logger(project, dataSourceId, sessionId);
    }

    @JvmStatic
    @TestOnly
    @NotNull
    public static Set<SmartStatementMark> getPendingStatements() {
        return Companion.getPendingStatements();
    }

    @JvmStatic
    public static void attach(@NotNull Handler handler2, @NotNull Disposable disposable) {
        Companion.attach(handler2, disposable);
    }

    @JvmStatic
    public static void setRootLevel(@NotNull Level level, @NotNull Disposable disposable) {
        Companion.setRootLevel(level, disposable);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Block;", "", "type", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "format", "", "<init>", "(Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;Z)V", "getType", "()Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "getFormat", "()Z", "content", "", "getContent", "()Ljava/lang/String;", "text", "getText", "text$delegate", "Lkotlin/Lazy;", "intellij.database.core.impl"})
    public static abstract class Block {
        @NotNull
        private final BlockType type;
        private final boolean format;
        @NotNull
        private final Lazy text$delegate;

        public Block(@NotNull BlockType type, boolean format) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.type = type;
            this.format = format;
            this.text$delegate = LazyKt.lazy(() -> Block.text_delegate$lambda$0(this));
        }

        public /* synthetic */ Block(BlockType blockType, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = true;
            }
            this(blockType, bl);
        }

        @NotNull
        public final BlockType getType() {
            return this.type;
        }

        public final boolean getFormat() {
            return this.format;
        }

        @NotNull
        protected abstract String getContent();

        @NotNull
        public final String getText() {
            Lazy lazy = this.text$delegate;
            return (String)lazy.getValue();
        }

        private static final String text_delegate$lambda$0(Block this$0) {
            return this$0.format ? this$0.type.format(this$0.getContent()) : this$0.getContent();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u001c\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0013\b\u0002\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u000e\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003J\u000e\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001a\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "", "separator", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getSeparator", "()Ljava/lang/String;", "STATEMENT_PREFIX", "LINE_PREFIX", "TIMESTAMP", "DATA_SOURCE", "SUBSYSTEM", "SESSION_ID", "STATEMENT_ID", "EVENT_TYPE", "STATEMENT", "MESSAGE", "WARNING", "ERROR", "PROJECT", "EXECUTION_DURATION", "FETCHING_DURATION", "UPDATE_COUNT", "TOTAL_UPDATE_COUNT", "TOTAL_RESULT_SET_COUNT", "STATEMENT_SUFFIX", "format", "s", "bound", "inline", "intellij.database.core.impl"})
    public static final class BlockType
    extends Enum<BlockType> {
        @NotNull
        private final String separator;
        public static final /* enum */ BlockType STATEMENT_PREFIX = new BlockType("\n");
        public static final /* enum */ BlockType LINE_PREFIX = new BlockType("LINE_PREFIX", 1, null, 1, null);
        public static final /* enum */ BlockType TIMESTAMP = new BlockType("TIMESTAMP", 2, null, 1, null);
        public static final /* enum */ BlockType DATA_SOURCE = new DATA_SOURCE("DATA_SOURCE", 3);
        public static final /* enum */ BlockType SUBSYSTEM = new SUBSYSTEM("SUBSYSTEM", 4);
        public static final /* enum */ BlockType SESSION_ID = new SESSION_ID("SESSION_ID", 5);
        public static final /* enum */ BlockType STATEMENT_ID = new STATEMENT_ID("STATEMENT_ID", 6);
        public static final /* enum */ BlockType EVENT_TYPE = new BlockType(" - ");
        public static final /* enum */ BlockType STATEMENT = new STATEMENT("STATEMENT", 8);
        public static final /* enum */ BlockType MESSAGE = new MESSAGE("MESSAGE", 9);
        public static final /* enum */ BlockType WARNING = new WARNING("WARNING", 10);
        public static final /* enum */ BlockType ERROR = new ERROR("ERROR", 11);
        public static final /* enum */ BlockType PROJECT = new PROJECT("PROJECT", 12);
        public static final /* enum */ BlockType EXECUTION_DURATION = new BlockType(", ");
        public static final /* enum */ BlockType FETCHING_DURATION = new BlockType(", ");
        public static final /* enum */ BlockType UPDATE_COUNT = new BlockType("UPDATE_COUNT", 15, null, 1, null);
        public static final /* enum */ BlockType TOTAL_UPDATE_COUNT = new BlockType(", ");
        public static final /* enum */ BlockType TOTAL_RESULT_SET_COUNT = new BlockType(", ");
        public static final /* enum */ BlockType STATEMENT_SUFFIX = new BlockType("");
        private static final /* synthetic */ BlockType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private BlockType(String separator) {
            this.separator = separator;
        }

        /* synthetic */ BlockType(String string, int n, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                string2 = " ";
            }
            this(string2);
        }

        @NotNull
        public final String getSeparator() {
            return this.separator;
        }

        @NotNull
        public String format(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return s;
        }

        @NotNull
        public final String bound(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return "[" + s + "]";
        }

        @NotNull
        public final String inline(@NotNull String s) {
            String string;
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            if (StringUtil.containsLineBreak((CharSequence)s)) {
                String string2 = StringUtil.escapeStringCharacters((String)s);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"escapeStringCharacters(...)");
            } else {
                string = s;
            }
            return string;
        }

        public static BlockType[] values() {
            return (BlockType[])$VALUES.clone();
        }

        public static BlockType valueOf(String value) {
            return Enum.valueOf(BlockType.class, value);
        }

        @NotNull
        public static EnumEntries<BlockType> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ BlockType(String $enum$name, int $enum$ordinal, String separator, DefaultConstructorMarker $constructor_marker) {
            this(separator);
        }

        static {
            $VALUES = blockTypeArray = new BlockType[]{BlockType.STATEMENT_PREFIX, BlockType.LINE_PREFIX, BlockType.TIMESTAMP, BlockType.DATA_SOURCE, BlockType.SUBSYSTEM, BlockType.SESSION_ID, BlockType.STATEMENT_ID, BlockType.EVENT_TYPE, BlockType.STATEMENT, BlockType.MESSAGE, BlockType.WARNING, BlockType.ERROR, BlockType.PROJECT, BlockType.EXECUTION_DURATION, BlockType.FETCHING_DURATION, BlockType.UPDATE_COUNT, BlockType.TOTAL_UPDATE_COUNT, BlockType.TOTAL_RESULT_SET_COUNT, BlockType.STATEMENT_SUFFIX};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"com/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService.BlockType.DATA_SOURCE", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "format", "", "s", "intellij.database.core.impl"})
        static final class DATA_SOURCE
        extends BlockType {
            /*
             * WARNING - void declaration
             */
            DATA_SOURCE() {
                void var1_1;
            }

            @Override
            @NotNull
            public String format(@NotNull String s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                return this.bound(s);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"com/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService.BlockType.ERROR", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "format", "", "s", "intellij.database.core.impl"})
        static final class ERROR
        extends BlockType {
            /*
             * WARNING - void declaration
             */
            ERROR() {
                void var1_1;
            }

            @Override
            @NotNull
            public String format(@NotNull String s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                return this.inline(s);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"com/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService.BlockType.MESSAGE", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "format", "", "s", "intellij.database.core.impl"})
        static final class MESSAGE
        extends BlockType {
            /*
             * WARNING - void declaration
             */
            MESSAGE() {
                void var1_1;
            }

            @Override
            @NotNull
            public String format(@NotNull String s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                return this.inline(s);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"com/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService.BlockType.PROJECT", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "format", "", "s", "intellij.database.core.impl"})
        static final class PROJECT
        extends BlockType {
            /*
             * WARNING - void declaration
             */
            PROJECT() {
                void var1_1;
            }

            @Override
            @NotNull
            public String format(@NotNull String s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                return this.bound(s);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"com/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService.BlockType.SESSION_ID", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "format", "", "s", "intellij.database.core.impl"})
        static final class SESSION_ID
        extends BlockType {
            /*
             * WARNING - void declaration
             */
            SESSION_ID() {
                void var1_1;
            }

            @Override
            @NotNull
            public String format(@NotNull String s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                return this.bound(s);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"com/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService.BlockType.STATEMENT", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "format", "", "s", "intellij.database.core.impl"})
        static final class STATEMENT
        extends BlockType {
            /*
             * WARNING - void declaration
             */
            STATEMENT() {
                void var1_1;
            }

            @Override
            @NotNull
            public String format(@NotNull String s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                return (!StringUtil.startsWith((CharSequence)s, (CharSequence)"\n") ? "\n" : "") + super.format(s);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"com/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService.BlockType.STATEMENT_ID", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "format", "", "s", "intellij.database.core.impl"})
        static final class STATEMENT_ID
        extends BlockType {
            /*
             * WARNING - void declaration
             */
            STATEMENT_ID() {
                void var1_1;
            }

            @Override
            @NotNull
            public String format(@NotNull String s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                return this.bound(s);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"com/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService.BlockType.SUBSYSTEM", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "format", "", "s", "intellij.database.core.impl"})
        static final class SUBSYSTEM
        extends BlockType {
            /*
             * WARNING - void declaration
             */
            SUBSYSTEM() {
                void var1_1;
            }

            @Override
            @NotNull
            public String format(@NotNull String s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                return this.bound(s);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"com/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService.BlockType.WARNING", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "format", "", "s", "intellij.database.core.impl"})
        static final class WARNING
        extends BlockType {
            /*
             * WARNING - void declaration
             */
            WARNING() {
                void var1_1;
            }

            @Override
            @NotNull
            public String format(@NotNull String s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                return this.inline(s);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001f\u001a\u00020\u000b2\b\u0010 \u001a\u0004\u0018\u00010\u000bH\u0002J\u001a\u0010!\u001a\u00020\u001a2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u0013H\u0007J$\u0010!\u001a\u00020\u001a2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010%\u001a\u00020&2\b\u0010 \u001a\u0004\u0018\u00010\u000bH\u0007J$\u0010!\u001a\u00020\u001a2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001f\u001a\u00020\u000b2\b\u0010 \u001a\u0004\u0018\u00010\u000bH\u0007J\u001b\u0010'\u001a\u00020(2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u0013H\u0086\u0002J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00100*H\u0007J\n\u0010+\u001a\u0004\u0018\u00010\u001aH\u0007J\u0018\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0007J\u0018\u00102\u001a\u00020-2\u0006\u00103\u001a\u0002042\u0006\u00100\u001a\u000201H\u0007J\u0010\u00105\u001a\u00020-2\u0006\u0010\u001d\u001a\u000206H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Companion;", "", "<init>", "()V", "MAX_CHARACTERS", "", "ORDER", "", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "[Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "DB_LOGGER", "", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "pending", "", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$LogInfo;", "sessions", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "formatter", "Ljava/time/format/DateTimeFormatter;", "statementsCounter", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Counter;", "sessionsCounter", "databaseCategoryLog", "Ljava/util/logging/Logger;", "wrap", "Ljava/util/logging/LogRecord;", "record", "projectName", "dataSourceId", "sessionId", "logger", "project", "Lcom/intellij/openapi/project/Project;", "connection", "dataSource", "Lcom/intellij/database/model/DasDataSource;", "get", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService;", "getPendingStatements", "", "rootLogger", "attach", "", "handler", "Ljava/util/logging/Handler;", "disposable", "Lcom/intellij/openapi/Disposable;", "setRootLevel", "level", "Ljava/util/logging/Level;", "print", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$DatabaseLogBlockRecord;", "intellij.database.core.impl"})
    @SourceDebugExtension(value={"SMAP\nDatabaseGlobalAuditService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseGlobalAuditService.kt\ncom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,529:1\n1#2:530\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        private static final int MAX_CHARACTERS = 10000;
        @NotNull
        private static final BlockType[] ORDER;
        @NotNull
        private static final String DB_LOGGER = "database-global-audit-service";
        @NotNull
        private static final Logger log;
        @NotNull
        private static final Map<SmartStatementMark, LogInfo> pending;
        @NotNull
        private static final Map<DatabaseConnectionCore, String> sessions;
        @NotNull
        private static final DateTimeFormatter formatter;
        @NotNull
        private static final Counter statementsCounter;
        @NotNull
        private static final Counter sessionsCounter;
        @Nullable
        private static final java.util.logging.Logger databaseCategoryLog;

        private Companion() {
        }

        private final LogRecord wrap(LogRecord record, String projectName, String dataSourceId, String sessionId) {
            LogRecord logRecord;
            if (record instanceof DatabaseLogRecord) {
                logRecord = record;
            } else {
                DatabaseLogRecord databaseLogRecord;
                DatabaseLogRecord $this$wrap_u24lambda_u240 = databaseLogRecord = new DatabaseLogRecord(projectName, dataSourceId, sessionId, record.getLevel(), record.getMessage());
                boolean bl = false;
                $this$wrap_u24lambda_u240.setInstant(record.getInstant());
                $this$wrap_u24lambda_u240.setSequenceNumber(record.getSequenceNumber());
                $this$wrap_u24lambda_u240.setSourceClassName(record.getSourceClassName());
                $this$wrap_u24lambda_u240.setSourceMethodName(record.getSourceMethodName());
                $this$wrap_u24lambda_u240.setThreadID(record.getThreadID());
                $this$wrap_u24lambda_u240.setThrown(record.getThrown());
                $this$wrap_u24lambda_u240.setLoggerName(record.getLoggerName());
                $this$wrap_u24lambda_u240.setResourceBundleName(record.getResourceBundleName());
                logRecord = databaseLogRecord;
            }
            return logRecord;
        }

        @JvmStatic
        @NotNull
        public final java.util.logging.Logger logger(@Nullable Project project, @NotNull DatabaseConnectionCore connection2) {
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            String sessionId = sessions.get(connection2);
            LocalDataSource localDataSource = connection2.getConnectionPoint().getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            LocalDataSource dataSource = localDataSource;
            return this.logger(project, dataSource, sessionId);
        }

        @JvmStatic
        @NotNull
        public final java.util.logging.Logger logger(@Nullable Project project, @NotNull DasDataSource dataSource, @Nullable String sessionId) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            String string = dataSource.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
            String dataSourceId = string;
            return this.logger(project, dataSourceId, sessionId);
        }

        @JvmStatic
        @NotNull
        public final java.util.logging.Logger logger(@Nullable Project project, @NotNull String dataSourceId, @Nullable String sessionId) {
            Intrinsics.checkNotNullParameter((Object)dataSourceId, (String)"dataSourceId");
            String string = sessionId;
            if (string == null) {
                string = dataSourceId;
            }
            String loggerName = "database-global-audit-service." + string;
            LogManager manager = LogManager.getLogManager();
            java.util.logging.Logger logger2 = manager.getLogger(loggerName);
            if (logger2 != null) {
                java.util.logging.Logger it = logger2;
                boolean bl = false;
                return it;
            }
            Project project2 = project;
            String projectName = project2 != null ? project2.getName() : null;
            java.util.logging.Logger newLogger2 = new java.util.logging.Logger(loggerName, projectName, dataSourceId, sessionId){
                final /* synthetic */ String $projectName;
                final /* synthetic */ String $dataSourceId;
                final /* synthetic */ String $sessionId;
                {
                    this.$projectName = $projectName;
                    this.$dataSourceId = $dataSourceId;
                    this.$sessionId = $sessionId;
                    super($loggerName, null);
                }

                public void log(LogRecord record) {
                    Intrinsics.checkNotNullParameter((Object)record, (String)"record");
                    LogRecord wrappedRecord = com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$wrap(com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.$$INSTANCE, record, this.$projectName, this.$dataSourceId, this.$sessionId);
                    super.log(wrappedRecord);
                }
            };
            manager.addLogger(newLogger2);
            return newLogger2;
        }

        @NotNull
        public final DatabaseGlobalAuditService get(@Nullable Project project, @NotNull DatabaseConnectionCore connection2) {
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            return new Service(project, connection2);
        }

        @JvmStatic
        @TestOnly
        @NotNull
        public final Set<SmartStatementMark> getPendingStatements() {
            return pending.keySet();
        }

        @TestOnly
        @Nullable
        public final java.util.logging.Logger rootLogger() {
            return databaseCategoryLog;
        }

        @JvmStatic
        public final void attach(@NotNull Handler handler2, @NotNull Disposable disposable) {
            block0: {
                java.util.logging.Logger logger2;
                Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
                Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
                java.util.logging.Logger logger3 = databaseCategoryLog;
                if (logger3 == null) break block0;
                java.util.logging.Logger $this$attach_u24lambda_u243 = logger2 = logger3;
                boolean bl = false;
                $this$attach_u24lambda_u243.addHandler(handler2);
                Disposer.register((Disposable)disposable, () -> Companion.attach$lambda$3$lambda$2($this$attach_u24lambda_u243, handler2));
            }
        }

        @JvmStatic
        public final void setRootLevel(@NotNull Level level, @NotNull Disposable disposable) {
            block0: {
                java.util.logging.Logger logger2;
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
                java.util.logging.Logger logger3 = databaseCategoryLog;
                if (logger3 == null) break block0;
                java.util.logging.Logger $this$setRootLevel_u24lambda_u245 = logger2 = logger3;
                boolean bl = false;
                Level prev2 = $this$setRootLevel_u24lambda_u245.getLevel();
                $this$setRootLevel_u24lambda_u245.setLevel(level);
                Disposer.register((Disposable)disposable, () -> Companion.setRootLevel$lambda$5$lambda$4($this$setRootLevel_u24lambda_u245, prev2));
            }
        }

        private final void print(DatabaseLogBlockRecord record) {
            block0: {
                java.util.logging.Logger logger2 = databaseCategoryLog;
                if (logger2 == null) break block0;
                logger2.log(record);
            }
        }

        private static final void attach$lambda$3$lambda$2(java.util.logging.Logger $this_apply, Handler $handler) {
            $this_apply.removeHandler($handler);
        }

        private static final void setRootLevel$lambda$5$lambda$4(java.util.logging.Logger $this_apply, Level $prev) {
            $this_apply.setLevel($prev);
        }

        public static final /* synthetic */ LogRecord access$wrap(Companion $this, LogRecord record, String projectName, String dataSourceId, String sessionId) {
            return $this.wrap(record, projectName, dataSourceId, sessionId);
        }

        public static final /* synthetic */ BlockType[] access$getORDER$p() {
            return ORDER;
        }

        static {
            $$INSTANCE = new Companion();
            Object object = new BlockType[]{BlockType.STATEMENT_PREFIX, BlockType.LINE_PREFIX, BlockType.TIMESTAMP, BlockType.PROJECT, BlockType.DATA_SOURCE, BlockType.SUBSYSTEM, BlockType.SESSION_ID, BlockType.STATEMENT_ID, BlockType.EVENT_TYPE, BlockType.STATEMENT, BlockType.MESSAGE, BlockType.WARNING, BlockType.ERROR, BlockType.UPDATE_COUNT, BlockType.EXECUTION_DURATION, BlockType.FETCHING_DURATION, BlockType.TOTAL_UPDATE_COUNT, BlockType.TOTAL_RESULT_SET_COUNT, BlockType.STATEMENT_SUFFIX};
            ORDER = object;
            Logger logger2 = Logger.getInstance(DatabaseGlobalAuditService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            log = logger2;
            ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakMap();
            Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakMap(...)");
            pending = concurrentMap;
            sessions = new ConcurrentHashMap();
            DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(" ").appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(":").appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(":").appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
            Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"toFormatter(...)");
            formatter = dateTimeFormatter;
            statementsCounter = new Counter();
            sessionsCounter = new Counter();
            try {
                File dir = SmartStatementsUtil.getLogPath().getParentFile();
                FileUtil.ensureExists((File)dir);
                String string = StringUtil.trimEnd((String)SmartStatementsUtil.getLogPath().getName(), (String)".0.log");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimEnd(...)");
                String trimmed = string;
                File oldFile = new File(dir, trimmed + ".log");
                if (oldFile.exists()) {
                    try {
                        FileUtil.rename((File)oldFile, (String)SmartStatementsUtil.getLogPath().getName());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                FileHandler handler2 = new FileHandler(new File(dir, trimmed + ".%g.log").getPath(), 0x100000, 12, true);
                handler2.setLevel(Level.INFO);
                handler2.setEncoding("UTF-8");
                handler2.setFormatter(new Formatter(){

                    @Override
                    public String format(LogRecord record) {
                        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
                        return record.getMessage() + "\n";
                    }
                });
                java.util.logging.Logger logger3 = java.util.logging.Logger.getLogger(DB_LOGGER);
                Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getLogger(...)");
                java.util.logging.Logger result2 = logger3;
                result2.setUseParentHandlers(false);
                result2.addHandler(handler2);
                result2.setLevel(Level.INFO);
                object = result2;
            }
            catch (IOException e) {
                log.error("Failed to initialize database logging", (Throwable)e);
                object = null;
            }
            databaseCategoryLog = object;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bJ\u001c\u0010\f\u001a\u00020\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J(\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0002R#\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Counter;", "", "<init>", "()V", "reference", "Ljava/util/concurrent/atomic/AtomicReference;", "Lkotlin/Pair;", "", "getReference", "()Ljava/util/concurrent/atomic/AtomicReference;", "incrementAndGet", "", "asIdString", "pair", "increment", "longs", "nextValue", "long", "intellij.database.core.impl"})
    private static final class Counter {
        @NotNull
        private final AtomicReference<Pair<Long, Long>> reference = new AtomicReference<Pair>(TuplesKt.to((Object)0L, (Object)Math.abs((long)new Random().nextInt())));

        @NotNull
        public final AtomicReference<Pair<Long, Long>> getReference() {
            return this.reference;
        }

        @NotNull
        public final String incrementAndGet() {
            Pair<Long, Long> pair = this.reference.updateAndGet(arg_0 -> Counter.incrementAndGet$lambda$0(this, arg_0));
            Intrinsics.checkNotNullExpressionValue(pair, (String)"updateAndGet(...)");
            return this.asIdString(pair);
        }

        private final String asIdString(Pair<Long, Long> pair) {
            return (((Number)pair.getFirst()).longValue() == 0L ? "" : String.valueOf(((Number)pair.getFirst()).longValue())) + pair.getSecond();
        }

        private final Pair<Long, Long> increment(Pair<Long, Long> longs) {
            long second = ((Number)longs.getSecond()).longValue();
            long nextSecond = this.nextValue(second);
            long first2 = nextSecond == 0L ? this.nextValue(((Number)longs.getFirst()).longValue()) : ((Number)longs.getFirst()).longValue();
            return new Pair((Object)first2, (Object)nextSecond);
        }

        private final long nextValue(long l) {
            return l == Long.MAX_VALUE ? 0L : l + 1L;
        }

        private static final Pair incrementAndGet$lambda$0(Counter this$0, Pair it) {
            Intrinsics.checkNotNull((Object)it);
            return this$0.increment((Pair<Long, Long>)it);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$DataSourceBlock;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Block;", "dataSource", "Lcom/intellij/database/model/DasDataSource;", "<init>", "(Lcom/intellij/database/model/DasDataSource;)V", "getDataSource", "()Lcom/intellij/database/model/DasDataSource;", "content", "", "getContent", "()Ljava/lang/String;", "intellij.database.core.impl"})
    public static final class DataSourceBlock
    extends Block {
        @NotNull
        private final DasDataSource dataSource;

        public DataSourceBlock(@NotNull DasDataSource dataSource) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            super(BlockType.DATA_SOURCE, false, 2, null);
            this.dataSource = dataSource;
        }

        @NotNull
        public final DasDataSource getDataSource() {
            return this.dataSource;
        }

        @Override
        @NotNull
        protected String getContent() {
            String string = this.dataSource.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dBe\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\b\u0010\u001a\u001a\u00020\u0003H\u0016J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001cR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0019\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$DatabaseLogBlockRecord;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$DatabaseLogRecord;", "projectName", "", "dataSource", "Lcom/intellij/database/model/DasDataSource;", "type", "statementId", "sessionId", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "level", "Ljava/util/logging/Level;", "blocks", "", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Block;", "<init>", "(Ljava/lang/String;Lcom/intellij/database/model/DasDataSource;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/database/dataSource/connection/DatabaseDepartment;Ljava/util/logging/Level;[Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Block;)V", "getType", "()Ljava/lang/String;", "getStatementId", "getDepartment", "()Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "getBlocks", "()[Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Block;", "[Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Block;", "getMessage", "prepare", "", "Companion", "intellij.database.core.impl"})
    @SourceDebugExtension(value={"SMAP\nDatabaseGlobalAuditService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseGlobalAuditService.kt\ncom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$DatabaseLogBlockRecord\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,529:1\n1#2:530\n*E\n"})
    public static final class DatabaseLogBlockRecord
    extends DatabaseLogRecord {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String type;
        @Nullable
        private final String statementId;
        @Nullable
        private final DatabaseDepartment department;
        @NotNull
        private final Block[] blocks;

        public DatabaseLogBlockRecord(@Nullable String projectName, @NotNull DasDataSource dataSource, @Nullable String type, @Nullable String statementId, @Nullable String sessionId, @Nullable DatabaseDepartment department, @NotNull Level level, Block ... blocks) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
            String string = dataSource.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
            super(projectName, string, sessionId, level, null);
            this.type = type;
            this.statementId = statementId;
            this.department = department;
            Object[] objectArray = new Block[]{new DataSourceBlock(dataSource)};
            this.blocks = (Block[])ArraysKt.plus((Object[])objectArray, (Object[])blocks);
        }

        public /* synthetic */ DatabaseLogBlockRecord(String string, DasDataSource dasDataSource, String string2, String string3, String string4, DatabaseDepartment databaseDepartment, Level level, Block[] blockArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            if ((n & 8) != 0) {
                string3 = null;
            }
            if ((n & 0x10) != 0) {
                string4 = null;
            }
            if ((n & 0x20) != 0) {
                databaseDepartment = null;
            }
            this(string, dasDataSource, string2, string3, string4, databaseDepartment, level, blockArray);
        }

        @Nullable
        public final String getType() {
            return this.type;
        }

        @Nullable
        public final String getStatementId() {
            return this.statementId;
        }

        @Nullable
        public final DatabaseDepartment getDepartment() {
            return this.department;
        }

        @NotNull
        public final Block[] getBlocks() {
            return this.blocks;
        }

        @Override
        @NotNull
        public String getMessage() {
            String string = super.getMessage();
            if (string != null) {
                String it = string;
                boolean bl = false;
                return it;
            }
            String newMessage = Companion.format(this.prepare());
            this.setMessage(newMessage);
            return newMessage;
        }

        @NotNull
        public final List<Block> prepare() {
            Block[] blockArray = this.blocks;
            return DatabaseLogBlockRecord.Companion.prepare(this.getProjectName(), this.type, this.statementId, this.getSessionId(), this.department, this.getMillis(), Arrays.copyOf(blockArray, blockArray.length));
        }

        @JvmStatic
        @NotNull
        public static final String format(@NotNull List<? extends Block> prepared) {
            return Companion.format(prepared);
        }

        @JvmStatic
        private static final List<Block> prepare(String projectName, String type, String statementId, String sessionId, DatabaseDepartment department, long millis, Block ... blocks) {
            return DatabaseLogBlockRecord.Companion.prepare(projectName, type, statementId, sessionId, department, millis, blocks);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007Ji\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0013\"\u00020\bH\u0003\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$DatabaseLogBlockRecord$Companion;", "", "<init>", "()V", "format", "", "prepared", "", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Block;", "prepare", "projectName", "type", "statementId", "sessionId", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "millis", "", "blocks", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/database/dataSource/connection/DatabaseDepartment;J[Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Block;)Ljava/util/List;", "intellij.database.core.impl"})
        @SourceDebugExtension(value={"SMAP\nDatabaseGlobalAuditService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseGlobalAuditService.kt\ncom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$DatabaseLogBlockRecord$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,529:1\n12574#2,2:530\n1053#3:532\n*S KotlinDebug\n*F\n+ 1 DatabaseGlobalAuditService.kt\ncom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$DatabaseLogBlockRecord$Companion\n*L\n494#1:530,2\n501#1:532\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final String format(@NotNull List<? extends Block> prepared) {
                Intrinsics.checkNotNullParameter(prepared, (String)"prepared");
                return SequencesKt.joinToString$default((Sequence)SequencesKt.mapIndexed((Sequence)CollectionsKt.asSequence((Iterable)prepared), (arg_0, arg_1) -> Companion.format$lambda$0(prepared, arg_0, arg_1)), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
            }

            @JvmStatic
            private final List<Block> prepare(String projectName, String type, String statementId, String sessionId, DatabaseDepartment department, long millis, Block ... blocks) {
                boolean statement2;
                ArrayList otherBlocks;
                block7: {
                    boolean bl;
                    otherBlocks = new ArrayList();
                    Collection collection = otherBlocks;
                    String string = com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.formatter.format(Instant.ofEpochMilli(millis).atZone(ZoneId.systemDefault()).toLocalDateTime());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
                    collection.add(new TextBlock(BlockType.TIMESTAMP, string, false, 4, null));
                    if (department != null) {
                        ((Collection)otherBlocks).add(new TextBlock(BlockType.SUBSYSTEM, department.getDepartmentName(), false, 4, null));
                    }
                    if (sessionId != null) {
                        ((Collection)otherBlocks).add(new TextBlock(BlockType.SESSION_ID, "session id: " + sessionId, false, 4, null));
                    }
                    if (statementId != null) {
                        ((Collection)otherBlocks).add(new TextBlock(BlockType.STATEMENT_ID, "statement id: " + statementId, false, 4, null));
                    }
                    if (type != null) {
                        ((Collection)otherBlocks).add(new TextBlock(BlockType.EVENT_TYPE, type, !(blocks.length == 0)));
                    }
                    Block[] $this$any$iv = blocks;
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int j = 0; j < n; ++j) {
                        Block element$iv;
                        Block it = element$iv = $this$any$iv[j];
                        boolean bl2 = false;
                        if (!(it.getType() == BlockType.STATEMENT)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = statement2 = false;
                }
                if (statement2) {
                    ((Collection)otherBlocks).add(new TextBlock(BlockType.STATEMENT_PREFIX, "-- [ --------------------------------------------------", false, 4, null));
                    ((Collection)otherBlocks).add(new TextBlock(BlockType.STATEMENT_SUFFIX, "-- ] --------------------------------------------------", false, 4, null));
                }
                if (projectName != null) {
                    ((Collection)otherBlocks).add(new TextBlock(BlockType.PROJECT, projectName, false, 4, null));
                }
                ((Collection)otherBlocks).add(new TextBlock(BlockType.LINE_PREFIX, "--", false, 4, null));
                Iterable $this$sortedBy$iv = CollectionsKt.plus((Collection)otherBlocks, (Object[])blocks);
                boolean $i$f$sortedBy = false;
                return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Block f = (Block)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(ArraysKt.indexOf((Object[])com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getORDER$p(), (Object)((Object)f.getType())));
                        f = (Block)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(ArraysKt.indexOf((Object[])com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getORDER$p(), (Object)((Object)f.getType()))));
                    }
                });
            }

            static /* synthetic */ List prepare$default(Companion companion, String string, String string2, String string3, String string4, DatabaseDepartment databaseDepartment, long l, Block[] blockArray, int n, Object object) {
                if ((n & 2) != 0) {
                    string2 = null;
                }
                if ((n & 4) != 0) {
                    string3 = null;
                }
                if ((n & 8) != 0) {
                    string4 = null;
                }
                if ((n & 0x10) != 0) {
                    databaseDepartment = null;
                }
                return companion.prepare(string, string2, string3, string4, databaseDepartment, l, blockArray);
            }

            private static final String format$lambda$0(List $prepared, int idx, Block value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return idx == $prepared.size() - 1 ? value.getText() : value.getText() + value.getType().getSeparator();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B7\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\t\u0010\nR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$DatabaseLogRecord;", "Ljava/util/logging/LogRecord;", "projectName", "", "dataSourceId", "sessionId", "level", "Ljava/util/logging/Level;", "msg", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/logging/Level;Ljava/lang/String;)V", "getProjectName", "()Ljava/lang/String;", "getDataSourceId", "getSessionId", "intellij.database.core.impl"})
    public static class DatabaseLogRecord
    extends LogRecord {
        @Nullable
        private final String projectName;
        @NotNull
        private final String dataSourceId;
        @Nullable
        private final String sessionId;

        public DatabaseLogRecord(@Nullable String projectName, @NotNull String dataSourceId, @Nullable String sessionId, @Nullable Level level, @Nullable String msg) {
            Intrinsics.checkNotNullParameter((Object)dataSourceId, (String)"dataSourceId");
            super(level, msg);
            this.projectName = projectName;
            this.dataSourceId = dataSourceId;
            this.sessionId = sessionId;
        }

        @Nullable
        public final String getProjectName() {
            return this.projectName;
        }

        @NotNull
        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        @Nullable
        public final String getSessionId() {
            return this.sessionId;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\nH\u00c6\u0003JG\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020\nH\u00d6\u0001J\t\u0010&\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0010\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0010\"\u0004\b\u0016\u0010\u0014R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006'"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$LogInfo;", "", "statementId", "", "startTime", "", "sessionId", "endTime", "updateCount", "results", "", "<init>", "(Ljava/lang/String;JLjava/lang/String;JJI)V", "getStatementId", "()Ljava/lang/String;", "getStartTime", "()J", "getSessionId", "getEndTime", "setEndTime", "(J)V", "getUpdateCount", "setUpdateCount", "getResults", "()I", "setResults", "(I)V", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "intellij.database.core.impl"})
    public static final class LogInfo {
        @NotNull
        private final String statementId;
        private final long startTime;
        @Nullable
        private final String sessionId;
        private long endTime;
        private long updateCount;
        private int results;

        public LogInfo(@NotNull String statementId, long startTime, @Nullable String sessionId, long endTime, long updateCount2, int results2) {
            Intrinsics.checkNotNullParameter((Object)statementId, (String)"statementId");
            this.statementId = statementId;
            this.startTime = startTime;
            this.sessionId = sessionId;
            this.endTime = endTime;
            this.updateCount = updateCount2;
            this.results = results2;
        }

        public /* synthetic */ LogInfo(String string, long l, String string2, long l2, long l3, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                l = -1L;
            }
            if ((n2 & 8) != 0) {
                l2 = -1L;
            }
            if ((n2 & 0x10) != 0) {
                l3 = 0L;
            }
            if ((n2 & 0x20) != 0) {
                n = 0;
            }
            this(string, l, string2, l2, l3, n);
        }

        @NotNull
        public final String getStatementId() {
            return this.statementId;
        }

        public final long getStartTime() {
            return this.startTime;
        }

        @Nullable
        public final String getSessionId() {
            return this.sessionId;
        }

        public final long getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(long l) {
            this.endTime = l;
        }

        public final long getUpdateCount() {
            return this.updateCount;
        }

        public final void setUpdateCount(long l) {
            this.updateCount = l;
        }

        public final int getResults() {
            return this.results;
        }

        public final void setResults(int n) {
            this.results = n;
        }

        @NotNull
        public final String component1() {
            return this.statementId;
        }

        public final long component2() {
            return this.startTime;
        }

        @Nullable
        public final String component3() {
            return this.sessionId;
        }

        public final long component4() {
            return this.endTime;
        }

        public final long component5() {
            return this.updateCount;
        }

        public final int component6() {
            return this.results;
        }

        @NotNull
        public final LogInfo copy(@NotNull String statementId, long startTime, @Nullable String sessionId, long endTime, long updateCount2, int results2) {
            Intrinsics.checkNotNullParameter((Object)statementId, (String)"statementId");
            return new LogInfo(statementId, startTime, sessionId, endTime, updateCount2, results2);
        }

        public static /* synthetic */ LogInfo copy$default(LogInfo logInfo, String string, long l, String string2, long l2, long l3, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = logInfo.statementId;
            }
            if ((n2 & 2) != 0) {
                l = logInfo.startTime;
            }
            if ((n2 & 4) != 0) {
                string2 = logInfo.sessionId;
            }
            if ((n2 & 8) != 0) {
                l2 = logInfo.endTime;
            }
            if ((n2 & 0x10) != 0) {
                l3 = logInfo.updateCount;
            }
            if ((n2 & 0x20) != 0) {
                n = logInfo.results;
            }
            return logInfo.copy(string, l, string2, l2, l3, n);
        }

        @NotNull
        public String toString() {
            return "LogInfo(statementId=" + this.statementId + ", startTime=" + this.startTime + ", sessionId=" + this.sessionId + ", endTime=" + this.endTime + ", updateCount=" + this.updateCount + ", results=" + this.results + ")";
        }

        public int hashCode() {
            int result2 = this.statementId.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.startTime);
            result2 = result2 * 31 + (this.sessionId == null ? 0 : this.sessionId.hashCode());
            result2 = result2 * 31 + Long.hashCode(this.endTime);
            result2 = result2 * 31 + Long.hashCode(this.updateCount);
            result2 = result2 * 31 + Integer.hashCode(this.results);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LogInfo)) {
                return false;
            }
            LogInfo logInfo = (LogInfo)other;
            if (!Intrinsics.areEqual((Object)this.statementId, (Object)logInfo.statementId)) {
                return false;
            }
            if (this.startTime != logInfo.startTime) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sessionId, (Object)logInfo.sessionId)) {
                return false;
            }
            if (this.endTime != logInfo.endTime) {
                return false;
            }
            if (this.updateCount != logInfo.updateCount) {
                return false;
            }
            return this.results == logInfo.results;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Printer;", "", "print", "", "record", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$DatabaseLogBlockRecord;", "intellij.database.core.impl"})
    public static interface Printer {
        public void print(@NotNull DatabaseLogBlockRecord var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0012H\u0016J\u0018\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0017H\u0016J\u0018\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010 \u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010$\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010%\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J;\u0010&\u001a\u00020\t2\b\u0010'\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020)2\u0012\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020,0+\"\u00020,H\u0002\u00a2\u0006\u0002\u0010-Ja\u0010&\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010/\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u00100\u001a\u0004\u0018\u0001012\u0006\u0010(\u001a\u00020)2\u0012\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020,0+\"\u00020,H\u0002\u00a2\u0006\u0002\u00102J\u0018\u00103\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u00104\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u00105\u001a\u00020\tH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Service;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService;", "project", "Lcom/intellij/openapi/project/Project;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/DatabaseConnectionCore;)V", "connected", "", "disconnected", "beforeCallableStatement", "data", "Lcom/intellij/database/dataSource/connection/statements/CallableStatementData;", "mark", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;", "beforeSimpleStatement", "sql", "", "beforeParameterizedStatement", "Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementData;", "logStatement", "warning", "", "message", "error", "updateCount", "count", "", "resultsOpened", "resultSet", "Lcom/intellij/database/remote/jdbc/RemoteResultSet;", "resultsProcessed", "beforeStatementClosing", "statement", "Lcom/intellij/database/remote/jdbc/RemoteStatement;", "afterStatement", "processed", "print", "type", "level", "Ljava/util/logging/Level;", "blocks", "", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Block;", "(Ljava/lang/String;Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;Ljava/util/logging/Level;[Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Block;)V", "statementId", "sessionId", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "(Lcom/intellij/database/dataSource/DatabaseConnectionCore;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/database/dataSource/connection/DatabaseDepartment;Ljava/util/logging/Level;[Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Block;)V", "beforeResultsClosing", "statementOpened", "close", "intellij.database.core.impl"})
    @SourceDebugExtension(value={"SMAP\nDatabaseGlobalAuditService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseGlobalAuditService.kt\ncom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Service\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,529:1\n37#2,2:530\n*S KotlinDebug\n*F\n+ 1 DatabaseGlobalAuditService.kt\ncom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Service\n*L\n314#1:530,2\n*E\n"})
    private static final class Service
    implements DatabaseGlobalAuditService {
        @Nullable
        private final Project project;
        @NotNull
        private final DatabaseConnectionCore connection;

        public Service(@Nullable Project project, @NotNull DatabaseConnectionCore connection2) {
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            this.project = project;
            this.connection = connection2;
        }

        @Override
        public void connected() {
            String sessionId = com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.sessionsCounter.incrementAndGet();
            com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.sessions.put(this.connection, sessionId);
            Level level = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"INFO");
            Service.print$default(this, this.connection, "connected", null, null, null, level, new Block[0], 24, null);
        }

        @Override
        public void disconnected() {
            String string = (String)com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.sessions.get(this.connection);
            if (string == null) {
                return;
            }
            String id = string;
            Level level = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"INFO");
            Service.print$default(this, this.connection, "disconnected", null, null, null, level, new Block[0], 24, null);
            com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.sessions.remove(this.connection);
        }

        @Override
        public void beforeCallableStatement(@NotNull CallableStatementData data, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            this.logStatement(data.getBasis().getSql(), mark2);
        }

        @Override
        public void beforeSimpleStatement(@NotNull String sql, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            this.logStatement(sql, mark2);
        }

        @Override
        public void beforeParameterizedStatement(@NotNull ParameterizedStatementData data, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            this.logStatement(data.getBasis().getSql(), mark2);
        }

        private final void logStatement(String sql, SmartStatementMark mark2) {
            String id = com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.statementsCounter.incrementAndGet();
            com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.pending.put(mark2, new LogInfo(id, System.currentTimeMillis(), (String)com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.sessions.get(this.connection), 0L, 0L, 0, 56, null));
            Level level = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"INFO");
            Block[] blockArray = new Block[]{new TextBlock(BlockType.STATEMENT, SmartStatementsUtil.trimSql(sql, 10000), false, 4, null)};
            this.print(null, mark2, level, blockArray);
        }

        @Override
        public void warning(@NotNull Throwable warning, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)warning, (String)"warning");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            Level level = Level.WARNING;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"WARNING");
            Block[] blockArray = new Block[1];
            String string = GridUtilCore.getLongMessage((Throwable)warning);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLongMessage(...)");
            blockArray[0] = new TextBlock(BlockType.WARNING, string, false, 4, null);
            this.print("warning", mark2, level, blockArray);
        }

        @Override
        public void warning(@NotNull Throwable warning) {
            Intrinsics.checkNotNullParameter((Object)warning, (String)"warning");
            Level level = Level.WARNING;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"WARNING");
            Block[] blockArray = new Block[1];
            String string = GridUtilCore.getLongMessage((Throwable)warning);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLongMessage(...)");
            blockArray[0] = new TextBlock(BlockType.WARNING, string, false, 4, null);
            this.print(this.connection, "warning", null, null, null, level, blockArray);
        }

        @Override
        public void message(@NotNull String message, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            Level level = Level.WARNING;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"WARNING");
            Block[] blockArray = new Block[]{new TextBlock(BlockType.MESSAGE, message, false, 4, null)};
            this.print("message", mark2, level, blockArray);
        }

        @Override
        public void message(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Level level = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"INFO");
            Block[] blockArray = new Block[]{new TextBlock(BlockType.MESSAGE, message, false, 4, null)};
            this.print(this.connection, "message", null, null, null, level, blockArray);
        }

        @Override
        public void error(@NotNull Throwable error, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            Level level = Level.SEVERE;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"SEVERE");
            Block[] blockArray = new Block[1];
            String string = GridUtilCore.getLongMessage((Throwable)error);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLongMessage(...)");
            blockArray[0] = new TextBlock(BlockType.ERROR, string, false);
            this.print("error", mark2, level, blockArray);
        }

        @Override
        public void error(@NotNull Throwable error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            Level level = Level.SEVERE;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"SEVERE");
            Block[] blockArray = new Block[1];
            String string = GridUtilCore.getLongMessage((Throwable)error);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLongMessage(...)");
            blockArray[0] = new TextBlock(BlockType.ERROR, string, false, 4, null);
            this.print(this.connection, "error", null, null, null, level, blockArray);
        }

        @Override
        public void updateCount(int count, @NotNull SmartStatementMark mark2) {
            LogInfo info2;
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            if (count < 1) {
                return;
            }
            LogInfo logInfo = info2 = (LogInfo)com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.pending.get(mark2);
            if (logInfo != null) {
                logInfo.setUpdateCount(info2.getUpdateCount() + (long)count);
            } else {
                com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.log.warn("Logging update count without pending statement");
            }
            Level level = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"INFO");
            Block[] blockArray = new Block[]{new TextBlock(BlockType.UPDATE_COUNT, String.valueOf(count), false, 4, null)};
            this.print("update count received", mark2, level, blockArray);
        }

        @Override
        public void resultsOpened(@NotNull RemoteResultSet resultSet, @NotNull SmartStatementMark mark2) {
            LogInfo info2;
            Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            LogInfo logInfo = info2 = (LogInfo)com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.pending.get(mark2);
            if (logInfo != null) {
                int n = logInfo.getResults();
                info2.setResults(n + 1);
            } else {
                com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.log.warn("Logging result set without pending statement");
            }
            Level level = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"INFO");
            this.print("results received", mark2, level, new Block[0]);
        }

        @Override
        public void resultsProcessed(@NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            this.processed(mark2);
        }

        @Override
        public void beforeStatementClosing(@NotNull RemoteStatement statement2, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            this.processed(mark2);
        }

        @Override
        public void afterStatement(@NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            LogInfo info2 = (LogInfo)com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.pending.get(mark2);
            if (info2 == null) {
                com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.log.warn("Execution finished without pending statement");
                return;
            }
            info2.setEndTime(System.currentTimeMillis());
        }

        private final void processed(SmartStatementMark mark2) {
            LogInfo logInfo = (LogInfo)com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.pending.remove(mark2);
            if (logInfo == null) {
                return;
            }
            LogInfo info2 = logInfo;
            long endTime = info2.getEndTime() == -1L ? System.currentTimeMillis() : info2.getEndTime();
            long executionDurationMs = info2.getEndTime() != -1L ? Math.max(endTime - info2.getStartTime(), 1L) : -1L;
            long processingDurationMs = System.currentTimeMillis() - info2.getStartTime();
            long fetchingDurationMs = info2.getEndTime() == -1L ? -1L : processingDurationMs - executionDurationMs;
            ArrayList messages = new ArrayList();
            if (executionDurationMs > 0L) {
                ((Collection)messages).add(new TextBlock(BlockType.EXECUTION_DURATION, "execution time: " + StringUtil.formatDuration((long)executionDurationMs), false, 4, null));
            }
            if (fetchingDurationMs > 0L && (info2.getUpdateCount() > 0L || info2.getResults() > 0)) {
                ((Collection)messages).add(new TextBlock(BlockType.FETCHING_DURATION, "fetching time: " + StringUtil.formatDuration((long)fetchingDurationMs), false, 4, null));
            }
            if (info2.getUpdateCount() > 0L) {
                ((Collection)messages).add(new TextBlock(BlockType.TOTAL_UPDATE_COUNT, "total update count: " + info2.getUpdateCount(), false, 4, null));
            }
            if (info2.getResults() > 0) {
                ((Collection)messages).add(new TextBlock(BlockType.TOTAL_RESULT_SET_COUNT, "total result sets count: " + info2.getResults(), false, 4, null));
            }
            String string = info2.getStatementId();
            String string2 = info2.getSessionId();
            DatabaseDepartment databaseDepartment = mark2.getDepartment();
            Level level = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"INFO");
            Collection $this$toTypedArray$iv = messages;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Block[] blockArray = thisCollection$iv.toArray(new Block[0]);
            this.print(this.connection, "finished", string, string2, databaseDepartment, level, Arrays.copyOf(blockArray, blockArray.length));
        }

        private final void print(String type, SmartStatementMark mark2, Level level, Block ... blocks) {
            LogInfo logInfo = (LogInfo)com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.pending.get(mark2);
            LogInfo logInfo2 = (LogInfo)com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.pending.get(mark2);
            this.print(this.connection, type, logInfo != null ? logInfo.getStatementId() : null, logInfo2 != null ? logInfo2.getSessionId() : null, mark2.getDepartment(), level, Arrays.copyOf(blocks, blocks.length));
        }

        private final void print(DatabaseConnectionCore connection2, String type, String statementId, String sessionId, DatabaseDepartment department, Level level, Block ... blocks) {
            Project project = this.project;
            String string = project != null ? project.getName() : null;
            LocalDataSource localDataSource = connection2.getConnectionPoint().getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            DasDataSource dasDataSource = localDataSource;
            String string2 = sessionId;
            if (string2 == null) {
                string2 = (String)com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.sessions.get(connection2);
            }
            Companion.print(new DatabaseLogBlockRecord(string, dasDataSource, type, statementId, string2, department, level, Arrays.copyOf(blocks, blocks.length)));
        }

        static /* synthetic */ void print$default(Service service, DatabaseConnectionCore databaseConnectionCore, String string, String string2, String string3, DatabaseDepartment databaseDepartment, Level level, Block[] blockArray, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            if ((n & 4) != 0) {
                string2 = null;
            }
            if ((n & 8) != 0) {
                string3 = null;
            }
            if ((n & 0x10) != 0) {
                databaseDepartment = null;
            }
            service.print(databaseConnectionCore, string, string2, string3, databaseDepartment, level, blockArray);
        }

        @Override
        public void beforeResultsClosing(@NotNull RemoteResultSet resultSet, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        }

        @Override
        public void statementOpened(@NotNull RemoteStatement statement2, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        }

        @Override
        public void close() {
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$TextBlock;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Block;", "type", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "content", "", "format", "", "<init>", "(Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;Ljava/lang/String;Z)V", "getContent", "()Ljava/lang/String;", "intellij.database.core.impl"})
    public static final class TextBlock
    extends Block {
        @NotNull
        private final String content;

        public TextBlock(@NotNull BlockType type, @NotNull String content, boolean format) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            super(type, format);
            this.content = content;
        }

        public /* synthetic */ TextBlock(BlockType blockType, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = true;
            }
            this(blockType, string, bl);
        }

        @Override
        @NotNull
        protected String getContent() {
            return this.content;
        }
    }
}

