/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script.generator.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeysCore;
import com.intellij.database.Dbms;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.DataSourceBriefConfig;
import com.intellij.database.dataSource.DataSourceBriefConfigs;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SyncQueue;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.model.BlackHoleTextStorage;
import com.intellij.database.model.LevelAnalyzer;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.script.generator.CustomScriptingOptions;
import com.intellij.database.script.generator.DefaultScriptingOptions;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptConsumer;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingNativeDefinitionTaskBuilder;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingSingleModelTask;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilderBase;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskKt;
import com.intellij.database.script.generator.UtilKt;
import com.intellij.database.script.generator.ui.ScriptFileLayoutPanel;
import com.intellij.database.script.generator.ui.ScriptGeneratorSettings;
import com.intellij.database.script.generator.ui.ScriptGeneratorTool;
import com.intellij.database.script.generator.ui.ScriptGeneratorUI;
import com.intellij.database.script.generator.ui.ScriptOptionsPanel;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.UiSchema;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.LightColors;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.content.Content;
import com.intellij.util.ApplicationKt;
import com.intellij.util.SingleAlarm;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import icons.DatabaseIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009e\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 \u0083\u00012\u00020\u0001:\b\u0083\u0001\u0084\u0001\u0085\u0001\u0086\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=J\b\u0010?\u001a\u00020@H\u0002J\b\u0010A\u001a\u00020BH\u0002J\u001e\u0010C\u001a\b\u0012\u0004\u0012\u0002HE0D\"\u0004\b\u0000\u0010E*\b\u0012\u0004\u0012\u0002HE0FH\u0002J\u0014\u0010G\u001a\u0002092\n\u0010H\u001a\u0006\u0012\u0002\b\u00030IH\u0002J\b\u0010J\u001a\u000209H\u0002J\u001e\u0010K\u001a\u0002092\u0006\u0010:\u001a\u00020;2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=H\u0002J\b\u0010L\u001a\u000209H\u0002J\u0010\u0010M\u001a\u0002092\u0006\u0010'\u001a\u00020\u001aH\u0002J\b\u0010N\u001a\u000209H\u0002J\b\u0010O\u001a\u000209H\u0002J\b\u0010P\u001a\u000209H\u0002J\b\u0010Q\u001a\u000209H\u0002J\u0010\u0010R\u001a\u0002092\u0006\u0010S\u001a\u00020TH\u0002J\u0010\u0010U\u001a\u0002092\u0006\u0010S\u001a\u00020TH\u0002J\u0010\u0010V\u001a\u0002092\u0006\u0010W\u001a\u00020XH\u0002J\u0010\u0010Y\u001a\u0002092\u0006\u0010Z\u001a\u00020[H\u0002J \u0010\\\u001a\u0002092\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020`H\u0002J \u0010a\u001a\u0002092\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020`H\u0002J\b\u0010b\u001a\u000209H\u0002J\b\u0010c\u001a\u000209H\u0002J\b\u0010d\u001a\u000209H\u0002J\u0018\u0010e\u001a\u0004\u0018\u00010[2\f\u0010H\u001a\b\u0012\u0002\b\u0003\u0018\u00010IH\u0002JB\u0010e\u001a\u00020[2\u0006\u0010'\u001a\u00020\u001a2\u0006\u0010:\u001a\u00020;2\f\u0010f\u001a\b\u0012\u0004\u0012\u00020/0g2\f\u0010h\u001a\b\u0012\u0004\u0012\u00020i0g2\f\u0010H\u001a\b\u0012\u0002\b\u0003\u0018\u00010IH\u0002J\b\u0010j\u001a\u000209H\u0002J\b\u0010k\u001a\u000209H\u0002J\b\u0010l\u001a\u000209H\u0002J\b\u0010m\u001a\u000209H\u0002J\b\u0010n\u001a\u000209H\u0002J\u0014\u0010o\u001a\u0004\u0018\u00010^2\b\u0010:\u001a\u0004\u0018\u00010;H\u0002J(\u0010p\u001a\u0014\u0012\u0004\u0012\u00020i\u0012\n\u0012\b\u0012\u0004\u0012\u00020s0r0q2\f\u0010t\u001a\b\u0012\u0004\u0012\u00020i0gH\u0002J(\u0010u\u001a\u0014\u0012\u0004\u0012\u00020i\u0012\n\u0012\b\u0012\u0004\u0012\u00020s0r0q2\f\u0010t\u001a\b\u0012\u0004\u0012\u00020i0gH\u0002J\b\u0010v\u001a\u000209H\u0002J\b\u0010w\u001a\u000209H\u0016J(\u0010x\u001a\u0012\u0012\u0004\u0012\u0002HE0yj\b\u0012\u0004\u0012\u0002HE`z\"\u0004\b\u0000\u0010E*\b\u0012\u0004\u0012\u0002HE0\u0019H\u0002J\u0016\u0010{\u001a\u0002092\f\u0010|\u001a\b\u0012\u0004\u0012\u0002090}H\u0002J\u0016\u0010~\u001a\u0002092\f\u0010|\u001a\b\u0012\u0004\u0012\u0002090}H\u0002J1\u0010\u007f\u001a\u0002HE\"\u0004\b\u0000\u0010E2\t\b\u0001\u0010\u0080\u0001\u001a\u00020s2\u000f\b\u0004\u0010\u0081\u0001\u001a\b\u0012\u0004\u0012\u0002HE0}H\u0082\b\u00a2\u0006\u0003\u0010\u0082\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010!\u001a\n #*\u0004\u0018\u00010\"0\"X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010$R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u0004\u0018\u00010-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u0004\u0018\u00010/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00102\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00104\u001a\u0004\u0018\u000105X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00106\u001a\u0004\u0018\u000107X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0087\u0001"}, d2={"Lcom/intellij/database/script/generator/ui/ScriptGeneratorUI;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "content", "Lcom/intellij/ui/content/Content;", "getContent$intellij_database_impl", "()Lcom/intellij/ui/content/Content;", "setContent$intellij_database_impl", "(Lcom/intellij/ui/content/Content;)V", "mainPanel", "Ljavax/swing/JPanel;", "getMainPanel$intellij_database_impl", "()Ljavax/swing/JPanel;", "viewer", "Lcom/intellij/ui/EditorTextField;", "getViewer$intellij_database_impl", "()Lcom/intellij/ui/EditorTextField;", "notificationPanel", "Lcom/intellij/ui/EditorNotificationPanel;", "loadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "categorySelector", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/database/script/generator/ScriptCategory;", "optionsPanel", "Lcom/intellij/database/script/generator/ui/ScriptOptionsPanel;", "layoutPanel", "Lcom/intellij/database/script/generator/ui/ScriptFileLayoutPanel;", "alarm", "Lcom/intellij/util/SingleAlarm;", "settings", "Lcom/intellij/database/script/generator/ui/ScriptGeneratorSettings;", "kotlin.jvm.PlatformType", "Lcom/intellij/database/script/generator/ui/ScriptGeneratorSettings;", "selection", "Lcom/intellij/database/script/generator/ui/ScriptGeneratorUI$Selection;", "category", "generationInProgress", "Ljava/util/concurrent/atomic/AtomicBoolean;", "refreshIsInProgress", "toRequestFocus", "generatedText", "Lcom/intellij/database/model/properties/CompositeText;", "currentSchema", "Lcom/intellij/database/model/basic/BasicSchema;", "scriptingOptions", "Lcom/intellij/database/script/generator/ScriptingOptions;", "document", "Lcom/intellij/openapi/editor/Document;", "psiFile", "Lcom/intellij/psi/PsiFile;", "messageBusConnection", "Lcom/intellij/util/messages/MessageBusConnection;", "startGeneration", "", "model", "Lcom/intellij/database/model/basic/BasicModel;", "nodes", "", "Lcom/intellij/database/model/basic/BasicNode;", "createUiSchema", "Lcom/intellij/database/util/UiSchema;", "describeCategory", "Lcom/intellij/database/util/UiSchema$Desc;", "asSequence", "Lkotlin/sequences/Sequence;", "T", "Ljavax/swing/ListModel;", "generate", "consumer", "Lcom/intellij/database/script/generator/ScriptConsumer;", "saveOutputSettings", "assignSelection", "adjustCategories", "assignCategory", "assignOptionsFromSettings", "adjustOptionsUI", "processOptionChange", "onRegenerationAlarm", "regenerateOrSchedule", "fluent", "", "regenerate", "applyAndShowTheGeneratedScript", "result", "Lcom/intellij/database/script/generator/ScriptingResult;", "updateWarningNotification", "task", "Lcom/intellij/database/script/generator/ScriptingTask;", "notifyIntrospectionRecommendation", "ds", "Lcom/intellij/database/dataSource/LocalDataSource;", "recommendation", "Lcom/intellij/database/model/LevelAnalyzer$Recommendation;", "startRecommendedIntrospection", "onRefreshFinish", "askGeneration", "removeWarningNotification", "createTask", "schemasToGenerate", "", "objectsToGenerate", "Lcom/intellij/database/model/basic/BasicElement;", "prepareDocument", "showTheScriptInsideUI", "copyToClipboard", "saveToFile", "openInConsole", "findDsForModel", "retrieveNativeDefinitionsForElements", "", "", "", "elements", "retrieveNativeDefinitionsForElementsInternal", "clear", "dispose", "getItems", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "inUI", "block", "Lkotlin/Function0;", "inWriteAction", "doing", "message", "operation", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "PsiFacadeListener", "Selection", "FinalAction", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nScriptGeneratorUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptGeneratorUI.kt\ncom/intellij/database/script/generator/ui/ScriptGeneratorUI\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,703:1\n669#1,6:728\n37#2,2:704\n19#3:706\n1611#4,9:707\n1863#4:716\n1864#4:718\n1620#4:719\n774#4:720\n865#4,2:721\n1863#4,2:723\n295#4,2:726\n1#5:717\n1#5:725\n14#6:734\n*S KotlinDebug\n*F\n+ 1 ScriptGeneratorUI.kt\ncom/intellij/database/script/generator/ui/ScriptGeneratorUI\n*L\n607#1:728,6\n196#1:704,2\n221#1:706\n301#1:707,9\n301#1:716\n301#1:718\n301#1:719\n308#1:720\n308#1:721,2\n316#1:723,2\n600#1:726,2\n301#1:717\n81#1:734\n*E\n"})
public final class ScriptGeneratorUI
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    public Content content;
    @NotNull
    private final JPanel mainPanel;
    @NotNull
    private final EditorTextField viewer;
    @NotNull
    private final EditorNotificationPanel notificationPanel;
    @NotNull
    private final JBLoadingPanel loadingPanel;
    @NotNull
    private final ComboBox<ScriptCategory> categorySelector;
    @NotNull
    private ScriptOptionsPanel optionsPanel;
    @NotNull
    private ScriptFileLayoutPanel layoutPanel;
    @NotNull
    private final SingleAlarm alarm;
    private final ScriptGeneratorSettings settings;
    @Nullable
    private Selection selection;
    @NotNull
    private ScriptCategory category;
    @NotNull
    private final AtomicBoolean generationInProgress;
    @NotNull
    private final AtomicBoolean refreshIsInProgress;
    @NotNull
    private final AtomicBoolean toRequestFocus;
    @Nullable
    private CompositeText generatedText;
    @Nullable
    private BasicSchema currentSchema;
    @NotNull
    private ScriptingOptions scriptingOptions;
    @Nullable
    private Document document;
    @Nullable
    private PsiFile psiFile;
    @Nullable
    private MessageBusConnection messageBusConnection;
    @NotNull
    private static final Key<ScriptGeneratorUI> contextKey = new Key("DatabaseScriptingContext");
    @NotNull
    private static final Key<BasicModel> modelKey = new Key("DatabaseModel");
    @NotNull
    private static final List<ScriptCategory> implementedCategories;
    @NotNull
    private static final Logger log;
    @Nullable
    private static String lastPath;

    /*
     * WARNING - void declaration
     */
    public ScriptGeneratorUI(@NotNull Project project) {
        void $this$_init__u24lambda_u2412;
        JPanel jPanel;
        BorderLayoutPanel borderLayoutPanel;
        JPanel $this$_init__u24lambda_u248;
        JPanel $this$_init__u24lambda_u244;
        ScriptGeneratorUI scriptGeneratorUI;
        block5: {
            block4: {
                void $this$_init__u24lambda_u242;
                JBLoadingPanel $this$_init__u24lambda_u240;
                Document document;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                this.project = project;
                this.alarm = SingleAlarm.Companion.pooledThreadSingleAlarm(250, (Disposable)this, (Function0)new Function0<Unit>((Object)this){

                    public final void invoke() {
                        ScriptGeneratorUI.access$onRegenerationAlarm((ScriptGeneratorUI)this.receiver);
                    }
                });
                this.settings = (ScriptGeneratorSettings)this.project.getService(ScriptGeneratorSettings.class);
                this.category = ScriptCategory.CREATE_COMPLETE;
                this.generationInProgress = new AtomicBoolean();
                this.refreshIsInProgress = new AtomicBoolean();
                this.toRequestFocus = new AtomicBoolean(false);
                this.scriptingOptions = DefaultScriptingOptions.INSTANCE;
                EditorFactory editorFactory = EditorFactory.getInstance();
                Document document2 = document = editorFactory.createDocument((CharSequence)"");
                scriptGeneratorUI = this;
                boolean $i$a$-apply-ScriptGeneratorUI$22 = false;
                $this$_init__u24lambda_u240.setReadOnly(true);
                scriptGeneratorUI.document = document;
                this.notificationPanel = new EditorNotificationPanel(LightColors.YELLOW, EditorNotificationPanel.Status.Warning);
                this.notificationPanel.setVisible(false);
                this.viewer = new EditorTextField(this.document, this.project, null, true, false);
                this.viewer.setFontInheritedFromLAF(false);
                this.viewer.addSettingsProvider(arg_0 -> ScriptGeneratorUI._init_$lambda$1(this, arg_0));
                JPanel editorPanel = new JPanel(new BorderLayout());
                editorPanel.add((Component)this.notificationPanel, "North");
                editorPanel.add((Component)this.viewer, "Center");
                JBLoadingPanel $i$a$-apply-ScriptGeneratorUI$22 = $this$_init__u24lambda_u240 = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 0, 4, null);
                scriptGeneratorUI = this;
                boolean bl = false;
                $this$_init__u24lambda_u242.add((Component)editorPanel, (Object)"Center");
                $this$_init__u24lambda_u242.setLoadingText(ScriptGeneratorUI.Companion.getNormalLoadingPanelText());
                scriptGeneratorUI.loadingPanel = $this$_init__u24lambda_u240;
                Collection $this$toTypedArray$iv = implementedCategories;
                boolean $i$f$toTypedArray22 = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Collection $i$f$toTypedArray22 = $this$toTypedArray$iv = new ComboBox((Object[])thisCollection$iv.toArray(new ScriptCategory[0]));
                scriptGeneratorUI = this;
                boolean bl2 = false;
                $this$_init__u24lambda_u244.setEditable(false);
                $this$_init__u24lambda_u244.setSelectedItem((Object)this.category);
                $this$_init__u24lambda_u244.addActionListener(arg_0 -> ScriptGeneratorUI.lambda$4$lambda$3((ComboBox)$this$_init__u24lambda_u244, this, arg_0));
                scriptGeneratorUI.categorySelector = $this$toTypedArray$iv;
                this.optionsPanel = new ScriptOptionsPanel((Function0<Unit>)((Function0)() -> ScriptGeneratorUI._init_$lambda$5(this)));
                ScriptGeneratorSettings scriptGeneratorSettings = this.settings;
                Intrinsics.checkNotNullExpressionValue((Object)scriptGeneratorSettings, (String)"settings");
                this.layoutPanel = new ScriptFileLayoutPanel(scriptGeneratorSettings, this.project, (Function1)new Function1<ScriptConsumer<?>, Unit>(this){

                    public final void invoke(ScriptConsumer<?> p0) {
                        Intrinsics.checkNotNullParameter(p0, (String)"p0");
                        ((ScriptGeneratorUI)this.receiver).generate(p0);
                    }
                }, (Function0<Unit>)((Function0)() -> ScriptGeneratorUI._init_$lambda$6(this)));
                $this$_init__u24lambda_u248 = $this$_init__u24lambda_u244 = new JPanel((LayoutManager)new VerticalLayout(4), false);
                boolean bl3 = false;
                UiSchema.Companion.register($this$_init__u24lambda_u248, this.createUiSchema());
                AnAction $this$asSafely$iv = ActionManager.getInstance().getAction("ScriptGenerator.Options.Popup");
                boolean $i$f$asSafely = false;
                AnAction anAction = $this$asSafely$iv;
                if (!(anAction instanceof ActionGroup)) {
                    anAction = null;
                }
                if ((borderLayoutPanel = (BorderLayoutPanel)anAction) == null) break block4;
                BorderLayoutPanel it = borderLayoutPanel;
                boolean bl4 = false;
                JComponent tb = ActionUtil.createToolbarComponent((JComponent)$this$_init__u24lambda_u248, (String)"popup", it, (boolean)true);
                BorderLayoutPanel borderLayoutPanel2 = JBUI.Panels.simplePanel().addToCenter((Component)this.categorySelector).addToRight((Component)tb);
                borderLayoutPanel = borderLayoutPanel2;
                if (borderLayoutPanel2 != null) break block5;
            }
            borderLayoutPanel = this.categorySelector;
        }
        BorderLayoutPanel c2 = borderLayoutPanel;
        String string = DatabaseBundle.message("scriptGen.ui.selectCategory.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$_init__u24lambda_u248.add(new ScriptOptionsPanel.LabeledComponent(string, (JComponent)c2));
        $this$_init__u24lambda_u248.add(this.optionsPanel.getComponent());
        JPanel optionsInnerPanel = $this$_init__u24lambda_u244;
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)optionsInnerPanel, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
        JScrollPane optionsScrollPane = jScrollPane;
        optionsScrollPane.setVerticalScrollBarPolicy(20);
        optionsScrollPane.setHorizontalScrollBarPolicy(31);
        String string2 = DatabaseBundle.message("scriptGen.ui.sidePanel.copyToClipboard", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        FinalAction copyToClipboardAction = new FinalAction(this, string2, null, AllIcons.Actions.Copy, () -> ScriptGeneratorUI._init_$lambda$9(this), 2, null);
        String string3 = DatabaseBundle.message("scriptGen.ui.sidePanel.saveIntoFile", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        FinalAction saveToFileAction = new FinalAction(this, string3, null, AllIcons.Actions.MenuSaveall, () -> ScriptGeneratorUI._init_$lambda$10(this), 2, null);
        String string4 = DatabaseBundle.message("scriptGen.ui.sidePanel.openInConsole", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        FinalAction openInConsoleAction = new FinalAction(this, string4, null, DatabaseIcons.ConsoleRun, () -> ScriptGeneratorUI._init_$lambda$11(this), 2, null);
        ActionManager actionManager = ActionManager.getInstance();
        AnAction[] bl4 = new AnAction[]{copyToClipboardAction, saveToFileAction, openInConsoleAction};
        DefaultActionGroup actions = new DefaultActionGroup(bl4);
        ActionToolbar actionToolbar = actionManager.createActionToolbar("EditorToolbar", (ActionGroup)actions, false);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar actionToolbar2 = actionToolbar;
        actionToolbar2.setTargetComponent((JComponent)this.viewer);
        JBTabbedPane tabs = new JBTabbedPane(2);
        tabs.addTab(null, AllIcons.General.GearPlain, (Component)optionsScrollPane, DatabaseBundle.message("scriptGen.ui.sidePanel.generatorOptions", new Object[0]));
        tabs.addTab(null, AllIcons.Actions.MenuSaveall, (Component)this.layoutPanel.getComponent(), DatabaseBundle.message("scriptGen.ui.sidePanel.fileOutputOptions", new Object[0]));
        JPanel jPanel2 = jPanel = new JPanel(new BorderLayout());
        scriptGeneratorUI = this;
        boolean bl = false;
        $this$_init__u24lambda_u2412.add((Component)this.loadingPanel, "Center");
        $this$_init__u24lambda_u2412.add((Component)tabs, "West");
        $this$_init__u24lambda_u2412.add((Component)actionToolbar2.getComponent(), "East");
        scriptGeneratorUI.mainPanel = jPanel;
    }

    @NotNull
    public final Content getContent$intellij_database_impl() {
        Content content = this.content;
        if (content != null) {
            return content;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"content");
        return null;
    }

    public final void setContent$intellij_database_impl(@NotNull Content content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"<set-?>");
        this.content = content;
    }

    @NotNull
    public final JPanel getMainPanel$intellij_database_impl() {
        return this.mainPanel;
    }

    @NotNull
    public final EditorTextField getViewer$intellij_database_impl() {
        return this.viewer;
    }

    public final void startGeneration(@NotNull BasicModel model, @NotNull Iterable<? extends BasicNode> nodes2) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter(nodes2, (String)"nodes");
        this.alarm.cancel();
        this.assignSelection(model, nodes2);
        this.adjustCategories();
        this.assignOptionsFromSettings();
        this.adjustOptionsUI();
        Object object = this.selection;
        if (!(object != null && (object = ((Selection)object).getElements()) != null ? !object.isEmpty() : false)) {
            this.clear();
            return;
        }
        this.toRequestFocus.set(true);
        this.askGeneration();
        if (this.messageBusConnection == null) {
            MessageBusConnection messageBusConnection = this.messageBusConnection = this.project.getMessageBus().connect();
            Intrinsics.checkNotNull((Object)messageBusConnection);
            Topic<DbPsiFacade.Listener> topic = DbPsiFacade.TOPIC;
            Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
            messageBusConnection.subscribe(topic, (Object)new PsiFacadeListener());
        }
    }

    private final UiSchema createUiSchema() {
        return UiSchema.Companion.create(new UiSchema.Desc("options", null, null, 6, null), (Function0<? extends List<? extends UiSchema>>)((Function0)() -> ScriptGeneratorUI.createUiSchema$lambda$15(this)));
    }

    private final UiSchema.Desc describeCategory() {
        ComboBoxModel comboBoxModel = this.categorySelector.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)comboBoxModel, (String)"getModel(...)");
        UiSchema.Type.Enum type = new UiSchema.Type.Enum(SequencesKt.toList((Sequence)SequencesKt.map(this.asSequence(comboBoxModel), ScriptGeneratorUI::describeCategory$lambda$16)));
        String string = DatabaseBundle.message("scriptGen.ui.selectCategory.label", new Object[0]);
        return (UiSchema.Desc)((Object)new UiSchema.Desc.Mutable(type, this, string){
            final /* synthetic */ UiSchema.Type.Enum $type;
            final /* synthetic */ ScriptGeneratorUI this$0;
            {
                this.$type = $type;
                this.this$0 = $receiver;
                super("generate", $super_call_param$1, "Which type of script to generate");
            }

            public UiSchema.Type getType() {
                return this.$type;
            }

            public String getValue() {
                ScriptCategory scriptCategory = (ScriptCategory)((Object)ScriptGeneratorUI.access$getCategorySelector$p(this.this$0).getItem());
                return scriptCategory != null ? scriptCategory.getCode() : null;
            }

            public Object setValue(String v, Continuation<? super Unit> $completion) {
                ScriptCategory item;
                String string = v;
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    v1 = ScriptCategory.Companion.of(v);
                } else {
                    v1 = item = null;
                }
                if (item == null) {
                    throw new RuntimeException("Value " + v + " not found");
                }
                ScriptGeneratorUI.access$getCategorySelector$p(this.this$0).getModel().setSelectedItem((Object)((Object)item));
                return Unit.INSTANCE;
            }

            public String settingMessage() {
                Object[] objectArray = new Object[]{this.getDisplayName()};
                String string = DatabaseBundle.message("progress.title.modifying", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }
        });
    }

    private final <T> Sequence<T> asSequence(ListModel<T> $this$asSequence) {
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)RangesKt.until((int)0, (int)$this$asSequence.getSize()))), arg_0 -> ScriptGeneratorUI.asSequence$lambda$17($this$asSequence, arg_0));
    }

    private final void generate(ScriptConsumer<?> consumer) {
        ScriptingTask scriptingTask = this.createTask(consumer);
        if (scriptingTask == null) {
            return;
        }
        ScriptingTask task = scriptingTask;
        ScriptGenerators.INSTANCE.makeScript(this.project, task);
        this.saveOutputSettings();
    }

    private final void saveOutputSettings() {
        this.settings.setOutputPath(this.layoutPanel.getPath());
        this.settings.setOutputLayout(this.layoutPanel.getLayout());
    }

    /*
     * WARNING - void declaration
     */
    private final void assignSelection(BasicModel model, Iterable<? extends BasicNode> nodes2) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterable<? extends BasicNode> iterable = nodes2;
        boolean $i$f$mapNotNull = false;
        void var6_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            BasicElement it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            BasicNode it = (BasicNode)element$iv$iv;
            boolean bl2 = false;
            if ((it instanceof BasicElement ? (BasicElement)it : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List elements = (List)destination$iv$iv;
        this.selection = new Selection(model, elements);
    }

    /*
     * WARNING - void declaration
     */
    private final void adjustCategories() {
        void $this$filterTo$iv$iv;
        Object object = this.selection;
        if (object == null || (object = ((Selection)object).getModel()) == null || (object = object.getDbms()) == null) {
            object = Dbms.UNKNOWN;
        }
        Object dbms = object;
        Iterable $this$filter$iv = implementedCategories;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ScriptCategory it = (ScriptCategory)((Object)element$iv$iv);
            boolean bl = false;
            if (!it.getApplicableDbs().value(dbms)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection collection = (List)destination$iv$iv;
        ArrayList needCategories = new ArrayList(collection);
        ArrayList<ScriptCategory> existentCategories = this.getItems(this.categorySelector);
        if (Intrinsics.areEqual(needCategories, existentCategories)) {
            return;
        }
        ScriptCategory savedCategory = this.category;
        this.categorySelector.removeAllItems();
        if (needCategories.isEmpty()) {
            return;
        }
        Iterable $this$forEach$iv = needCategories;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScriptCategory it = (ScriptCategory)((Object)element$iv);
            boolean bl = false;
            this.categorySelector.addItem((Object)it);
        }
        if (needCategories.contains((Object)savedCategory)) {
            this.categorySelector.setSelectedItem((Object)savedCategory);
            this.assignCategory(savedCategory);
        } else {
            this.categorySelector.setSelectedIndex(0);
            this.assignCategory((ScriptCategory)((Object)CollectionsKt.first((List)needCategories)));
        }
    }

    private final void assignCategory(ScriptCategory category) {
        this.category = category;
        this.assignOptionsFromSettings();
    }

    private final void assignOptionsFromSettings() {
        Object object = this.selection;
        Dbms rdbms = object != null && (object = ((Selection)object).getModel()) != null ? object.getDbms() : null;
        CustomScriptingOptions customScriptingOptions = rdbms != null ? this.settings.get(rdbms, this.category) : null;
        this.scriptingOptions = customScriptingOptions != null ? (ScriptingOptions)customScriptingOptions : (ScriptingOptions)DefaultScriptingOptions.INSTANCE;
    }

    private final void adjustOptionsUI() {
        ScriptingTask scriptingTask;
        ScriptOptionsPanel scriptOptionsPanel = this.optionsPanel;
        Object object = this.selection;
        if (object != null && (object = ((Selection)object).getModel()) != null) {
            Object it = object;
            ScriptOptionsPanel scriptOptionsPanel2 = scriptOptionsPanel;
            boolean bl = false;
            scriptingTask = this.createTask(this.category, (BasicModel)it, CollectionsKt.emptyList(), CollectionsKt.emptyList(), null);
            scriptOptionsPanel = scriptOptionsPanel2;
        } else {
            scriptingTask = null;
        }
        scriptOptionsPanel.adjustOptionsUI(scriptingTask, this.scriptingOptions);
    }

    private final void processOptionChange() {
        Dbms rdbms;
        ScriptingOptions newOptions;
        this.scriptingOptions = newOptions = this.optionsPanel.gatherOptions();
        Object object = this.selection;
        Dbms dbms = object != null && (object = ((Selection)object).getModel()) != null ? object.getDbms() : (rdbms = null);
        if (rdbms != null) {
            this.settings.set(rdbms, this.category, newOptions instanceof CustomScriptingOptions ? (CustomScriptingOptions)newOptions : null);
        }
    }

    private final void onRegenerationAlarm() {
        this.regenerateOrSchedule(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void regenerateOrSchedule(boolean fluent) {
        boolean ok2 = this.generationInProgress.compareAndSet(false, true);
        if (ok2) {
            try {
                this.regenerate(fluent);
            }
            finally {
                this.generationInProgress.set(false);
            }
        } else {
            SingleAlarm.cancelAndRequest$default((SingleAlarm)this.alarm, (boolean)false, (int)1, null);
        }
    }

    private final void regenerate(boolean fluent) {
        ScriptingTask scriptingTask = this.createTask(null);
        if (scriptingTask == null) {
            return;
        }
        ScriptingTask task = scriptingTask;
        Object object = this.selection;
        if (object == null || (object = ((Selection)object).getModel()) == null) {
            return;
        }
        Object model = object;
        BasicSchema basicSchema = task.getCurrentSchema();
        if (basicSchema == null) {
            BasicDatabase basicDatabase = model.getRoot().getCurrentDatabase();
            basicSchema = this.currentSchema = basicDatabase != null ? ModelFun.getCurrentSchema(basicDatabase) : null;
        }
        if (!fluent) {
            ScriptGeneratorUI.Companion.invokeLater((Function0<Unit>)() -> ScriptGeneratorUI.regenerate$lambda$22(this, task));
        }
        ReadAction.nonBlocking(() -> ScriptGeneratorUI.regenerate$lambda$23(this, task)).finishOnUiThread(ModalityState.nonModal(), arg_0 -> ScriptGeneratorUI.regenerate$lambda$25(arg_0 -> ScriptGeneratorUI.regenerate$lambda$24(this, arg_0), arg_0)).expireWith((Disposable)this).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private final void applyAndShowTheGeneratedScript(ScriptingResult result2) {
        this.generatedText = result2.getScript();
        this.inWriteAction((Function0<Unit>)((Function0)() -> ScriptGeneratorUI.applyAndShowTheGeneratedScript$lambda$26(this)));
    }

    private final void updateWarningNotification(ScriptingTask task) {
        if (!(task instanceof ScriptingSingleModelTask)) {
            this.removeWarningNotification();
            return;
        }
        LocalDataSource localDataSource = this.findDsForModel(ScriptingTaskKt.getAnyModel(task));
        if (localDataSource == null) {
            return;
        }
        LocalDataSource ds = localDataSource;
        LevelAnalyzer levelAnalyzer = ModelFacade.forDbms(ScriptingTaskKt.getDbms(task)).createLevelAnalyzer(ds.getUniqueId());
        Intrinsics.checkNotNullExpressionValue((Object)levelAnalyzer, (String)"createLevelAnalyzer(...)");
        LevelAnalyzer analyzer = levelAnalyzer;
        analyzer.addElementsToAnalysis((Iterable<? extends BasicElement>)((ScriptingSingleModelTask)task).getElements());
        LevelAnalyzer.Recommendation recommendation = analyzer.analyzeForScripting(((ScriptingSingleModelTask)task).getCategory());
        if (!recommendation.hasContent()) {
            this.removeWarningNotification();
            return;
        }
        if (this.refreshIsInProgress.get()) {
            return;
        }
        if (DbImplUtil.isConnected(this.project, ds)) {
            this.startRecommendedIntrospection(this.project, ds, recommendation);
        } else {
            this.notifyIntrospectionRecommendation(this.project, ds, recommendation);
        }
    }

    private final void notifyIntrospectionRecommendation(Project project, LocalDataSource ds, LevelAnalyzer.Recommendation recommendation) {
        this.notificationPanel.clear();
        this.notificationPanel.setText(DatabaseBundle.message("scriptGenerator.notification.lowLevel.1", new Object[0]));
        Ref.ObjectRef hyperLabel = new Ref.ObjectRef();
        hyperLabel.element = this.notificationPanel.createActionLabel(recommendation.getTitle(), () -> ScriptGeneratorUI.notifyIntrospectionRecommendation$lambda$27(hyperLabel, this, project, ds, recommendation));
        this.notificationPanel.setVisible(true);
    }

    private final void startRecommendedIntrospection(Project project, LocalDataSource ds, LevelAnalyzer.Recommendation recommendation) {
        this.notificationPanel.setText(DatabaseBundle.message("scriptGenerator.notification.lowLevel.2", new Object[0]));
        this.notificationPanel.setVisible(true);
        LoaderContext loaderContext = LoaderContext.selectTasks(project, ds, (Collection<? extends IntrospectionTask>)recommendation.tasks);
        AsyncTask<SyncQueue.SyncResult> asyncTask = DataSourceUtil.performManualSyncTask(loaderContext);
        Intrinsics.checkNotNullExpressionValue(asyncTask, (String)"performManualSyncTask(...)");
        AsyncTask<SyncQueue.SyncResult> syncTask = asyncTask;
        this.refreshIsInProgress.set(true);
        syncTask.whenComplete(null, (arg_0, arg_1) -> ScriptGeneratorUI.startRecommendedIntrospection$lambda$29((arg_0, arg_1) -> ScriptGeneratorUI.startRecommendedIntrospection$lambda$28(this, arg_0, arg_1), arg_0, arg_1));
    }

    private final void onRefreshFinish() {
        this.notificationPanel.clear();
        this.notificationPanel.setVisible(false);
        this.refreshIsInProgress.set(false);
        this.regenerateOrSchedule(true);
    }

    private final void askGeneration() {
        this.regenerateOrSchedule(false);
    }

    private final void removeWarningNotification() {
        this.notificationPanel.clear();
        this.notificationPanel.setVisible(false);
    }

    private final ScriptingTask createTask(ScriptConsumer<?> consumer) {
        Selection selection = this.selection;
        if (selection == null) {
            return null;
        }
        Selection selection2 = selection;
        ScriptCategory category = this.category;
        JBIterable jBIterable = JBIterable.from((Iterable)selection2.getElements());
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
        JBIterable sel = jBIterable;
        JBIterable jBIterable2 = sel.filter(BasicDatabase.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
        JBIterable explicitDatabases = jBIterable2;
        JBIterable jBIterable3 = sel.filter(BasicSchema.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"filter(...)");
        JBIterable explicitSchemas = jBIterable3;
        JBIterable jBIterable4 = sel.filter(BasicElement.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"filter(...)");
        JBIterable explicitScriptableObjects = jBIterable4;
        List list = explicitDatabases.flatten(arg_0 -> ScriptGeneratorUI.createTask$lambda$31(ScriptGeneratorUI::createTask$lambda$30, arg_0)).append((Iterable)explicitSchemas).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        List schemasToGenerate = list;
        List list2 = explicitScriptableObjects.filter(arg_0 -> ScriptGeneratorUI.createTask$lambda$33(arg_0 -> ScriptGeneratorUI.createTask$lambda$32(schemasToGenerate, arg_0), arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"toList(...)");
        List objectsToGenerate = list2;
        return this.createTask(category, selection2.getModel(), schemasToGenerate, objectsToGenerate, consumer);
    }

    private final ScriptingTask createTask(ScriptCategory category, BasicModel model, List<? extends BasicSchema> schemasToGenerate, List<? extends BasicElement> objectsToGenerate, ScriptConsumer<?> consumer) {
        ScriptingSingleModelTaskBuilderBase scriptingSingleModelTaskBuilderBase;
        ScriptingSingleModelTaskBuilderBase scriptingSingleModelTaskBuilderBase2;
        if (WhenMappings.$EnumSwitchMapping$0[category.ordinal()] == 1) {
            ScriptingNativeDefinitionTaskBuilder scriptingNativeDefinitionTaskBuilder;
            ScriptingNativeDefinitionTaskBuilder $this$createTask_u24lambda_u2434 = scriptingNativeDefinitionTaskBuilder = new ScriptingNativeDefinitionTaskBuilder(model);
            boolean bl = false;
            $this$createTask_u24lambda_u2434.setNativeDefinitionsRetriever((Function1<? super List<? extends BasicElement>, ? extends Map<BasicElement, String[]>>)((Function1)new Function1<List<? extends BasicElement>, Map<BasicElement, ? extends String[]>>((Object)this){

                public final Map<BasicElement, String[]> invoke(List<? extends BasicElement> p0) {
                    Intrinsics.checkNotNullParameter(p0, (String)"p0");
                    return ScriptGeneratorUI.access$retrieveNativeDefinitionsForElements((ScriptGeneratorUI)this.receiver, p0);
                }
            }));
            scriptingSingleModelTaskBuilderBase2 = scriptingNativeDefinitionTaskBuilder;
        } else {
            scriptingSingleModelTaskBuilderBase2 = new ScriptingSingleModelTaskBuilder(model, category);
        }
        ScriptingSingleModelTaskBuilderBase $this$createTask_u24lambda_u2442 = scriptingSingleModelTaskBuilderBase = scriptingSingleModelTaskBuilderBase2;
        boolean bl = false;
        if (category == ScriptCategory.CREATE_DEFINITION) {
            $this$createTask_u24lambda_u2442.getElements().addAll((Collection<BasicElement>)schemasToGenerate);
            $this$createTask_u24lambda_u2442.getElements().addAll((Collection<BasicElement>)objectsToGenerate);
        } else {
            ScriptGenerator gen = ScriptGenerators.INSTANCE.byModel(model);
            JBIterable jBIterable = JBIterable.from((Iterable)schemasToGenerate).flatten(arg_0 -> ScriptGeneratorUI.createTask$lambda$42$lambda$36(ScriptGeneratorUI::createTask$lambda$42$lambda$35, arg_0)).append((Iterable)objectsToGenerate);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"append(...)");
            JBIterable objects = jBIterable;
            JBIterable jBIterable2 = ((JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.from(arg_0 -> ScriptGeneratorUI.createTask$lambda$42$lambda$37(createTask.2.1.INSTANCE, arg_0)).withRoots((Iterable)objects)).expandAndSkip(arg_0 -> ScriptGeneratorUI.createTask$lambda$42$lambda$39(arg_0 -> ScriptGeneratorUI.createTask$lambda$42$lambda$38(gen, category, $this$createTask_u24lambda_u2442, arg_0), arg_0))).traverse().collect($this$createTask_u24lambda_u2442.getElements());
            Intrinsics.checkNotNull((Object)jBIterable2);
        }
        $this$createTask_u24lambda_u2442.setCurrentSchema(switch (schemasToGenerate.size()) {
            case 0 -> (BasicSchema)SequencesKt.singleOrNull((Sequence)SequencesKt.distinct((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)objectsToGenerate), ScriptGeneratorUI::createTask$lambda$42$lambda$40))));
            case 1 -> (BasicSchema)CollectionsKt.firstOrNull(schemasToGenerate);
            default -> null;
        });
        $this$createTask_u24lambda_u2442.setOptions(this.scriptingOptions);
        LocalDataSource localDataSource = this.findDsForModel(model);
        if (localDataSource != null) {
            LocalDataSource it = localDataSource;
            boolean bl2 = false;
            $this$createTask_u24lambda_u2442.setCodeStyleFrom(it);
        }
        $this$createTask_u24lambda_u2442.setConsumer(consumer);
        return scriptingSingleModelTaskBuilderBase.build();
    }

    private final void prepareDocument() {
        Document document;
        Selection selection = this.selection;
        if (selection == null) {
            return;
        }
        Selection selection2 = selection;
        BasicModel model = selection2.getModel();
        Document document2 = this.document;
        if ((document2 != null ? (BasicModel)document2.getUserData(modelKey) : null) == model) {
            return;
        }
        LocalDataSource localDataSource = this.findDsForModel(model);
        if (localDataSource == null) {
            return;
        }
        LocalDataSource dataSource = localDataSource;
        DbDataSource dbDataSource = DbPsiFacadeImpl.getInstance(this.project).findDataSource(dataSource.getUniqueId());
        if (dbDataSource == null) {
            return;
        }
        DbDataSource dbDataSource2 = dbDataSource;
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect(dataSource);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect, (String)"getSqlDialect(...)");
        SqlLanguageDialect language = sqlLanguageDialect;
        PsiFile psiFile = PsiFileFactory.getInstance((Project)this.project).createFileFromText("generated.sql", (Language)language, (CharSequence)"");
        DatabaseDataKeysCore.DATA_SOURCE_KEY.set((UserDataHolder)psiFile, (Object)dbDataSource2);
        DatabaseDataKeysCore.SEARCH_PATH_KEY.set((UserDataHolder)psiFile, (Object)ObjectPaths.searchPathOf(this.currentSchema));
        this.psiFile = psiFile;
        Document document3 = document = PsiDocumentManager.getInstance((Project)this.project).getDocument(psiFile);
        Intrinsics.checkNotNull((Object)document3);
        document3.putUserData(modelKey, (Object)model);
        this.document = document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void showTheScriptInsideUI() {
        block9: {
            Document document = this.document;
            if (document == null) {
                throw new IllegalStateException("The document is not prepared".toString());
            }
            Document document2 = document;
            Object object = this.generatedText;
            if (object == null || (object = object.getText()) == null || (object = object.toString()) == null) {
                object = "";
            }
            String string = StringUtil.convertLineSeparators((String)object);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertLineSeparators(...)");
            String text2 = string;
            int caretPos = 0;
            if (this.viewer.isViewer()) {
                CaretModel caretModel = this.viewer.getCaretModel();
                caretPos = caretModel != null ? caretModel.getOffset() : 0;
            }
            caretPos = RangesKt.coerceAtMost((int)caretPos, (int)text2.length());
            document2.setReadOnly(false);
            try {
                document2.setText((CharSequence)text2);
            }
            finally {
                document2.setReadOnly(true);
            }
            if (this.viewer.getDocument() != document2) {
                this.viewer.setDocument(document2);
            }
            this.viewer.setVisible(true);
            CaretModel caretModel = this.viewer.getCaretModel();
            if (caretModel != null) {
                caretModel.moveToOffset(caretPos);
            }
            Editor editor2 = this.viewer.getEditor();
            EditorImpl editorImpl = editor2 instanceof EditorImpl ? (EditorImpl)editor2 : null;
            if (editorImpl == null) break block9;
            editorImpl.setCaretEnabled(true);
        }
    }

    private final void copyToClipboard() {
        CompositeText compositeText = this.generatedText;
        if (compositeText == null) {
            return;
        }
        CompositeText generatedText = compositeText;
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(((Object)generatedText.getText()).toString()));
    }

    private final void saveToFile() {
        String string;
        CompositeText compositeText = this.generatedText;
        if (compositeText == null) {
            return;
        }
        CompositeText generatedText = compositeText;
        if (lastPath != null) {
            String string2 = lastPath;
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        } else if (StringsKt.equals((String)this.project.getName(), (String)"default", (boolean)true)) {
            string = System.getProperty("user.home");
            if (string == null) {
                string = "";
            }
        } else {
            string = this.project.getBasePath();
            if (string == null) {
                string = "";
            }
        }
        String path = string;
        String[] stringArray = new String[]{"sql"};
        FileSaverDescriptor descriptor2 = new FileSaverDescriptor(DatabaseBundle.message("scriptGen.ui.dialog.title.selectFileToSaveScript", new Object[0]), "", stringArray);
        FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor2, this.project);
        Intrinsics.checkNotNullExpressionValue((Object)fileSaverDialog, (String)"createSaveFileDialog(...)");
        FileSaverDialog chooser = fileSaverDialog;
        VirtualFile virtualBaseDir = LocalFileSystem.getInstance().findFileByIoFile(new File(path));
        VirtualFileWrapper virtualFileWrapper = chooser.save(virtualBaseDir, "script.sql");
        if (virtualFileWrapper == null) {
            return;
        }
        VirtualFileWrapper fileWrapper = virtualFileWrapper;
        File file = fileWrapper.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
        File file2 = file;
        lastPath = file2.getParent();
        try {
            Files.write(Paths.get(file2.getPath(), new String[0]), (Iterable<? extends CharSequence>)CollectionsKt.listOf((Object)generatedText.getText()), new OpenOption[0]);
        }
        catch (Exception e) {
            String message = "Failed to save SQL script into a file \"" + file2.getAbsolutePath() + ": exception " + e.getClass().getSimpleName() + ": " + e.getMessage();
            log.warn(message, (Throwable)e);
        }
    }

    private final void openInConsole() {
        CompositeText compositeText = this.generatedText;
        if (compositeText == null) {
            return;
        }
        CompositeText generatedText = compositeText;
        Selection selection = this.selection;
        LocalDataSource localDataSource = this.findDsForModel(selection != null ? selection.getModel() : null);
        if (localDataSource == null) {
            return;
        }
        LocalDataSource ds = localDataSource;
        DbUIUtil.openInConsole(this.project, ds, null, StringUtil.convertLineSeparators((String)((Object)generatedText.getText()).toString()), false);
    }

    private final LocalDataSource findDsForModel(BasicModel model) {
        Object v1;
        block2: {
            if (model == null) {
                return null;
            }
            List<LocalDataSource> list = DataSourceStorage.getProjectStorage(this.project).getDataSources();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getDataSources(...)");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                LocalDataSource ds = (LocalDataSource)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)ds.getModel(), (Object)model)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        return v1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Map<BasicElement, String[]> retrieveNativeDefinitionsForElements(List<? extends BasicElement> elements) {
        Map map2;
        void this_$iv;
        int n = elements.size();
        if (n == 0) {
            return MapsKt.emptyMap();
        }
        ScriptGeneratorUI scriptGeneratorUI = this;
        Object[] objectArray = new Object[]{n, n == 1 ? 0 : 1};
        String string = DatabaseBundle.message("retrieving.native.definitions.for.0.1.choice.0.element.1.elements", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String message$iv = string;
        boolean $i$f$doing = false;
        this_$iv.loadingPanel.setLoadingText(message$iv);
        try {
            boolean bl = false;
            map2 = this.retrieveNativeDefinitionsForElementsInternal(elements);
        }
        finally {
            this_$iv.loadingPanel.setLoadingText(ScriptGeneratorUI.Companion.getNormalLoadingPanelText());
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<BasicElement, String[]> retrieveNativeDefinitionsForElementsInternal(List<? extends BasicElement> elements) {
        Selection selection = this.selection;
        Intrinsics.checkNotNull((Object)selection);
        BasicModel model = selection.getModel();
        LocalDataSource dataSource = this.findDsForModel(model);
        if (dataSource == null) {
            Map map2 = JBIterable.from((Iterable)elements).toMap(arg_0 -> ScriptGeneratorUI.retrieveNativeDefinitionsForElementsInternal$lambda$46(ScriptGeneratorUI::retrieveNativeDefinitionsForElementsInternal$lambda$45, arg_0), arg_0 -> ScriptGeneratorUI.retrieveNativeDefinitionsForElementsInternal$lambda$48(ScriptGeneratorUI::retrieveNativeDefinitionsForElementsInternal$lambda$47, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"toMap(...)");
            return map2;
        }
        Map result2 = null;
        AutoCloseable autoCloseable = DatabaseSessionManager.getFacade$default(this.project, dataSource, null, null, null, DGDepartment.CODE_GENERATION, 24, null).connect();
        Throwable throwable = null;
        try {
            GuardedRef c2 = (GuardedRef)autoCloseable;
            boolean bl = false;
            DataSourceBriefConfig dsConfig = DataSourceBriefConfigs.getConfig(dataSource);
            DBIntrospector introspector = DBIntrospectorFactory.createIntrospector(this.project, new ModelFactory(BlackHoleTextStorage.INSTANCE), dataSource);
            Object t = c2.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            introspector.attachToDB((DatabaseConnectionCore)t);
            Intrinsics.checkNotNull((Object)model, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicModModel");
            introspector.init((BasicModModel)model, dsConfig, null);
            result2 = introspector.introspectNativeDefinitions((Iterable<? extends BasicElement>)elements, false);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        Map map3 = result2;
        if (map3 == null) {
            map3 = MapsKt.emptyMap();
        }
        return map3;
    }

    private final void clear() {
        this.generatedText = null;
        this.inUI((Function0<Unit>)((Function0)() -> ScriptGeneratorUI.clear$lambda$50(this)));
    }

    public void dispose() {
        MessageBusConnection messageBusConnection = this.messageBusConnection;
        if (messageBusConnection != null) {
            messageBusConnection.disconnect();
        }
        this.getContent$intellij_database_impl().putUserData(contextKey, null);
        this.loadingPanel.removeAll();
        ScriptGeneratorTool.INSTANCE.forgetProjectToolWindow$intellij_database_impl(this.project);
    }

    private final <T> ArrayList<T> getItems(ComboBox<T> $this$getItems) {
        int n = $this$getItems.getItemCount();
        ArrayList<Object> list = new ArrayList<Object>(n);
        for (int i2 = 0; i2 < n; ++i2) {
            list.add($this$getItems.getItemAt(i2));
        }
        return list;
    }

    private final void inUI(Function0<Unit> block) {
        ScriptGeneratorUI.Companion.invokeLater((Function0<Unit>)() -> ScriptGeneratorUI.inUI$lambda$51(this, block));
    }

    private final void inWriteAction(Function0<Unit> block) {
        ApplicationManager.getApplication().runWriteAction(() -> ScriptGeneratorUI.inWriteAction$lambda$52(block));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T doing(@Nls String message, Function0<? extends T> operation) {
        boolean $i$f$doing = false;
        this.loadingPanel.setLoadingText(message);
        try {
            Object object = operation.invoke();
            return (T)object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.loadingPanel.setLoadingText(ScriptGeneratorUI.Companion.getNormalLoadingPanelText());
            InlineMarker.finallyEnd((int)1);
        }
    }

    private static final void _init_$lambda$1(ScriptGeneratorUI this$0, EditorEx editor2) {
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this$0.project).getPsiFile((Document)editor2.getDocument());
        if (psiFile != null) {
            DatabaseDialogsHelper.setSpecificSyntaxHighlighter(this$0.project, psiFile.getLanguage(), editor2, psiFile.getVirtualFile());
        }
        editor2.setHorizontalScrollbarVisible(true);
        editor2.setVerticalScrollbarVisible(true);
        editor2.setBorder((Border)JBUI.Borders.empty());
        EditorSettings editorSettings = editor2.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"getSettings(...)");
        EditorSettings settings = editorSettings;
        settings.setWheelFontChangeEnabled(true);
        settings.setFoldingOutlineShown(true);
        settings.setAdditionalLinesCount(2);
        settings.setUseSoftWraps(false);
        settings.setLineNumbersShown(true);
        settings.setAnimatedScrolling(true);
    }

    private static final void lambda$4$lambda$3(ComboBox $this_apply, ScriptGeneratorUI this$0, ActionEvent it) {
        ScriptCategory selectedCategory;
        Object object = $this_apply.getSelectedItem();
        ScriptCategory scriptCategory = selectedCategory = object instanceof ScriptCategory ? (ScriptCategory)((Object)object) : null;
        if (selectedCategory != null) {
            this$0.assignCategory(selectedCategory);
            this$0.adjustOptionsUI();
            this$0.askGeneration();
        }
    }

    private static final Unit _init_$lambda$5(ScriptGeneratorUI this$0) {
        this$0.processOptionChange();
        this$0.askGeneration();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$6(ScriptGeneratorUI this$0) {
        this$0.saveOutputSettings();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$9(ScriptGeneratorUI this$0) {
        this$0.copyToClipboard();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$10(ScriptGeneratorUI this$0) {
        this$0.saveToFile();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$11(ScriptGeneratorUI this$0) {
        this$0.openInConsole();
        return Unit.INSTANCE;
    }

    private static final List createUiSchema$lambda$15(ScriptGeneratorUI this$0) {
        List list;
        block0: {
            List $this$createUiSchema_u24lambda_u2415_u24lambda_u2414 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$createUiSchema_u24lambda_u2415_u24lambda_u2414.add(UiSchema.Companion.create$default(UiSchema.Companion, this$0.describeCategory(), null, 2, null));
            UiSchema uiSchema = UiSchema.Companion.get(this$0.optionsPanel.getComponent());
            if (uiSchema == null) break block0;
            UiSchema it = uiSchema;
            boolean bl2 = false;
            $this$createUiSchema_u24lambda_u2415_u24lambda_u2414.addAll((Collection)it.children());
        }
        return CollectionsKt.build((List)list);
    }

    private static final UiSchema.Type.EnumValue describeCategory$lambda$16(ScriptCategory it) {
        return new UiSchema.Type.EnumValue(it.getCode(), it.getDisplayName(), null, 4, null);
    }

    private static final Object asSequence$lambda$17(ListModel $this_asSequence, int it) {
        return $this_asSequence.getElementAt(it);
    }

    private static final Unit regenerate$lambda$22(ScriptGeneratorUI this$0, ScriptingTask $task) {
        this$0.updateWarningNotification($task);
        this$0.loadingPanel.startLoading();
        return Unit.INSTANCE;
    }

    private static final ScriptingResult regenerate$lambda$23(ScriptGeneratorUI this$0, ScriptingTask $task) {
        return ScriptGenerators.INSTANCE.makeScript(this$0.project, $task);
    }

    private static final Unit regenerate$lambda$24(ScriptGeneratorUI this$0, ScriptingResult result2) {
        Intrinsics.checkNotNull((Object)result2);
        this$0.applyAndShowTheGeneratedScript(result2);
        return Unit.INSTANCE;
    }

    private static final void regenerate$lambda$25(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit applyAndShowTheGeneratedScript$lambda$26(ScriptGeneratorUI this$0) {
        this$0.prepareDocument();
        this$0.showTheScriptInsideUI();
        this$0.loadingPanel.stopLoading();
        return Unit.INSTANCE;
    }

    private static final void notifyIntrospectionRecommendation$lambda$27(Ref.ObjectRef $hyperLabel, ScriptGeneratorUI this$0, Project $project, LocalDataSource $ds, LevelAnalyzer.Recommendation $recommendation) {
        HyperlinkLabel hyperlinkLabel = (HyperlinkLabel)$hyperLabel.element;
        if (hyperlinkLabel != null) {
            hyperlinkLabel.setEnabled(false);
        }
        this$0.startRecommendedIntrospection($project, $ds, $recommendation);
    }

    private static final Unit startRecommendedIntrospection$lambda$28(ScriptGeneratorUI this$0, SyncQueue.SyncResult syncResult, Throwable throwable) {
        this$0.onRefreshFinish();
        return Unit.INSTANCE;
    }

    private static final void startRecommendedIntrospection$lambda$29(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Iterable createTask$lambda$30(BasicDatabase db) {
        return db.getSchemas();
    }

    private static final Iterable createTask$lambda$31(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final boolean createTask$lambda$32(List $schemasToGenerate, BasicElement it) {
        return !$schemasToGenerate.contains(it.getSchema());
    }

    private static final boolean createTask$lambda$33(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Iterable createTask$lambda$42$lambda$35(BasicSchema it) {
        Intrinsics.checkNotNull((Object)it);
        return UtilKt.getScriptableMajorObjects(it);
    }

    private static final Iterable createTask$lambda$42$lambda$36(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final Iterable createTask$lambda$42$lambda$37(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final boolean createTask$lambda$42$lambda$38(ScriptGenerator $gen, ScriptCategory $category, ScriptingSingleModelTaskBuilderBase $this_apply, BasicElement it) {
        Intrinsics.checkNotNull((Object)it);
        return $gen.capabilities(it).get($category).get($this_apply.getVersion()) == false;
    }

    private static final boolean createTask$lambda$42$lambda$39(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final BasicSchema createTask$lambda$42$lambda$40(BasicElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSchema();
    }

    private static final BasicElement retrieveNativeDefinitionsForElementsInternal$lambda$45(BasicElement it) {
        return it;
    }

    private static final BasicElement retrieveNativeDefinitionsForElementsInternal$lambda$46(Function1 $tmp0, Object p0) {
        return (BasicElement)$tmp0.invoke(p0);
    }

    private static final String[] retrieveNativeDefinitionsForElementsInternal$lambda$47(BasicElement it) {
        String[] stringArray = new String[]{"-- LocalDataSource not found :("};
        return stringArray;
    }

    private static final String[] retrieveNativeDefinitionsForElementsInternal$lambda$48(Function1 $tmp0, Object p0) {
        return (String[])$tmp0.invoke(p0);
    }

    private static final Unit clear$lambda$50(ScriptGeneratorUI this$0) {
        this$0.document = null;
        this$0.viewer.getDocument().setText((CharSequence)"");
        this$0.removeWarningNotification();
        return Unit.INSTANCE;
    }

    private static final Unit inUI$lambda$51(ScriptGeneratorUI this$0, Function0 $block) {
        this$0.inWriteAction((Function0<Unit>)$block);
        return Unit.INSTANCE;
    }

    private static final void inWriteAction$lambda$52(Function0 $tmp0) {
        $tmp0.invoke();
    }

    public static final /* synthetic */ ComboBox access$getCategorySelector$p(ScriptGeneratorUI $this) {
        return $this.categorySelector;
    }

    public static final /* synthetic */ Map access$retrieveNativeDefinitionsForElements(ScriptGeneratorUI $this, List elements) {
        return $this.retrieveNativeDefinitionsForElements(elements);
    }

    public static final /* synthetic */ void access$onRegenerationAlarm(ScriptGeneratorUI $this) {
        $this.onRegenerationAlarm();
    }

    static {
        ScriptCategory[] scriptCategoryArray = new ScriptCategory[]{ScriptCategory.CREATE_COMPLETE, ScriptCategory.CREATE_DEFINITION, ScriptCategory.NATIVE_DEFINITION, ScriptCategory.ENABLE_CONSTRAINTS, ScriptCategory.DISABLE_CONSTRAINTS, ScriptCategory.REFRESH, ScriptCategory.RECOMPILE, ScriptCategory.EXECUTE, ScriptCategory.TRUNCATE, ScriptCategory.DROP_COMPLETE};
        implementedCategories = CollectionsKt.listOf((Object[])scriptCategoryArray);
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(ScriptGeneratorUI.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        log = logger2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u001bH\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/script/generator/ui/ScriptGeneratorUI$Companion;", "", "<init>", "()V", "contextKey", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/database/script/generator/ui/ScriptGeneratorUI;", "getContextKey$intellij_database_impl", "()Lcom/intellij/openapi/util/Key;", "modelKey", "Lcom/intellij/database/model/basic/BasicModel;", "getModelKey$intellij_database_impl", "implementedCategories", "", "Lcom/intellij/database/script/generator/ScriptCategory;", "getImplementedCategories", "()Ljava/util/List;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "lastPath", "", "normalLoadingPanelText", "getNormalLoadingPanelText", "()Ljava/lang/String;", "invokeLater", "", "whatToDo", "Lkotlin/Function0;", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<ScriptGeneratorUI> getContextKey$intellij_database_impl() {
            return contextKey;
        }

        @NotNull
        public final Key<BasicModel> getModelKey$intellij_database_impl() {
            return modelKey;
        }

        @NotNull
        public final List<ScriptCategory> getImplementedCategories() {
            return implementedCategories;
        }

        private final String getNormalLoadingPanelText() {
            String string = DatabaseBundle.message("scriptGen.ui.generatingSqlScript", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        private final void invokeLater(Function0<Unit> whatToDo) {
            ApplicationKt.getApplication().invokeLater(() -> Companion.invokeLater$lambda$0(whatToDo), ModalityState.any());
        }

        private static final void invokeLater$lambda$0(Function0 $tmp0) {
            $tmp0.invoke();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B9\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/script/generator/ui/ScriptGeneratorUI$FinalAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "text", "", "description", "icon", "Ljavax/swing/Icon;", "action", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/database/script/generator/ui/ScriptGeneratorUI;Ljava/lang/String;Ljava/lang/String;Ljavax/swing/Icon;Lkotlin/jvm/functions/Function0;)V", "getAction", "()Lkotlin/jvm/functions/Function0;", "actionPerformed", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.database.impl"})
    private final class FinalAction
    extends AnAction {
        @NotNull
        private final Function0<Unit> action;
        final /* synthetic */ ScriptGeneratorUI this$0;

        @NotNull
        public final Function0<Unit> getAction() {
            return this.action;
        }

        public FinalAction(@NlsActions.ActionText @NotNull ScriptGeneratorUI this$0, @NlsActions.ActionDescription @Nullable String text2, @Nullable String description, @NotNull Icon icon, Function0<Unit> action) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            this.this$0 = this$0;
            super(text2, description, icon);
            this.action = action;
        }

        public /* synthetic */ FinalAction(ScriptGeneratorUI scriptGeneratorUI, String string, String string2, Icon icon, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                icon = null;
            }
            this(scriptGeneratorUI, string, string2, icon, (Function0<Unit>)function0);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.action.invoke();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/script/generator/ui/ScriptGeneratorUI$PsiFacadeListener;", "Lcom/intellij/database/psi/DbPsiFacade$Listener;", "<init>", "(Lcom/intellij/database/script/generator/ui/ScriptGeneratorUI;)V", "onChanged", "", "source", "Lcom/intellij/database/psi/DbDataSource;", "intellij.database.impl"})
    private final class PsiFacadeListener
    implements DbPsiFacade.Listener {
        @Override
        public void onChanged(@Nullable DbDataSource source) {
            if (ScriptGeneratorUI.this.selection == null || ScriptGeneratorUI.this.generatedText == null || ScriptGeneratorUI.this.refreshIsInProgress.get()) {
                return;
            }
            ScriptGeneratorUI.this.askGeneration();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/script/generator/ui/ScriptGeneratorUI$Selection;", "", "model", "Lcom/intellij/database/model/basic/BasicModel;", "elements", "", "Lcom/intellij/database/model/basic/BasicElement;", "<init>", "(Lcom/intellij/database/model/basic/BasicModel;Ljava/util/Collection;)V", "getModel", "()Lcom/intellij/database/model/basic/BasicModel;", "getElements", "()Ljava/util/Collection;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.database.impl"})
    private static final class Selection {
        @NotNull
        private final BasicModel model;
        @NotNull
        private final Collection<BasicElement> elements;

        public Selection(@NotNull BasicModel model, @NotNull Collection<? extends BasicElement> elements) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            this.model = model;
            this.elements = elements;
        }

        @NotNull
        public final BasicModel getModel() {
            return this.model;
        }

        @NotNull
        public final Collection<BasicElement> getElements() {
            return this.elements;
        }

        @NotNull
        public final BasicModel component1() {
            return this.model;
        }

        @NotNull
        public final Collection<BasicElement> component2() {
            return this.elements;
        }

        @NotNull
        public final Selection copy(@NotNull BasicModel model, @NotNull Collection<? extends BasicElement> elements) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return new Selection(model, elements);
        }

        public static /* synthetic */ Selection copy$default(Selection selection, BasicModel basicModel, Collection collection, int n, Object object) {
            if ((n & 1) != 0) {
                basicModel = selection.model;
            }
            if ((n & 2) != 0) {
                collection = selection.elements;
            }
            return selection.copy(basicModel, collection);
        }

        @NotNull
        public String toString() {
            return "Selection(model=" + this.model + ", elements=" + this.elements + ")";
        }

        public int hashCode() {
            int result2 = this.model.hashCode();
            result2 = result2 * 31 + ((Object)this.elements).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Selection)) {
                return false;
            }
            Selection selection = (Selection)other;
            if (!Intrinsics.areEqual((Object)this.model, (Object)selection.model)) {
                return false;
            }
            return Intrinsics.areEqual(this.elements, selection.elements);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScriptCategory.values().length];
            try {
                nArray[ScriptCategory.NATIVE_DEFINITION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

