/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.database.util.common.IntArrayBuilder;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.sql.formatter.model.MatrixColumn;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFun;
import com.intellij.sql.formatter.model.SqlParenthesizedListBlock;
import com.intellij.sql.formatter.model.SqlQueryBlock;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0015\n\u0002\b\u0007\u001a2\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0001H\u0000\u001a'\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u0010\u001a3\u0010\u0011\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u0013\u001a0\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a8\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a0\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0001H\u0002\u001a-\u0010\u001e\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u001f\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006 "}, d2={"rowCountLimit", "", "getRowCountLimit", "()I", "alignTheMatrix", "", "header", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$InsertSection;", "matrix", "Lcom/intellij/sql/formatter/model/SqlQueryBlock$ValuesSection;", "percentile", "minWideningThreshold", "breakThreshold", "analyzeTheMatrix", "", "Lcom/intellij/sql/formatter/model/MatrixColumn;", "(Lcom/intellij/sql/formatter/model/SqlQueryBlock$InsertSection;Lcom/intellij/sql/formatter/model/SqlQueryBlock$ValuesSection;)[Lcom/intellij/sql/formatter/model/MatrixColumn;", "computeColumnWidths", "columns", "([Lcom/intellij/sql/formatter/model/MatrixColumn;III)V", "computeColumnWidth", "column", "rowLength", "computeSmart", "longs", "", "shortCnt", "infimum", "computeByPercentile", "computeMax", "arrangeAlignMarkers", "(Lcom/intellij/sql/formatter/model/SqlQueryBlock$InsertSection;Lcom/intellij/sql/formatter/model/SqlQueryBlock$ValuesSection;[Lcom/intellij/sql/formatter/model/MatrixColumn;)V", "intellij.database.sql.core.impl"})
@JvmName(name="SqlInsertMatrixAligner")
@SourceDebugExtension(value={"SMAP\nSqlInsertMatrixAligner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlInsertMatrixAligner.kt\ncom/intellij/sql/formatter/model/SqlInsertMatrixAligner\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 SqlBlock.kt\ncom/intellij/sql/formatter/model/SqlBlock\n*L\n1#1,217:1\n12820#2,3:218\n112#3,4:221\n*S KotlinDebug\n*F\n+ 1 SqlInsertMatrixAligner.kt\ncom/intellij/sql/formatter/model/SqlInsertMatrixAligner\n*L\n102#1:218,3\n209#1:221,4\n*E\n"})
public final class SqlInsertMatrixAligner {
    private static final int getRowCountLimit() {
        return Registry.Companion.intValue("sql.formatter.insert.matrix.limit.rows", 1000);
    }

    public static final void alignTheMatrix(@Nullable SqlQueryBlock.InsertSection header, @NotNull SqlQueryBlock.ValuesSection matrix, int percentile, int minWideningThreshold, int breakThreshold) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        MatrixColumn[] columns = SqlInsertMatrixAligner.analyzeTheMatrix(header, matrix);
        if (columns == null) {
            return;
        }
        SqlInsertMatrixAligner.computeColumnWidths(columns, percentile, minWideningThreshold, breakThreshold);
        SqlInsertMatrixAligner.arrangeAlignMarkers(header, matrix, columns);
    }

    private static final MatrixColumn[] analyzeTheMatrix(SqlQueryBlock.InsertSection header, SqlQueryBlock.ValuesSection matrix) {
        int n;
        int m = matrix.getCountOfRows$intellij_database_sql_core_impl();
        if (m < 2) {
            return null;
        }
        SqlQueryBlock.InsertSection insertSection = header;
        if (insertSection != null) {
            v1 = insertSection.getCountOfFields();
        } else {
            SqlQueryBlock.SqlCortegeLikeParenthesizedListBlock sqlCortegeLikeParenthesizedListBlock = (SqlQueryBlock.SqlCortegeLikeParenthesizedListBlock)matrix.getRows$intellij_database_sql_core_impl().first();
            v1 = n = sqlCortegeLikeParenthesizedListBlock != null ? sqlCortegeLikeParenthesizedListBlock.getCountOfFields() : 0;
        }
        if (n == 0) {
            return null;
        }
        int rowCount = matrix.getCountOfRows$intellij_database_sql_core_impl();
        if (rowCount > SqlInsertMatrixAligner.getRowCountLimit()) {
            return null;
        }
        int n2 = 0;
        int[] nArray = new int[n];
        while (n2 < n) {
            int n3 = n2++;
            nArray[n3] = 1;
        }
        int[] columnInfima = nArray;
        int n4 = 0;
        int[] nArray2 = new int[n];
        while (n4 < n) {
            int n5 = n4++;
            nArray2[n5] = 0;
        }
        int[] columnMinima = nArray2;
        int n6 = 0;
        int[] nArray3 = new int[n];
        while (n6 < n) {
            int n7 = n6++;
            nArray3[n7] = 0;
        }
        int[] columnShortCounts = nArray3;
        int n8 = 0;
        IntArrayBuilder[] intArrayBuilderArray = new IntArrayBuilder[n];
        while (n8 < n) {
            int n9 = n8++;
            intArrayBuilderArray[n9] = IntArrayBuilder.box-impl(IntArrayBuilder.constructor-impl());
        }
        IntArrayBuilder[] columnLongs = intArrayBuilderArray;
        if (header != null) {
            Iterator iterator = ((Iterable)header.getFields()).iterator();
            int n10 = 0;
            while (iterator.hasNext()) {
                int i2 = n10++;
                SqlBlock field = (SqlBlock)iterator.next();
                if (i2 >= n) break;
                int w = field.getTextRange().getLength();
                if (w <= 1) continue;
                columnInfima[i2] = w;
            }
        }
        block5: for (SqlQueryBlock.SqlCortegeLikeParenthesizedListBlock row : matrix.getRows$intellij_database_sql_core_impl()) {
            Iterator iterator = ((Iterable)row.getFields()).iterator();
            int n11 = 0;
            while (iterator.hasNext()) {
                int i3 = n11++;
                SqlBlock field = (SqlBlock)iterator.next();
                if (i3 >= n) continue block5;
                int w = field.getTextRange().getLength();
                columnMinima[i3] = columnMinima[i3] == 0 ? w : Math.min(columnMinima[i3], w);
                if (w >= 2 && w > columnInfima[i3]) {
                    IntArrayBuilder.add-impl(columnLongs[i3].unbox-impl(), w);
                    continue;
                }
                int n12 = columnShortCounts[i3];
                columnShortCounts[i3] = n12 + 1;
            }
        }
        int n13 = 0;
        MatrixColumn[] matrixColumnArray = new MatrixColumn[n];
        while (n13 < n) {
            int n14 = n13++;
            matrixColumnArray[n14] = new MatrixColumn(n14, Math.max(columnInfima[n14], columnMinima[n14]), columnShortCounts[n14], IntArrayBuilder.build-impl(columnLongs[n14].unbox-impl()));
        }
        return matrixColumnArray;
    }

    /*
     * WARNING - void declaration
     */
    private static final void computeColumnWidths(MatrixColumn[] columns, int percentile, int minWideningThreshold, int breakThreshold) {
        void $this$fold$iv;
        void initial$iv;
        MatrixColumn[] matrixColumnArray = columns;
        int n = 0;
        int n2 = 12;
        boolean $i$f$fold = false;
        void accumulator$iv = initial$iv;
        int n3 = ((void)$this$fold$iv).length;
        for (int j = 0; j < n3; ++j) {
            void column2;
            void element$iv;
            void var12_14 = element$iv = $this$fold$iv[j];
            void len = accumulator$iv;
            boolean bl = false;
            accumulator$iv = len + column2.getInfimum() + 2;
        }
        void var16_17 = accumulator$iv;
        int rowLength = n2 + var16_17;
        for (MatrixColumn column3 : columns) {
            int width = SqlInsertMatrixAligner.computeColumnWidth(column3, rowLength, percentile, minWideningThreshold, breakThreshold);
            if (width <= column3.getWidth()) continue;
            column3.setWidth(width);
        }
    }

    private static final int computeColumnWidth(MatrixColumn column2, int rowLength, int percentile, int minWideningThreshold, int breakThreshold) {
        int[] longs = column2.getLongs();
        int m = longs.length;
        if (m == 0) {
            return 0;
        }
        int n = percentile;
        return n == 100 ? SqlInsertMatrixAligner.computeMax(longs, column2.getInfimum()) : ((1 <= n ? n < 100 : false) ? SqlInsertMatrixAligner.computeByPercentile(longs, column2.getShortCnt(), column2.getInfimum(), percentile, breakThreshold) : SqlInsertMatrixAligner.computeSmart(longs, column2.getShortCnt(), column2.getInfimum(), rowLength, minWideningThreshold, breakThreshold));
    }

    private static final int computeSmart(int[] longs, int shortCnt, int infimum, int rowLength, int minWideningThreshold, int breakThreshold) {
        int m = longs.length;
        int n = m + shortCnt;
        ArraysKt.sort((int[])longs);
        int max = ArraysKt.last((int[])longs);
        if (max - infimum <= breakThreshold) {
            return max;
        }
        int curWidth = infimum;
        long curSpace = (long)rowLength * (long)m;
        long curPatch = 0L;
        int bestWidth = curWidth;
        long bestValue = curSpace;
        for (int i2 = 0; i2 < m; ++i2) {
            long curValue;
            int nextWidening;
            int w = longs[i2];
            int widening = w - curWidth;
            long l = curPatch + (long)2;
            curPatch = l + (long)(switch (widening) {
                case 0 -> 2;
                case 1 -> 1;
                default -> 0;
            });
            curSpace = curSpace - (long)rowLength + (long)((w - curWidth) * (n - (m - i2)));
            curWidth = w;
            int n2 = nextWidening = i2 + 1 < m ? longs[i2 + 1] - w : Integer.MAX_VALUE;
            if (nextWidening < minWideningThreshold || (curValue = curSpace - curPatch) >= bestValue || curWidth == bestWidth) continue;
            bestWidth = curWidth;
            bestValue = curValue;
        }
        if (max - bestWidth <= breakThreshold) {
            return max;
        }
        return bestWidth;
    }

    private static final int computeByPercentile(int[] longs, int shortCnt, int infimum, int percentile, int breakThreshold) {
        boolean bl;
        boolean bl2 = 1 <= percentile ? percentile < 100 : (bl = false);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        ArraysKt.sortDescending((int[])longs);
        int max = ArraysKt.first((int[])longs);
        if (max - infimum <= breakThreshold) {
            return max;
        }
        int m = longs.length;
        int n = shortCnt + m;
        int revPercentile = 100 - percentile;
        int k = (n * revPercentile + 99) / 100;
        if (k >= m) {
            return 0;
        }
        int theWidth = longs[k];
        if (max - theWidth <= breakThreshold) {
            return max;
        }
        return theWidth;
    }

    private static final int computeMax(int[] longs, int infimum) {
        return !(longs.length == 0) ? ArraysKt.maxOrThrow((int[])longs) : infimum;
    }

    /*
     * WARNING - void declaration
     */
    private static final void arrangeAlignMarkers(SqlQueryBlock.InsertSection header, SqlQueryBlock.ValuesSection matrix, MatrixColumn[] columns) {
        Wrap wrap = SqlFlowBlock.makeWrap$default(matrix, WrapType.ALWAYS, false, 2, null);
        Wrap noWrap = Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
        Alignment openingAlign = SqlFormattingModelFun.makeLeftAlignmentBS();
        Alignment closingAlign = SqlFormattingModelFun.makeLeftAlignmentBS();
        int n = columns.length;
        for (int i2 = 0; i2 < n; ++i2) {
            columns[i2].setAlignment(SqlFormattingModelFun.makeLeftAlignmentBS());
        }
        if (header != null) {
            SqlBlock sqlBlock;
            SqlBlock sqlBlock2;
            Iterator iterator = ((Iterable)header.getFields()).iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                int i3 = n2++;
                SqlBlock field = (SqlBlock)iterator.next();
                if (i3 >= n) break;
                field.setMyAlign(columns[i3].getAlignment());
            }
            if ((sqlBlock2 = header.getFieldsBlock()) != null && (sqlBlock2 = ((SqlParenthesizedListBlock)sqlBlock2).getOpeningBlock()) != null) {
                sqlBlock2.setMyAlign(openingAlign);
            }
            if ((sqlBlock = header.getFieldsBlock()) != null && (sqlBlock = ((SqlParenthesizedListBlock)sqlBlock).getClosingBlock()) != null) {
                sqlBlock.setMyAlign(closingAlign);
            }
        }
        for (SqlQueryBlock.SqlCortegeLikeParenthesizedListBlock row : matrix.getRows$intellij_database_sql_core_impl()) {
            boolean boom = false;
            Iterator iterator = ((Iterable)row.getFields()).iterator();
            int n3 = 0;
            while (iterator.hasNext()) {
                void indent$iv;
                void this_$iv;
                int i4 = n3++;
                SqlBlock field = (SqlBlock)iterator.next();
                if (i4 >= n) break;
                MatrixColumn column2 = columns[i4];
                Wrap w = boom ? wrap : noWrap;
                SqlBlock sqlBlock = field;
                Indent indent = SqlFormattingFunKt.getNORMAL_INDENT();
                Alignment align$iv = column2.getAlignment();
                boolean $i$f$setAttributes = false;
                this_$iv.setMyWrap(w);
                this_$iv.setMyIndent((Indent)indent$iv);
                this_$iv.setMyAlign(align$iv);
                int width = field.getTextRange().getLength();
                boom = width > column2.getWidth();
            }
            SqlBlock sqlBlock = row.getOpeningBlock();
            if (sqlBlock != null) {
                sqlBlock.setMyAlign(openingAlign);
            }
            SqlBlock sqlBlock3 = row.getClosingBlock();
            if (sqlBlock3 == null) continue;
            sqlBlock3.setMyAlign(closingAlign);
        }
    }
}

