/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.Dbms;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.psi.SqlBooleanLiteralExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlSpecialLiteralExpression;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.util.SqlTokenRegistry;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0016\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0016\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0016\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0016\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0016\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0016\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0016\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0016\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0016\u0010\u0019\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0016\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0016\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0016\u0010\u001c\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0016\u0010\u001d\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0016\u0010\u001e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020!\u001a\u000e\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020!\u001a\u000e\u0010$\u001a\u00020\n2\u0006\u0010#\u001a\u00020!\u001a\u000e\u0010%\u001a\u00020\n2\u0006\u0010#\u001a\u00020!\u001a\u000e\u0010&\u001a\u00020\n2\u0006\u0010#\u001a\u00020!\"\u0016\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0016\u0010\u0005\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0004\"\u0016\u0010\u0007\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0004\u00a8\u0006'"}, d2={"SQL_DIV", "Lcom/intellij/sql/psi/SqlTokenType;", "Lorg/jetbrains/annotations/NotNull;", "getSQL_DIV", "()Lcom/intellij/sql/psi/SqlTokenType;", "SQL_MOD", "getSQL_MOD", "SQL_XOR", "getSQL_XOR", "isBooleanOperation", "", "sign", "Lcom/intellij/psi/tree/IElementType;", "dbms", "Lcom/intellij/database/Dbms;", "isBitwiseOperation", "isLogicalNot", "isBitwiseNot", "isLogicalAnd", "isLogicalOr", "isLogicalXor", "isBitwiseAnd", "isBitwiseOr", "isStringConcat", "isBitwiseXor", "isNotEq", "isEq", "isMod", "isIntDiv", "isBitwiseLeftShift", "isBitwiseRightShift", "isNegateOperation", "opElement", "Lcom/intellij/psi/PsiElement;", "isUnknown", "element", "isNull", "isTrue", "isFalse", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlPsiUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlPsiUtil.kt\ncom/intellij/sql/psi/impl/SqlPsiUtilKt\n+ 2 SqlUtilFun.kt\ncom/intellij/sql/SqlUtilFun\n*L\n1#1,124:1\n275#2:125\n*S KotlinDebug\n*F\n+ 1 SqlPsiUtil.kt\ncom/intellij/sql/psi/impl/SqlPsiUtilKt\n*L\n109#1:125\n*E\n"})
public final class SqlPsiUtilKt {
    @NotNull
    private static final SqlTokenType SQL_DIV;
    @NotNull
    private static final SqlTokenType SQL_MOD;
    @NotNull
    private static final SqlTokenType SQL_XOR;

    @NotNull
    public static final SqlTokenType getSQL_DIV() {
        return SQL_DIV;
    }

    @NotNull
    public static final SqlTokenType getSQL_MOD() {
        return SQL_MOD;
    }

    @NotNull
    public static final SqlTokenType getSQL_XOR() {
        return SQL_XOR;
    }

    public static final boolean isBooleanOperation(@NotNull IElementType sign, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        return sign == SqlCommonTokens.SQL_OP_EQ || sign == SqlCommonTokens.SQL_OP_NEQ || sign == SqlCommonTokens.SQL_OP_NEQ2 || sign == SqlCommonTokens.SQL_OP_GT || sign == SqlCommonTokens.SQL_OP_LT || sign == SqlCommonTokens.SQL_OP_GE || sign == SqlCommonTokens.SQL_OP_LE || sign == SqlCommonTokens.SQL_OP_NOT_LT || sign == SqlCommonTokens.SQL_OP_NOT_GT && dbms.isMicrosoft() || sign == SqlCommonTokens.SQL_OP_NULLSAFE_EQ && dbms.isMysql() || sign == SqlCommonKeywords.SQL_LIKE || sign == SqlCommonKeywords.SQL_IS || sign == SqlCommonKeywords.SQL_IN || sign == SqlCommonKeywords.SQL_BETWEEN;
    }

    public static final boolean isBitwiseOperation(@NotNull IElementType sign, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        return SqlPsiUtilKt.isBitwiseAnd(sign, dbms) || SqlPsiUtilKt.isBitwiseOr(sign, dbms) || SqlPsiUtilKt.isBitwiseXor(sign, dbms) || SqlPsiUtilKt.isBitwiseLeftShift(sign, dbms) || SqlPsiUtilKt.isBitwiseRightShift(sign, dbms);
    }

    public static final boolean isLogicalNot(@NotNull IElementType sign, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        IElementType iElementType = sign;
        return Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonKeywords.SQL_NOT) ? true : (Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_OP_NOT2) ? dbms.isMysql() : false);
    }

    public static final boolean isBitwiseNot(@NotNull IElementType sign, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        return Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_BITWISE_NOT) ? dbms.isMysql() || dbms.isPostgres() : false;
    }

    public static final boolean isLogicalAnd(@NotNull IElementType sign) {
        Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
        return Intrinsics.areEqual((Object)sign, (Object)SqlCommonKeywords.SQL_AND);
    }

    public static final boolean isLogicalOr(@NotNull IElementType sign) {
        Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
        return Intrinsics.areEqual((Object)sign, (Object)SqlCommonKeywords.SQL_OR);
    }

    public static final boolean isLogicalXor(@NotNull IElementType sign, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        return Intrinsics.areEqual((Object)sign, (Object)SQL_XOR) ? dbms.isMysql() : false;
    }

    public static final boolean isBitwiseAnd(@NotNull IElementType sign, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        return Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_BITWISE_AND) ? dbms.isPostgres() || dbms.isMysql() || dbms.isMicrosoft() : false;
    }

    public static final boolean isBitwiseOr(@NotNull IElementType sign, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        return Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_BITWISE_OR) ? dbms.isPostgres() || dbms.isMysql() || dbms.isMicrosoft() : false;
    }

    public static final boolean isStringConcat(@NotNull IElementType sign, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        IElementType iElementType = sign;
        return Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_OP_PLUS) ? dbms.isMicrosoft() : (Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_OP_CONCAT) ? dbms.isPostgres() : false);
    }

    public static final boolean isBitwiseXor(@NotNull IElementType sign, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        IElementType iElementType = sign;
        return Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.PG_OP_BITWISE_XOR) ? dbms.isPostgres() : (Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_OP_BITWISE_XOR) ? dbms.isMysql() || dbms.isMicrosoft() : false);
    }

    public static final boolean isNotEq(@NotNull IElementType sign, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        IElementType iElementType = sign;
        return Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_OP_NEQ) || Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_OP_NEQ2) ? dbms.isPostgres() || dbms.isMysql() || dbms.isMicrosoft() : false;
    }

    public static final boolean isEq(@NotNull IElementType sign, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        IElementType iElementType = sign;
        return Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_OP_EQ) ? dbms.isPostgres() || dbms.isMysql() || dbms.isMicrosoft() : (Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_OP_NULLSAFE_EQ) ? dbms.isMysql() : false);
    }

    public static final boolean isMod(@NotNull IElementType sign, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        IElementType iElementType = sign;
        return Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_OP_MODULO) ? true : (Intrinsics.areEqual((Object)iElementType, (Object)SQL_MOD) ? dbms.isMysql() : false);
    }

    public static final boolean isIntDiv(@NotNull IElementType sign, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        return Intrinsics.areEqual((Object)sign, (Object)SQL_DIV) ? dbms.isMysql() : false;
    }

    public static final boolean isBitwiseLeftShift(@NotNull IElementType sign, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        return Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_LEFT_SHIFT) ? dbms.isPostgres() || dbms.isMysql() : false;
    }

    public static final boolean isBitwiseRightShift(@NotNull IElementType sign, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        return Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_RIGHT_SHIFT) ? dbms.isPostgres() || dbms.isMysql() : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isNegateOperation(@NotNull PsiElement opElement) {
        Intrinsics.checkNotNullParameter((Object)opElement, (String)"opElement");
        if (!(PsiTreeUtilKt.getElementType((PsiElement)opElement) instanceof SqlCompositeElementType)) return false;
        PsiElement[] psiElementArray = opElement.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        if (!SequencesKt.contains((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])psiElementArray), SqlPsiUtilKt::isNegateOperation$lambda$0), (Object)SqlCommonKeywords.SQL_NOT)) return false;
        return true;
    }

    public static final boolean isUnknown(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof SqlCompositeElement) {
            PsiElement $this$child$iv = element;
            boolean $i$f$child = false;
            return Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)PsiTreeUtil.findChildOfType((PsiElement)$this$child$iv, PsiElement.class)), (Object)SqlCommonKeywords.SQL_UNKNOWN);
        }
        return Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)element), (Object)SqlCommonKeywords.SQL_UNKNOWN);
    }

    public static final boolean isNull(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof SqlSpecialLiteralExpression && ((SqlSpecialLiteralExpression)element).isNull();
    }

    public static final boolean isTrue(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof SqlBooleanLiteralExpression && ((SqlBooleanLiteralExpression)element).isTrue();
    }

    public static final boolean isFalse(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof SqlBooleanLiteralExpression && ((SqlBooleanLiteralExpression)element).isFalse();
    }

    private static final IElementType isNegateOperation$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return PsiTreeUtilKt.getElementType((PsiElement)it);
    }

    static {
        SqlTokenType sqlTokenType = SqlTokenRegistry.getType((String)"DIV");
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"getType(...)");
        SQL_DIV = sqlTokenType;
        SqlTokenType sqlTokenType2 = SqlTokenRegistry.getType((String)"MOD");
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"getType(...)");
        SQL_MOD = sqlTokenType2;
        SqlTokenType sqlTokenType3 = SqlTokenRegistry.getType((String)"XOR");
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType3, (String)"getType(...)");
        SQL_XOR = sqlTokenType3;
    }
}

