/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.mime;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.microservices.MicroservicesBundle;
import com.intellij.microservices.mime.MimeTypePsiElement;
import com.intellij.microservices.mime.MimeTypes;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0014B#\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\n\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0002H\u0016J\u0013\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016\u00a2\u0006\u0002\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/microservices/mime/MimeTypeReference;", "Lcom/intellij/psi/PsiReferenceBase;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/codeInsight/daemon/EmptyResolveMessageProvider;", "element", "range", "Lcom/intellij/openapi/util/TextRange;", "isInjected", "", "MimeTypeReference", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;Z)V", "()Z", "resolve", "getUnresolvedMessagePattern", "", "isReferenceTo", "getVariants", "", "", "()[Ljava/lang/Object;", "Companion", "intellij.microservices"})
@SourceDebugExtension(value={"SMAP\nMimeTypeReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MimeTypeReference.kt\ncom/intellij/microservices/mime/MimeTypeReference\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,60:1\n11165#2:61\n11500#2,3:62\n*S KotlinDebug\n*F\n+ 1 MimeTypeReference.kt\ncom/intellij/microservices/mime/MimeTypeReference\n*L\n34#1:61\n34#1:62,3\n*E\n"})
public final class MimeTypeReference
extends PsiReferenceBase<PsiElement>
implements EmptyResolveMessageProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isInjected;

    @JvmOverloads
    public MimeTypeReference(@NotNull PsiElement element, @NotNull TextRange range, boolean isInjected) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        super(element, range);
        this.isInjected = isInjected;
    }

    public /* synthetic */ MimeTypeReference(PsiElement psiElement, TextRange textRange, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            bl2 = false;
        }
        this(psiElement, textRange, bl2);
    }

    public final boolean isInjected() {
        return this.isInjected;
    }

    @Nullable
    public PsiElement resolve() {
        String string = this.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        String string2 = string;
        if (!MimeTypes.MIME_PATTERN.matcher(string2).matches()) {
            return null;
        }
        PsiElement psiElement = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        return (PsiElement)new MimeTypePsiElement(psiElement, string2);
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        return MicroservicesBundle.message("mime.type.element.error", new Object[0]);
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof MimeTypePsiElement && Intrinsics.areEqual((Object)((MimeTypePsiElement)element).getName(), (Object)this.getValue());
    }

    @NotNull
    public Object[] getVariants() {
        Intrinsics.checkNotNullExpressionValue((Object)MimeTypes.PREDEFINED_MIME_VARIANTS, (String)"PREDEFINED_MIME_VARIANTS");
        Object[] objectArray = MimeTypes.PREDEFINED_MIME_VARIANTS;
        boolean bl2 = false;
        Object[] objectArray2 = objectArray;
        Collection collection = new ArrayList(objectArray.length);
        boolean bl3 = false;
        for (Object object : objectArray2) {
            String string = (String)object;
            Collection collection2 = collection;
            boolean bl4 = false;
            collection2.add(LookupElementBuilder.create((String)string).withIcon(AllIcons.Nodes.Type));
        }
        Object[] objectArray3 = ArrayUtil.toObjectArray((Collection)((List)collection));
        Intrinsics.checkNotNullExpressionValue((Object)objectArray3, (String)"toObjectArray(...)");
        return objectArray3;
    }

    @JvmOverloads
    public MimeTypeReference(@NotNull PsiElement element, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this(element, range, false, 4, null);
    }

    @JvmStatic
    @NotNull
    public static final PsiReference[] forElement(@NotNull PsiElement injectionHost) {
        return Companion.forElement(injectionHost);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PsiReference[] forElement(@NotNull PsiElement injectionHost, @NotNull TextRange range, boolean isInjected) {
        return Companion.forElement(injectionHost, range, isInjected);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PsiReference[] forElement(@NotNull PsiElement injectionHost, @NotNull TextRange range) {
        return Companion.forElement(injectionHost, range);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a2\u0006\u0002\u0010\tJ-\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/microservices/mime/MimeTypeReference$Companion;", "", "MimeTypeReference$Companion", "()V", "forElement", "", "Lcom/intellij/psi/PsiReference;", "injectionHost", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiReference;", "range", "Lcom/intellij/openapi/util/TextRange;", "isInjected", "", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;Z)[Lcom/intellij/psi/PsiReference;", "intellij.microservices"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PsiReference[] forElement(@NotNull PsiElement injectionHost) {
            Intrinsics.checkNotNullParameter((Object)injectionHost, (String)"injectionHost");
            TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)injectionHost);
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getValueTextRange(...)");
            return com.intellij.microservices.mime.MimeTypeReference$Companion.forElement$default(this, injectionHost, textRange, false, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PsiReference[] forElement(@NotNull PsiElement injectionHost, @NotNull TextRange range, boolean isInjected) {
            Intrinsics.checkNotNullParameter((Object)injectionHost, (String)"injectionHost");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            String string = ElementManipulators.getValueText((PsiElement)injectionHost);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValueText(...)");
            String string2 = string;
            List list = StringUtil.split((String)string2, (String)";");
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"split(...)");
            List list2 = list;
            if (list2.size() > 0) {
                String string3 = (String)list2.get(0);
                TextRange textRange = new TextRange(range.getStartOffset(), range.getStartOffset() + string3.length());
                PsiReference[] psiReferenceArray = new PsiReference[]{new MimeTypeReference(injectionHost, textRange, isInjected)};
                return psiReferenceArray;
            }
            PsiReference[] psiReferenceArray = new PsiReference[]{new MimeTypeReference(injectionHost, range, isInjected)};
            return psiReferenceArray;
        }

        public static /* synthetic */ PsiReference[] forElement$default(Companion companion, PsiElement psiElement, TextRange textRange, boolean bl2, int n2, Object object) {
            if ((n2 & 4) != 0) {
                bl2 = false;
            }
            return companion.forElement(psiElement, textRange, bl2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PsiReference[] forElement(@NotNull PsiElement injectionHost, @NotNull TextRange range) {
            Intrinsics.checkNotNullParameter((Object)injectionHost, (String)"injectionHost");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            return com.intellij.microservices.mime.MimeTypeReference$Companion.forElement$default(this, injectionHost, range, false, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

