/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.url;

import com.intellij.openapi.util.TextRange;
import com.intellij.util.text.PlaceholderTextRanges;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.AbstractList;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J \u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00110\u00150\u00142\u0006\u0010\u0012\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/microservices/url/UrlSpecialSegmentMarker;", "", "prefix", "", "suffix", "pattern", "Ljava/util/regex/Pattern;", "UrlSpecialSegmentMarker", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/regex/Pattern;)V", "getPrefix", "()Ljava/lang/String;", "getSuffix", "matches", "", "segment", "", "z", "Lcom/intellij/microservices/url/UrlSpecialSegmentMarker$ExtractionInfo;", "segmentStr", "extractAll", "", "Lkotlin/Pair;", "Lcom/intellij/openapi/util/TextRange;", "ExtractionInfo", "intellij.microservices"})
@SourceDebugExtension(value={"SMAP\nUrlPathModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlPathModel.kt\ncom/intellij/microservices/url/UrlSpecialSegmentMarker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,337:1\n1611#2,9:338\n1863#2:347\n1864#2:350\n1620#2:351\n1#3:348\n1#3:349\n*S KotlinDebug\n*F\n+ 1 UrlPathModel.kt\ncom/intellij/microservices/url/UrlSpecialSegmentMarker\n*L\n302#1:338,9\n302#1:347\n302#1:350\n302#1:351\n302#1:349\n*E\n"})
public final class UrlSpecialSegmentMarker {
    @NotNull
    private final String prefix;
    @NotNull
    private final String suffix;
    @Nullable
    private final Pattern pattern;

    @JvmOverloads
    public UrlSpecialSegmentMarker(@NotNull String prefix, @NotNull String suffix, @Nullable Pattern pattern) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        this.prefix = prefix;
        this.suffix = suffix;
        this.pattern = pattern;
    }

    public /* synthetic */ UrlSpecialSegmentMarker(String string, String string2, Pattern pattern, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            pattern = null;
        }
        this(string, string2, pattern);
    }

    @NotNull
    public final String getPrefix() {
        return this.prefix;
    }

    @NotNull
    public final String getSuffix() {
        return this.suffix;
    }

    public final boolean matches(@NotNull CharSequence segment) {
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        return StringsKt.startsWith$default((CharSequence)segment, (CharSequence)this.prefix, (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)segment, (CharSequence)this.suffix, (boolean)false, (int)2, null);
    }

    private final ExtractionInfo z(CharSequence charSequence) {
        if (!this.matches(charSequence)) {
            return null;
        }
        String string = ((Object)charSequence.subSequence(this.prefix.length(), charSequence.length() - this.suffix.length())).toString();
        if (this.pattern != null) {
            Matcher matcher = this.pattern.matcher(string);
            if (matcher.find()) {
                String string2 = matcher.group(1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
                return new ExtractionInfo(string2, matcher);
            }
            return null;
        }
        return new ExtractionInfo(string, null);
    }

    @NotNull
    public final List<Pair<TextRange, ExtractionInfo>> extractAll(@NotNull CharSequence segmentStr) {
        Intrinsics.checkNotNullParameter((Object)segmentStr, (String)"segmentStr");
        Set set = PlaceholderTextRanges.getPlaceholderRanges((String)((Object)segmentStr).toString(), (String)this.prefix, (String)this.suffix, (boolean)true, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getPlaceholderRanges(...)");
        Iterable iterable = set;
        boolean bl2 = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl3 = false;
        Iterable iterable3 = iterable2;
        boolean bl4 = false;
        Iterator iterator = iterable3.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object t10;
            Object t11 = t10 = iterator.next();
            boolean bl5 = false;
            TextRange textRange = (TextRange)t11;
            boolean bl6 = false;
            CharSequence charSequence = textRange.subSequence(segmentStr);
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"subSequence(...)");
            if (this.z(charSequence) != null) {
                ExtractionInfo extractionInfo;
                boolean bl7 = false;
                pair = TuplesKt.to((Object)textRange, (Object)extractionInfo);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair pair2 = pair;
            boolean bl8 = false;
            collection.add(pair2);
        }
        return (List)collection;
    }

    @JvmOverloads
    public UrlSpecialSegmentMarker(@NotNull String prefix, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        this(prefix, suffix, null, 4, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u00c2\u0003J\u001f\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/intellij/microservices/url/UrlSpecialSegmentMarker$ExtractionInfo;", "", "value", "", "matcher", "Ljava/util/regex/Matcher;", "UrlSpecialSegmentMarker$ExtractionInfo", "(Ljava/lang/String;Ljava/util/regex/Matcher;)V", "getValue", "()Ljava/lang/String;", "regexGroups", "", "getRegexGroups", "()Ljava/util/List;", "component1", "z", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.microservices"})
    public static final class ExtractionInfo {
        @NotNull
        private final String value;
        @Nullable
        private final Matcher matcher;
        @NotNull
        private final List<String> regexGroups;

        public ExtractionInfo(@NotNull String value, @Nullable Matcher matcher) {
            List list;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.value = value;
            this.matcher = matcher;
            ExtractionInfo extractionInfo = this;
            Matcher matcher2 = this.matcher;
            if (matcher2 != null) {
                Matcher matcher3 = matcher2;
                ExtractionInfo extractionInfo2 = extractionInfo;
                boolean bl2 = false;
                extractionInfo = extractionInfo2;
                list = (List)new AbstractList<String>(matcher3){
                    final /* synthetic */ Matcher $m;
                    {
                        this.$m = $m;
                    }

                    public int getSize() {
                        return this.$m.groupCount() + 1;
                    }

                    public String get(int index) {
                        return this.$m.group(index);
                    }
                };
            } else {
                list = CollectionsKt.emptyList();
            }
            extractionInfo.regexGroups = list;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public final List<String> getRegexGroups() {
            return this.regexGroups;
        }

        @NotNull
        public final String component1() {
            return this.value;
        }

        private final Matcher z() {
            return this.matcher;
        }

        @NotNull
        public final ExtractionInfo copy(@NotNull String value, @Nullable Matcher matcher) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new ExtractionInfo(value, matcher);
        }

        public static /* synthetic */ ExtractionInfo copy$default(ExtractionInfo extractionInfo, String string, Matcher matcher, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = extractionInfo.value;
            }
            if ((n2 & 2) != 0) {
                matcher = extractionInfo.matcher;
            }
            return extractionInfo.copy(string, matcher);
        }

        @NotNull
        public String toString() {
            return "ExtractionInfo(value=" + this.value + ", matcher=" + this.matcher + ")";
        }

        public int hashCode() {
            int n2 = this.value.hashCode();
            n2 = n2 * 31 + (this.matcher == null ? 0 : this.matcher.hashCode());
            return n2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExtractionInfo)) {
                return false;
            }
            ExtractionInfo extractionInfo = (ExtractionInfo)other;
            if (!Intrinsics.areEqual((Object)this.value, (Object)extractionInfo.value)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.matcher, (Object)extractionInfo.matcher);
        }
    }
}

