/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.url.inlay;

import com.intellij.codeInsight.daemon.impl.InlayHintsPassFactoryInternal;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.Language;
import com.intellij.microservices.MicroservicesBundle;
import com.intellij.microservices.url.inlay.UrlPathInlayHint;
import com.intellij.microservices.url.inlay.UrlPathInlayHintsProvider;
import com.intellij.microservices.url.inlay.UrlPathInlayHintsProviderFactory;
import com.intellij.microservices.url.inlay.UrlPathInlayHintsProviderSemElement;
import com.intellij.microservices.url.inlay.UrlPathInlayLanguagesProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.semantic.SemService;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\"\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J#\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0002J \u0010\u0011\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002\u001b\u001c\u00a8\u0006\u001d"}, d2={"Lcom/intellij/microservices/url/inlay/UrlPathInlaySettingsIntention;", "Lcom/intellij/codeInsight/intention/PsiElementBaseIntentionAction;", "shouldBeEnabled", "", "UrlPathInlaySettingsIntention", "(Z)V", "getText", "", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "z", "language", "Lcom/intellij/lang/Language;", "getElementToMakeWritable", "currentFile", "Lcom/intellij/psi/PsiFile;", "getFileModifierForPreview", "Lcom/intellij/codeInsight/intention/FileModifier;", "target", "Companion", "Lcom/intellij/microservices/url/inlay/UrlPathInlayHintsDisableIntention;", "Lcom/intellij/microservices/url/inlay/UrlPathInlayHintsEnableIntention;", "intellij.microservices"})
public abstract class UrlPathInlaySettingsIntention
extends PsiElementBaseIntentionAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean shouldBeEnabled;

    private UrlPathInlaySettingsIntention(boolean shouldBeEnabled) {
        this.shouldBeEnabled = shouldBeEnabled;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFamilyName(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (editor == null) {
            return false;
        }
        Language language = element.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        if (UrlPathInlayHintsProvider.Companion.isUrlPathInlaysEnabledForLanguage$intellij_microservices(language) == this.shouldBeEnabled) {
            return false;
        }
        return com.intellij.microservices.url.inlay.UrlPathInlaySettingsIntention$Companion.shouldHaveUrlPathInlayAroundOffset$intellij_microservices$default(Companion, element, editor.getCaretModel().getOffset(), 0, 4, null);
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Language language = element.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        UrlPathInlayHintsProvider.Companion.setUrlPathInlaysEnabledForLanguage$intellij_microservices(language, this.shouldBeEnabled);
        InlayHintsPassFactoryInternal.Companion.restartDaemonUpdatingHints(project);
        ApplicationManager.getApplication().invokeLater(() -> UrlPathInlaySettingsIntention.z(this, project, editor, element), ModalityState.nonModal(), project.getDisposed());
    }

    private final void z(Project project, Editor editor, Language language) {
        Object[] objectArray = new Object[]{this.shouldBeEnabled ? 0 : 1};
        HtmlBuilder htmlBuilder = new HtmlBuilder().append(MicroservicesBundle.message("microservices.inlay.settings.inlays.intention.hint.message", objectArray)).appendLink("link", MicroservicesBundle.message("microservices.inlay.settings.inlays.intention.hint.link", new Object[0]));
        HintManager.getInstance().showInformationHint(editor, htmlBuilder.toString(), arg_0 -> UrlPathInlaySettingsIntention.z(project, language, arg_0));
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        Intrinsics.checkNotNullParameter((Object)currentFile, (String)"currentFile");
        return null;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return null;
    }

    private static final void z(UrlPathInlaySettingsIntention urlPathInlaySettingsIntention, Project project, Editor editor, PsiElement psiElement) {
        Editor editor2 = editor;
        Intrinsics.checkNotNull((Object)editor2);
        Language language = psiElement.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        urlPathInlaySettingsIntention.z(project, editor2, language);
    }

    private static final void z(Project project, Language language, HyperlinkEvent hyperlinkEvent) {
        if (!Intrinsics.areEqual((Object)hyperlinkEvent.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            return;
        }
        UrlPathInlayHintsProvider.Companion.openUrlPathInlaySettings$intellij_microservices(project, language);
    }

    public /* synthetic */ UrlPathInlaySettingsIntention(boolean shouldBeEnabled, DefaultConstructorMarker $constructor_marker) {
        this(shouldBeEnabled);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/microservices/url/inlay/UrlPathInlaySettingsIntention$Companion;", "", "UrlPathInlaySettingsIntention$Companion", "()V", "shouldHaveUrlPathInlayAroundOffset", "", "element", "Lcom/intellij/psi/PsiElement;", "offset", "", "searchLimit", "shouldHaveUrlPathInlayAroundOffset$intellij_microservices", "intellij.microservices"})
    @SourceDebugExtension(value={"SMAP\nUrlPathInlaySettingsIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlPathInlaySettingsIntention.kt\ncom/intellij/microservices/url/inlay/UrlPathInlaySettingsIntention$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1251#2,2:83\n1#3:85\n*S KotlinDebug\n*F\n+ 1 UrlPathInlaySettingsIntention.kt\ncom/intellij/microservices/url/inlay/UrlPathInlaySettingsIntention$Companion\n*L\n79#1:83,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean shouldHaveUrlPathInlayAroundOffset$intellij_microservices(@NotNull PsiElement element, int offset, int searchLimit) {
            boolean bl2;
            block2: {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Language language = element.getLanguage();
                Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
                UrlPathInlayLanguagesProvider urlPathInlayLanguagesProvider = UrlPathInlayHintsProviderFactory.Companion.getLanguagesProviderByLanguage$intellij_microservices(language);
                if (urlPathInlayLanguagesProvider == null) {
                    return false;
                }
                UrlPathInlayLanguagesProvider urlPathInlayLanguagesProvider2 = urlPathInlayLanguagesProvider;
                SemService semService = SemService.getSemService((Project)element.getProject());
                Sequence sequence = SequencesKt.mapNotNull((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.take((Sequence)SequencesKt.generateSequence((Object)element, Companion::z), (int)searchLimit), arg_0 -> Companion.z(urlPathInlayLanguagesProvider2, semService, arg_0)), Companion::z), Companion::z);
                boolean bl3 = false;
                for (Object e2 : sequence) {
                    PsiElement psiElement = (PsiElement)e2;
                    boolean bl4 = false;
                    if (!psiElement.getTextRange().grown(1).contains(offset)) continue;
                    bl2 = true;
                    break block2;
                }
                bl2 = false;
            }
            return bl2;
        }

        public static /* synthetic */ boolean shouldHaveUrlPathInlayAroundOffset$intellij_microservices$default(Companion companion, PsiElement psiElement, int n2, int n3, int n4, Object object) {
            if ((n4 & 4) != 0) {
                n3 = Integer.MAX_VALUE;
            }
            return companion.shouldHaveUrlPathInlayAroundOffset$intellij_microservices(psiElement, n2, n3);
        }

        private static final PsiElement z(PsiElement psiElement) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"it");
            PsiElement psiElement2 = psiElement.getParent();
            if (psiElement2 != null) {
                PsiElement psiElement3;
                PsiElement psiElement4 = psiElement3 = psiElement2;
                boolean bl2 = false;
                object = !(psiElement4 instanceof PsiFile) ? psiElement3 : null;
            } else {
                object = null;
            }
            return object;
        }

        private static final Sequence z(UrlPathInlayLanguagesProvider urlPathInlayLanguagesProvider, SemService semService, PsiElement psiElement) {
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"it");
            Intrinsics.checkNotNull((Object)semService);
            return UrlPathInlayHintsProvider.Companion.inlaysInElement$intellij_microservices(urlPathInlayLanguagesProvider, psiElement, semService);
        }

        private static final Iterable z(UrlPathInlayHintsProviderSemElement urlPathInlayHintsProviderSemElement) {
            Intrinsics.checkNotNullParameter((Object)urlPathInlayHintsProviderSemElement, (String)"it");
            return urlPathInlayHintsProviderSemElement.getInlayHints();
        }

        private static final PsiElement z(UrlPathInlayHint urlPathInlayHint) {
            Intrinsics.checkNotNullParameter((Object)urlPathInlayHint, (String)"it");
            SmartPsiElementPointer<PsiElement> smartPsiElementPointer = urlPathInlayHint.getAttachedTo();
            return smartPsiElementPointer != null ? smartPsiElementPointer.getElement() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

