/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.url.parameters;

import com.intellij.ide.presentation.Presentation;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.microservices.MicroservicesBundle;
import com.intellij.microservices.url.UrlConversionConstants;
import com.intellij.microservices.url.references.PathVariablePresentationProvider;
import com.intellij.microservices.utils.CommonFakeNavigatablePomTarget;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathVariablePsiElement
extends CommonFakeNavigatablePomTarget {
    private final Pattern myNameValidationPattern;
    private final PathVariablePomTarget myVariablePomTarget;
    private final boolean myForceFindUsages;

    private PathVariablePsiElement(@NotNull PathVariablePomTarget pomTarget, @NotNull Pattern nameValidationPattern, boolean forceFindUsages) {
        if (pomTarget == null) {
            PathVariablePsiElement.z(0);
        }
        if (nameValidationPattern == null) {
            PathVariablePsiElement.z(1);
        }
        super(pomTarget.myScope.getProject(), pomTarget);
        this.myVariablePomTarget = pomTarget;
        this.myNameValidationPattern = nameValidationPattern;
        this.myForceFindUsages = forceFindUsages;
    }

    private PathVariablePsiElement(@NotNull String name, @NotNull PsiElement scope, @NotNull TextRange textRange, @NotNull Pattern nameValidationPattern, @NotNull SemDefinitionProvider semDefinitionProvider) {
        if (name == null) {
            PathVariablePsiElement.z(2);
        }
        if (scope == null) {
            PathVariablePsiElement.z(3);
        }
        if (textRange == null) {
            PathVariablePsiElement.z(4);
        }
        if (nameValidationPattern == null) {
            PathVariablePsiElement.z(5);
        }
        if (semDefinitionProvider == null) {
            PathVariablePsiElement.z(6);
        }
        this(new PathVariablePomTarget(name, scope, textRange, semDefinitionProvider), nameValidationPattern, true);
    }

    public static PathVariablePsiElement create(@NotNull String varName, @NotNull PsiElement scope, @NotNull TextRange textRange, @NotNull SemDefinitionProvider semDefinitionProvider) {
        if (varName == null) {
            PathVariablePsiElement.z(7);
        }
        if (scope == null) {
            PathVariablePsiElement.z(8);
        }
        if (textRange == null) {
            PathVariablePsiElement.z(9);
        }
        if (semDefinitionProvider == null) {
            PathVariablePsiElement.z(10);
        }
        return new PathVariablePsiElement(varName, scope, textRange, UrlConversionConstants.STANDARD_PATH_VARIABLE_NAME_PATTERN, semDefinitionProvider);
    }

    public static PathVariablePsiElement create(@NotNull String varName, @NotNull PsiElement scope, @NotNull SemDefinitionProvider semDefinitionProvider) {
        if (varName == null) {
            PathVariablePsiElement.z(11);
        }
        if (scope == null) {
            PathVariablePsiElement.z(12);
        }
        if (semDefinitionProvider == null) {
            PathVariablePsiElement.z(13);
        }
        return PathVariablePsiElement.create(varName, scope, ElementManipulators.getValueTextRange((PsiElement)scope), semDefinitionProvider);
    }

    public static PathVariablePsiElement create(@NotNull String varName, @NotNull PsiElement scope, @NotNull TextRange textRange, @NotNull Pattern nameValidationPattern, @NotNull SemDefinitionProvider semDefinitionProvider) {
        if (varName == null) {
            PathVariablePsiElement.z(14);
        }
        if (scope == null) {
            PathVariablePsiElement.z(15);
        }
        if (textRange == null) {
            PathVariablePsiElement.z(16);
        }
        if (nameValidationPattern == null) {
            PathVariablePsiElement.z(17);
        }
        if (semDefinitionProvider == null) {
            PathVariablePsiElement.z(18);
        }
        return new PathVariablePsiElement(varName, scope, textRange, nameValidationPattern, semDefinitionProvider);
    }

    @Nullable
    public static PathVariablePsiElement merge(@NotNull List<PathVariablePsiElement> elements) {
        if (elements == null) {
            PathVariablePsiElement.z(19);
        }
        if (elements.isEmpty()) {
            return null;
        }
        if (elements.size() == 1) {
            return elements.get(0);
        }
        return new MultiplePomTarget(elements.stream().map(pathVariablePsiElement -> pathVariablePsiElement.getVariablePomTarget()).collect(Collectors.toSet()));
    }

    public PathVariablePomTarget getVariablePomTarget() {
        return this.myVariablePomTarget;
    }

    @NotNull
    public String getName() {
        String string = this.myVariablePomTarget.getName();
        if (string == null) {
            PathVariablePsiElement.z(20);
        }
        return string;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myVariablePomTarget.myTextRange;
        if (textRange == null) {
            PathVariablePsiElement.z(21);
        }
        return textRange;
    }

    @NotNull
    public PathVariablePsiElement navigatingToDeclaration() {
        return new PathVariablePsiElement(this.myVariablePomTarget, this.myNameValidationPattern, false);
    }

    @Override
    public void navigate(boolean requestFocus) {
        if (this.myForceFindUsages) {
            super.navigate(requestFocus);
            return;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)this.myVariablePomTarget.myScope);
        if (virtualFile == null) {
            return;
        }
        PsiNavigationSupport.getInstance().createNavigatable(this.getProject(), virtualFile, this.getTextOffset()).navigate(requestFocus);
    }

    @Nullable
    public PsiElement getParent() {
        return this.myVariablePomTarget.myScope;
    }

    @NotNull
    public Pattern getNameValidationPattern() {
        Pattern pattern = this.myNameValidationPattern;
        if (pattern == null) {
            PathVariablePsiElement.z(22);
        }
        return pattern;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            PathVariablePsiElement.z(23);
        }
        this.myVariablePomTarget.setName(name);
        return this;
    }

    public int getTextOffset() {
        return this.getParent().getTextOffset() + this.myVariablePomTarget.myTextRange.getStartOffset();
    }

    @Override
    public boolean canNavigate() {
        return true;
    }

    public int getTextLength() {
        return this.getName().length();
    }

    public String getTypeName() {
        return MicroservicesBundle.message("microservices.url.path.variable.typeName", new Object[0]);
    }

    public Icon getIcon() {
        return IconManager.getInstance().getPlatformIcon(PlatformIcons.Variable);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof PathVariablePsiElement)) {
            return false;
        }
        PathVariablePsiElement pathVariablePsiElement = (PathVariablePsiElement)((Object)o2);
        if (!this.myVariablePomTarget.equals(pathVariablePsiElement.myVariablePomTarget)) {
            return false;
        }
        if (!this.getName().equals(pathVariablePsiElement.getName())) {
            return false;
        }
        return this.getTextRange().equals((Object)pathVariablePsiElement.getTextRange());
    }

    public int hashCode() {
        int n2 = this.myVariablePomTarget.hashCode();
        n2 = 31 * n2 + this.getName().hashCode();
        n2 = 31 * n2 + this.getTextRange().hashCode();
        return n2;
    }

    private static /* synthetic */ void z(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 20, 21, 22 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pomTarget";
                break;
            }
            case 1: 
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameValidationPattern";
                break;
            }
            case 2: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 8: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semDefinitionProvider";
                break;
            }
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/microservices/url/parameters/PathVariablePsiElement";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/microservices/url/parameters/PathVariablePsiElement";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameValidationPattern";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 20, 21, 22 -> new IllegalStateException(string);
        };
    }

    @Presentation(provider=PathVariablePresentationProvider.class)
    public static class PathVariablePomTarget
    extends CommonFakeNavigatablePomTarget.SimpleNamePomTarget {
        private final PsiElement myScope;
        private final TextRange myTextRange;
        private final SemDefinitionProvider mySemDefinitionProvider;

        private PathVariablePomTarget(@NotNull String name, PsiElement scope, TextRange range, SemDefinitionProvider semDefinitionProvider) {
            if (name == null) {
                PathVariablePomTarget.z(0);
            }
            super(name);
            this.myScope = scope;
            this.myTextRange = range;
            this.mySemDefinitionProvider = semDefinitionProvider;
        }

        @Override
        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            if (!super.equals(o2)) {
                return false;
            }
            PathVariablePomTarget pathVariablePomTarget = (PathVariablePomTarget)o2;
            return this.myScope.equals(pathVariablePomTarget.myScope) && this.myTextRange.equals((Object)pathVariablePomTarget.myTextRange);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.myScope, this.myTextRange);
        }

        public PsiElement getScope() {
            return this.myScope;
        }

        public TextRange getTextRange() {
            return this.myTextRange;
        }

        @NotNull
        @ApiStatus.Internal
        Iterable<PsiElement> findSemDefinitionPsiElement() {
            Iterable<PsiElement> iterable = this.mySemDefinitionProvider.findSemDefiningElements(this);
            if (iterable == null) {
                PathVariablePomTarget.z(1);
            }
            return iterable;
        }

        private static /* synthetic */ void z(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/microservices/url/parameters/PathVariablePsiElement$PathVariablePomTarget";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/microservices/url/parameters/PathVariablePsiElement$PathVariablePomTarget";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findSemDefinitionPsiElement";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static interface SemDefinitionProvider {
        @NotNull
        public Iterable<PsiElement> findSemDefiningElements(@NotNull PathVariablePomTarget var1);
    }

    private static class MultiplePomTarget
    extends PathVariablePsiElement {
        private final Set<PathVariablePomTarget> myPomTargets;

        private MultiplePomTarget(Set<PathVariablePomTarget> pomTargets) {
            super(((PathVariablePomTarget)ContainerUtil.getFirstItem(pomTargets)).getName(), ((PathVariablePomTarget)ContainerUtil.getFirstItem(pomTargets)).myScope, ((PathVariablePomTarget)ContainerUtil.getFirstItem(pomTargets)).myTextRange, UrlConversionConstants.STANDARD_PATH_VARIABLE_NAME_PATTERN, ((PathVariablePomTarget)ContainerUtil.getFirstItem(pomTargets)).mySemDefinitionProvider);
            this.myPomTargets = pomTargets;
        }

        @Override
        public boolean isEquivalentTo(@Nullable PsiElement another) {
            if (this == another) {
                return true;
            }
            if (!(another instanceof PathVariablePsiElement)) {
                return false;
            }
            if (another instanceof MultiplePomTarget) {
                return this.myPomTargets.equals(((MultiplePomTarget)another).myPomTargets);
            }
            PathVariablePomTarget pathVariablePomTarget = ((PathVariablePsiElement)another).getVariablePomTarget();
            return this.myPomTargets.stream().anyMatch(pathVariablePomTarget2 -> pathVariablePomTarget2.equals(pathVariablePomTarget));
        }
    }
}

