/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.view;

import com.intellij.openapi.graph.impl.view.JBGraphEditorComponentDrawable;
import com.intellij.openapi.graph.impl.view.JByToSwingEventsDelegatingMode;
import java.applet.Applet;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import x.S.DR;
import x.S.Sg;
import x.S.Sw;
import x.S.Vw;
import x.S.Yj;
import x.t.g;
import x.t.q;
import x.t.x;
import x.z.zq;

public class JBCellEditorMode
extends Vw {
    @NotNull
    private final q myNodeCellEditorProvider;
    @NotNull
    private final x myUserObjectMap;
    @NotNull
    private final CellEditorListener myCellEditorListener = new MyCellEditorListener();
    @Nullable
    private Sw myCurrentEditor;
    @Nullable
    private DR myCurrentEditedNodeRealizer;
    @Nullable
    private JComponent myCurrentEditorComponent;
    @Nullable
    private JByToSwingEventsDelegatingMode myEventsDelegatingMode;
    @Nullable
    private JBGraphEditorComponentDrawable myEditorComponentDrawable;
    @Nullable
    private PropertyChangeListener myFocusOwnerChangeListener;

    public JBCellEditorMode(Sw nodeCellEditor, x userObjectMap) {
        this(zq.z(nodeCellEditor), userObjectMap);
    }

    public JBCellEditorMode(q nodeCellEditorProvider, x userObjectMap) {
        super(nodeCellEditorProvider, userObjectMap);
        this.myNodeCellEditorProvider = nodeCellEditorProvider;
        this.myUserObjectMap = userObjectMap;
    }

    @Override
    public boolean editNode(g node, EventObject event) {
        if (this.isNodeEditable(node) && (!this.isCellEditing() || this.stopCellEditing())) {
            DR dR = this.z().z(node);
            Sw sw = this.getNodeCellEditor(node);
            if (sw == null || event != null && !sw.isCellEditable(event)) {
                return false;
            }
            this.startCellEditing(dR, sw);
            if (event instanceof MouseEvent && ((MouseEvent)event).getID() == 500 && this.myEventsDelegatingMode != null && this.isCellEditing()) {
                this.myEventsDelegatingMode.mouseClicked((MouseEvent)event);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isNodeEditable(g node) {
        return this.getNodeCellEditor(node) != null;
    }

    private void t(MouseEvent mouseEvent) {
        Object object;
        Yj yj;
        if (!this.isCellEditing()) {
            if (!this.shouldStartCellEditing(mouseEvent)) {
                return;
            }
            yj = this.z(mouseEvent);
            if (yj.z() == null) {
                return;
            }
            this.editNode((g)yj.z(), mouseEvent);
            if (!DR.V) {
                return;
            }
        }
        this.x(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner());
        if (this.isCellEditing() && mouseEvent.getID() == 501 && ((object = (yj = this.z(mouseEvent)).z()) == null || object != this.myCurrentEditedNodeRealizer.z()) && !this.stopCellEditing()) {
            this.cancelCellEditing();
        }
    }

    @Override
    @Nullable
    public Object getUserObject(g node) {
        return this.myUserObjectMap.get(this.myCurrentEditedNodeRealizer.z());
    }

    @Override
    public void setUserObject(g node, Object data) {
        this.myUserObjectMap.z((Object)node, data);
    }

    @Override
    protected boolean shouldStartCellEditing(@NotNull MouseEvent event) {
        if (event == null) {
            JBCellEditorMode.x(0);
        }
        return event.getID() == 500 && event.getClickCount() == 2;
    }

    @Override
    @Nullable
    public Sw getNodeCellEditor(g node) {
        Object object = this.myNodeCellEditorProvider != null ? this.myNodeCellEditorProvider.get(node) : null;
        return object instanceof Sw ? (Sw)object : null;
    }

    @Override
    public boolean isCellEditing() {
        return this.myCurrentEditor != null;
    }

    @Override
    public void startCellEditing(DR nodeRealizer, Sw nodeCellEditor) {
        if (this.isCellEditing() && !this.stopCellEditing()) {
            this.cancelCellEditing();
        }
        if (!this.isCellEditing()) {
            this.myCurrentEditor = nodeCellEditor;
            this.myCurrentEditedNodeRealizer = nodeRealizer;
            nodeCellEditor.addCellEditorListener(this.myCellEditorListener);
            JComponent jComponent = nodeCellEditor.getNodeCellEditorComponent(this.b, nodeRealizer, this.getUserObject(nodeRealizer.z()), nodeRealizer.V());
            this.installEditor(jComponent, nodeRealizer);
        }
    }

    @Override
    @Nullable
    public Sw getEditor() {
        return this.myCurrentEditor;
    }

    @Override
    @Nullable
    public g getEditingNode() {
        return this.myCurrentEditedNodeRealizer != null ? this.myCurrentEditedNodeRealizer.z() : null;
    }

    @Override
    public void cancelCellEditing() {
        if (this.myCurrentEditor != null) {
            this.myCurrentEditor.cancelCellEditing();
        }
    }

    @Override
    public boolean stopCellEditing() {
        return this.myCurrentEditor != null ? this.myCurrentEditor.stopCellEditing() : true;
    }

    @Override
    protected void cellEditingCanceled() {
        if (this.myCurrentEditor != null) {
            this.myCurrentEditor.removeCellEditorListener(this.myCellEditorListener);
            this.removeEditor();
            this.myCurrentEditor = null;
            this.reactivateParent();
        }
    }

    @Override
    protected void cellEditingStopped() {
        if (this.myCurrentEditor != null) {
            this.myCurrentEditor.removeCellEditorListener(this.myCellEditorListener);
            this.removeEditor();
            this.myCurrentEditor = null;
            this.reactivateParent();
        }
    }

    @Override
    public void reactivateParent() {
        super.reactivateParent();
    }

    @Override
    public void cancelEditing() throws UnsupportedOperationException {
        super.cancelEditing();
    }

    @Override
    protected void setEditing(boolean b10) {
        super.setEditing(b10);
    }

    @Override
    public void activate(boolean b10) {
        super.activate(b10);
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        if (this.myEventsDelegatingMode != null) {
            this.myEventsDelegatingMode.mouseMoved(event);
        }
    }

    private void a(@NotNull MouseEvent mouseEvent) {
        Object object;
        if (mouseEvent == null) {
            JBCellEditorMode.x(1);
        }
        if (mouseEvent.getID() == 501 && this.isCellEditing() && ((object = this.z(mouseEvent).z()) == null || object != this.myCurrentEditedNodeRealizer.z()) && !this.stopCellEditing()) {
            this.cancelCellEditing();
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (this.myEventsDelegatingMode != null) {
            this.myEventsDelegatingMode.mouseReleased(event);
        }
        this.r(event);
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (this.myEventsDelegatingMode != null) {
            this.myEventsDelegatingMode.mouseDragged(event);
        }
        this.r(event);
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (this.myEventsDelegatingMode != null) {
            this.myEventsDelegatingMode.mousePressed(event);
        }
        this.r(event);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (this.myEventsDelegatingMode != null) {
            this.myEventsDelegatingMode.mouseClicked(event);
        }
        this.r(event);
    }

    private void r(MouseEvent mouseEvent) {
        this.a(mouseEvent);
        if (!DR.V) {
            return;
        }
        this.t(mouseEvent);
    }

    @Override
    protected void installEditor(@NotNull JComponent editorComponent, DR nodeRealizer) {
        if (editorComponent == null) {
            JBCellEditorMode.x(2);
        }
        if (editorComponent.getNextFocusableComponent() == null) {
            editorComponent.setNextFocusableComponent(this.b.x());
        }
        JComponent jComponent = this.z();
        jComponent.add(editorComponent);
        this.myCurrentEditorComponent = editorComponent;
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(nodeRealizer.z(), nodeRealizer.t());
        JByToSwingEventsDelegatingMode jByToSwingEventsDelegatingMode = new JByToSwingEventsDelegatingMode(true);
        this.z(jByToSwingEventsDelegatingMode, null, null, null);
        jByToSwingEventsDelegatingMode.addDelegateComponent(editorComponent, affineTransform);
        this.myEventsDelegatingMode = jByToSwingEventsDelegatingMode;
        this.myEditorComponentDrawable = new JBGraphEditorComponentDrawable(jComponent, editorComponent, affineTransform);
        this.b.t(this.myEditorComponentDrawable);
        editorComponent.setBounds(0, 0, (int)nodeRealizer.x(), (int)nodeRealizer.r());
        editorComponent.validate();
        editorComponent.requestFocusInWindow();
        editorComponent.repaint();
        if (this.myFocusOwnerChangeListener == null) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.myFocusOwnerChangeListener = new MyFocusOwnerListener(keyboardFocusManager);
            keyboardFocusManager.addPropertyChangeListener("permanentFocusOwner", this.myFocusOwnerChangeListener);
        }
    }

    @Override
    protected void removeEditor() {
        if (this.myFocusOwnerChangeListener != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.myFocusOwnerChangeListener);
            this.myFocusOwnerChangeListener = null;
        }
        if (this.myCurrentEditorComponent != null) {
            this.myEventsDelegatingMode.reactivateParent();
            this.z().remove(this.myCurrentEditorComponent);
            this.b.x(this.myEditorComponentDrawable);
            this.b.x().repaint();
            this.myEventsDelegatingMode = null;
        }
        this.myCurrentEditorComponent = null;
    }

    private void x(Component component) {
        if (component instanceof Sg) {
            return;
        }
        boolean bl2 = DR.V;
        if (this.isCellEditing()) {
            JComponent jComponent = this.z();
            for (Component component2 = component; component2 != null && component2 != jComponent; component2 = component2.getParent()) {
                if (component2 instanceof Window || component2 instanceof Applet && component2.getParent() == null) {
                    if (component2 == SwingUtilities.getRoot(this.b) && !this.stopCellEditing()) {
                        this.cancelCellEditing();
                    }
                    return;
                }
                if (!bl2) continue;
                return;
            }
        }
    }

    @NotNull
    private JComponent z() {
        JComponent jComponent = this.b.x();
        if (jComponent == null) {
            JBCellEditorMode.x(3);
        }
        return jComponent;
    }

    private static /* synthetic */ void x(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/impl/view/JBCellEditorMode";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/impl/view/JBCellEditorMode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanvasComponent";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shouldStartCellEditing";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "cancelEditingIfAnotherNodeWasClicked";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "installEditor";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private final class MyCellEditorListener
    implements CellEditorListener {
        MyCellEditorListener() {
        }

        @Override
        public void editingStopped(ChangeEvent event) {
            JBCellEditorMode.this.cellEditingStopped();
        }

        @Override
        public void editingCanceled(ChangeEvent event) {
            JBCellEditorMode.this.cellEditingCanceled();
        }
    }

    private final class MyFocusOwnerListener
    implements PropertyChangeListener {
        @NotNull
        private final KeyboardFocusManager myFocusManager;

        public MyFocusOwnerListener(KeyboardFocusManager focusManager) {
            if (focusManager == null) {
                MyFocusOwnerListener.z(0);
            }
            this.myFocusManager = focusManager;
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            JBCellEditorMode.this.x(this.myFocusManager.getPermanentFocusOwner());
        }

        private static /* synthetic */ void z(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "focusManager", "com/intellij/openapi/graph/impl/view/JBCellEditorMode$MyFocusOwnerListener", "<init>"));
        }
    }
}

