/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.api;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.platform.lsp.api.Lsp4jClient;
import com.intellij.platform.lsp.api.LspCommunicationChannel;
import com.intellij.platform.lsp.api.LspServerListener;
import com.intellij.platform.lsp.api.LspServerNotificationsHandler;
import com.intellij.platform.lsp.api.customization.LspCodeActionsSupport;
import com.intellij.platform.lsp.api.customization.LspCommandsSupport;
import com.intellij.platform.lsp.api.customization.LspCompletionSupport;
import com.intellij.platform.lsp.api.customization.LspDiagnosticsSupport;
import com.intellij.platform.lsp.api.customization.LspDocumentColorSupport;
import com.intellij.platform.lsp.api.customization.LspFindReferencesSupport;
import com.intellij.platform.lsp.api.customization.LspFormattingSupport;
import com.intellij.platform.lsp.api.customization.LspSemanticTokensSupport;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.util.io.URLUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.ClientInfo;
import org.eclipse.lsp4j.CodeActionCapabilities;
import org.eclipse.lsp4j.CodeActionKindCapabilities;
import org.eclipse.lsp4j.CodeActionLiteralSupportCapabilities;
import org.eclipse.lsp4j.CodeActionResolveSupportCapabilities;
import org.eclipse.lsp4j.ColorProviderCapabilities;
import org.eclipse.lsp4j.CompletionCapabilities;
import org.eclipse.lsp4j.CompletionItemCapabilities;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionItemKindCapabilities;
import org.eclipse.lsp4j.CompletionItemResolveSupportCapabilities;
import org.eclipse.lsp4j.CompletionItemTag;
import org.eclipse.lsp4j.CompletionItemTagSupportCapabilities;
import org.eclipse.lsp4j.CompletionListCapabilities;
import org.eclipse.lsp4j.ConfigurationItem;
import org.eclipse.lsp4j.DefinitionCapabilities;
import org.eclipse.lsp4j.DiagnosticTag;
import org.eclipse.lsp4j.DiagnosticsTagSupport;
import org.eclipse.lsp4j.DidChangeWatchedFilesCapabilities;
import org.eclipse.lsp4j.ExecuteCommandCapabilities;
import org.eclipse.lsp4j.FormattingCapabilities;
import org.eclipse.lsp4j.GeneralClientCapabilities;
import org.eclipse.lsp4j.HoverCapabilities;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.PublishDiagnosticsCapabilities;
import org.eclipse.lsp4j.ReferencesCapabilities;
import org.eclipse.lsp4j.SemanticTokensCapabilities;
import org.eclipse.lsp4j.SemanticTokensClientCapabilitiesRequests;
import org.eclipse.lsp4j.SemanticTokensClientCapabilitiesRequestsFull;
import org.eclipse.lsp4j.SemanticTokensWorkspaceCapabilities;
import org.eclipse.lsp4j.ShowDocumentCapabilities;
import org.eclipse.lsp4j.StaleRequestCapabilities;
import org.eclipse.lsp4j.SynchronizationCapabilities;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;
import org.eclipse.lsp4j.TypeDefinitionCapabilities;
import org.eclipse.lsp4j.WindowClientCapabilities;
import org.eclipse.lsp4j.WindowShowMessageRequestCapabilities;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;
import org.eclipse.lsp4j.WorkspaceEditCapabilities;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u0000 g2\u00020\u0001:\u0001gB/\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u0012\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bH'J\b\u0010\u0017\u001a\u00020\u0018H\u0017J\b\u0010\u0019\u001a\u00020\u001aH\u0017J\u0010\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\bH\u0016J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005H\u0002J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\bH\u0014J\u0012\u0010#\u001a\u0004\u0018\u00010\b2\u0006\u0010$\u001a\u00020\u0005H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010\b2\u0006\u0010&\u001a\u00020\u0005H\u0014J\u0010\u0010'\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\bH\u0016J\b\u0010(\u001a\u00020)H\u0016J\n\u0010.\u001a\u0004\u0018\u00010\u0001H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016J\u0012\u0010d\u001a\u0004\u0018\u00010\u00012\u0006\u0010e\u001a\u00020fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010*\u001a\u00020+8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R \u00103\u001a\u000e\u0012\n\b\u0001\u0012\u000605j\u0002`604X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0016\u00109\u001a\u0004\u0018\u00010:X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u0014\u0010=\u001a\u00020\u0015X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0014\u0010@\u001a\u00020\u0015X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010?R\u0014\u0010B\u001a\u00020\u0015X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010?R\u0016\u0010D\u001a\u0004\u0018\u00010EX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010GR\u0016\u0010H\u001a\u0004\u0018\u00010IX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010KR\u0016\u0010L\u001a\u0004\u0018\u00010MX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u0010OR\u0016\u0010P\u001a\u0004\u0018\u00010QX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010SR\u0016\u0010T\u001a\u0004\u0018\u00010UX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bV\u0010WR\u0016\u0010X\u001a\u0004\u0018\u00010YX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bZ\u0010[R\u0016\u0010\\\u001a\u0004\u0018\u00010]X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b^\u0010_R\u0016\u0010`\u001a\u0004\u0018\u00010aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bb\u0010c\u00a8\u0006h"}, d2={"Lcom/intellij/platform/lsp/api/LspServerDescriptor;", "", "project", "Lcom/intellij/openapi/project/Project;", "presentableName", "", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "LspServerDescriptor", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;[Lcom/intellij/openapi/vfs/VirtualFile;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getPresentableName", "()Ljava/lang/String;", "getRoots", "()[Lcom/intellij/openapi/vfs/VirtualFile;", "[Lcom/intellij/openapi/vfs/VirtualFile;", "toString", "Lcom/intellij/openapi/util/NlsSafe;", "isSupportedFile", "", "file", "startServerProcess", "Lcom/intellij/execution/process/OSProcessHandler;", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "lspCommunicationChannel", "Lcom/intellij/platform/lsp/api/LspCommunicationChannel;", "getLspCommunicationChannel", "()Lcom/intellij/platform/lsp/api/LspCommunicationChannel;", "getFileUri", "z", "uri", "getFilePath", "findFileByUri", "fileUri", "findLocalFileByPath", "path", "getLanguageId", "createInitializeParams", "Lorg/eclipse/lsp4j/InitializeParams;", "clientCapabilities", "Lorg/eclipse/lsp4j/ClientCapabilities;", "getClientCapabilities", "()Lorg/eclipse/lsp4j/ClientCapabilities;", "createInitializationOptions", "createLsp4jClient", "Lcom/intellij/platform/lsp/api/Lsp4jClient;", "handler", "Lcom/intellij/platform/lsp/api/LspServerNotificationsHandler;", "lsp4jServerClass", "Ljava/lang/Class;", "Lorg/eclipse/lsp4j/services/LanguageServer;", "Lcom/intellij/platform/lsp/api/Lsp4jServer;", "getLsp4jServerClass", "()Ljava/lang/Class;", "lspServerListener", "Lcom/intellij/platform/lsp/api/LspServerListener;", "getLspServerListener", "()Lcom/intellij/platform/lsp/api/LspServerListener;", "lspGoToDefinitionSupport", "getLspGoToDefinitionSupport", "()Z", "lspGoToTypeDefinitionSupport", "getLspGoToTypeDefinitionSupport", "lspHoverSupport", "getLspHoverSupport", "lspCompletionSupport", "Lcom/intellij/platform/lsp/api/customization/LspCompletionSupport;", "getLspCompletionSupport", "()Lcom/intellij/platform/lsp/api/customization/LspCompletionSupport;", "lspSemanticTokensSupport", "Lcom/intellij/platform/lsp/api/customization/LspSemanticTokensSupport;", "getLspSemanticTokensSupport", "()Lcom/intellij/platform/lsp/api/customization/LspSemanticTokensSupport;", "lspDiagnosticsSupport", "Lcom/intellij/platform/lsp/api/customization/LspDiagnosticsSupport;", "getLspDiagnosticsSupport", "()Lcom/intellij/platform/lsp/api/customization/LspDiagnosticsSupport;", "lspCodeActionsSupport", "Lcom/intellij/platform/lsp/api/customization/LspCodeActionsSupport;", "getLspCodeActionsSupport", "()Lcom/intellij/platform/lsp/api/customization/LspCodeActionsSupport;", "lspCommandsSupport", "Lcom/intellij/platform/lsp/api/customization/LspCommandsSupport;", "getLspCommandsSupport", "()Lcom/intellij/platform/lsp/api/customization/LspCommandsSupport;", "lspFormattingSupport", "Lcom/intellij/platform/lsp/api/customization/LspFormattingSupport;", "getLspFormattingSupport", "()Lcom/intellij/platform/lsp/api/customization/LspFormattingSupport;", "lspFindReferencesSupport", "Lcom/intellij/platform/lsp/api/customization/LspFindReferencesSupport;", "getLspFindReferencesSupport", "()Lcom/intellij/platform/lsp/api/customization/LspFindReferencesSupport;", "lspDocumentColorSupport", "Lcom/intellij/platform/lsp/api/customization/LspDocumentColorSupport;", "getLspDocumentColorSupport", "()Lcom/intellij/platform/lsp/api/customization/LspDocumentColorSupport;", "getWorkspaceConfiguration", "item", "Lorg/eclipse/lsp4j/ConfigurationItem;", "Companion", "intellij.platform.lsp"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nLspServerDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspServerDescriptor.kt\ncom/intellij/platform/lsp/api/LspServerDescriptor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,533:1\n11165#2:534\n11500#2,3:535\n1#3:538\n*S KotlinDebug\n*F\n+ 1 LspServerDescriptor.kt\ncom/intellij/platform/lsp/api/LspServerDescriptor\n*L\n231#1:534\n231#1:535,3\n*E\n"})
public abstract class LspServerDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String presentableName;
    @NotNull
    private final VirtualFile[] roots;
    @NotNull
    private final LspCommunicationChannel lspCommunicationChannel;
    @NotNull
    private final Class<? extends LanguageServer> lsp4jServerClass;
    @Nullable
    private final LspServerListener lspServerListener;
    private final boolean lspGoToDefinitionSupport;
    private final boolean lspGoToTypeDefinitionSupport;
    private final boolean lspHoverSupport;
    @Nullable
    private final LspCompletionSupport lspCompletionSupport;
    @Nullable
    private final LspSemanticTokensSupport lspSemanticTokensSupport;
    @Nullable
    private final LspDiagnosticsSupport lspDiagnosticsSupport;
    @Nullable
    private final LspCodeActionsSupport lspCodeActionsSupport;
    @Nullable
    private final LspCommandsSupport lspCommandsSupport;
    @Nullable
    private final LspFormattingSupport lspFormattingSupport;
    @Nullable
    private final LspFindReferencesSupport lspFindReferencesSupport;
    @Nullable
    private final LspDocumentColorSupport lspDocumentColorSupport;
    @JvmField
    @NotNull
    public static final Logger LOG;
    @NotNull
    private static final List<Pair<String, String>> FILE_NAME_ENDING_TO_LANGUAGE_ID;
    @NotNull
    private static final Map<String, String> FILE_EXTENSION_TO_LANGUAGE_ID;

    protected LspServerDescriptor(@NotNull Project project, @NlsSafe @NotNull String presentableName, VirtualFile ... roots) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)presentableName, (String)"presentableName");
        Intrinsics.checkNotNullParameter((Object)roots, (String)"roots");
        this.project = project;
        this.presentableName = presentableName;
        this.roots = roots;
        this.lspCommunicationChannel = LspCommunicationChannel.StdIO.INSTANCE;
        this.lsp4jServerClass = LanguageServer.class;
        this.lspGoToDefinitionSupport = true;
        this.lspGoToTypeDefinitionSupport = true;
        this.lspHoverSupport = true;
        this.lspCompletionSupport = new LspCompletionSupport();
        this.lspSemanticTokensSupport = new LspSemanticTokensSupport();
        this.lspDiagnosticsSupport = new LspDiagnosticsSupport();
        this.lspCodeActionsSupport = new LspCodeActionsSupport();
        this.lspCommandsSupport = new LspCommandsSupport();
        this.lspFormattingSupport = new LspFormattingSupport();
        this.lspFindReferencesSupport = new LspFindReferencesSupport();
        this.lspDocumentColorSupport = new LspDocumentColorSupport();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final String getPresentableName() {
        return this.presentableName;
    }

    @NotNull
    public final VirtualFile[] getRoots() {
        return this.roots;
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "@" + this.project.getName();
    }

    @RequiresReadLock
    public abstract boolean isSupportedFile(@NotNull VirtualFile var1);

    @RequiresBackgroundThread
    @NotNull
    public OSProcessHandler startServerProcess() throws ExecutionException {
        GeneralCommandLine generalCommandLine = this.createCommandLine().withCharset(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withCharset(...)");
        GeneralCommandLine generalCommandLine2 = generalCommandLine;
        LOG.info(this + ": starting LSP server: " + generalCommandLine2);
        return new OSProcessHandler(generalCommandLine2){

            protected BaseOutputReader.Options readerOptions() {
                return new BaseOutputReader.Options(){

                    public BaseDataReader.SleepingPolicy policy() {
                        BaseDataReader.SleepingPolicy sleepingPolicy = BaseOutputReader.Options.forMostlySilentProcess().policy();
                        Intrinsics.checkNotNullExpressionValue((Object)sleepingPolicy, (String)"policy(...)");
                        return sleepingPolicy;
                    }

                    public boolean splitToLines() {
                        return false;
                    }
                };
            }
        };
    }

    @RequiresBackgroundThread
    @NotNull
    public GeneralCommandLine createCommandLine() throws ExecutionException {
        throw new ExecutionException("createCommandLine() function not implemented");
    }

    @NotNull
    public LspCommunicationChannel getLspCommunicationChannel() {
        return this.lspCommunicationChannel;
    }

    @NotNull
    public String getFileUri(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = URLUtil.encodePath((String)this.getFilePath(file));
        String string2 = VirtualFileManager.constructUrl((String)"file", (String)string);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"constructUrl(...)");
        String string3 = string2;
        Object object = VfsUtil.toUri((String)string3);
        if (object == null || (object = ((URI)object).toString()) == null) {
            object = string3;
        }
        Object object2 = object;
        return this.z((String)object2);
    }

    private final String z(String string) {
        String string2 = "file:///";
        if (StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) {
            String string3 = string.substring(string2.length());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            if (OSAgnosticPathUtil.startsWithWindowsDrive((String)string3)) {
                String string4 = String.valueOf(string.charAt(string2.length()));
                Intrinsics.checkNotNull((Object)string4, (String)"null cannot be cast to non-null type java.lang.String");
                String string5 = string4.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
                String string6 = string.substring(string2.length() + 2);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                return string2 + string5 + "%3A" + string6;
            }
        }
        return string;
    }

    @NotNull
    protected String getFilePath(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    @Nullable
    public VirtualFile findFileByUri(@NotNull String fileUri) {
        URI uRI;
        Object object;
        Intrinsics.checkNotNullParameter((Object)fileUri, (String)"fileUri");
        String string = "file:///wsl$/";
        if (StringsKt.startsWith$default((String)fileUri, (String)string, (boolean)false, (int)2, null)) {
            String string2 = fileUri.substring(string.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            object = "file:////wsl$/" + string2;
        } else {
            object = fileUri;
        }
        String string3 = object;
        try {
            uRI = new URI(string3);
            if (!Intrinsics.areEqual((Object)"file", (Object)uRI.getScheme())) {
                LOG.warn("Unexpected URI scheme: " + fileUri);
                return null;
            }
            String string4 = uRI.getPath();
            if (string4 == null) {
                LOG.warn("Unexpected URI (no path): " + fileUri);
                return null;
            }
            uRI = this.findLocalFileByPath(string4);
        }
        catch (URISyntaxException uRISyntaxException) {
            LOG.warn("Malformed URI: " + fileUri + "; " + uRISyntaxException.getMessage());
            uRI = null;
        }
        return uRI;
    }

    @Nullable
    protected VirtualFile findLocalFileByPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    @NotNull
    public String getLanguageId(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Companion.getLanguageId(file);
    }

    @NotNull
    public InitializeParams createInitializeParams() {
        InitializeParams initializeParams;
        block2: {
            InitializeParams initializeParams2 = initializeParams = new InitializeParams();
            boolean bl2 = false;
            initializeParams2.setClientInfo(new ClientInfo(ApplicationNamesInfo.getInstance().getFullProductNameWithEdition(), ApplicationInfo.getInstance().getBuild().asStringWithoutProductCode()));
            initializeParams2.setCapabilities(this.getClientCapabilities());
            if (this.roots.length == 1) {
                initializeParams2.setRootUri(this.getFileUri(this.roots[0]));
                initializeParams2.setRootPath(this.getFilePath(this.roots[0]));
            }
            VirtualFile[] virtualFileArray = this.roots;
            InitializeParams initializeParams3 = initializeParams2;
            boolean bl3 = false;
            Object object = virtualFileArray;
            Collection collection = new ArrayList(virtualFileArray.length);
            boolean bl4 = false;
            int n2 = ((VirtualFile[])object).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                VirtualFile virtualFile;
                VirtualFile virtualFile2 = virtualFile = object[i2];
                Collection collection2 = collection;
                boolean bl5 = false;
                collection2.add(new WorkspaceFolder(this.getFileUri(virtualFile2), virtualFile2.getName()));
            }
            initializeParams3.setWorkspaceFolders((List)collection);
            Object object2 = this.createInitializationOptions();
            if (object2 == null) break block2;
            object = object2;
            boolean bl6 = false;
            initializeParams2.setInitializationOptions(object);
        }
        return initializeParams;
    }

    @NotNull
    public ClientCapabilities getClientCapabilities() {
        String[] stringArray;
        WorkspaceClientCapabilities workspaceClientCapabilities;
        ClientCapabilities clientCapabilities;
        ClientCapabilities clientCapabilities2 = clientCapabilities = new ClientCapabilities();
        boolean bl2 = false;
        WorkspaceClientCapabilities workspaceClientCapabilities2 = workspaceClientCapabilities = new WorkspaceClientCapabilities();
        ClientCapabilities clientCapabilities3 = clientCapabilities2;
        boolean bl3 = false;
        workspaceClientCapabilities2.setApplyEdit(Boolean.valueOf(true));
        workspaceClientCapabilities2.setWorkspaceFolders(Boolean.valueOf(true));
        Object object = new WorkspaceEditCapabilities();
        Object object2 = object;
        WorkspaceClientCapabilities workspaceClientCapabilities3 = workspaceClientCapabilities2;
        boolean bl4 = false;
        object2.setDocumentChanges(Boolean.valueOf(true));
        object2.setResourceOperations(CollectionsKt.listOf((Object)"create"));
        object2.setFailureHandling("abort");
        object2.setNormalizesLineEndings(Boolean.valueOf(true));
        workspaceClientCapabilities3.setWorkspaceEdit((WorkspaceEditCapabilities)object);
        object = new DidChangeWatchedFilesCapabilities(Boolean.valueOf(true));
        object2 = object;
        workspaceClientCapabilities3 = workspaceClientCapabilities2;
        bl4 = false;
        object2.setRelativePatternSupport(Boolean.valueOf(true));
        workspaceClientCapabilities3.setDidChangeWatchedFiles((DidChangeWatchedFilesCapabilities)object);
        workspaceClientCapabilities2.setExecuteCommand(new ExecuteCommandCapabilities(Boolean.valueOf(false)));
        object = new SemanticTokensWorkspaceCapabilities();
        object2 = object;
        workspaceClientCapabilities3 = workspaceClientCapabilities2;
        bl4 = false;
        object2.setRefreshSupport(Boolean.valueOf(true));
        workspaceClientCapabilities3.setSemanticTokens((SemanticTokensWorkspaceCapabilities)object);
        clientCapabilities3.setWorkspace(workspaceClientCapabilities);
        workspaceClientCapabilities2 = workspaceClientCapabilities = new TextDocumentClientCapabilities();
        clientCapabilities3 = clientCapabilities2;
        bl3 = false;
        object = new SynchronizationCapabilities();
        object2 = object;
        workspaceClientCapabilities3 = workspaceClientCapabilities2;
        bl4 = false;
        object2.setDynamicRegistration(Boolean.valueOf(false));
        object2.setWillSave(Boolean.valueOf(false));
        object2.setWillSaveWaitUntil(Boolean.valueOf(false));
        object2.setDidSave(Boolean.valueOf(true));
        workspaceClientCapabilities3.setSynchronization((SynchronizationCapabilities)object);
        object = new DefinitionCapabilities();
        object2 = object;
        workspaceClientCapabilities3 = workspaceClientCapabilities2;
        bl4 = false;
        object2.setLinkSupport(Boolean.valueOf(true));
        workspaceClientCapabilities3.setDefinition((DefinitionCapabilities)object);
        object = new TypeDefinitionCapabilities();
        object2 = object;
        workspaceClientCapabilities3 = workspaceClientCapabilities2;
        bl4 = false;
        object2.setLinkSupport(Boolean.valueOf(true));
        workspaceClientCapabilities3.setTypeDefinition((TypeDefinitionCapabilities)object);
        object = new CompletionCapabilities();
        object2 = object;
        workspaceClientCapabilities3 = workspaceClientCapabilities2;
        bl4 = false;
        String[] stringArray2 = stringArray = new CompletionItemCapabilities();
        WorkspaceEditCapabilities workspaceEditCapabilities = object2;
        boolean bl5 = false;
        String[] stringArray3 = new String[]{"markdown", "plaintext"};
        stringArray2.setDocumentationFormat(CollectionsKt.listOf((Object[])stringArray3));
        stringArray2.setDeprecatedSupport(Boolean.valueOf(true));
        stringArray2.setTagSupport(new CompletionItemTagSupportCapabilities(CollectionsKt.listOf((Object)CompletionItemTag.Deprecated)));
        stringArray2.setInsertReplaceSupport(Boolean.valueOf(true));
        stringArray2.setLabelDetailsSupport(Boolean.valueOf(true));
        stringArray2.setSnippetSupport(Boolean.valueOf(true));
        String[] stringArray4 = stringArray3 = new CompletionItemResolveSupportCapabilities();
        String[] stringArray5 = stringArray2;
        boolean bl6 = false;
        stringArray4.setProperties(CollectionsKt.listOf((Object)"documentation"));
        stringArray5.setResolveSupport((CompletionItemResolveSupportCapabilities)stringArray3);
        workspaceEditCapabilities.setCompletionItem((CompletionItemCapabilities)stringArray);
        stringArray2 = stringArray = new CompletionItemKindCapabilities();
        workspaceEditCapabilities = object2;
        bl5 = false;
        stringArray2.setValueSet((List)EntriesMappings.entries$0);
        workspaceEditCapabilities.setCompletionItemKind((CompletionItemKindCapabilities)stringArray);
        stringArray2 = stringArray = new CompletionListCapabilities();
        workspaceEditCapabilities = object2;
        bl5 = false;
        stringArray3 = new String[]{"commitCharacters", "editRange", "insertTextFormat", "insertTextMode", "data"};
        stringArray2.setItemDefaults(CollectionsKt.listOf((Object[])stringArray3));
        workspaceEditCapabilities.setCompletionList((CompletionListCapabilities)stringArray);
        workspaceClientCapabilities3.setCompletion((CompletionCapabilities)object);
        object = new HoverCapabilities();
        object2 = object;
        workspaceClientCapabilities3 = workspaceClientCapabilities2;
        bl4 = false;
        stringArray = new String[]{"markdown", "plaintext"};
        object2.setContentFormat(CollectionsKt.listOf((Object[])stringArray));
        workspaceClientCapabilities3.setHover((HoverCapabilities)object);
        object = this.getLspSemanticTokensSupport();
        if (object != null) {
            WorkspaceEditCapabilities workspaceEditCapabilities2 = object2 = new SemanticTokensCapabilities();
            workspaceClientCapabilities3 = workspaceClientCapabilities2;
            boolean bl7 = false;
            stringArray2 = new SemanticTokensClientCapabilitiesRequests();
            workspaceEditCapabilities = stringArray2;
            WorkspaceEditCapabilities workspaceEditCapabilities3 = workspaceEditCapabilities2;
            boolean bl8 = false;
            workspaceEditCapabilities.setRange(Either.forLeft((Object)false));
            stringArray5 = stringArray4 = new SemanticTokensClientCapabilitiesRequestsFull();
            WorkspaceEditCapabilities workspaceEditCapabilities4 = workspaceEditCapabilities;
            boolean bl9 = false;
            stringArray5.setDelta(Boolean.valueOf(false));
            workspaceEditCapabilities4.setFull(Either.forRight((Object)stringArray4));
            workspaceEditCapabilities2.setTokenTypes(((LspSemanticTokensSupport)object).getTokenTypes());
            workspaceEditCapabilities2.setTokenModifiers(((LspSemanticTokensSupport)object).getTokenModifiers());
            workspaceEditCapabilities2.setFormats(CollectionsKt.listOf((Object)"relative"));
            workspaceEditCapabilities2.setOverlappingTokenSupport(Boolean.valueOf(true));
            workspaceEditCapabilities2.setMultilineTokenSupport(Boolean.valueOf(true));
            workspaceEditCapabilities2.setServerCancelSupport(Boolean.valueOf(false));
            workspaceEditCapabilities3.setRequests((SemanticTokensClientCapabilitiesRequests)stringArray2);
            workspaceClientCapabilities3.setSemanticTokens((SemanticTokensCapabilities)object2);
        }
        WorkspaceEditCapabilities workspaceEditCapabilities5 = object2 = new PublishDiagnosticsCapabilities();
        workspaceClientCapabilities3 = workspaceClientCapabilities2;
        boolean bl10 = false;
        workspaceEditCapabilities5.setVersionSupport(Boolean.valueOf(true));
        stringArray2 = new DiagnosticTag[]{DiagnosticTag.Unnecessary, DiagnosticTag.Deprecated};
        workspaceEditCapabilities5.setTagSupport(Either.forRight((Object)new DiagnosticsTagSupport(CollectionsKt.listOf((Object[])stringArray2))));
        workspaceClientCapabilities3.setPublishDiagnostics((PublishDiagnosticsCapabilities)object2);
        workspaceEditCapabilities5 = object2 = new CodeActionCapabilities();
        workspaceClientCapabilities3 = workspaceClientCapabilities2;
        bl10 = false;
        stringArray2 = new CodeActionLiteralSupportCapabilities();
        workspaceEditCapabilities = stringArray2;
        WorkspaceEditCapabilities workspaceEditCapabilities6 = workspaceEditCapabilities5;
        boolean bl11 = false;
        stringArray4 = new String[]{"quickfix", "", "source", "refactor"};
        workspaceEditCapabilities.setCodeActionKind(new CodeActionKindCapabilities(CollectionsKt.listOf((Object[])stringArray4)));
        workspaceEditCapabilities6.setCodeActionLiteralSupport((CodeActionLiteralSupportCapabilities)stringArray2);
        workspaceEditCapabilities5.setDisabledSupport(Boolean.valueOf(true));
        workspaceEditCapabilities5.setDataSupport(Boolean.valueOf(true));
        stringArray2 = new CodeActionResolveSupportCapabilities();
        workspaceEditCapabilities = stringArray2;
        workspaceEditCapabilities6 = workspaceEditCapabilities5;
        bl11 = false;
        workspaceEditCapabilities.setProperties(CollectionsKt.listOf((Object)"edit"));
        workspaceEditCapabilities6.setResolveSupport((CodeActionResolveSupportCapabilities)stringArray2);
        workspaceClientCapabilities3.setCodeAction((CodeActionCapabilities)object2);
        workspaceClientCapabilities2.setFormatting(new FormattingCapabilities(Boolean.valueOf(true)));
        workspaceClientCapabilities2.setReferences(new ReferencesCapabilities(Boolean.valueOf(true)));
        workspaceClientCapabilities2.setColorProvider(new ColorProviderCapabilities(Boolean.valueOf(true)));
        clientCapabilities3.setTextDocument((TextDocumentClientCapabilities)workspaceClientCapabilities);
        clientCapabilities2.setNotebookDocument(null);
        workspaceClientCapabilities2 = workspaceClientCapabilities = new WindowClientCapabilities();
        clientCapabilities3 = clientCapabilities2;
        bl3 = false;
        workspaceClientCapabilities2.setShowMessage(new WindowShowMessageRequestCapabilities());
        workspaceClientCapabilities2.setShowDocument(new ShowDocumentCapabilities(true));
        clientCapabilities3.setWindow((WindowClientCapabilities)workspaceClientCapabilities);
        workspaceClientCapabilities2 = workspaceClientCapabilities = new GeneralClientCapabilities();
        clientCapabilities3 = clientCapabilities2;
        bl3 = false;
        object = new StaleRequestCapabilities();
        object2 = object;
        workspaceClientCapabilities3 = workspaceClientCapabilities2;
        boolean bl12 = false;
        object2.setCancel(true);
        workspaceClientCapabilities3.setStaleRequestSupport((StaleRequestCapabilities)object);
        clientCapabilities3.setGeneral((GeneralClientCapabilities)workspaceClientCapabilities);
        clientCapabilities2.setExperimental(null);
        return clientCapabilities;
    }

    @Nullable
    public Object createInitializationOptions() {
        return null;
    }

    @NotNull
    public Lsp4jClient createLsp4jClient(@NotNull LspServerNotificationsHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        return new Lsp4jClient(handler);
    }

    @NotNull
    public Class<? extends LanguageServer> getLsp4jServerClass() {
        return this.lsp4jServerClass;
    }

    @Nullable
    public LspServerListener getLspServerListener() {
        return this.lspServerListener;
    }

    public boolean getLspGoToDefinitionSupport() {
        return this.lspGoToDefinitionSupport;
    }

    public boolean getLspGoToTypeDefinitionSupport() {
        return this.lspGoToTypeDefinitionSupport;
    }

    public boolean getLspHoverSupport() {
        return this.lspHoverSupport;
    }

    @Nullable
    public LspCompletionSupport getLspCompletionSupport() {
        return this.lspCompletionSupport;
    }

    @Nullable
    public LspSemanticTokensSupport getLspSemanticTokensSupport() {
        return this.lspSemanticTokensSupport;
    }

    @Nullable
    public LspDiagnosticsSupport getLspDiagnosticsSupport() {
        return this.lspDiagnosticsSupport;
    }

    @Nullable
    public LspCodeActionsSupport getLspCodeActionsSupport() {
        return this.lspCodeActionsSupport;
    }

    @Nullable
    public LspCommandsSupport getLspCommandsSupport() {
        return this.lspCommandsSupport;
    }

    @Nullable
    public LspFormattingSupport getLspFormattingSupport() {
        return this.lspFormattingSupport;
    }

    @Nullable
    public LspFindReferencesSupport getLspFindReferencesSupport() {
        return this.lspFindReferencesSupport;
    }

    @Nullable
    public LspDocumentColorSupport getLspDocumentColorSupport() {
        return this.lspDocumentColorSupport;
    }

    @Nullable
    public Object getWorkspaceConfiguration(@NotNull ConfigurationItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return null;
    }

    static {
        Logger logger = Logger.getInstance(LspServerDescriptor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        FILE_NAME_ENDING_TO_LANGUAGE_ID = CollectionsKt.listOf((Object)TuplesKt.to((Object)".blade.php", (Object)"blade"));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"js", (Object)"javascript"), TuplesKt.to((Object)"cjs", (Object)"javascript"), TuplesKt.to((Object)"mjs", (Object)"javascript"), TuplesKt.to((Object)"jsx", (Object)"javascriptreact"), TuplesKt.to((Object)"ts", (Object)"typescript"), TuplesKt.to((Object)"tsx", (Object)"typescriptreact"), TuplesKt.to((Object)"fs", (Object)"fsharp"), TuplesKt.to((Object)"fsx", (Object)"fsharp"), TuplesKt.to((Object)"handlebars", (Object)"handlebars"), TuplesKt.to((Object)"pcss", (Object)"postcss"), TuplesKt.to((Object)"phtml", (Object)"php"), TuplesKt.to((Object)"pug", (Object)"jade"), TuplesKt.to((Object)"py", (Object)"python"), TuplesKt.to((Object)"rb", (Object)"ruby"), TuplesKt.to((Object)"tpl", (Object)"smarty")};
        FILE_EXTENSION_TO_LANGUAGE_ID = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/platform/lsp/api/LspServerDescriptor$Companion;", "", "LspServerDescriptor$Companion", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLanguageId", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "FILE_NAME_ENDING_TO_LANGUAGE_ID", "", "Lkotlin/Pair;", "FILE_EXTENSION_TO_LANGUAGE_ID", "", "intellij.platform.lsp"})
    @SourceDebugExtension(value={"SMAP\nLspServerDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspServerDescriptor.kt\ncom/intellij/platform/lsp/api/LspServerDescriptor$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,533:1\n1#2:534\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getLanguageId(@NotNull VirtualFile file) {
            Object object;
            block8: {
                block7: {
                    Object v0;
                    Iterable iterable;
                    block6: {
                        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                        String string = StringUtil.toLowerCase((String)file.getName());
                        iterable = FILE_NAME_ENDING_TO_LANGUAGE_ID;
                        for (Object t10 : iterable) {
                            Pair pair = (Pair)t10;
                            boolean bl2 = false;
                            Intrinsics.checkNotNull((Object)string);
                            if (!StringsKt.endsWith$default((String)string, (String)((String)pair.getFirst()), (boolean)false, (int)2, null)) continue;
                            v0 = t10;
                            break block6;
                        }
                        v0 = null;
                    }
                    Pair pair = v0;
                    if (pair != null) {
                        iterable = pair;
                        boolean bl3 = false;
                        return (String)iterable.getSecond();
                    }
                    object = StringUtil.toLowerCase((String)file.getExtension());
                    if (object == null) break block7;
                    Object object2 = object;
                    boolean bl4 = false;
                    Object object3 = (String)FILE_EXTENSION_TO_LANGUAGE_ID.get(object2);
                    if (object3 == null) {
                        object3 = object2;
                    }
                    object = object3;
                    if (object3 != null) break block8;
                }
                object = "";
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<CompletionItemKind> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])CompletionItemKind.values()));
        }
    }
}

