/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.auth.hub;

import com.intellij.jupyter.core.jupyter.connections.auth.JupyterAuthHandlerFinder;
import com.intellij.jupyter.core.jupyter.connections.auth.hub.JupyterHubAuthHandler;
import com.intellij.jupyter.core.jupyter.connections.http.HttpSession;
import com.intellij.jupyter.core.jupyter.connections.http.JupyterHttpSessionRestUtilsKt;
import com.intellij.jupyter.core.jupyter.connections.http.JupyterRest;
import com.intellij.openapi.diagnostic.Logger;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/auth/hub/JupyterHubAuthHandlerFinder;", "Lcom/intellij/jupyter/core/jupyter/connections/auth/JupyterAuthHandlerFinder;", "<init>", "()V", "find", "Lkotlin/Pair;", "Lcom/intellij/jupyter/core/jupyter/connections/auth/hub/JupyterHubAuthHandler;", "Ljava/net/URI;", "uri", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterHubAuthHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterHubAuthHandler.kt\ncom/intellij/jupyter/core/jupyter/connections/auth/hub/JupyterHubAuthHandlerFinder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,503:1\n1557#2:504\n1628#2,3:505\n14#3:508\n14#3:509\n14#3:510\n*S KotlinDebug\n*F\n+ 1 JupyterHubAuthHandler.kt\ncom/intellij/jupyter/core/jupyter/connections/auth/hub/JupyterHubAuthHandlerFinder\n*L\n57#1:504\n57#1:505,3\n58#1:508\n61#1:509\n64#1:510\n*E\n"})
public final class JupyterHubAuthHandlerFinder
implements JupyterAuthHandlerFinder {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public Pair<JupyterHubAuthHandler, URI> find(@NotNull URI uri) {
        Pair pair;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        HttpSession.Response<String> response = JupyterRest.INSTANCE.execRequest$intellij_jupyter_core(uri);
        if (response == null) {
            return null;
        }
        HttpSession.Response<String> response2 = response;
        Iterable $this$map$iv = response2.getHeaders();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = ((String)it.getFirst()).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            collection.add(string);
        }
        if (((List)destination$iv$iv).contains("x-jupyterhub-version")) {
            $i$f$logger = false;
            Logger logger = Logger.getInstance(JupyterHubAuthHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("URI " + uri + " has header x-jupyterhub-version");
        } else if (StringsKt.contains$default((CharSequence)response2.getBody(), (CharSequence)"JupyterHub requires JavaScript", (boolean)false, (int)2, null)) {
            $i$f$logger = false;
            Logger logger = Logger.getInstance(JupyterHubAuthHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("URI " + uri + " has 'JupyterHub requires JavaScript' in body");
        } else {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(JupyterHubAuthHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("URL " + uri + " doesn't look like a JupyterHub server");
            return null;
        }
        List path = URLEncodedUtils.parsePathSegments((CharSequence)uri.getPath());
        int userSegmentIdx = path.indexOf("user");
        String username = null;
        String uriPathPrefix = null;
        if (userSegmentIdx >= 0 && userSegmentIdx < path.size() - 1) {
            username = (String)path.get(userSegmentIdx + 1);
            uriPathPrefix = URLEncodedUtils.formatSegments((Iterable)path.subList(0, userSegmentIdx), (Charset)StandardCharsets.UTF_8);
        } else {
            String string;
            MatchGroupCollection matchGroupCollection;
            username = "";
            String page = response2.getBody();
            MatchResult matchResult = Regex.find$default((Regex)new Regex("<form.*action=['\"]([^ \"']*)/hub/login.*>"), (CharSequence)page, (int)0, (int)2, null);
            if (matchResult == null || (matchGroupCollection = matchResult.getGroups()) == null || (pair = matchGroupCollection.get(1)) == null || (string = pair.getValue()) == null) {
                throw JupyterHttpSessionRestUtilsKt.unhandledResponseError$default("Failed to retrieve URL prefix from a JupyterHub page", new HttpSession.Request(HttpSession.Method.GET, uri, null, null, null, null, 60, null), response2, null, 8, null);
            }
            uriPathPrefix = string;
        }
        return TuplesKt.to((Object)new JupyterHubAuthHandler(username, uriPathPrefix), (Object)new URIBuilder(uri).setPath(uriPathPrefix).removeQuery().setFragment(null).build());
    }
}

