/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.execution.callbacks;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionStatus;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionStatusKt;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionTask;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterExecutionCallbackAdapter;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessage;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessageChannel;
import com.intellij.jupyter.core.jupyter.inlays.progress.JupyterProgressStatusChangeNotificationService;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/execution/callbacks/JupyterCellResultUserNotificationCallback;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterExecutionCallbackAdapter;", "project", "Lcom/intellij/openapi/project/Project;", "task", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterExecutionTask;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterExecutionTask;)V", "userNotificationService", "Lcom/intellij/jupyter/core/jupyter/inlays/progress/JupyterProgressStatusChangeNotificationService;", "channel", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessageChannel;", "getChannel", "()Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessageChannel;", "onExecuteReply", "", "message", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessage;", "intellij.jupyter.core"})
public final class JupyterCellResultUserNotificationCallback
extends JupyterExecutionCallbackAdapter {
    @NotNull
    private final JupyterExecutionTask task;
    @NotNull
    private final JupyterProgressStatusChangeNotificationService userNotificationService;
    @NotNull
    private final JupyterMessageChannel channel;

    public JupyterCellResultUserNotificationCallback(@NotNull Project project, @NotNull JupyterExecutionTask task2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        this.task = task2;
        this.userNotificationService = JupyterProgressStatusChangeNotificationService.Companion.getInstance(project);
        this.channel = JupyterMessageChannel.SHELL;
    }

    @Override
    @NotNull
    public JupyterMessageChannel getChannel() {
        return this.channel;
    }

    @Override
    public void onExecuteReply(@NotNull JupyterMessage message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        NotebookIntervalPointer notebookIntervalPointer = this.task.getOptions().getCellPointer();
        if (notebookIntervalPointer == null) {
            return;
        }
        NotebookIntervalPointer cellPointer = notebookIntervalPointer;
        BackedNotebookVirtualFile notebookVirtualFile = this.task.getNotebookVirtualFile();
        JupyterExecutionStatus executionStatus = JupyterExecutionStatusKt.getStatus(message2);
        this.userNotificationService.notifyCellExecutionFinished(cellPointer, notebookVirtualFile, executionStatus);
    }
}

