/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor;

import com.intellij.jupyter.core.editor.settings.JupyterDSSettings;
import com.intellij.jupyter.core.editor.settings.JupyterShowExecutionTimeMode;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.notebooks.visualization.ui.ProgressStatus;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0011\u001a\u0004\u0018\u00010\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0007J#\u0010\u0016\u001a\t\u0018\u00010\f\u00a2\u0006\u0002\b\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0015H\u0002J(\u0010\u001b\u001a\u0004\u0018\u00010\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u001c\u001a\u0004\u0018\u00010\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0007J\u001e\u0010\u001d\u001a\u0004\u0018\u00010\f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u0015H\u0003J\u0018\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u0015H\u0007J\u0018\u0010\"\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u0015H\u0007R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0018\u0010\b\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\f8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\f8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\f8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\f8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\f8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/BelowCellExecutionStatusTextFormatter;", "", "<init>", "()V", "dateFormatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "Ljava/time/format/DateTimeFormatter;", "timeFormatter", "settings", "Lcom/intellij/jupyter/core/editor/settings/JupyterDSSettings;", "msTimeUnit", "", "sTimeUnit", "mTimeUnit", "hTimeUnit", "dTimeUnit", "getExecutionStatusText", "status", "Lcom/intellij/notebooks/visualization/ui/ProgressStatus;", "endTime", "Ljava/time/ZonedDateTime;", "getStoppedTimeTooltipText", "Lorg/jetbrains/annotations/Nls;", "err", "", "executionEndTime", "getExecutionDurationString", "startTime", "computeExecutionDuration", "executionStartTime", "presentableTimeDiff", "startDateTime", "endDateTime", "detailedTimeDiff", "intellij.jupyter.core"})
public final class BelowCellExecutionStatusTextFormatter {
    private final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy.MM.dd");
    private final DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm");
    @NotNull
    private final JupyterDSSettings settings = JupyterDSSettings.Companion.getInstance();
    @Nls
    @NotNull
    private final String msTimeUnit = JupyterBundle.message("jupyter.inlay.progress.time.unit.milliseconds", new Object[0]);
    @Nls
    @NotNull
    private final String sTimeUnit = JupyterBundle.message("jupyter.inlay.progress.time.unit.seconds", new Object[0]);
    @Nls
    @NotNull
    private final String mTimeUnit = JupyterBundle.message("jupyter.inlay.progress.time.unit.minutes", new Object[0]);
    @Nls
    @NotNull
    private final String hTimeUnit = JupyterBundle.message("jupyter.inlay.progress.time.unit.hours", new Object[0]);
    @Nls
    @NotNull
    private final String dTimeUnit = JupyterBundle.message("jupyter.inlay.progress.time.unit.days", new Object[0]);

    @Nls
    @Nullable
    public final String getExecutionStatusText(@Nullable ProgressStatus status, @Nullable ZonedDateTime endTime) {
        ProgressStatus progressStatus = status;
        return switch (progressStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[progressStatus.ordinal()]) {
            case 1 -> JupyterBundle.message("jupyter.cell.status.execution.not.started", new Object[0]);
            case 2 -> JupyterBundle.message("jupyter.cell.status.is.running", new Object[0]);
            case 3 -> JupyterBundle.message("jupyter.cell.status.queued.for.execution", new Object[0]);
            case 4 -> JupyterBundle.message("jupyter.cell.status.execution.cancelled", new Object[0]);
            case 5 -> this.getStoppedTimeTooltipText(false, endTime);
            case 6 -> this.getStoppedTimeTooltipText(true, endTime);
            case -1 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final String getStoppedTimeTooltipText(boolean err, ZonedDateTime executionEndTime) {
        String string;
        if (executionEndTime == null) {
            return null;
        }
        ZoneId userTimeZone = ZoneId.systemDefault();
        ZonedDateTime localDateTime = executionEndTime.withZoneSameInstant(userTimeZone);
        String formattedDate = localDateTime.format(this.dateFormatter);
        String formattedTime = localDateTime.format(this.timeFormatter);
        boolean bl = err;
        if (bl) {
            Object[] objectArray = new Object[]{formattedDate, formattedTime};
            string = JupyterBundle.message("jupyter.inlay.progress.time.crashed", objectArray);
        } else if (!bl) {
            Object[] objectArray = new Object[]{formattedDate, formattedTime};
            string = JupyterBundle.message("jupyter.inlay.progress.time.finished", objectArray);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    static /* synthetic */ String getStoppedTimeTooltipText$default(BelowCellExecutionStatusTextFormatter belowCellExecutionStatusTextFormatter, boolean bl, ZonedDateTime zonedDateTime, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return belowCellExecutionStatusTextFormatter.getStoppedTimeTooltipText(bl, zonedDateTime);
    }

    @Nls
    @Nullable
    public final String getExecutionDurationString(@Nullable ProgressStatus status, @Nullable ZonedDateTime startTime, @Nullable ZonedDateTime endTime) {
        ProgressStatus progressStatus = status;
        return switch (progressStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[progressStatus.ordinal()]) {
            case 5, 6 -> this.computeExecutionDuration(startTime, endTime);
            case 2 -> null;
            case -1, 1, 3, 4 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Nls
    private final String computeExecutionDuration(ZonedDateTime executionStartTime, ZonedDateTime executionEndTime) {
        if (executionStartTime == null || executionEndTime == null) {
            return null;
        }
        JupyterShowExecutionTimeMode displayMode = this.settings.getExecutionTimeShowMode();
        return switch (WhenMappings.$EnumSwitchMapping$1[displayMode.ordinal()]) {
            case 1 -> this.presentableTimeDiff(executionStartTime, executionEndTime);
            case 2 -> this.detailedTimeDiff(executionStartTime, executionEndTime);
            case 3 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Nls
    @NotNull
    public final String presentableTimeDiff(@NotNull ZonedDateTime startDateTime, @NotNull ZonedDateTime endDateTime) {
        Intrinsics.checkNotNullParameter((Object)startDateTime, (String)"startDateTime");
        Intrinsics.checkNotNullParameter((Object)endDateTime, (String)"endDateTime");
        Duration diff = Duration.between(startDateTime, endDateTime);
        return diff.compareTo(Duration.ofMillis(10L)) < 0 ? "< 10 " + this.msTimeUnit : (diff.compareTo(Duration.ofSeconds(1L)) < 0 ? diff.toMillis() + this.msTimeUnit : (diff.compareTo(Duration.ofMinutes(1L)) < 0 ? diff.toSecondsPart() + this.sTimeUnit + " " + diff.toMillisPart() + this.msTimeUnit : (diff.compareTo(Duration.ofHours(1L)) < 0 ? diff.toMinutesPart() + this.mTimeUnit + " " + diff.toSecondsPart() + this.sTimeUnit : (diff.compareTo(Duration.ofDays(1L)) < 0 ? diff.toHoursPart() + this.hTimeUnit + " " + diff.toMinutesPart() + this.mTimeUnit : diff.toDaysPart() + this.dTimeUnit + " " + diff.toHoursPart() + this.hTimeUnit + " " + diff.toMinutesPart() + this.mTimeUnit))));
    }

    @Nls
    @NotNull
    public final String detailedTimeDiff(@NotNull ZonedDateTime startDateTime, @NotNull ZonedDateTime endDateTime) {
        Intrinsics.checkNotNullParameter((Object)startDateTime, (String)"startDateTime");
        Intrinsics.checkNotNullParameter((Object)endDateTime, (String)"endDateTime");
        Duration diff = Duration.between(startDateTime, endDateTime);
        return diff.compareTo(Duration.ofSeconds(1L)) < 0 ? diff.toMillis() + this.msTimeUnit : (diff.compareTo(Duration.ofMinutes(1L)) < 0 ? diff.toSecondsPart() + this.sTimeUnit + " " + diff.toMillisPart() + this.msTimeUnit : (diff.compareTo(Duration.ofHours(1L)) < 0 ? diff.toMinutesPart() + this.mTimeUnit + " " + diff.toSecondsPart() + this.sTimeUnit + " " + diff.toMillisPart() + this.msTimeUnit : (diff.compareTo(Duration.ofDays(1L)) < 0 ? diff.toHoursPart() + this.hTimeUnit + " " + diff.toMinutesPart() + this.mTimeUnit + " " + diff.toSecondsPart() + this.sTimeUnit + " " + diff.toMillisPart() + this.msTimeUnit : diff.toDaysPart() + this.dTimeUnit + " " + diff.toHoursPart() + this.hTimeUnit + " " + diff.toMinutesPart() + this.mTimeUnit + " " + diff.toSecondsPart() + this.sTimeUnit + " " + diff.toMillisPart() + this.msTimeUnit)));
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ProgressStatus.values().length];
            try {
                nArray[ProgressStatus.NOT_STARTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProgressStatus.RUNNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProgressStatus.QUEUED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProgressStatus.CANCELLED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProgressStatus.STOPPED_OK.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProgressStatus.STOPPED_ERROR.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[JupyterShowExecutionTimeMode.values().length];
            try {
                nArray[JupyterShowExecutionTimeMode.COMPACT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterShowExecutionTimeMode.EXACT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterShowExecutionTimeMode.HIDDEN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

