/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.webHandlers;

import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.webHandlers.JupyterCefWebSocketHandler;
import com.intellij.notebooks.jupyter.core.jupyter.preview.JupyterCefHttpHandlerBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.UriUtilKt;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Base64;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.Responses;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0013\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\tH\u0002R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/webHandlers/JupyterCefHttpHandler;", "Lcom/intellij/notebooks/jupyter/core/jupyter/preview/JupyterCefHttpHandlerBase;", "<init>", "()V", "isSupported", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "appName", "", "getAppName", "()Ljava/lang/String;", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "context", "Lio/netty/channel/ChannelHandlerContext;", "loadLocalFile", "filePath", "processLocalUrl", "getLocalFileBytes", "", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterCefHttpHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterCefHttpHandler.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/webHandlers/JupyterCefHttpHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n24#2:86\n1#3:87\n*S KotlinDebug\n*F\n+ 1 JupyterCefHttpHandler.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/appBasedApi/webHandlers/JupyterCefHttpHandler\n*L\n78#1:86\n*E\n"})
public final class JupyterCefHttpHandler
extends JupyterCefHttpHandlerBase {
    @NotNull
    private final String appName;

    public JupyterCefHttpHandler() {
        super(SetsKt.emptySet());
        this.appName = "jupyter-web";
    }

    public boolean isSupported(@NotNull FullHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return super.isSupported(request) && JupyterCefWebSocketHandler.Companion.listenerExists$intellij_jupyter_core();
    }

    @NotNull
    public String getAppName() {
        return this.appName;
    }

    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = request.uri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri(...)");
        if (StringsKt.startsWith$default((String)string, (String)"/jupyter/relative_url/", (boolean)false, (int)2, null)) {
            return this.processLocalUrl(urlDecoder, request, context);
        }
        if (super.process(urlDecoder, request, context)) {
            return true;
        }
        String fullPath = urlDecoder.path();
        Intrinsics.checkNotNull((Object)fullPath);
        String filePath = this.getFileFromUrl(fullPath);
        return filePath != null ? this.loadLocalFile(filePath, request, context) : false;
    }

    private final boolean loadLocalFile(String filePath, FullHttpRequest request, ChannelHandlerContext context) {
        byte[] bytes = this.getLocalFileBytes(request, filePath);
        if (bytes != null) {
            Channel channel = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
            EmptyHttpHeaders emptyHttpHeaders = EmptyHttpHeaders.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)emptyHttpHeaders, (String)"INSTANCE");
            this.sendData(bytes, filePath, request, channel, (HttpHeaders)emptyHttpHeaders);
        } else {
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"NOT_FOUND");
            Channel channel = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
            Responses.send$default((HttpResponseStatus)httpResponseStatus, (Channel)channel, (HttpRequest)((HttpRequest)request), null, null, (int)12, null);
        }
        return true;
    }

    private final boolean processLocalUrl(QueryStringDecoder urlDecoder, FullHttpRequest request, ChannelHandlerContext context) {
        String string = urlDecoder.path();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path(...)");
        String base64path = StringsKt.substringAfter$default((String)string, (String)"/jupyter/relative_url/", null, (int)2, null);
        byte[] byArray = Base64.getUrlDecoder().decode(base64path);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        byte[] byArray2 = byArray;
        String decodedPath = new String(byArray2, Charsets.UTF_8);
        return this.loadLocalFile(decodedPath, request, context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final byte[] getLocalFileBytes(FullHttpRequest request, String filePath) {
        Path path;
        Object object;
        String string = request.headers().get((CharSequence)HttpHeaderNames.REFERER);
        if (string == null) {
            return null;
        }
        String refererUri = string;
        String string2 = (String)UriUtilKt.getQueryParameters((URI)new URI(refererUri)).get("url");
        if (string2 == null) {
            return null;
        }
        String wsUrlStr = string2;
        URI wsUrl = new URI(wsUrlStr);
        if (!Intrinsics.areEqual((Object)wsUrl.getScheme(), (Object)"ws")) {
            return null;
        }
        String string3 = (String)UriUtilKt.getQueryParameters((URI)wsUrl).get("uuid");
        if (string3 == null) {
            return null;
        }
        String uuidStr = string3;
        try {
            object = UUID.fromString(uuidStr);
        }
        catch (IllegalArgumentException e) {
            JupyterCefHttpHandler $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterCefHttpHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unable to decode UUID: " + uuidStr, (Throwable)e);
            return null;
        }
        UUID uuid = object;
        Intrinsics.checkNotNull((Object)uuid);
        object = JupyterCefWebSocketHandler.Companion.getListener(uuid);
        if (object == null) return null;
        Path path2 = object.resolveFilePath(filePath);
        if (path2 == null) return null;
        Path it = path = path2;
        boolean bl = false;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return null;
        Path path3 = path;
        Path path4 = path3;
        if (path4 == null) return null;
        byte[] byArray = Files.readAllBytes(path4);
        byte[] byArray2 = byArray;
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
        return byArray2;
    }
}

