/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.portForwarding.utils.WindowsProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 49891180159843L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-840027630 + -((char)-20914), -840027630 + -((char)-32385), (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-840027630 + -((char)-20915), 840027630 + 30739, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 118796619969485L;
                thread = Thread.currentThread();
                String[] stringArray = SshAgentIpcService.z();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (stringArray == null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-2119532970 - -21778, -2119532970 - -20541, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-2119532970 - -21779, 2119532970 - 17366, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-2119532970 - -21784, 2119532970 - 4477, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                String[] stringArray;
                l2 = 88769818175057L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    stringArray = SshAgentIpcService.z();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1434167940 - -((char)-20105), 1434167940 - (char)-19123, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1434167940 - -((char)-20108), 1434036870 + (char)-4517, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        this.hPipe = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        windowsNamedPipeAgentIpc = this;
                        if (stringArray == null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-1434167940 - -((char)-20107), -1434036870 + -((char)-9114), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1434167940 - -((char)-20094), -1434036870 + -((char)-2321), (int)l2) + WindowsProcessInfoUtil.INSTANCE.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1434167940 - -((char)-20093), -1434167940 - -((char)-8688), (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-1434167940 - -((char)-20107), -1434036870 + -((char)-9114), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1434167940 - -((char)-20096), -1434036870 + -((char)-4358), (int)l2));
            if (ActionTimestamp.z() == null) {
                SshAgentIpcService.z(new String[4]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                String[] stringArray;
                block6: {
                    long l2 = 88471247591035L;
                    stringArray = SshAgentIpcService.z();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (stringArray == null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (stringArray == null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        String[] stringArray;
        long l2;
        block27: {
            block28: {
                l2 = 45462562425701L;
                String[] stringArray2 = SshAgentIpcService.z();
                this.assertConnectionThread();
                stringArray = stringArray2;
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (stringArray == null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-333573150 + -10265, -333573150 + -8195, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-333573150 + -10269, -333573150 + -32706, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-333573150 + -10260, -333573150 + -13653, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-333573150 + -10269, -333573150 + -32706, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-333573150 + -10259, 333573150 + 28484, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-333573150 + -10265, -333573150 + -8195, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-333573150 + -10269, -333573150 + -32706, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-333573150 + -10262, 333573150 + 32697, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (stringArray == null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-333573150 + -10265, -333573150 + -8195, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-333573150 + -10269, -333573150 + -32706, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-333573150 + -10261, 333573150 + 24554, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-333573150 + -10269, -333573150 + -32706, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-333573150 + -10256, 333573150 + 9814, (int)l2) + WindowsProcessInfoUtil.INSTANCE.prettyHRESULT(n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (stringArray == null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(-333573150 + -10269, -333573150 + -32706, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-333573150 + -10259, 333573150 + 28484, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-333573150 + -10265, -333573150 + -8195, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-333573150 + -10269, -333573150 + -32706, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-333573150 + -10255, 333573150 + 15547, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 88034139137868L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(194507880 - (char)-20894, -194507880 - -32028, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 102564076448642L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(257421480 - 9695, -257421480 - -8008, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "z\u0006\u0086>{\u00fc\f\u0005;3R\u00a5<\u00a5rhP\u00b6\u0094\u0014\t\u00e7\u00e8\u0004\u00ady\u00ab0M\u0093Ye\u009fD\u00c7\u00df\u000b\u0086\u00f89";
                        var4_3 = "z\u0006\u0086>{\u00fc\f\u0005;3R\u00a5<\u00a5rhP\u00b6\u0094\u0014\t\u00e7\u00e8\u0004\u00ady\u00ab0M\u0093Ye\u009fD\u00c7\u00df\u000b\u0086\u00f89".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 117;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 69;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 13;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 110;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 4;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 74;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 112;
                                        break;
                                    }
                                    default: {
                                        v11 = 39;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x214A) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 96;
                            case 1 -> 211;
                            case 2 -> 29;
                            case 3 -> 184;
                            case 4 -> 45;
                            case 5 -> 12;
                            case 6 -> 5;
                            case 7 -> 120;
                            case 8 -> 239;
                            case 9 -> 46;
                            case 10 -> 154;
                            case 11 -> 230;
                            case 12 -> 23;
                            case 13 -> 75;
                            case 14 -> 232;
                            case 15 -> 32;
                            case 16 -> 164;
                            case 17 -> 19;
                            case 18 -> 201;
                            case 19 -> 234;
                            case 20 -> 91;
                            case 21 -> 7;
                            case 22 -> 59;
                            case 23 -> 155;
                            case 24 -> 168;
                            case 25 -> 79;
                            case 26 -> 210;
                            case 27 -> 207;
                            case 28 -> 10;
                            case 29 -> 66;
                            case 30 -> 222;
                            case 31 -> 255;
                            case 32 -> 126;
                            case 33 -> 132;
                            case 34 -> 218;
                            case 35 -> 117;
                            case 36 -> 202;
                            case 37 -> 63;
                            case 38 -> 243;
                            case 39 -> 61;
                            case 40 -> 215;
                            case 41 -> 68;
                            case 42 -> 227;
                            case 43 -> 74;
                            case 44 -> 111;
                            case 45 -> 244;
                            case 46 -> 226;
                            case 47 -> 242;
                            case 48 -> 107;
                            case 49 -> 106;
                            case 50 -> 214;
                            case 51 -> 18;
                            case 52 -> 83;
                            case 53 -> 228;
                            case 54 -> 0;
                            case 55 -> 129;
                            case 56 -> 101;
                            case 57 -> 203;
                            case 58 -> 17;
                            case 59 -> 157;
                            case 60 -> 14;
                            case 61 -> 99;
                            case 62 -> 44;
                            case 63 -> 179;
                            case 64 -> 25;
                            case 65 -> 3;
                            case 66 -> 37;
                            case 67 -> 181;
                            case 68 -> 26;
                            case 69 -> 170;
                            case 70 -> 86;
                            case 71 -> 81;
                            case 72 -> 206;
                            case 73 -> 169;
                            case 74 -> 212;
                            case 75 -> 21;
                            case 76 -> 172;
                            case 77 -> 51;
                            case 78 -> 116;
                            case 79 -> 208;
                            case 80 -> 173;
                            case 81 -> 100;
                            case 82 -> 84;
                            case 83 -> 89;
                            case 84 -> 158;
                            case 85 -> 109;
                            case 86 -> 33;
                            case 87 -> 241;
                            case 88 -> 209;
                            case 89 -> 24;
                            case 90 -> 20;
                            case 91 -> 199;
                            case 92 -> 127;
                            case 93 -> 225;
                            case 94 -> 42;
                            case 95 -> 216;
                            case 96 -> 196;
                            case 97 -> 36;
                            case 98 -> 177;
                            case 99 -> 85;
                            case 100 -> 128;
                            case 101 -> 97;
                            case 102 -> 194;
                            case 103 -> 229;
                            case 104 -> 143;
                            case 105 -> 82;
                            case 106 -> 60;
                            case 107 -> 31;
                            case 108 -> 151;
                            case 109 -> 217;
                            case 110 -> 162;
                            case 111 -> 95;
                            case 112 -> 188;
                            case 113 -> 187;
                            case 114 -> 231;
                            case 115 -> 182;
                            case 116 -> 189;
                            case 117 -> 123;
                            case 118 -> 135;
                            case 119 -> 39;
                            case 120 -> 67;
                            case 121 -> 224;
                            case 122 -> 156;
                            case 123 -> 146;
                            case 124 -> 16;
                            case 125 -> 110;
                            case 126 -> 114;
                            case 127 -> 159;
                            case 128 -> 15;
                            case 129 -> 30;
                            case 130 -> 72;
                            case 131 -> 200;
                            case 132 -> 145;
                            case 133 -> 219;
                            case 134 -> 139;
                            case 135 -> 50;
                            case 136 -> 246;
                            case 137 -> 90;
                            case 138 -> 220;
                            case 139 -> 171;
                            case 140 -> 180;
                            case 141 -> 76;
                            case 142 -> 88;
                            case 143 -> 55;
                            case 144 -> 235;
                            case 145 -> 237;
                            case 146 -> 62;
                            case 147 -> 28;
                            case 148 -> 71;
                            case 149 -> 41;
                            case 150 -> 195;
                            case 151 -> 48;
                            case 152 -> 165;
                            case 153 -> 69;
                            case 154 -> 149;
                            case 155 -> 22;
                            case 156 -> 130;
                            case 157 -> 186;
                            case 158 -> 240;
                            case 159 -> 124;
                            case 160 -> 238;
                            case 161 -> 92;
                            case 162 -> 6;
                            case 163 -> 40;
                            case 164 -> 204;
                            case 165 -> 150;
                            case 166 -> 166;
                            case 167 -> 49;
                            case 168 -> 87;
                            case 169 -> 122;
                            case 170 -> 102;
                            case 171 -> 233;
                            case 172 -> 253;
                            case 173 -> 147;
                            case 174 -> 245;
                            case 175 -> 11;
                            case 176 -> 197;
                            case 177 -> 43;
                            case 178 -> 152;
                            case 179 -> 133;
                            case 180 -> 153;
                            case 181 -> 175;
                            case 182 -> 118;
                            case 183 -> 93;
                            case 184 -> 2;
                            case 185 -> 98;
                            case 186 -> 236;
                            case 187 -> 112;
                            case 188 -> 125;
                            case 189 -> 141;
                            case 190 -> 53;
                            case 191 -> 13;
                            case 192 -> 193;
                            case 193 -> 38;
                            case 194 -> 163;
                            case 195 -> 183;
                            case 196 -> 223;
                            case 197 -> 248;
                            case 198 -> 119;
                            case 199 -> 138;
                            case 200 -> 1;
                            case 201 -> 142;
                            case 202 -> 192;
                            case 203 -> 131;
                            case 204 -> 108;
                            case 205 -> 190;
                            case 206 -> 247;
                            case 207 -> 56;
                            case 208 -> 104;
                            case 209 -> 249;
                            case 210 -> 176;
                            case 211 -> 251;
                            case 212 -> 27;
                            case 213 -> 52;
                            case 214 -> 103;
                            case 215 -> 185;
                            case 216 -> 178;
                            case 217 -> 136;
                            case 218 -> 77;
                            case 219 -> 58;
                            case 220 -> 174;
                            case 221 -> 115;
                            case 222 -> 70;
                            case 223 -> 4;
                            case 224 -> 113;
                            case 225 -> 73;
                            case 226 -> 140;
                            case 227 -> 9;
                            case 228 -> 64;
                            case 229 -> 80;
                            case 230 -> 198;
                            case 231 -> 144;
                            case 232 -> 252;
                            case 233 -> 78;
                            case 234 -> 148;
                            case 235 -> 205;
                            case 236 -> 221;
                            case 237 -> 134;
                            case 238 -> 121;
                            case 239 -> 8;
                            case 240 -> 47;
                            case 241 -> 191;
                            case 242 -> 137;
                            case 243 -> 35;
                            case 244 -> 54;
                            case 245 -> 161;
                            case 246 -> 65;
                            case 247 -> 250;
                            case 248 -> 167;
                            case 249 -> 105;
                            case 250 -> 160;
                            case 251 -> 34;
                            case 252 -> 213;
                            case 253 -> 254;
                            case 254 -> 57;
                            default -> 94;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (stringArray == null) {
                ActionTimestamp.z("d6Yctc");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 120505834654653L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    String[] stringArray = SshAgentIpcService.z();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (stringArray == null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1937214600 + -2151, -1937214600 + -113, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1937214600 + -2139, -1937214600 + -24192, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1937214600 + -2160, -1937214600 + -17873, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1937214600 + -2151, -1937214600 + -113, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-1937214600 + -2139, -1937214600 + -24192, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1937214600 + -2159, 1937214600 + 15509, (int)l3) + WindowsProcessInfoUtil.INSTANCE.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    String[] stringArray;
                    block13: {
                        long l2 = 139235347831959L;
                        String[] stringArray2 = SshAgentIpcService.z();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-1098104460 - -((char)-1360), -1098104460 - -((char)-3349), (int)l2));
                        stringArray = stringArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (stringArray == null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (stringArray == null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-1098104460 - -((char)-1359), -1098104460 - -((char)-15263), (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (stringArray == null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        String[] stringArray;
        long l2;
        block25: {
            block26: {
                l2 = 34452116349737L;
                String[] stringArray2 = SshAgentIpcService.z();
                this.assertConnectionThread();
                Object object2 = this.lock;
                stringArray = stringArray2;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (stringArray == null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (stringArray == null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2111275560 + 349, 2111275560 + 6507, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(2111275560 + 353, 2111275560 + 31300, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2111275560 + 368, 2111275560 + 1398, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(2111275560 + 353, 2111275560 + 31300, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2111275560 + 347, -2111275560 + -19114, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2111275560 + 349, 2111275560 + 6507, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(2111275560 + 353, 2111275560 + 31300, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2111275560 + 369, -2111275560 + -2169, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (stringArray == null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2111275560 + 349, 2111275560 + 6507, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(2111275560 + 353, 2111275560 + 31300, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2111275560 + 366, 2111275560 + 26664, (int)l2) + WindowsProcessInfoUtil.INSTANCE.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (stringArray == null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2111275560 + 349, 2111275560 + 6507, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(2111275560 + 353, 2111275560 + 31300, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2111275560 + 367, -2111275560 + -21590, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                String[] stringArray;
                block16: {
                    l2 = 77972333424546L;
                    Object object = this.lock;
                    stringArray = SshAgentIpcService.z();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (stringArray == null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1497081540 + -((char)-30162), -1497081540 + -((char)-32220), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1497081540 + -((char)-30150), -1497081540 + -((char)-22443), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1497081540 + -((char)-30179), 1497081540 + (char)-30130, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-1497081540 + -((char)-30178), 1497081540 + (char)-28446, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1497081540 + -((char)-30162), -1497081540 + -((char)-32220), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1497081540 + -((char)-30150), -1497081540 + -((char)-22443), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1497081540 + -((char)-30173), -1497081540 + -((char)-29820), (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (stringArray == null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (stringArray == null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1497081540 + -((char)-30162), -1497081540 + -((char)-32220), (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-1497081540 + -((char)-30150), -1497081540 + -((char)-22443), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1497081540 + -((char)-30172), -1497081540 + -28693, (int)l2) + WindowsProcessInfoUtil.INSTANCE.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1497081540 + -((char)-30162), -1497081540 + -((char)-32220), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1497081540 + -((char)-30150), -1497081540 + -((char)-22443), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1497081540 + -((char)-30175), -1497081540 + -26355, (int)l2));
                    if (stringArray == null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1497081540 + -((char)-30162), -1497081540 + -((char)-32220), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1497081540 + -((char)-30150), -1497081540 + -((char)-22443), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1497081540 + -((char)-30174), -1497081540 + -((char)-21725), (int)l2) + WindowsProcessInfoUtil.INSTANCE.kernel32LastError());
            }
            this.hPipe = WinNT.INVALID_HANDLE_VALUE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[32];
                var3_1 = 0;
                var2_2 = "\u00afW\u001aRd\u00ac\u00e4\u00a2\u00148r\u00d0\u0011\u00c3L\u00bf\u00a4K\u0080\u00ff4zI\u00c7\u00aa\u00ec\u001c\u00a8M\u0006?\u008b\b\u00c9L\u009e\u0018K\u0093\u00de\u001d\u0080\b\u00d5\u00ec\u00ce\u00f4@\u00ca\u00ebi\u00a7,I\u00a52\u00e7\u00bd\u0084\u0011\u0085\t\u0098\u00b3:\u00a8w!3\u0081.\u0005\u00f6B1\u00f0q\bRx\u00a5\u00c6\u00c1\u0018V\u00d6\u0005\u001b*\u008c\u00fd\u00c6\u001e\u00a2\u00d8\u00ae\u00c7\u001f\u0097\u0084eA\u00d1\u00fa\u00e9\u00f0-f\u00c0\u0090\u00a9\u00db\u0092,\u0005/x$\u008eU\u00c4\u00f6\u001f\u0010\u00b6N\u00c8\u00d0\u0084G\u0001\u0086\u008c\u001f\u00ce\u00cdp\u00fc\u00d9e\tY\u0016\u00d4\r\u00f9\u00b2\u00c4l>\u0010\u0006D\u00de\u0091FoY\u0083\u0087\u00bf\u00af\u00d9\\~\\5?d\u0083~\u00ac\b\u00f3\u00e3\u0085\u00dc\u001c\f\u00ab\u0091\u0093w.w\u0011Z@\u0092\r\u0083\u001f\u00a1\u008a\u00e8\u00f0v\u00cf\u00a86\u00be\u00d7\u00d9\u0088\u0091\u001b\u00d8I\u00da\u00c4\u0083\u00e5\u00f0\u0006\u00dbY\u009f\u00a2\u008c\u009bb\u0005\u00bf\u00b6?vV+M\u0003(\b\u0086\u00c1?\u00f1\u0092\u00fe<\n\f\u00c7-\u0007w\u0088L\u0091[\u00b7\u00ec\u00fb\u00b7FTfu\u001e\u00c6aX\u00fe\u008eT\u00d6d\\b\u00d16_u_c ;\u00d6\u00eb=?\u0088M\u00c5Q\u00e4\u00d9\u000b\u009c\u00ad\u00c0\u00c5_\u00f9\u0005mX\u00fe\u008d\u0081\u008e\u00a157\u00d7\u00ff\u009f\u00e3\u0013\u0099od9\u00ab~\u00c1\u00c0\u00e5\u00e0\u00acY\u0095\u00a3\u00d6\u0013\u001f8(\u00fd\u00d9uT\u00c9\u001d\u00e8\u00de\u00cf\bV\f\u00b9U\u0010\u00f3\u00b6\u0013J\u00b54\u00c5&\u00e9\u0002\u00e4\u0001\u00ea~\u000b\u00baK\u00a8\u00bb}\u00d5/h`\u0086\u000b\u0015\u000e\u009a>\u0082\u00a8\u009ay\u00fc\u0094\u00f4]\u0086\u00baq9\u00ac\u00fbX\u0016\u001fh)\u000b\u00fd\u009bc\u00b9\u0003P\u00f7\u00db\u0083\u00a9\u00a3\u009es>\u00bf\u00bf&\u0098\u000e\u007fnT\u00a6E\u00cc\u00b98Y\u0085\u00f7}\u0097\u00adXke7f\u00a1=\u0007]=[a\u0085\u001eL\u0007\u00fb\u00d0\u00eb\u00b0t\u00cbd(\u0003\u001d\u00d6^\u00a0\u00ce\u0085i\u0011\u0087\u00da\u0015\u00d3$\u00d5\u00d6\u00c5\u00a6y]\":\u0090\u00e7MX\u000e\u00d1\u0098\u00d8\u0014\u00cf\u0010\u00906a\u0012\u000b\u001b\u00d5\u000f\u00ce\u00b6!\u0002\u00b6)\u00e2V\u0088\u00edH\t!\u00f3\u0015\"\u00fbS\u0085\u00b6z\u00b9(\u00a0\u00d4iH\u00fe\u00a1\u00d4\u00bd\u0085$Ha\u0081\u00aa\u009fN\u00c8\u0095Un\u00d5\u0087\n\u008e\u008b\u0096\u0080\u000e\u00dd:C\u0093\u00fa\u001bk\u0010\u00b9%n\u0010\u00e9\u00da\u001b\u00f6\u00fc!NM\u0015\b\u008d\u0082\u0011\u0084\u0097\u00e4\u001c3\u008a]\u0003\u00f3t\u00c3\u0015\u0010?\u0015\u00c6+\n/\u001d\u00deu\u00a6\u0096\u00a6\u00d7\u00fc8\u0018\u000e\u00de>\u0007\u00af\u0080ua3Ep\u0082\u00c3\u00ed+\u0095)\u00e1\u00aaQ\u0090\u00fa!\u0091)\u00e6\u00b9&\u00eb\u000e\u0012\u00a6\u00d5\u0005\u00c7r+\u00e1kN\u00c7\u00cf\\I\u0084\u007f/\u001d\u0082\u0019\u00da\u00af\u0016\u00c8\u001c~\u00df\u0083'\u000f\u00aeQ\u00ab\u00e02\u00ed";
                var4_3 = "\u00afW\u001aRd\u00ac\u00e4\u00a2\u00148r\u00d0\u0011\u00c3L\u00bf\u00a4K\u0080\u00ff4zI\u00c7\u00aa\u00ec\u001c\u00a8M\u0006?\u008b\b\u00c9L\u009e\u0018K\u0093\u00de\u001d\u0080\b\u00d5\u00ec\u00ce\u00f4@\u00ca\u00ebi\u00a7,I\u00a52\u00e7\u00bd\u0084\u0011\u0085\t\u0098\u00b3:\u00a8w!3\u0081.\u0005\u00f6B1\u00f0q\bRx\u00a5\u00c6\u00c1\u0018V\u00d6\u0005\u001b*\u008c\u00fd\u00c6\u001e\u00a2\u00d8\u00ae\u00c7\u001f\u0097\u0084eA\u00d1\u00fa\u00e9\u00f0-f\u00c0\u0090\u00a9\u00db\u0092,\u0005/x$\u008eU\u00c4\u00f6\u001f\u0010\u00b6N\u00c8\u00d0\u0084G\u0001\u0086\u008c\u001f\u00ce\u00cdp\u00fc\u00d9e\tY\u0016\u00d4\r\u00f9\u00b2\u00c4l>\u0010\u0006D\u00de\u0091FoY\u0083\u0087\u00bf\u00af\u00d9\\~\\5?d\u0083~\u00ac\b\u00f3\u00e3\u0085\u00dc\u001c\f\u00ab\u0091\u0093w.w\u0011Z@\u0092\r\u0083\u001f\u00a1\u008a\u00e8\u00f0v\u00cf\u00a86\u00be\u00d7\u00d9\u0088\u0091\u001b\u00d8I\u00da\u00c4\u0083\u00e5\u00f0\u0006\u00dbY\u009f\u00a2\u008c\u009bb\u0005\u00bf\u00b6?vV+M\u0003(\b\u0086\u00c1?\u00f1\u0092\u00fe<\n\f\u00c7-\u0007w\u0088L\u0091[\u00b7\u00ec\u00fb\u00b7FTfu\u001e\u00c6aX\u00fe\u008eT\u00d6d\\b\u00d16_u_c ;\u00d6\u00eb=?\u0088M\u00c5Q\u00e4\u00d9\u000b\u009c\u00ad\u00c0\u00c5_\u00f9\u0005mX\u00fe\u008d\u0081\u008e\u00a157\u00d7\u00ff\u009f\u00e3\u0013\u0099od9\u00ab~\u00c1\u00c0\u00e5\u00e0\u00acY\u0095\u00a3\u00d6\u0013\u001f8(\u00fd\u00d9uT\u00c9\u001d\u00e8\u00de\u00cf\bV\f\u00b9U\u0010\u00f3\u00b6\u0013J\u00b54\u00c5&\u00e9\u0002\u00e4\u0001\u00ea~\u000b\u00baK\u00a8\u00bb}\u00d5/h`\u0086\u000b\u0015\u000e\u009a>\u0082\u00a8\u009ay\u00fc\u0094\u00f4]\u0086\u00baq9\u00ac\u00fbX\u0016\u001fh)\u000b\u00fd\u009bc\u00b9\u0003P\u00f7\u00db\u0083\u00a9\u00a3\u009es>\u00bf\u00bf&\u0098\u000e\u007fnT\u00a6E\u00cc\u00b98Y\u0085\u00f7}\u0097\u00adXke7f\u00a1=\u0007]=[a\u0085\u001eL\u0007\u00fb\u00d0\u00eb\u00b0t\u00cbd(\u0003\u001d\u00d6^\u00a0\u00ce\u0085i\u0011\u0087\u00da\u0015\u00d3$\u00d5\u00d6\u00c5\u00a6y]\":\u0090\u00e7MX\u000e\u00d1\u0098\u00d8\u0014\u00cf\u0010\u00906a\u0012\u000b\u001b\u00d5\u000f\u00ce\u00b6!\u0002\u00b6)\u00e2V\u0088\u00edH\t!\u00f3\u0015\"\u00fbS\u0085\u00b6z\u00b9(\u00a0\u00d4iH\u00fe\u00a1\u00d4\u00bd\u0085$Ha\u0081\u00aa\u009fN\u00c8\u0095Un\u00d5\u0087\n\u008e\u008b\u0096\u0080\u000e\u00dd:C\u0093\u00fa\u001bk\u0010\u00b9%n\u0010\u00e9\u00da\u001b\u00f6\u00fc!NM\u0015\b\u008d\u0082\u0011\u0084\u0097\u00e4\u001c3\u008a]\u0003\u00f3t\u00c3\u0015\u0010?\u0015\u00c6+\n/\u001d\u00deu\u00a6\u0096\u00a6\u00d7\u00fc8\u0018\u000e\u00de>\u0007\u00af\u0080ua3Ep\u0082\u00c3\u00ed+\u0095)\u00e1\u00aaQ\u0090\u00fa!\u0091)\u00e6\u00b9&\u00eb\u000e\u0012\u00a6\u00d5\u0005\u00c7r+\u00e1kN\u00c7\u00cf\\I\u0084\u007f/\u001d\u0082\u0019\u00da\u00af\u0016\u00c8\u001c~\u00df\u0083'\u000f\u00aeQ\u00ab\u00e02\u00ed".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 68;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "C\u00a9\u00d9\u00aa\u001c\u00c7`\u00d7Y\u001d\u00df\u0081O\u00a2mu\u0084w\u000f\u00dd}&N\u0084\u00f5t\u00f6hp\u00c8C\u00d7'\r\u00bby$ig";
                    var4_3 = "C\u00a9\u00d9\u00aa\u001c\u00c7`\u00d7Y\u001d\u00df\u0081O\u00a2mu\u0084w\u000f\u00dd}&N\u0084\u00f5t\u00f6hp\u00c8C\u00d7'\r\u00bby$ig".length();
                    var1_4 = 9;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 111;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 83;
                            break;
                        }
                        case 1: {
                            v15 = 17;
                            break;
                        }
                        case 2: {
                            v15 = 71;
                            break;
                        }
                        case 3: {
                            v15 = 119;
                            break;
                        }
                        case 4: {
                            v15 = 45;
                            break;
                        }
                        case 5: {
                            v15 = 108;
                            break;
                        }
                        default: {
                            v15 = 47;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[32];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFFA0A7) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 19;
                case 1 -> 245;
                case 2 -> 197;
                case 3 -> 3;
                case 4 -> 66;
                case 5 -> 79;
                case 6 -> 193;
                case 7 -> 43;
                case 8 -> 120;
                case 9 -> 192;
                case 10 -> 83;
                case 11 -> 44;
                case 12 -> 201;
                case 13 -> 45;
                case 14 -> 31;
                case 15 -> 28;
                case 16 -> 219;
                case 17 -> 68;
                case 18 -> 42;
                case 19 -> 181;
                case 20 -> 131;
                case 21 -> 95;
                case 22 -> 117;
                case 23 -> 180;
                case 24 -> 203;
                case 25 -> 247;
                case 26 -> 51;
                case 27 -> 222;
                case 28 -> 122;
                case 29 -> 67;
                case 30 -> 109;
                case 31 -> 184;
                case 32 -> 173;
                case 33 -> 148;
                case 34 -> 48;
                case 35 -> 119;
                case 36 -> 241;
                case 37 -> 90;
                case 38 -> 18;
                case 39 -> 183;
                case 40 -> 6;
                case 41 -> 155;
                case 42 -> 176;
                case 43 -> 27;
                case 44 -> 253;
                case 45 -> 132;
                case 46 -> 104;
                case 47 -> 252;
                case 48 -> 13;
                case 49 -> 103;
                case 50 -> 50;
                case 51 -> 167;
                case 52 -> 116;
                case 53 -> 161;
                case 54 -> 15;
                case 55 -> 121;
                case 56 -> 240;
                case 57 -> 0;
                case 58 -> 215;
                case 59 -> 238;
                case 60 -> 216;
                case 61 -> 12;
                case 62 -> 188;
                case 63 -> 156;
                case 64 -> 107;
                case 65 -> 152;
                case 66 -> 9;
                case 67 -> 244;
                case 68 -> 130;
                case 69 -> 49;
                case 70 -> 137;
                case 71 -> 178;
                case 72 -> 128;
                case 73 -> 251;
                case 74 -> 142;
                case 75 -> 25;
                case 76 -> 102;
                case 77 -> 82;
                case 78 -> 93;
                case 79 -> 170;
                case 80 -> 171;
                case 81 -> 140;
                case 82 -> 232;
                case 83 -> 114;
                case 84 -> 191;
                case 85 -> 36;
                case 86 -> 52;
                case 87 -> 248;
                case 88 -> 185;
                case 89 -> 69;
                case 90 -> 123;
                case 91 -> 71;
                case 92 -> 157;
                case 93 -> 229;
                case 94 -> 255;
                case 95 -> 168;
                case 96 -> 254;
                case 97 -> 150;
                case 98 -> 239;
                case 99 -> 182;
                case 100 -> 160;
                case 101 -> 73;
                case 102 -> 33;
                case 103 -> 145;
                case 104 -> 139;
                case 105 -> 112;
                case 106 -> 80;
                case 107 -> 57;
                case 108 -> 26;
                case 109 -> 235;
                case 110 -> 249;
                case 111 -> 70;
                case 112 -> 17;
                case 113 -> 212;
                case 114 -> 127;
                case 115 -> 159;
                case 116 -> 169;
                case 117 -> 199;
                case 118 -> 77;
                case 119 -> 209;
                case 120 -> 223;
                case 121 -> 108;
                case 122 -> 20;
                case 123 -> 16;
                case 124 -> 204;
                case 125 -> 195;
                case 126 -> 38;
                case 127 -> 166;
                case 128 -> 236;
                case 129 -> 11;
                case 130 -> 206;
                case 131 -> 202;
                case 132 -> 144;
                case 133 -> 21;
                case 134 -> 41;
                case 135 -> 221;
                case 136 -> 85;
                case 137 -> 105;
                case 138 -> 136;
                case 139 -> 205;
                case 140 -> 218;
                case 141 -> 64;
                case 142 -> 53;
                case 143 -> 61;
                case 144 -> 208;
                case 145 -> 92;
                case 146 -> 97;
                case 147 -> 133;
                case 148 -> 175;
                case 149 -> 58;
                case 150 -> 115;
                case 151 -> 224;
                case 152 -> 210;
                case 153 -> 230;
                case 154 -> 220;
                case 155 -> 113;
                case 156 -> 2;
                case 157 -> 143;
                case 158 -> 35;
                case 159 -> 29;
                case 160 -> 189;
                case 161 -> 23;
                case 162 -> 14;
                case 163 -> 63;
                case 164 -> 231;
                case 165 -> 88;
                case 166 -> 111;
                case 167 -> 190;
                case 168 -> 5;
                case 169 -> 74;
                case 170 -> 55;
                case 171 -> 62;
                case 172 -> 196;
                case 173 -> 37;
                case 174 -> 84;
                case 175 -> 151;
                case 176 -> 174;
                case 177 -> 99;
                case 178 -> 198;
                case 179 -> 227;
                case 180 -> 207;
                case 181 -> 75;
                case 182 -> 172;
                case 183 -> 138;
                case 184 -> 40;
                case 185 -> 211;
                case 186 -> 94;
                case 187 -> 158;
                case 188 -> 134;
                case 189 -> 76;
                case 190 -> 234;
                case 191 -> 177;
                case 192 -> 233;
                case 193 -> 7;
                case 194 -> 10;
                case 195 -> 179;
                case 196 -> 118;
                case 197 -> 34;
                case 198 -> 165;
                case 199 -> 86;
                case 200 -> 81;
                case 201 -> 39;
                case 202 -> 187;
                case 203 -> 135;
                case 204 -> 129;
                case 205 -> 194;
                case 206 -> 98;
                case 207 -> 96;
                case 208 -> 200;
                case 209 -> 153;
                case 210 -> 54;
                case 211 -> 124;
                case 212 -> 47;
                case 213 -> 56;
                case 214 -> 228;
                case 215 -> 78;
                case 216 -> 32;
                case 217 -> 147;
                case 218 -> 87;
                case 219 -> 59;
                case 220 -> 1;
                case 221 -> 164;
                case 222 -> 60;
                case 223 -> 154;
                case 224 -> 89;
                case 225 -> 213;
                case 226 -> 246;
                case 227 -> 226;
                case 228 -> 106;
                case 229 -> 100;
                case 230 -> 242;
                case 231 -> 24;
                case 232 -> 30;
                case 233 -> 214;
                case 234 -> 141;
                case 235 -> 250;
                case 236 -> 163;
                case 237 -> 101;
                case 238 -> 46;
                case 239 -> 149;
                case 240 -> 110;
                case 241 -> 186;
                case 242 -> 217;
                case 243 -> 91;
                case 244 -> 125;
                case 245 -> 72;
                case 246 -> 162;
                case 247 -> 65;
                case 248 -> 146;
                case 249 -> 237;
                case 250 -> 22;
                case 251 -> 4;
                case 252 -> 225;
                case 253 -> 243;
                case 254 -> 126;
                default -> 8;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 111483402541646L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1063633050 - (char)-15551, 1063501980 + (char)-8823, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        String[] stringArray;
                        block4: {
                            l2 = 32027029830638L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            stringArray = SshAgentIpcService.z();
                            try {
                                hANDLE2 = hANDLE;
                                if (stringArray == null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (stringArray == null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(541319100 - 708, 541319100 - 18938, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(541319100 - 705, 541319100 - 20014, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(541319100 - 706, -541319100 - -24062, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "c\u009fy\u00e0nj\u001b\u001e\u0010\u0088\u008e\u00f5cE\u00a1\u0087>$\u00f2p\u001679U\u00a5";
                    var4_3 = "c\u009fy\u00e0nj\u001b\u001e\u0010\u0088\u008e\u00f5cE\u00a1\u0087>$\u00f2p\u001679U\u00a5".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 94;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00bd\u0014\u00d5\u00e6\u00fc5\u0087\u00dc\u0085\u0093$\u00f1\u00c4\u00e8L\u00e4\u0098c\u00aa\n\u0094>\u0098\u0006!\u00d4(\twF\u0082\u001ft\u00a1f\u00da\u00f6\u000f\u0098\u00ab\u00d0Uz\u0007=\u00b01\u001dz9\u0017\u00aa\u00c4\u00b9\u0001[C\f\u0002";
                        var4_3 = "\u00bd\u0014\u00d5\u00e6\u00fc5\u0087\u00dc\u0085\u0093$\u00f1\u00c4\u00e8L\u00e4\u0098c\u00aa\n\u0094>\u0098\u0006!\u00d4(\twF\u0082\u001ft\u00a1f\u00da\u00f6\u000f\u0098\u00ab\u00d0Uz\u0007=\u00b01\u001dz9\u0017\u00aa\u00c4\u00b9\u0001[C\f\u0002".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 38;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 14;
                                break;
                            }
                            case 1: {
                                v15 = 52;
                                break;
                            }
                            case 2: {
                                v15 = 79;
                                break;
                            }
                            case 3: {
                                v15 = 33;
                                break;
                            }
                            case 4: {
                                v15 = 19;
                                break;
                            }
                            case 5: {
                                v15 = 111;
                                break;
                            }
                            default: {
                                v15 = 15;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFA717) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 67;
                    case 1 -> 11;
                    case 2 -> 149;
                    case 3 -> 129;
                    case 4 -> 209;
                    case 5 -> 158;
                    case 6 -> 198;
                    case 7 -> 157;
                    case 8 -> 9;
                    case 9 -> 240;
                    case 10 -> 233;
                    case 11 -> 28;
                    case 12 -> 160;
                    case 13 -> 31;
                    case 14 -> 173;
                    case 15 -> 79;
                    case 16 -> 71;
                    case 17 -> 216;
                    case 18 -> 121;
                    case 19 -> 253;
                    case 20 -> 0;
                    case 21 -> 230;
                    case 22 -> 170;
                    case 23 -> 118;
                    case 24 -> 177;
                    case 25 -> 10;
                    case 26 -> 134;
                    case 27 -> 250;
                    case 28 -> 186;
                    case 29 -> 74;
                    case 30 -> 61;
                    case 31 -> 225;
                    case 32 -> 135;
                    case 33 -> 66;
                    case 34 -> 204;
                    case 35 -> 43;
                    case 36 -> 190;
                    case 37 -> 191;
                    case 38 -> 130;
                    case 39 -> 146;
                    case 40 -> 175;
                    case 41 -> 184;
                    case 42 -> 201;
                    case 43 -> 165;
                    case 44 -> 239;
                    case 45 -> 125;
                    case 46 -> 100;
                    case 47 -> 105;
                    case 48 -> 49;
                    case 49 -> 195;
                    case 50 -> 202;
                    case 51 -> 40;
                    case 52 -> 237;
                    case 53 -> 117;
                    case 54 -> 164;
                    case 55 -> 95;
                    case 56 -> 128;
                    case 57 -> 93;
                    case 58 -> 185;
                    case 59 -> 127;
                    case 60 -> 227;
                    case 61 -> 111;
                    case 62 -> 50;
                    case 63 -> 214;
                    case 64 -> 22;
                    case 65 -> 116;
                    case 66 -> 166;
                    case 67 -> 34;
                    case 68 -> 221;
                    case 69 -> 124;
                    case 70 -> 219;
                    case 71 -> 205;
                    case 72 -> 145;
                    case 73 -> 89;
                    case 74 -> 244;
                    case 75 -> 115;
                    case 76 -> 78;
                    case 77 -> 179;
                    case 78 -> 169;
                    case 79 -> 187;
                    case 80 -> 228;
                    case 81 -> 48;
                    case 82 -> 182;
                    case 83 -> 101;
                    case 84 -> 126;
                    case 85 -> 110;
                    case 86 -> 243;
                    case 87 -> 96;
                    case 88 -> 55;
                    case 89 -> 54;
                    case 90 -> 4;
                    case 91 -> 97;
                    case 92 -> 94;
                    case 93 -> 235;
                    case 94 -> 98;
                    case 95 -> 16;
                    case 96 -> 42;
                    case 97 -> 69;
                    case 98 -> 8;
                    case 99 -> 133;
                    case 100 -> 180;
                    case 101 -> 226;
                    case 102 -> 77;
                    case 103 -> 206;
                    case 104 -> 161;
                    case 105 -> 20;
                    case 106 -> 2;
                    case 107 -> 5;
                    case 108 -> 119;
                    case 109 -> 62;
                    case 110 -> 113;
                    case 111 -> 29;
                    case 112 -> 140;
                    case 113 -> 176;
                    case 114 -> 72;
                    case 115 -> 84;
                    case 116 -> 35;
                    case 117 -> 90;
                    case 118 -> 168;
                    case 119 -> 70;
                    case 120 -> 238;
                    case 121 -> 41;
                    case 122 -> 246;
                    case 123 -> 148;
                    case 124 -> 6;
                    case 125 -> 131;
                    case 126 -> 108;
                    case 127 -> 208;
                    case 128 -> 26;
                    case 129 -> 24;
                    case 130 -> 87;
                    case 131 -> 58;
                    case 132 -> 229;
                    case 133 -> 80;
                    case 134 -> 57;
                    case 135 -> 107;
                    case 136 -> 65;
                    case 137 -> 38;
                    case 138 -> 3;
                    case 139 -> 162;
                    case 140 -> 245;
                    case 141 -> 211;
                    case 142 -> 189;
                    case 143 -> 234;
                    case 144 -> 18;
                    case 145 -> 76;
                    case 146 -> 27;
                    case 147 -> 60;
                    case 148 -> 223;
                    case 149 -> 123;
                    case 150 -> 45;
                    case 151 -> 178;
                    case 152 -> 30;
                    case 153 -> 64;
                    case 154 -> 241;
                    case 155 -> 192;
                    case 156 -> 81;
                    case 157 -> 188;
                    case 158 -> 51;
                    case 159 -> 68;
                    case 160 -> 159;
                    case 161 -> 247;
                    case 162 -> 25;
                    case 163 -> 132;
                    case 164 -> 151;
                    case 165 -> 104;
                    case 166 -> 153;
                    case 167 -> 59;
                    case 168 -> 255;
                    case 169 -> 102;
                    case 170 -> 47;
                    case 171 -> 13;
                    case 172 -> 15;
                    case 173 -> 222;
                    case 174 -> 143;
                    case 175 -> 23;
                    case 176 -> 37;
                    case 177 -> 212;
                    case 178 -> 193;
                    case 179 -> 46;
                    case 180 -> 88;
                    case 181 -> 63;
                    case 182 -> 142;
                    case 183 -> 213;
                    case 184 -> 236;
                    case 185 -> 207;
                    case 186 -> 73;
                    case 187 -> 194;
                    case 188 -> 252;
                    case 189 -> 36;
                    case 190 -> 174;
                    case 191 -> 14;
                    case 192 -> 254;
                    case 193 -> 232;
                    case 194 -> 163;
                    case 195 -> 53;
                    case 196 -> 248;
                    case 197 -> 21;
                    case 198 -> 112;
                    case 199 -> 12;
                    case 200 -> 139;
                    case 201 -> 7;
                    case 202 -> 172;
                    case 203 -> 75;
                    case 204 -> 249;
                    case 205 -> 181;
                    case 206 -> 122;
                    case 207 -> 52;
                    case 208 -> 137;
                    case 209 -> 197;
                    case 210 -> 218;
                    case 211 -> 86;
                    case 212 -> 85;
                    case 213 -> 33;
                    case 214 -> 82;
                    case 215 -> 167;
                    case 216 -> 109;
                    case 217 -> 44;
                    case 218 -> 251;
                    case 219 -> 217;
                    case 220 -> 91;
                    case 221 -> 155;
                    case 222 -> 92;
                    case 223 -> 210;
                    case 224 -> 150;
                    case 225 -> 231;
                    case 226 -> 200;
                    case 227 -> 138;
                    case 228 -> 141;
                    case 229 -> 242;
                    case 230 -> 32;
                    case 231 -> 19;
                    case 232 -> 114;
                    case 233 -> 171;
                    case 234 -> 152;
                    case 235 -> 147;
                    case 236 -> 144;
                    case 237 -> 154;
                    case 238 -> 215;
                    case 239 -> 1;
                    case 240 -> 39;
                    case 241 -> 136;
                    case 242 -> 56;
                    case 243 -> 83;
                    case 244 -> 99;
                    case 245 -> 199;
                    case 246 -> 17;
                    case 247 -> 224;
                    case 248 -> 196;
                    case 249 -> 120;
                    case 250 -> 156;
                    case 251 -> 183;
                    case 252 -> 103;
                    case 253 -> 203;
                    case 254 -> 106;
                    default -> 220;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 81277778275391L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "V#\b2k\u001fr\u000f\tQ)\u001b8&]o\u0013o";
                    var5_4 = "V#\b2k\u001fr\u000f\tQ)\u001b8&]o\u0013o".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 123;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 70;
                                    break;
                                }
                                case 1: {
                                    v11 = 61;
                                    break;
                                }
                                case 2: {
                                    v11 = 1;
                                    break;
                                }
                                case 3: {
                                    v11 = 39;
                                    break;
                                }
                                case 4: {
                                    v11 = 117;
                                    break;
                                }
                                case 5: {
                                    v11 = 8;
                                    break;
                                }
                                default: {
                                    v11 = 58;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 37766964947318L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "\u007f\tR\"F\u0015Z\u0004y\u0017^8\nu\bU8J\u0017B_\t\\\tu\bU8J\u0017BS\u0003\rr\u000eH5@\u001aXS\u0004O?A\u0013";
                    var5_4 = "\u007f\tR\"F\u0015Z\u0004y\u0017^8\nu\bU8J\u0017B_\t\\\tu\bU8J\u0017BS\u0003\rr\u000eH5@\u001aXS\u0004O?A\u0013".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 88;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "C=b\u0013p,g\u0006C=b\u0013|&";
                        var5_4 = "C=b\u0013p,g\u0006C=b\u0013|&".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 110;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 110;
                                break;
                            }
                            case 1: {
                                v15 = 63;
                                break;
                            }
                            case 2: {
                                v15 = 99;
                                break;
                            }
                            case 3: {
                                v15 = 14;
                                break;
                            }
                            case 4: {
                                v15 = 119;
                                break;
                            }
                            case 5: {
                                v15 = 44;
                                break;
                            }
                            default: {
                                v15 = 110;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 24099207683216L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-146143050 + -((char)-3829), 146274120 - (char)-2139, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 54941433753695L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "BH)@\u00d4\u0003\u00ed,h\u0005\u00a4\u00d1\u00d3\u00b7h\rn\u00ef\u00bc:p\u00e0\u00acw\u00d9\r\u00b2\u0087v\u0010\u00f7\u0093H^\u00d1\u00f9\u00b3i\u00f3J\u0014\"D\u0019g\u00f0\u0005A\u00c6oU\u00ff3E\u00f5\u00feD\u00d2\u00fe\u00e3\u009d\u0084)qg.\u00e0\u0006\u00d0\u00df)\u00ea\u00b9'\u0089\u00d6\u00fb\u0094c\u00d7\u00a9\u0087I\u00d0\u00c9\u00c9]\u00cb\u00cb\u00c5\u00b3\u0093x\u00f1\u008fX\u007f\u0007\u00f9\u00fcq^Y~";
                    var4_3 = "BH)@\u00d4\u0003\u00ed,h\u0005\u00a4\u00d1\u00d3\u00b7h\rn\u00ef\u00bc:p\u00e0\u00acw\u00d9\r\u00b2\u0087v\u0010\u00f7\u0093H^\u00d1\u00f9\u00b3i\u00f3J\u0014\"D\u0019g\u00f0\u0005A\u00c6oU\u00ff3E\u00f5\u00feD\u00d2\u00fe\u00e3\u009d\u0084)qg.\u00e0\u0006\u00d0\u00df)\u00ea\u00b9'\u0089\u00d6\u00fb\u0094c\u00d7\u00a9\u0087I\u00d0\u00c9\u00c9]\u00cb\u00cb\u00c5\u00b3\u0093x\u00f1\u008fX\u007f\u0007\u00f9\u00fcq^Y~".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 101;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00b3\u0000G\u00ab\u00b7\u00c0\u00f8\u00c9\u001d\u00d9N\u00d7\u0088 yPL\u00da\u00a4\u009d\u00f5\u00c6\u00c3\u00b8\u00c7\u009c\u008b\u00d2$\u0015\u00d0Y7\u00b6\u0083\u00bf\u009db\u00ee\u00d32\u00906\u00f5B\u00be\u00fa\u009fW\u00b7\u00e7\u00f2\u0007Ws|\u0081\u00bd\u00ca\u0099-\u00ad\u00ea\u00e5\u00ac\bQ\u00db{\u0015\u0002F;\u00bb\u00bd&\u00d9\u00b5\u00cd\u0000\u008b\u00cb\u001b1H\u0003\u00a6\u00cd)\u00cb\u007f\u001d\u0095";
                        var4_3 = "\u00b3\u0000G\u00ab\u00b7\u00c0\u00f8\u00c9\u001d\u00d9N\u00d7\u0088 yPL\u00da\u00a4\u009d\u00f5\u00c6\u00c3\u00b8\u00c7\u009c\u008b\u00d2$\u0015\u00d0Y7\u00b6\u0083\u00bf\u009db\u00ee\u00d32\u00906\u00f5B\u00be\u00fa\u009fW\u00b7\u00e7\u00f2\u0007Ws|\u0081\u00bd\u00ca\u0099-\u00ad\u00ea\u00e5\u00ac\bQ\u00db{\u0015\u0002F;\u00bb\u00bd&\u00d9\u00b5\u00cd\u0000\u008b\u00cb\u001b1H\u0003\u00a6\u00cd)\u00cb\u007f\u001d\u0095".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 43;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 102;
                                break;
                            }
                            case 1: {
                                v15 = 26;
                                break;
                            }
                            case 2: {
                                v15 = 76;
                                break;
                            }
                            case 3: {
                                v15 = 38;
                                break;
                            }
                            case 4: {
                                v15 = 12;
                                break;
                            }
                            case 5: {
                                v15 = 44;
                                break;
                            }
                            default: {
                                v15 = 22;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF8B3B) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 79;
                    case 1 -> 244;
                    case 2 -> 220;
                    case 3 -> 236;
                    case 4 -> 104;
                    case 5 -> 243;
                    case 6 -> 76;
                    case 7 -> 4;
                    case 8 -> 129;
                    case 9 -> 122;
                    case 10 -> 94;
                    case 11 -> 226;
                    case 12 -> 173;
                    case 13 -> 163;
                    case 14 -> 3;
                    case 15 -> 83;
                    case 16 -> 186;
                    case 17 -> 127;
                    case 18 -> 123;
                    case 19 -> 72;
                    case 20 -> 73;
                    case 21 -> 102;
                    case 22 -> 62;
                    case 23 -> 106;
                    case 24 -> 49;
                    case 25 -> 214;
                    case 26 -> 88;
                    case 27 -> 165;
                    case 28 -> 198;
                    case 29 -> 182;
                    case 30 -> 194;
                    case 31 -> 18;
                    case 32 -> 223;
                    case 33 -> 21;
                    case 34 -> 185;
                    case 35 -> 59;
                    case 36 -> 23;
                    case 37 -> 175;
                    case 38 -> 95;
                    case 39 -> 37;
                    case 40 -> 35;
                    case 41 -> 203;
                    case 42 -> 90;
                    case 43 -> 150;
                    case 44 -> 92;
                    case 45 -> 25;
                    case 46 -> 101;
                    case 47 -> 207;
                    case 48 -> 85;
                    case 49 -> 138;
                    case 50 -> 139;
                    case 51 -> 152;
                    case 52 -> 22;
                    case 53 -> 100;
                    case 54 -> 128;
                    case 55 -> 133;
                    case 56 -> 228;
                    case 57 -> 86;
                    case 58 -> 87;
                    case 59 -> 233;
                    case 60 -> 77;
                    case 61 -> 154;
                    case 62 -> 204;
                    case 63 -> 192;
                    case 64 -> 14;
                    case 65 -> 19;
                    case 66 -> 50;
                    case 67 -> 135;
                    case 68 -> 36;
                    case 69 -> 26;
                    case 70 -> 57;
                    case 71 -> 190;
                    case 72 -> 247;
                    case 73 -> 179;
                    case 74 -> 43;
                    case 75 -> 16;
                    case 76 -> 205;
                    case 77 -> 15;
                    case 78 -> 126;
                    case 79 -> 151;
                    case 80 -> 202;
                    case 81 -> 42;
                    case 82 -> 211;
                    case 83 -> 32;
                    case 84 -> 215;
                    case 85 -> 137;
                    case 86 -> 149;
                    case 87 -> 33;
                    case 88 -> 209;
                    case 89 -> 11;
                    case 90 -> 142;
                    case 91 -> 134;
                    case 92 -> 103;
                    case 93 -> 212;
                    case 94 -> 60;
                    case 95 -> 1;
                    case 96 -> 39;
                    case 97 -> 74;
                    case 98 -> 210;
                    case 99 -> 238;
                    case 100 -> 108;
                    case 101 -> 113;
                    case 102 -> 0;
                    case 103 -> 158;
                    case 104 -> 155;
                    case 105 -> 245;
                    case 106 -> 166;
                    case 107 -> 54;
                    case 108 -> 9;
                    case 109 -> 221;
                    case 110 -> 187;
                    case 111 -> 199;
                    case 112 -> 56;
                    case 113 -> 250;
                    case 114 -> 89;
                    case 115 -> 116;
                    case 116 -> 114;
                    case 117 -> 222;
                    case 118 -> 117;
                    case 119 -> 66;
                    case 120 -> 40;
                    case 121 -> 225;
                    case 122 -> 53;
                    case 123 -> 120;
                    case 124 -> 96;
                    case 125 -> 197;
                    case 126 -> 124;
                    case 127 -> 213;
                    case 128 -> 235;
                    case 129 -> 107;
                    case 130 -> 28;
                    case 131 -> 232;
                    case 132 -> 64;
                    case 133 -> 146;
                    case 134 -> 208;
                    case 135 -> 176;
                    case 136 -> 58;
                    case 137 -> 252;
                    case 138 -> 80;
                    case 139 -> 156;
                    case 140 -> 82;
                    case 141 -> 167;
                    case 142 -> 189;
                    case 143 -> 8;
                    case 144 -> 181;
                    case 145 -> 251;
                    case 146 -> 97;
                    case 147 -> 229;
                    case 148 -> 159;
                    case 149 -> 234;
                    case 150 -> 24;
                    case 151 -> 160;
                    case 152 -> 242;
                    case 153 -> 200;
                    case 154 -> 196;
                    case 155 -> 216;
                    case 156 -> 34;
                    case 157 -> 65;
                    case 158 -> 169;
                    case 159 -> 110;
                    case 160 -> 157;
                    case 161 -> 130;
                    case 162 -> 27;
                    case 163 -> 112;
                    case 164 -> 63;
                    case 165 -> 140;
                    case 166 -> 219;
                    case 167 -> 20;
                    case 168 -> 81;
                    case 169 -> 161;
                    case 170 -> 10;
                    case 171 -> 180;
                    case 172 -> 168;
                    case 173 -> 41;
                    case 174 -> 144;
                    case 175 -> 48;
                    case 176 -> 217;
                    case 177 -> 230;
                    case 178 -> 227;
                    case 179 -> 5;
                    case 180 -> 119;
                    case 181 -> 2;
                    case 182 -> 183;
                    case 183 -> 170;
                    case 184 -> 93;
                    case 185 -> 99;
                    case 186 -> 162;
                    case 187 -> 118;
                    case 188 -> 115;
                    case 189 -> 241;
                    case 190 -> 91;
                    case 191 -> 131;
                    case 192 -> 164;
                    case 193 -> 109;
                    case 194 -> 30;
                    case 195 -> 141;
                    case 196 -> 67;
                    case 197 -> 178;
                    case 198 -> 84;
                    case 199 -> 71;
                    case 200 -> 255;
                    case 201 -> 147;
                    case 202 -> 29;
                    case 203 -> 224;
                    case 204 -> 75;
                    case 205 -> 13;
                    case 206 -> 184;
                    case 207 -> 188;
                    case 208 -> 6;
                    case 209 -> 132;
                    case 210 -> 121;
                    case 211 -> 46;
                    case 212 -> 31;
                    case 213 -> 218;
                    case 214 -> 237;
                    case 215 -> 98;
                    case 216 -> 45;
                    case 217 -> 253;
                    case 218 -> 249;
                    case 219 -> 195;
                    case 220 -> 7;
                    case 221 -> 171;
                    case 222 -> 52;
                    case 223 -> 17;
                    case 224 -> 143;
                    case 225 -> 69;
                    case 226 -> 111;
                    case 227 -> 145;
                    case 228 -> 206;
                    case 229 -> 177;
                    case 230 -> 172;
                    case 231 -> 191;
                    case 232 -> 78;
                    case 233 -> 105;
                    case 234 -> 153;
                    case 235 -> 148;
                    case 236 -> 248;
                    case 237 -> 240;
                    case 238 -> 47;
                    case 239 -> 254;
                    case 240 -> 51;
                    case 241 -> 55;
                    case 242 -> 174;
                    case 243 -> 68;
                    case 244 -> 125;
                    case 245 -> 70;
                    case 246 -> 201;
                    case 247 -> 44;
                    case 248 -> 246;
                    case 249 -> 38;
                    case 250 -> 231;
                    case 251 -> 12;
                    case 252 -> 193;
                    case 253 -> 239;
                    case 254 -> 136;
                    default -> 61;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 70819021519283L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(694277790 - 27413, -694277790 - -((char)-17936), (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 137545339013497L;
                    String[] stringArray = SshAgentIpcService.z();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(988661010 - (char)-22064, 988661010 - (char)-28199, (int)l2));
                    String[] stringArray2 = stringArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (stringArray2 == null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 101892372567306L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00e7\u0004\u0012\u00c1\u00bd\u0003\u0010\u00ad\u00ba";
                var4_3 = "\u00e7\u0004\u0012\u00c1\u00bd\u0003\u0010\u00ad\u00ba".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 122;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 15;
                                break;
                            }
                            case 1: {
                                v11 = 53;
                                break;
                            }
                            case 2: {
                                v11 = 18;
                                break;
                            }
                            case 3: {
                                v11 = 55;
                                break;
                            }
                            case 4: {
                                v11 = 53;
                                break;
                            }
                            case 5: {
                                v11 = 1;
                                break;
                            }
                            default: {
                                v11 = 82;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF923A) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 23;
                    case 1 -> 245;
                    case 2 -> 62;
                    case 3 -> 24;
                    case 4 -> 248;
                    case 5 -> 146;
                    case 6 -> 1;
                    case 7 -> 179;
                    case 8 -> 237;
                    case 9 -> 133;
                    case 10 -> 31;
                    case 11 -> 102;
                    case 12 -> 75;
                    case 13 -> 115;
                    case 14 -> 66;
                    case 15 -> 189;
                    case 16 -> 9;
                    case 17 -> 44;
                    case 18 -> 214;
                    case 19 -> 7;
                    case 20 -> 72;
                    case 21 -> 169;
                    case 22 -> 65;
                    case 23 -> 85;
                    case 24 -> 26;
                    case 25 -> 164;
                    case 26 -> 109;
                    case 27 -> 228;
                    case 28 -> 187;
                    case 29 -> 124;
                    case 30 -> 70;
                    case 31 -> 74;
                    case 32 -> 147;
                    case 33 -> 123;
                    case 34 -> 202;
                    case 35 -> 95;
                    case 36 -> 38;
                    case 37 -> 113;
                    case 38 -> 191;
                    case 39 -> 154;
                    case 40 -> 13;
                    case 41 -> 90;
                    case 42 -> 178;
                    case 43 -> 181;
                    case 44 -> 8;
                    case 45 -> 96;
                    case 46 -> 127;
                    case 47 -> 43;
                    case 48 -> 60;
                    case 49 -> 183;
                    case 50 -> 103;
                    case 51 -> 61;
                    case 52 -> 227;
                    case 53 -> 216;
                    case 54 -> 229;
                    case 55 -> 16;
                    case 56 -> 111;
                    case 57 -> 30;
                    case 58 -> 152;
                    case 59 -> 129;
                    case 60 -> 51;
                    case 61 -> 240;
                    case 62 -> 40;
                    case 63 -> 176;
                    case 64 -> 208;
                    case 65 -> 234;
                    case 66 -> 255;
                    case 67 -> 56;
                    case 68 -> 170;
                    case 69 -> 114;
                    case 70 -> 250;
                    case 71 -> 162;
                    case 72 -> 69;
                    case 73 -> 107;
                    case 74 -> 210;
                    case 75 -> 145;
                    case 76 -> 119;
                    case 77 -> 12;
                    case 78 -> 39;
                    case 79 -> 64;
                    case 80 -> 173;
                    case 81 -> 253;
                    case 82 -> 58;
                    case 83 -> 78;
                    case 84 -> 120;
                    case 85 -> 192;
                    case 86 -> 201;
                    case 87 -> 101;
                    case 88 -> 222;
                    case 89 -> 186;
                    case 90 -> 226;
                    case 91 -> 211;
                    case 92 -> 150;
                    case 93 -> 18;
                    case 94 -> 252;
                    case 95 -> 140;
                    case 96 -> 221;
                    case 97 -> 112;
                    case 98 -> 84;
                    case 99 -> 46;
                    case 100 -> 174;
                    case 101 -> 42;
                    case 102 -> 200;
                    case 103 -> 153;
                    case 104 -> 242;
                    case 105 -> 105;
                    case 106 -> 197;
                    case 107 -> 106;
                    case 108 -> 98;
                    case 109 -> 117;
                    case 110 -> 172;
                    case 111 -> 50;
                    case 112 -> 149;
                    case 113 -> 36;
                    case 114 -> 32;
                    case 115 -> 243;
                    case 116 -> 63;
                    case 117 -> 223;
                    case 118 -> 171;
                    case 119 -> 134;
                    case 120 -> 77;
                    case 121 -> 37;
                    case 122 -> 247;
                    case 123 -> 213;
                    case 124 -> 190;
                    case 125 -> 48;
                    case 126 -> 33;
                    case 127 -> 25;
                    case 128 -> 193;
                    case 129 -> 19;
                    case 130 -> 151;
                    case 131 -> 57;
                    case 132 -> 81;
                    case 133 -> 92;
                    case 134 -> 185;
                    case 135 -> 249;
                    case 136 -> 231;
                    case 137 -> 99;
                    case 138 -> 5;
                    case 139 -> 104;
                    case 140 -> 156;
                    case 141 -> 17;
                    case 142 -> 118;
                    case 143 -> 244;
                    case 144 -> 128;
                    case 145 -> 67;
                    case 146 -> 238;
                    case 147 -> 225;
                    case 148 -> 217;
                    case 149 -> 88;
                    case 150 -> 160;
                    case 151 -> 159;
                    case 152 -> 14;
                    case 153 -> 121;
                    case 154 -> 82;
                    case 155 -> 3;
                    case 156 -> 180;
                    case 157 -> 97;
                    case 158 -> 136;
                    case 159 -> 130;
                    case 160 -> 41;
                    case 161 -> 168;
                    case 162 -> 4;
                    case 163 -> 76;
                    case 164 -> 86;
                    case 165 -> 20;
                    case 166 -> 198;
                    case 167 -> 148;
                    case 168 -> 79;
                    case 169 -> 29;
                    case 170 -> 6;
                    case 171 -> 22;
                    case 172 -> 177;
                    case 173 -> 59;
                    case 174 -> 205;
                    case 175 -> 125;
                    case 176 -> 126;
                    case 177 -> 138;
                    case 178 -> 230;
                    case 179 -> 89;
                    case 180 -> 49;
                    case 181 -> 35;
                    case 182 -> 93;
                    case 183 -> 207;
                    case 184 -> 135;
                    case 185 -> 122;
                    case 186 -> 218;
                    case 187 -> 199;
                    case 188 -> 21;
                    case 189 -> 131;
                    case 190 -> 167;
                    case 191 -> 157;
                    case 192 -> 209;
                    case 193 -> 47;
                    case 194 -> 203;
                    case 195 -> 27;
                    case 196 -> 188;
                    case 197 -> 166;
                    case 198 -> 34;
                    case 199 -> 11;
                    case 200 -> 80;
                    case 201 -> 212;
                    case 202 -> 182;
                    case 203 -> 143;
                    case 204 -> 161;
                    case 205 -> 100;
                    case 206 -> 144;
                    case 207 -> 206;
                    case 208 -> 251;
                    case 209 -> 194;
                    case 210 -> 142;
                    case 211 -> 15;
                    case 212 -> 233;
                    case 213 -> 246;
                    case 214 -> 158;
                    case 215 -> 2;
                    case 216 -> 195;
                    case 217 -> 91;
                    case 218 -> 220;
                    case 219 -> 141;
                    case 220 -> 184;
                    case 221 -> 132;
                    case 222 -> 110;
                    case 223 -> 94;
                    case 224 -> 45;
                    case 225 -> 54;
                    case 226 -> 155;
                    case 227 -> 241;
                    case 228 -> 137;
                    case 229 -> 165;
                    case 230 -> 68;
                    case 231 -> 232;
                    case 232 -> 139;
                    case 233 -> 204;
                    case 234 -> 163;
                    case 235 -> 224;
                    case 236 -> 235;
                    case 237 -> 254;
                    case 238 -> 239;
                    case 239 -> 28;
                    case 240 -> 219;
                    case 241 -> 71;
                    case 242 -> 87;
                    case 243 -> 0;
                    case 244 -> 236;
                    case 245 -> 73;
                    case 246 -> 108;
                    case 247 -> 52;
                    case 248 -> 10;
                    case 249 -> 116;
                    case 250 -> 53;
                    case 251 -> 215;
                    case 252 -> 196;
                    case 253 -> 175;
                    case 254 -> 83;
                    default -> 55;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

