/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.api;

import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.scientific.py.tables.api.FilterCommandComposerForPythonHelper;
import com.intellij.scientific.py.tables.api.PyDevdID;
import com.intellij.scientific.py.tables.api.PythonTableCommandCodeProvider;
import com.intellij.scientific.py.tables.commands.DSTableParserKt;
import com.intellij.scientific.tables.DSTableDataException;
import com.intellij.scientific.tables.DSTableRateExceededException;
import com.intellij.scientific.tables.DSTableRawData;
import com.intellij.scientific.tables.DataId;
import com.intellij.scientific.tables.api.DSDataFrameInfo;
import com.intellij.scientific.tables.api.DSTableCommandExecutor;
import com.intellij.scientific.tables.api.DSTableDataProvider;
import com.intellij.scientific.tables.api.DSTableTypeDataWithDocumentation;
import com.intellij.scientific.tables.api.FilterComparisonType;
import com.intellij.scientific.tables.api.InfoTableCommand;
import com.intellij.scientific.tables.api.SliceTableCommand;
import com.intellij.scientific.tables.api.TableCommand;
import com.intellij.scientific.tables.api.TableCommandCodeProvider;
import com.intellij.scientific.tables.fus.DSTableDataProviderLogger;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0004J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0012H\u0016J:\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0016J\b\u0010#\u001a\u00020$H\u0002R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006%"}, d2={"Lcom/intellij/scientific/py/tables/api/PyDevdTableDataProvider;", "Lcom/intellij/scientific/tables/api/DSTableDataProvider;", "Lcom/intellij/scientific/py/tables/api/FilterCommandComposerForPythonHelper;", "<init>", "()V", "pydevdId", "Lcom/intellij/scientific/py/tables/api/PyDevdID;", "getPydevdId", "()Lcom/intellij/scientific/py/tables/api/PyDevdID;", "commandCodeProvider", "Lcom/intellij/scientific/tables/api/TableCommandCodeProvider;", "getCommandCodeProvider", "()Lcom/intellij/scientific/tables/api/TableCommandCodeProvider;", "commandCodeProvider$delegate", "Lkotlin/Lazy;", "createCommandCodeProvider", "Lcom/intellij/scientific/py/tables/api/PythonTableCommandCodeProvider;", "executeCommand", "", "Lcom/intellij/scientific/tables/api/DSTableCommandExecutor;", "tableCommand", "Lcom/intellij/scientific/tables/api/TableCommand;", "loadDynamicTableDataFrameInfo", "Lcom/intellij/scientific/tables/api/DSDataFrameInfo;", "commandExecutor", "tableVariable", "textTableOutput", "loadDynamicTableData", "Lcom/intellij/scientific/tables/DSTableRawData;", "dataId", "Lcom/intellij/scientific/tables/DataId;", "format", "start", "", "end", "getTableTypeDataWithDocumentation", "Lcom/intellij/scientific/tables/api/DSTableTypeDataWithDocumentation;", "intellij.scientific.py.tables"})
public abstract class PyDevdTableDataProvider
implements DSTableDataProvider,
FilterCommandComposerForPythonHelper {
    @NotNull
    private final Lazy commandCodeProvider$delegate = LazyKt.lazy(() -> PyDevdTableDataProvider.commandCodeProvider_delegate$lambda$0(this));

    @NotNull
    public abstract PyDevdID getPydevdId();

    private final TableCommandCodeProvider getCommandCodeProvider() {
        Lazy lazy = this.commandCodeProvider$delegate;
        return (TableCommandCodeProvider)lazy.getValue();
    }

    @NotNull
    protected PythonTableCommandCodeProvider createCommandCodeProvider() {
        return new PythonTableCommandCodeProvider(this.getPydevdId());
    }

    @NotNull
    protected final String executeCommand(@NotNull DSTableCommandExecutor $this$executeCommand, @NotNull TableCommand tableCommand) {
        Intrinsics.checkNotNullParameter((Object)$this$executeCommand, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)tableCommand, (String)"tableCommand");
        return $this$executeCommand.executeCommand(tableCommand, this.getCommandCodeProvider());
    }

    @NotNull
    public DSDataFrameInfo loadDynamicTableDataFrameInfo(@NotNull DSTableCommandExecutor commandExecutor, @NotNull String tableVariable, @NotNull String textTableOutput) throws DSTableDataException {
        DSDataFrameInfo dSDataFrameInfo;
        Intrinsics.checkNotNullParameter((Object)commandExecutor, (String)"commandExecutor");
        Intrinsics.checkNotNullParameter((Object)tableVariable, (String)"tableVariable");
        Intrinsics.checkNotNullParameter((Object)textTableOutput, (String)"textTableOutput");
        String commandResult = this.executeCommand(commandExecutor, (TableCommand)new InfoTableCommand(tableVariable));
        DSTableTypeDataWithDocumentation tableTypeData = this.getTableTypeDataWithDocumentation();
        DSDataFrameInfo $this$loadDynamicTableDataFrameInfo_u24lambda_u241 = dSDataFrameInfo = DSTableParserKt.parseDataFrameInfo(commandResult, tableTypeData.getShortName());
        boolean bl = false;
        $this$loadDynamicTableDataFrameInfo_u24lambda_u241.setTableType(this.getType());
        $this$loadDynamicTableDataFrameInfo_u24lambda_u241.setDocumentationUrl(tableTypeData.getDocumentationUrl());
        DSDataFrameInfo dataFrameInfo = dSDataFrameInfo;
        DSTableParserKt.setDataFrameDimensions(textTableOutput, dataFrameInfo);
        DSTableDataProviderLogger.INSTANCE.tableInfoLoaded(this.getType(), PluginInfoDetectorKt.getPluginInfo(this.getClass()), commandExecutor.getDataAccessorClass(), dataFrameInfo.getRows(), dataFrameInfo.getColumnNames().size());
        return dataFrameInfo;
    }

    @NotNull
    public DSTableRawData loadDynamicTableData(@NotNull DSTableCommandExecutor commandExecutor, @NotNull DataId dataId, @NotNull String tableVariable, @Nullable String format2, int start2, int end) throws DSTableDataException, DSTableRateExceededException {
        Intrinsics.checkNotNullParameter((Object)commandExecutor, (String)"commandExecutor");
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        Intrinsics.checkNotNullParameter((Object)tableVariable, (String)"tableVariable");
        boolean useCsvSerialization = Registry.Companion.get("tables.command.slice.mode").asBoolean();
        String tableConverted = this.executeCommand(commandExecutor, (TableCommand)new SliceTableCommand(tableVariable, useCsvSerialization, format2, start2, end));
        DSTableDataProviderLogger.INSTANCE.tableDataLoaded(this.getType(), PluginInfoDetectorKt.getPluginInfo(this.getClass()), commandExecutor.getDataAccessorClass(), end - start2);
        DSTableRawData parseTableToData = useCsvSerialization ? DSTableParserKt.parseTableCsvToData(dataId, tableConverted) : DSTableParserKt.parseTableHtmlToData(dataId, tableConverted);
        return parseTableToData;
    }

    private final DSTableTypeDataWithDocumentation getTableTypeDataWithDocumentation() {
        return this.getType().getTypeDataWithDocumentation();
    }

    @NotNull
    public List<FilterComparisonType> getSupportedFilterComparisonTypes() {
        return DSTableDataProvider.DefaultImpls.getSupportedFilterComparisonTypes((DSTableDataProvider)this);
    }

    private static final PythonTableCommandCodeProvider commandCodeProvider_delegate$lambda$0(PyDevdTableDataProvider this$0) {
        return this$0.createCommandCodeProvider();
    }
}

