/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.structureView;

import com.google.common.collect.Lists;
import com.intellij.formatting.Block;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.jinja.template.formatter.DjangoTagBlock;
import com.intellij.jinja.template.formatter.MutableBlockWrapper;
import com.intellij.psi.PsiElement;
import com.jetbrains.django.lang.template.structureView.DjangoXmlRootTreeElement;
import com.jetbrains.django.lang.template.structureView.StructureViewBlockWrapper;
import com.jetbrains.django.lang.template.structureView.TreeElementBlock;
import java.util.ArrayList;
import java.util.List;

public final class DjangoStructureViewUtil {
    public static Block convertFromTreeViewToBlocks(PsiTreeElementBase<PsiElement> root) {
        return new TreeElementBlock(root);
    }

    public static StructureViewTreeElement convertFromBlockTreeToTreeView(DjangoXmlRootTreeElement root, Block block) {
        List<StructureViewTreeElement> res = DjangoStructureViewUtil.convertFromBlockTreeToTreeView(Lists.newArrayList((Object[])new Block[]{block}));
        if (res.size() == 1) {
            return res.get(0);
        }
        return DjangoStructureViewUtil.createBlockWrapper(root, res);
    }

    public static List<StructureViewTreeElement> convertFromBlockTreeToTreeView(List<? extends Block> blocks) {
        ArrayList<StructureViewTreeElement> result2 = new ArrayList<StructureViewTreeElement>();
        for (Block block : blocks) {
            DjangoStructureViewUtil.convertFromBlockTreeToTreeView(result2, block);
        }
        return result2;
    }

    public static List<StructureViewTreeElement> convertFromBlockTreeToTreeView(Block block) {
        ArrayList<StructureViewTreeElement> result2 = new ArrayList<StructureViewTreeElement>();
        DjangoStructureViewUtil.convertFromBlockTreeToTreeView(result2, block);
        if (result2.size() == 1 && result2.get(0) instanceof StructureViewBlockWrapper) {
            return Lists.newArrayList((Object[])((StructureViewBlockWrapper)result2.get(0)).getChildren());
        }
        return result2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void convertFromBlockTreeToTreeView(List<? super StructureViewTreeElement> result2, Block b2) {
        if (b2 instanceof TreeElementBlock) {
            List<StructureViewTreeElement> children2 = DjangoStructureViewUtil.convertFromBlockTreeToTreeView(b2.getSubBlocks());
            result2.add(DjangoStructureViewUtil.createBlockWrapper(((TreeElementBlock)b2).getTreeElement(), children2));
            return;
        } else if (b2 instanceof MutableBlockWrapper && ((MutableBlockWrapper)b2).getOriginalBlock() instanceof TreeElementBlock) {
            List<StructureViewTreeElement> children3 = DjangoStructureViewUtil.convertFromBlockTreeToTreeView(b2.getSubBlocks());
            Block originalBlock = ((MutableBlockWrapper)b2).getOriginalBlock();
            if (!(originalBlock instanceof TreeElementBlock)) throw new IllegalStateException("this should not happen");
            result2.add(DjangoStructureViewUtil.createBlockWrapper(((TreeElementBlock)originalBlock).getTreeElement(), children3));
            return;
        } else if (b2 instanceof DjangoTagBlock) {
            TreeElementBlock treeElementBlock;
            List<StructureViewTreeElement> children4 = DjangoStructureViewUtil.convertFromBlockTreeToTreeView(b2.getSubBlocks());
            Block openTag = ((DjangoTagBlock)b2).getOpenTag();
            if (openTag instanceof TreeElementBlock) {
                treeElementBlock = (TreeElementBlock)openTag;
            } else {
                if (!(openTag instanceof MutableBlockWrapper)) throw new IllegalStateException("unexpected block:" + openTag.getClass());
                treeElementBlock = (TreeElementBlock)((MutableBlockWrapper)openTag).getOriginalBlock();
            }
            result2.add(DjangoStructureViewUtil.createBlockWrapper(treeElementBlock.getTreeElement(), children4));
            return;
        } else {
            result2.addAll(DjangoStructureViewUtil.convertFromBlockTreeToTreeView(b2.getSubBlocks()));
        }
    }

    private static StructureViewBlockWrapper createBlockWrapper(PsiTreeElementBase treeElement, List<StructureViewTreeElement> children2) {
        return new StructureViewBlockWrapper((StructureViewTreeElement)treeElement, children2);
    }
}

