/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.defaultTheme;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.commons.values.FontFace;
import org.jetbrains.letsPlot.core.plot.base.render.linetype.LineType;
import org.jetbrains.letsPlot.core.plot.base.theme.FontFamilyRegistry;
import org.jetbrains.letsPlot.core.plot.base.theme.ThemeTextStyle;
import org.jetbrains.letsPlot.core.plot.base.theme.TooltipsTheme;
import org.jetbrains.letsPlot.core.plot.builder.defaultTheme.ThemeValuesAccess;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/defaultTheme/DefaultTooltipsTheme;", "Lorg/jetbrains/letsPlot/core/plot/builder/defaultTheme/ThemeValuesAccess;", "Lorg/jetbrains/letsPlot/core/plot/base/theme/TooltipsTheme;", "options", "", "", "", "fontFamilyRegistry", "Lorg/jetbrains/letsPlot/core/plot/base/theme/FontFamilyRegistry;", "(Ljava/util/Map;Lorg/jetbrains/letsPlot/core/plot/base/theme/FontFamilyRegistry;)V", "textKey", "", "getTextKey$plot_builder", "()Ljava/util/List;", "titleTextKey", "getTitleTextKey$plot_builder", "tooltipKey", "getTooltipKey$plot_builder", "labelStyle", "Lorg/jetbrains/letsPlot/core/plot/base/theme/ThemeTextStyle;", "show", "", "textStyle", "titleStyle", "tooltipColor", "Lorg/jetbrains/letsPlot/commons/values/Color;", "tooltipFill", "tooltipLineType", "Lorg/jetbrains/letsPlot/core/plot/base/render/linetype/LineType;", "tooltipStrokeWidth", "", "plot-builder"})
public final class DefaultTooltipsTheme
extends ThemeValuesAccess
implements TooltipsTheme {
    @NotNull
    private final List<String> tooltipKey;
    @NotNull
    private final List<String> textKey;
    @NotNull
    private final List<String> titleTextKey;

    public DefaultTooltipsTheme(@NotNull Map<String, ? extends Object> options, @NotNull FontFamilyRegistry fontFamilyRegistry) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)fontFamilyRegistry, (String)"fontFamilyRegistry");
        super(options, fontFamilyRegistry);
        Object[] objectArray = new String[]{"tooltip", "rect"};
        this.tooltipKey = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"tooltip_text", "text"};
        this.textKey = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"tooltip_title_text", "tooltip_text", "text"};
        this.titleTextKey = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final List<String> getTooltipKey$plot_builder() {
        return this.tooltipKey;
    }

    @NotNull
    public final List<String> getTextKey$plot_builder() {
        return this.textKey;
    }

    @NotNull
    public final List<String> getTitleTextKey$plot_builder() {
        return this.titleTextKey;
    }

    @Override
    @NotNull
    public Color tooltipColor() {
        return this.getColor(this.getElemValue(this.tooltipKey), "color");
    }

    @Override
    @NotNull
    public Color tooltipFill() {
        return this.getColor(this.getElemValue(this.tooltipKey), "fill");
    }

    @Override
    public double tooltipStrokeWidth() {
        return this.getNumber(this.getElemValue(this.tooltipKey), "size");
    }

    @Override
    @NotNull
    public LineType tooltipLineType() {
        return this.getLineType(this.getElemValue(this.tooltipKey));
    }

    @Override
    @NotNull
    public ThemeTextStyle textStyle() {
        return this.getTextStyle(this.getElemValue(this.textKey));
    }

    @Override
    @NotNull
    public ThemeTextStyle titleStyle() {
        ThemeTextStyle titleStyle = this.getTextStyle(this.getElemValue(this.titleTextKey));
        FontFace textFontFace = this.getFontFace(this.getElemValue(this.textKey));
        return ThemeTextStyle.copy$default(titleStyle, null, titleStyle.getFace().plus(textFontFace), 0.0, null, 13, null);
    }

    @Override
    @NotNull
    public ThemeTextStyle labelStyle() {
        ThemeTextStyle $this$labelStyle_u24lambda_u240 = this.textStyle();
        boolean bl = false;
        return new ThemeTextStyle($this$labelStyle_u24lambda_u240.getFamily(), FontFace.Companion.getBOLD().plus($this$labelStyle_u24lambda_u240.getFace()), $this$labelStyle_u24lambda_u240.getSize(), $this$labelStyle_u24lambda_u240.getColor());
    }

    @Override
    public boolean show() {
        return !this.isElemBlank(CollectionsKt.listOf((Object)"tooltip"));
    }
}

