/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj;

import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.DeflatedChunkReader;
import org.jetbrains.letsPlot.util.pngj.Inflater;
import org.jetbrains.letsPlot.util.pngj.PngjException;
import org.jetbrains.letsPlot.util.pngj.PngjInputException;
import org.jetbrains.letsPlot.util.pngj.Zip;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u000f\b\u0010\u0018\u00002\u00020\u0001:\u0001MB?\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010;\u001a\u00020\u00052\u0006\u0010<\u001a\u00020\u0003J\u0010\u0010=\u001a\u00020\u00052\b\u0010<\u001a\u0004\u0018\u00010\u0003J\u000e\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u001dJ\b\u0010A\u001a\u00020?H\u0016J\b\u0010B\u001a\u00020\u0005H\u0002J\u0006\u0010C\u001a\u00020?J\b\u0010D\u001a\u00020?H\u0014J\u000e\u0010E\u001a\u00020?2\u0006\u0010F\u001a\u00020\u0007J\u001e\u0010G\u001a\u00020?2\u0006\u0010H\u001a\u00020\f2\u0006\u0010I\u001a\u00020\u00072\u0006\u0010F\u001a\u00020\u0007J\b\u0010J\u001a\u00020?H\u0014J\b\u0010K\u001a\u00020\u0007H\u0014J\b\u0010L\u001a\u00020\u0003H\u0016R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u001a\u0010\u0015\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0017\"\u0004\b \u0010\u0019R\u000e\u0010!\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010#R\u0011\u0010$\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b$\u0010#R\u0011\u0010%\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b%\u0010#R\u0014\u0010&\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010#R\u0011\u0010'\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b'\u0010#R(\u0010(\u001a\u0004\u0018\u00010\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\f@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001e\u0010-\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0017R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0017\"\u0004\b0\u0010\u0019R\u000e\u00101\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u001e\u00103\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u0017R\u001a\u00105\u001a\u000206X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:\u00a8\u0006N"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/DeflatedChunksSet;", "", "chunkid", "", "isCallbackMode", "", "rowLen", "", "maxRowLen", "inflater", "Lorg/jetbrains/letsPlot/util/pngj/Inflater;", "buffer", "", "(Ljava/lang/String;ZIILorg/jetbrains/letsPlot/util/pngj/Inflater;[B)V", "<set-?>", "", "bytesIn", "getBytesIn", "()J", "bytesOut", "getBytesOut", "chunkNum", "getChunkNum", "()I", "setChunkNum", "(I)V", "getChunkid", "()Ljava/lang/String;", "curChunk", "Lorg/jetbrains/letsPlot/util/pngj/DeflatedChunkReader;", "firstChunqSeqNum", "getFirstChunqSeqNum", "setFirstChunqSeqNum", "inf", "infOwn", "()Z", "isClosed", "isDone", "isRowReady", "isWaitingForMoreInput", "row", "getRow", "()[B", "setRow", "([B)V", "rowFilled", "getRowFilled", "getRowLen", "setRowLen", "rowfilled", "rowlen", "rown", "getRown", "state", "Lorg/jetbrains/letsPlot/util/pngj/DeflatedChunksSet$State;", "getState", "()Lorg/jetbrains/letsPlot/util/pngj/DeflatedChunksSet$State;", "setState", "(Lorg/jetbrains/letsPlot/util/pngj/DeflatedChunksSet$State;)V", "ackNextChunkId", "id", "allowOtherChunksInBetween", "appendNewChunk", "", "cr", "close", "inflateData", "markAsDone", "preProcessRow", "prepareForNextRow", "len", "processBytes", "buf", "off", "processDoneCallback", "processRowCallback", "toString", "State", "plot-api"})
public class DeflatedChunksSet {
    @NotNull
    private final String chunkid;
    private final boolean isCallbackMode;
    private int rowLen;
    @Nullable
    private byte[] row;
    private final int rowfilled;
    private int rowFilled;
    private final int rowlen;
    private int rown;
    @NotNull
    private State state;
    @NotNull
    private Inflater inf;
    private boolean infOwn;
    @Nullable
    private DeflatedChunkReader curChunk;
    private long bytesIn;
    private long bytesOut;
    private int chunkNum;
    private int firstChunqSeqNum;

    @JvmOverloads
    public DeflatedChunksSet(@NotNull String chunkid, boolean isCallbackMode, int rowLen, int maxRowLen, @Nullable Inflater inflater, @Nullable byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)chunkid, (String)"chunkid");
        this.chunkid = chunkid;
        this.isCallbackMode = isCallbackMode;
        this.rowLen = rowLen;
        this.state = State.WAITING_FOR_INPUT;
        this.chunkNum = -1;
        this.firstChunqSeqNum = -1;
        if (this.rowLen < 1 || maxRowLen < this.rowLen) {
            throw new PngjException("bad inital row len " + this.rowLen);
        }
        if (inflater != null) {
            this.inf = inflater;
            this.infOwn = false;
        } else {
            this.inf = Zip.INSTANCE.newInflater();
            this.infOwn = true;
        }
        this.row = buffer != null && buffer.length >= this.rowLen ? buffer : new byte[maxRowLen];
        this.rown = -1;
        this.state = State.WAITING_FOR_INPUT;
        try {
            this.prepareForNextRow(this.rowLen);
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    public /* synthetic */ DeflatedChunksSet(String string, boolean bl, int n, int n2, Inflater inflater, byte[] byArray, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x10) != 0) {
            inflater = null;
        }
        if ((n3 & 0x20) != 0) {
            byArray = null;
        }
        this(string, bl, n, n2, inflater, byArray);
    }

    @NotNull
    public final String getChunkid() {
        return this.chunkid;
    }

    public final boolean isCallbackMode() {
        return this.isCallbackMode;
    }

    public final int getRowLen() {
        return this.rowLen;
    }

    public final void setRowLen(int n) {
        this.rowLen = n;
    }

    @Nullable
    public final byte[] getRow() {
        return this.row;
    }

    protected final void setRow(@Nullable byte[] byArray) {
        this.row = byArray;
    }

    public final int getRowFilled() {
        return this.rowFilled;
    }

    public final int getRown() {
        return this.rown;
    }

    @NotNull
    public final State getState() {
        return this.state;
    }

    public final void setState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"<set-?>");
        this.state = state;
    }

    public final long getBytesIn() {
        return this.bytesIn;
    }

    public final long getBytesOut() {
        return this.bytesOut;
    }

    public final int getChunkNum() {
        return this.chunkNum;
    }

    public final void setChunkNum(int n) {
        this.chunkNum = n;
    }

    public final int getFirstChunqSeqNum() {
        return this.firstChunqSeqNum;
    }

    public final void setFirstChunqSeqNum(int n) {
        this.firstChunqSeqNum = n;
    }

    public final void appendNewChunk(@NotNull DeflatedChunkReader cr) {
        Intrinsics.checkNotNullParameter((Object)cr, (String)"cr");
        if (!Intrinsics.areEqual((Object)this.chunkid, (Object)cr.getChunkRaw().getId())) {
            throw new PngjInputException("Bad chunk inside IdatSet, id:" + cr.getChunkRaw().getId() + ", expected:" + this.chunkid);
        }
        this.curChunk = cr;
        int n = this.chunkNum;
        this.chunkNum = n + 1;
        if (this.firstChunqSeqNum >= 0) {
            cr.setSeqNumExpected(this.chunkNum + this.firstChunqSeqNum);
        }
    }

    public final void processBytes(@NotNull byte[] buf, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        this.bytesIn += (long)len;
        if (len < 1 || this.state.isDone()) {
            return;
        }
        if (this.state == State.ROW_READY) {
            throw new PngjInputException("this should only be called if waitingForMoreInput");
        }
        if (this.inf.getNeedsDictionary() || !this.inf.getNeedsInput()) {
            throw new IllegalStateException("should not happen".toString());
        }
        this.inf.setInput(buf, off, len);
        if (this.isCallbackMode) {
            while (this.inflateData()) {
                int nextRowLen = this.processRowCallback();
                this.prepareForNextRow(nextRowLen);
                if (!this.isDone()) continue;
                this.processDoneCallback();
            }
        } else {
            this.inflateData();
        }
    }

    private final boolean inflateData() {
        try {
            State nextstate;
            int ninflated;
            block11: {
                block10: {
                    if (this.state == State.ROW_READY) {
                        throw new PngjException("invalid state");
                    }
                    if (this.state.isDone()) {
                        return false;
                    }
                    ninflated = 0;
                    if (this.row == null) break block10;
                    Intrinsics.checkNotNull((Object)this.row);
                    if (this.row.length >= this.rowLen) break block11;
                }
                this.row = new byte[this.rowLen];
            }
            if (this.rowFilled < this.rowLen && !this.inf.getFinished()) {
                Intrinsics.checkNotNull((Object)this.row);
                ninflated = this.inf.inflate(this.row, this.rowFilled, this.rowLen - this.rowFilled);
                this.rowFilled += ninflated;
                this.bytesOut += (long)ninflated;
            }
            this.state = nextstate = this.rowFilled == this.rowLen ? State.ROW_READY : (!this.inf.getFinished() ? State.WAITING_FOR_INPUT : (this.rowFilled > 0 ? State.ROW_READY : State.DONE));
            if (this.state == State.ROW_READY) {
                this.preProcessRow();
                return true;
            }
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
        return false;
    }

    protected void preProcessRow() {
    }

    protected int processRowCallback() {
        throw new PngjInputException("not implemented");
    }

    protected void processDoneCallback() {
    }

    public final void prepareForNextRow(int len) {
        this.rowFilled = 0;
        int n = this.rown;
        this.rown = n + 1;
        if (len < 1) {
            this.rowLen = 0;
            this.markAsDone();
        } else if (this.inf.getFinished()) {
            this.rowLen = 0;
            this.markAsDone();
        } else {
            this.state = State.WAITING_FOR_INPUT;
            this.rowLen = len;
            if (!this.isCallbackMode) {
                this.inflateData();
            }
        }
    }

    public final boolean isWaitingForMoreInput() {
        return this.state == State.WAITING_FOR_INPUT;
    }

    public boolean isRowReady() {
        return this.state == State.ROW_READY;
    }

    public final boolean isDone() {
        return this.state.isDone();
    }

    public final boolean isClosed() {
        return this.state.isClosed();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean ackNextChunkId(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (this.state.isClosed()) {
            return false;
        }
        if (Intrinsics.areEqual((Object)id, (Object)this.chunkid)) {
            return true;
        }
        if (this.allowOtherChunksInBetween(id)) return true;
        if (!this.state.isDone()) throw new PngjInputException("Unexpected chunk " + id + " while " + this.chunkid + " set is not done");
        if (this.state.isClosed()) return false;
        this.close();
        return false;
    }

    public void close() {
        try {
            if (!this.state.isClosed()) {
                this.state = State.CLOSED;
            }
            if (this.infOwn) {
                this.inf.end();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void markAsDone() {
        if (!this.isDone()) {
            this.state = State.DONE;
        }
    }

    public final boolean allowOtherChunksInBetween(@Nullable String id) {
        return false;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("idatSet : ");
        DeflatedChunkReader deflatedChunkReader = this.curChunk;
        Intrinsics.checkNotNull((Object)deflatedChunkReader);
        StringBuilder sb = new StringBuilder(stringBuilder.append(deflatedChunkReader.getChunkRaw().getId()).append(" state=").append((Object)this.state).append(" rows=").append(this.rown).append(" bytes=").append(this.bytesIn).append('/').append(this.bytesOut).toString());
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmOverloads
    public DeflatedChunksSet(@NotNull String chunkid, boolean isCallbackMode, int rowLen, int maxRowLen, @Nullable Inflater inflater) {
        Intrinsics.checkNotNullParameter((Object)chunkid, (String)"chunkid");
        this(chunkid, isCallbackMode, rowLen, maxRowLen, inflater, null, 32, null);
    }

    @JvmOverloads
    public DeflatedChunksSet(@NotNull String chunkid, boolean isCallbackMode, int rowLen, int maxRowLen) {
        Intrinsics.checkNotNullParameter((Object)chunkid, (String)"chunkid");
        this(chunkid, isCallbackMode, rowLen, maxRowLen, null, null, 48, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0005j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/DeflatedChunksSet$State;", "", "(Ljava/lang/String;I)V", "isClosed", "", "()Z", "isDone", "WAITING_FOR_INPUT", "ROW_READY", "DONE", "CLOSED", "plot-api"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State WAITING_FOR_INPUT = new State();
        public static final /* enum */ State ROW_READY = new State();
        public static final /* enum */ State DONE = new State();
        public static final /* enum */ State CLOSED = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public final boolean isDone() {
            return this == DONE || this == CLOSED;
        }

        public final boolean isClosed() {
            return this == CLOSED;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value2) {
            return Enum.valueOf(State.class, value2);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.WAITING_FOR_INPUT, State.ROW_READY, State.DONE, State.CLOSED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

