/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.inspector.components;

import com.intellij.icons.AllIcons;
import com.intellij.internal.inspector.UiInspectorUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.border.NamedBorder;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.ColorsIcon;
import com.intellij.util.ui.JBScalableIcon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ValueCellRenderer
implements TableCellRenderer {
    private static final Map<Class<?>, Renderer<?>> RENDERERS = new HashMap();
    private static final Renderer<Object> DEFAULT_RENDERER;
    private static final JLabel NULL_RENDERER;

    ValueCellRenderer() {
    }

    @Override
    public JLabel getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            NULL_RENDERER.setOpaque(isSelected);
            NULL_RENDERER.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
            NULL_RENDERER.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            return NULL_RENDERER;
        }
        Renderer renderer = (Renderer)ObjectUtils.notNull(ValueCellRenderer.getRenderer(value.getClass()), DEFAULT_RENDERER);
        renderer.setOpaque(isSelected);
        renderer.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
        renderer.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        renderer.setValue(value);
        return renderer;
    }

    @Nullable
    private static Renderer<Object> getRenderer(Class<?> clazz) {
        Class<?>[] interfaces;
        if (clazz == null) {
            return null;
        }
        Renderer<Object> renderer = RENDERERS.get(clazz);
        if (renderer != null) {
            return renderer;
        }
        for (Class<?> aClass : interfaces = clazz.getInterfaces()) {
            renderer = ValueCellRenderer.getRenderer(aClass);
            if (renderer == null) continue;
            return renderer;
        }
        if ((clazz = clazz.getSuperclass()) != null) {
            return ValueCellRenderer.getRenderer(clazz);
        }
        return null;
    }

    @NotNull
    public static String getToStringValue(@NotNull Object value) {
        if (value == null) {
            ValueCellRenderer.$$$reportNull$$$0(0);
        }
        StringBuilder sb = new StringBuilder();
        if (value.getClass().getName().equals("javax.swing.ArrayTable")) {
            Map<Object, Object> properties = ValueCellRenderer.parseClientProperties(value);
            if (properties != null) {
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    if (entry.getKey().equals(UiInspectorUtil.ADDED_AT_STACKTRACE)) continue;
                    if (!sb.isEmpty()) {
                        sb.append(",");
                    }
                    sb.append('[').append(entry.getKey()).append("->").append(entry.getValue()).append(']');
                }
            }
            if (sb.isEmpty()) {
                sb.append("-");
            }
            value = sb;
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            for (int index = 0; index < length; ++index) {
                Object obj;
                if (!sb.isEmpty()) {
                    sb.append(", ");
                }
                if ((obj = Array.get(value, index)) == null) continue;
                sb.append(obj.getClass().getName());
            }
            value = sb.isEmpty() ? "-" : sb;
        }
        String toString2 = StringUtil.notNullize((String)String.valueOf(value), (String)"toString()==null");
        String string = toString2.replace('\n', ' ');
        if (string == null) {
            ValueCellRenderer.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public static Map<Object, Object> parseClientProperties(@NotNull Object value) {
        Object table;
        if (value == null) {
            ValueCellRenderer.$$$reportNull$$$0(2);
        }
        if ((table = ReflectionUtil.getField(value.getClass(), (Object)value, Object.class, (String)"table")) instanceof Map) {
            return (Map)table;
        }
        if (table instanceof Object[]) {
            Object[] arr = (Object[])table;
            HashMap<Object, Object> properties = new HashMap<Object, Object>();
            for (int i = 0; i < arr.length; i += 2) {
                if (arr[i].equals(UiInspectorUtil.ADDED_AT_STACKTRACE)) continue;
                properties.put(arr[i], arr[i + 1]);
            }
            return properties;
        }
        return null;
    }

    private static ColorIcon createColorIcon(Color color) {
        return (ColorIcon)JBUIScale.scaleIcon((JBScalableIcon)new ColorIcon(13, 11, color, true));
    }

    private static Icon createColorIcon(Color color1, Color color2) {
        return JBUIScale.scaleIcon((JBScalableIcon)new ColorsIcon(11, new Color[]{color1, color2}));
    }

    static {
        RENDERERS.put(Point.class, new PointRenderer());
        RENDERERS.put(Dimension.class, new DimensionRenderer());
        RENDERERS.put(Insets.class, new InsetsRenderer());
        RENDERERS.put(Rectangle.class, new RectangleRenderer());
        RENDERERS.put(Color.class, new ColorRenderer());
        RENDERERS.put(Font.class, new FontRenderer());
        RENDERERS.put(Boolean.class, new BooleanRenderer());
        RENDERERS.put(Icon.class, new IconRenderer());
        RENDERERS.put(Border.class, new BorderRenderer());
        DEFAULT_RENDERER = new ObjectRenderer();
        NULL_RENDERER = new JLabel("-");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/inspector/components/ValueCellRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/inspector/components/ValueCellRenderer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getToStringValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getToStringValue";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseClientProperties";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static abstract class Renderer<T>
    extends JLabel {
        private Renderer() {
        }

        abstract void setValue(@NotNull T var1);
    }

    private static final class PointRenderer
    extends Renderer<Point> {
        private PointRenderer() {
        }

        @Override
        public void setValue(@NotNull Point value) {
            if (value == null) {
                PointRenderer.$$$reportNull$$$0(0);
            }
            this.setText(String.valueOf(value.x) + ":" + value.y);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/components/ValueCellRenderer$PointRenderer", "setValue"));
        }
    }

    private static final class DimensionRenderer
    extends Renderer<Dimension> {
        private DimensionRenderer() {
        }

        @Override
        public void setValue(@NotNull Dimension value) {
            if (value == null) {
                DimensionRenderer.$$$reportNull$$$0(0);
            }
            this.setText(value.width + "x" + value.height);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/components/ValueCellRenderer$DimensionRenderer", "setValue"));
        }
    }

    private static final class InsetsRenderer
    extends Renderer<Insets> {
        private InsetsRenderer() {
        }

        @Override
        public void setValue(@NotNull Insets value) {
            if (value == null) {
                InsetsRenderer.$$$reportNull$$$0(0);
            }
            this.setText("top: " + value.top + " left:" + value.left + " bottom:" + value.bottom + " right:" + value.right);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/components/ValueCellRenderer$InsetsRenderer", "setValue"));
        }
    }

    static final class RectangleRenderer
    extends Renderer<Rectangle> {
        RectangleRenderer() {
        }

        @Override
        public void setValue(@NotNull Rectangle value) {
            if (value == null) {
                RectangleRenderer.$$$reportNull$$$0(0);
            }
            this.setText(RectangleRenderer.toString(value));
        }

        @NotNull
        public static String toString(@NotNull Rectangle r) {
            if (r == null) {
                RectangleRenderer.$$$reportNull$$$0(1);
            }
            String string = r.width + "x" + r.height + " @ " + r.x + ":" + r.y;
            if (string == null) {
                RectangleRenderer.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/inspector/components/ValueCellRenderer$RectangleRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/inspector/components/ValueCellRenderer$RectangleRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "toString";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static final class ColorRenderer
    extends Renderer<Color> {
        private ColorRenderer() {
        }

        @Override
        public void setValue(@NotNull Color value) {
            String name;
            if (value == null) {
                ColorRenderer.$$$reportNull$$$0(0);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(" r:").append(value.getRed());
            sb.append(" g:").append(value.getGreen());
            sb.append(" b:").append(value.getBlue());
            sb.append(" a:").append(value.getAlpha());
            sb.append(" argb:0x");
            String hex = Integer.toHexString(value.getRGB());
            sb.append("0".repeat(8 - hex.length()));
            sb.append(StringUtil.toUpperCase((String)hex));
            if (value instanceof UIResource) {
                sb.append(" UIResource");
            }
            if (value instanceof JBColor && !StringUtil.isEmpty((String)(name = ((JBColor)value).getName()))) {
                sb.append(" name: ").append(name);
            }
            this.setText(sb.toString());
            this.setIcon((Icon)ValueCellRenderer.createColorIcon(value));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/components/ValueCellRenderer$ColorRenderer", "setValue"));
        }
    }

    private static final class FontRenderer
    extends Renderer<Font> {
        private FontRenderer() {
        }

        @Override
        public void setValue(@NotNull Font value) {
            if (value == null) {
                FontRenderer.$$$reportNull$$$0(0);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(value.getFontName()).append(" (").append(value.getFamily()).append("), ").append(value.getSize()).append("px");
            if (1 == (1 & value.getStyle())) {
                sb.append(" bold");
            }
            if (2 == (2 & value.getStyle())) {
                sb.append(" italic");
            }
            if (value instanceof UIResource) {
                sb.append(" UIResource");
            }
            Map<TextAttribute, ?> attributes = value.getAttributes();
            StringBuilder attrs = new StringBuilder();
            for (Map.Entry<TextAttribute, ?> entry : attributes.entrySet()) {
                String name;
                if (entry.getKey() == TextAttribute.FAMILY || entry.getKey() == TextAttribute.SIZE || entry.getValue() == null) continue;
                if (!attrs.isEmpty()) {
                    attrs.append(",");
                }
                attrs.append((name = (String)ReflectionUtil.getField(TextAttribute.class, (Object)entry.getKey(), String.class, (String)"name")) != null ? name : entry.getKey()).append("=").append(entry.getValue());
            }
            if (!attrs.isEmpty()) {
                sb.append(" {").append((CharSequence)attrs).append("}");
            }
            this.setText(sb.toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/components/ValueCellRenderer$FontRenderer", "setValue"));
        }
    }

    private static final class BooleanRenderer
    extends Renderer<Boolean> {
        private BooleanRenderer() {
        }

        @Override
        public void setValue(@NotNull Boolean value) {
            if (value == null) {
                BooleanRenderer.$$$reportNull$$$0(0);
            }
            this.setText(value != false ? "Yes" : "No");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/components/ValueCellRenderer$BooleanRenderer", "setValue"));
        }
    }

    private static final class IconRenderer
    extends Renderer<Icon> {
        private IconRenderer() {
        }

        @Override
        public void setValue(@NotNull Icon value) {
            if (value == null) {
                IconRenderer.$$$reportNull$$$0(0);
            }
            this.setIcon(value);
            this.setText(IconRenderer.getPathToIcon(value));
        }

        private static String getPathToIcon(@NotNull Icon value) {
            Icon icon;
            if (value == null) {
                IconRenderer.$$$reportNull$$$0(1);
            }
            if (value instanceof RetrievableIcon && (icon = ((RetrievableIcon)value).retrieveIcon()) != value) {
                return IconRenderer.getPathToIcon(icon);
            }
            String text = ValueCellRenderer.getToStringValue(value);
            if (text.startsWith("jar:") && text.contains("!")) {
                int index = text.lastIndexOf("!");
                String jarFile = text.substring(4, index);
                String path = text.substring(index + 1);
                return path + " in " + jarFile;
            }
            return text;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/intellij/internal/inspector/components/ValueCellRenderer$IconRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPathToIcon";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class BorderRenderer
    extends Renderer<Border> {
        private BorderRenderer() {
        }

        @Override
        public void setValue(@NotNull Border value) {
            if (value == null) {
                BorderRenderer.$$$reportNull$$$0(0);
            }
            this.setText(BorderRenderer.getTextDescription(value));
            if (value instanceof CompoundBorder) {
                Color insideColor = BorderRenderer.getBorderColor(((CompoundBorder)value).getInsideBorder());
                Color outsideColor = BorderRenderer.getBorderColor(((CompoundBorder)value).getOutsideBorder());
                if (insideColor != null && outsideColor != null) {
                    this.setIcon(ValueCellRenderer.createColorIcon(insideColor, outsideColor));
                } else if (insideColor != null) {
                    this.setIcon((Icon)ValueCellRenderer.createColorIcon(insideColor));
                } else if (outsideColor != null) {
                    this.setIcon((Icon)ValueCellRenderer.createColorIcon(outsideColor));
                } else {
                    this.setIcon(null);
                }
            } else {
                Color color = BorderRenderer.getBorderColor(value);
                this.setIcon((Icon)(color != null ? ValueCellRenderer.createColorIcon(color) : null));
            }
        }

        @Nullable
        private static Color getBorderColor(@Nullable Border value) {
            if (value instanceof LineBorder) {
                return ((LineBorder)value).getLineColor();
            }
            if (value instanceof CustomLineBorder) {
                try {
                    return (Color)ReflectionUtil.findField(CustomLineBorder.class, Color.class, (String)"myColor").get(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        @NotNull
        private static String getTextDescription(@Nullable Border value) {
            if (value == null) {
                return "null";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(UiInspectorUtil.getClassName((Object)value));
            Color color = BorderRenderer.getBorderColor(value);
            if (color != null) {
                sb.append(" color=").append(color);
            }
            if (value instanceof LineBorder && ((LineBorder)value).getRoundedCorners()) {
                sb.append(" roundedCorners=true");
            }
            if (value instanceof TitledBorder) {
                sb.append(" title='").append(((TitledBorder)value).getTitle()).append("'");
            }
            if (value instanceof CompoundBorder) {
                sb.append(" inside={").append(BorderRenderer.getTextDescription(((CompoundBorder)value).getInsideBorder())).append("}");
                sb.append(" outside={").append(BorderRenderer.getTextDescription(((CompoundBorder)value).getOutsideBorder())).append("}");
            }
            if (value instanceof EmptyBorder) {
                Insets insets = ((EmptyBorder)value).getBorderInsets();
                sb.append(" insets={top=").append(insets.top).append(" left=").append(insets.left).append(" bottom=").append(insets.bottom).append(" right=").append(insets.right).append("}");
            }
            if (value instanceof NamedBorder) {
                NamedBorder namedBorder = (NamedBorder)value;
                sb.append(" '").append(namedBorder.getName()).append("' ").append(BorderRenderer.getTextDescription(namedBorder.getOriginal()));
            }
            if (value instanceof UIResource) {
                sb.append(" UIResource");
            }
            sb.append(" (").append(ValueCellRenderer.getToStringValue(value)).append(")");
            String string = sb.toString();
            if (string == null) {
                BorderRenderer.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/inspector/components/ValueCellRenderer$BorderRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/inspector/components/ValueCellRenderer$BorderRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setValue";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static final class ObjectRenderer
    extends Renderer<Object> {
        private ObjectRenderer() {
            this.putClientProperty("html.disable", Boolean.TRUE);
        }

        @Override
        public void setValue(@NotNull Object value) {
            if (value == null) {
                ObjectRenderer.$$$reportNull$$$0(0);
            }
            this.setText(ValueCellRenderer.getToStringValue(value));
            this.setIcon(this.getText().contains("$$$setupUI$$$") ? AllIcons.FileTypes.UiForm : null);
            if (!this.getText().equals(this.getText().trim())) {
                this.setForeground((Color)JBColor.RED);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/internal/inspector/components/ValueCellRenderer$ObjectRenderer", "setValue"));
        }
    }
}

