/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.lang.ecmascript6.psi.impl.JSLinkedProject;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JSSymlinkLinkedProject
implements JSLinkedProject {
    private final VirtualFile myImportRoot;
    private final VirtualFile myLinkedPackage;
    private final String myPackageName;

    JSSymlinkLinkedProject(@NotNull VirtualFile sourceRoot, @NotNull VirtualFile linkedPackage, @NotNull String packageName) {
        if (sourceRoot == null) {
            JSSymlinkLinkedProject.$$$reportNull$$$0(0);
        }
        if (linkedPackage == null) {
            JSSymlinkLinkedProject.$$$reportNull$$$0(1);
        }
        if (packageName == null) {
            JSSymlinkLinkedProject.$$$reportNull$$$0(2);
        }
        this.myImportRoot = sourceRoot;
        this.myLinkedPackage = linkedPackage;
        this.myPackageName = packageName;
    }

    @Override
    @Nullable
    public VirtualFile getSourceFileByLinkedFile(@NotNull VirtualFile linkedFile) {
        if (linkedFile == null) {
            JSSymlinkLinkedProject.$$$reportNull$$$0(3);
        }
        return linkedFile.getCanonicalFile();
    }

    @Override
    @NotNull
    public String getPackageName() {
        String string = this.myPackageName;
        if (string == null) {
            JSSymlinkLinkedProject.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @Nullable
    public String getLinkedPath(@NotNull VirtualFile sourceFile) {
        if (sourceFile == null) {
            JSSymlinkLinkedProject.$$$reportNull$$$0(5);
        }
        if (sourceFile.equals(this.getSourceRoot())) {
            return this.getPackageName();
        }
        String pathToFile = VfsUtilCore.getRelativePath((VirtualFile)sourceFile, (VirtualFile)this.getSourceRoot());
        if (pathToFile == null) {
            return null;
        }
        return this.getPackageName() + "/" + pathToFile;
    }

    @Override
    @NotNull
    public VirtualFile getSourceRoot() {
        VirtualFile virtualFile = this.myImportRoot;
        if (virtualFile == null) {
            JSSymlinkLinkedProject.$$$reportNull$$$0(6);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile getLinkedPackageRoot() {
        VirtualFile virtualFile = this.myLinkedPackage;
        if (virtualFile == null) {
            JSSymlinkLinkedProject.$$$reportNull$$$0(7);
        }
        return virtualFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoot";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedPackage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedFile";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/psi/impl/JSSymlinkLinkedProject";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/JSSymlinkLinkedProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoot";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinkedPackageRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFileByLinkedFile";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLinkedPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7 -> new IllegalStateException(string);
        };
    }
}

