/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.extjs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.literal.JSLiteralImplicitElementProvider;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Ext4FrameworkHandler
extends FrameworkIndexingHandler {
    private static final String MODELS = "models";
    private static final String STORES = "stores";
    private static final String VIEWS = "views";
    private static final String CONTROLLERS = "controllers";
    private static final String REF = "ref";
    private static final String CONFIG = "config";
    private static final String ALIAS = "alias";
    private static final String DEFINE = "define";
    public static final String[] INTERESTED_METHOD_NAMES = new String[]{"define"};
    public static final String CLASS_NAME_PROPERTY = "$className";
    static final String CONFIG_OPTIONS_SUFFIX = "options";
    static final String[] EXT_CREATE = new String[]{"Ext", "create"};
    static final String[] EXT_DEFINE = new String[]{"Ext", "define"};
    private static final Pattern ourJSDocCfgPattern = Pattern.compile("^\\s*@cfg (?:\\{([^}]+)}\\s+)?([^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+)(.*)$");

    @Override
    public boolean processProperty(@Nullable String name, @NotNull JSProperty property, final @NotNull JSElementIndexingData outData) {
        if (property == null) {
            Ext4FrameworkHandler.$$$reportNull$$$0(0);
        }
        if (outData == null) {
            Ext4FrameworkHandler.$$$reportNull$$$0(1);
        }
        JSExpression value = property.getValue();
        if ((MODELS.equals(name) || STORES.equals(name) || VIEWS.equals(name) || CONTROLLERS.equals(name)) && value instanceof JSArrayLiteralExpression) {
            String suffix = null;
            for (JSExpression e : StreamEx.of(((JSArrayLiteralExpression)value).getExpressionStream())) {
                String s;
                if (!(e instanceof JSLiteralExpression) || (s = StringUtil.unquoteString((String)e.getText())).length() <= 0 || !StringUtil.isJavaIdentifier((String)s)) continue;
                if (suffix == null) {
                    suffix = StringUtil.toTitleCase((String)name);
                    suffix = suffix.substring(0, suffix.length() - 1);
                }
                s = StringUtil.toTitleCase((String)s);
                JSImplicitElementImpl.Builder builder2 = new JSImplicitElementImpl.Builder("get" + s + suffix, (PsiElement)e).setProperties(JSImplicitElement.Property.GetFunction);
                outData.addImplicitElement(builder2.toImplicitElement());
            }
            return false;
        }
        if (REF.equals(name) && value instanceof JSLiteralExpression) {
            String s = StringUtil.unquoteString((String)value.getText());
            if (s.length() > 0 && StringUtil.isJavaIdentifier((String)s)) {
                JSImplicitElementImpl.Builder builder3 = new JSImplicitElementImpl.Builder("get" + StringUtil.toTitleCase((String)s), (PsiElement)value).setProperties(JSImplicitElement.Property.GetFunction);
                outData.addImplicitElement(builder3.toImplicitElement());
            }
            return false;
        }
        if (CONFIG.equals(name) && value instanceof JSObjectLiteralExpression) {
            JSObjectLiteralExpression objectLiteral = (JSObjectLiteralExpression)value;
            PsiElement parent = value.getParent().getParent();
            if (!(parent instanceof JSObjectLiteralExpression) || !JSPsiImplUtils.isArgumentOfCallWithName((JSObjectLiteralExpression)parent, -1, EXT_DEFINE)) {
                return true;
            }
            outData.addAccessorsFromObjectLiteral(objectLiteral);
            JSSymbolUtil.forEachIdentifierProperty(objectLiteral, new JSSymbolUtil.PropertyProcessor(){

                @Override
                public void process(String titleCasedPropName, JSProperty property) {
                    outData.addImplicitElement(new JSImplicitElementImpl("apply" + titleCasedPropName, (PsiElement)property));
                }
            });
            return false;
        }
        if (Ext4FrameworkHandler.isXTypeDefinition(name, value)) {
            boolean isExt = ALIAS.equals(name);
            String className = Ext4FrameworkHandler.findExtClassName(value.getParent().getParent());
            List<JSExpression> expressions = value instanceof JSArrayLiteralExpression ? Arrays.asList(((JSArrayLiteralExpression)value).getExpressions()) : (value instanceof JSLiteralExpression ? Collections.singletonList(value) : Collections.emptyList());
            for (JSExpression expression : expressions) {
                boolean addAlias;
                if (!(expression instanceof JSLiteralExpression) || !((JSLiteralExpression)expression).isQuotedLiteral()) continue;
                String alias = StringUtil.unquoteString((String)expression.getText());
                boolean bl = addAlias = className != null;
                if (isExt) {
                    String widgetPrefix = "widget.";
                    if (alias.startsWith("widget.")) {
                        alias = alias.substring("widget.".length());
                    } else {
                        addAlias = false;
                    }
                }
                if (!addAlias) continue;
                outData.addImplicitElement(new JSImplicitElementImpl(alias, JSQualifiedNameImpl.fromQualifiedName("ext$xtype"), (PsiElement)expression));
                outData.addImplicitElement(new JSImplicitElementImpl(alias, (PsiElement)expression));
                outData.addTypedef(alias, className);
            }
            return false;
        }
        return true;
    }

    @Nullable
    private static String findExtClassName(PsiElement configObject) {
        if (!(configObject instanceof JSObjectLiteralExpression)) {
            return null;
        }
        PsiElement parent = configObject.getParent();
        if (parent instanceof JSReturnStatement && (parent = PsiTreeUtil.getParentOfType((PsiElement)parent, JSFunction.class)) != null) {
            configObject = parent;
            parent = parent.getParent();
        }
        if (parent instanceof JSArgumentList) {
            JSExpression[] arguments = ((JSArgumentList)parent).getArguments();
            if (arguments.length < 2 || configObject != arguments[1]) {
                return null;
            }
            if (!(arguments[0] instanceof JSLiteralExpression) || !((JSLiteralExpression)arguments[0]).isQuotedLiteral()) {
                return null;
            }
            PsiElement callExpression = parent.getParent();
            if (!(callExpression instanceof JSCallExpression)) {
                return null;
            }
            JSExpression methodExpression = ((JSCallExpression)callExpression).getMethodExpression();
            if (!(methodExpression instanceof JSReferenceExpression) || !DEFINE.equals(((JSReferenceExpression)methodExpression).getReferenceName())) {
                return null;
            }
            return StringUtil.unquoteString((String)arguments[0].getText());
        }
        return null;
    }

    @Contract(value="_, null -> false")
    private static boolean isXTypeDefinition(String name, JSElement value) {
        if (value == null) {
            return false;
        }
        if (ALIAS.equals(name)) {
            return true;
        }
        if (!"xtype".equals(name)) {
            return false;
        }
        PsiElement property = value.getParent();
        if (!(property instanceof JSProperty)) {
            return false;
        }
        PsiElement objectLiteral = property.getParent();
        return objectLiteral instanceof JSObjectLiteralExpression && JSPsiImplUtils.isArgumentOfCallWithName((JSObjectLiteralExpression)objectLiteral, -1, EXT_DEFINE);
    }

    @Override
    public String @NotNull [] interestedProperties() {
        String[] stringArray = new String[]{MODELS, CONTROLLERS, VIEWS, STORES, REF, CONFIG, ALIAS, "xtype"};
        if (stringArray == null) {
            Ext4FrameworkHandler.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    @Override
    public void processCallExpression(JSCallExpression callExpression, @NotNull JSElementIndexingData outData) {
        JSExpression methodExpression;
        if (outData == null) {
            Ext4FrameworkHandler.$$$reportNull$$$0(3);
        }
        if (!((methodExpression = callExpression.getMethodExpression()) instanceof JSReferenceExpression)) {
            return;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)methodExpression;
        if (JSSymbolUtil.isAccurateReferenceExpressionName(referenceExpression, "Ext", "reg") || JSSymbolUtil.isAccurateReferenceExpressionName(referenceExpression, "Ext", "ComponentMgr", "registerType")) {
            JSLiteralExpression literalExpression;
            JSExpression[] arguments = callExpression.getArguments();
            if (!(arguments.length == 2 && arguments[0] instanceof JSLiteralExpression && (literalExpression = (JSLiteralExpression)arguments[0]).isQuotedLiteral() && arguments[1] instanceof JSReferenceExpression)) {
                return;
            }
            String xtype = StringUtil.unquoteString((String)literalExpression.getText());
            outData.addImplicitElement(new JSImplicitElementImpl(xtype, JSQualifiedNameImpl.fromQualifiedName("ext$xtype"), (PsiElement)literalExpression));
            outData.addImplicitElement(new JSImplicitElementImpl(xtype, (PsiElement)literalExpression));
            outData.addTypedef(xtype, arguments[1].getText());
        }
    }

    @Override
    public boolean shouldCreateStubForCallExpression(@NotNull ASTNode node) {
        ASTNode methodExpression;
        if (node == null) {
            Ext4FrameworkHandler.$$$reportNull$$$0(4);
        }
        if ((methodExpression = node.getFirstChildNode()).getElementType() != JSElementTypes.REFERENCE_EXPRESSION) {
            return false;
        }
        ASTNode referencedNameElement = methodExpression.getLastChildNode();
        if (referencedNameElement == null) {
            return false;
        }
        String referencedName = referencedNameElement.getText();
        if ("reg".equals(referencedName)) {
            ASTNode qualifier = methodExpression.getFirstChildNode();
            return qualifier.getElementType() == JSElementTypes.REFERENCE_EXPRESSION && qualifier.getFirstChildNode() == qualifier.getLastChildNode() && "Ext".equals(qualifier.getText());
        }
        if ("registerType".equals(referencedName)) {
            ASTNode qualifier = methodExpression.getFirstChildNode();
            ASTNode qualifierQualifier = qualifier.getFirstChildNode();
            return qualifierQualifier != null && qualifierQualifier.getElementType() == JSElementTypes.REFERENCE_EXPRESSION && qualifierQualifier.getFirstChildNode() == qualifierQualifier.getLastChildNode() && "ComponentMgr".equals(qualifier.getLastChildNode().getText()) && "Ext".equals(qualifierQualifier.getText());
        }
        return false;
    }

    @Override
    public String resolveContextFromProperty(JSObjectLiteralExpression objectLiteralExpression, boolean returnPropertiesNamespace) {
        JSExpression value;
        String value2;
        if (!returnPropertiesNamespace && (value2 = Ext4FrameworkHandler.resolveXType(objectLiteralExpression)) != null) {
            return value2;
        }
        JSProperty classNameProperty = objectLiteralExpression.findProperty(CLASS_NAME_PROPERTY);
        if (classNameProperty != null && (value = classNameProperty.getValue()) instanceof JSLiteralExpression && ((JSLiteralExpression)value).isQuotedLiteral()) {
            return StringUtil.unquoteString((String)value.getText());
        }
        return null;
    }

    private static String resolveXType(JSObjectLiteralExpression objectLiteralExpression) {
        JSExpression value;
        PsiElement parent;
        JSProperty property = objectLiteralExpression.findProperty("xtype");
        if (property == null && (parent = objectLiteralExpression.getParent()) instanceof JSProperty) {
            JSObjectLiteralExpression parentObjectLiteral = (JSObjectLiteralExpression)parent.getParent();
            property = parentObjectLiteral.findProperty("xtype");
        }
        if (property != null && (value = property.getValue()) instanceof JSLiteralExpression && ((JSLiteralExpression)value).isQuotedLiteral()) {
            return StringUtil.unquoteString((String)value.getText());
        }
        return null;
    }

    @Override
    public String @NotNull [] implicitProviderMethodNames() {
        if (INTERESTED_METHOD_NAMES == null) {
            Ext4FrameworkHandler.$$$reportNull$$$0(5);
        }
        return INTERESTED_METHOD_NAMES;
    }

    @Override
    public String @NotNull [] inheritanceMethodNames() {
        if (INTERESTED_METHOD_NAMES == null) {
            Ext4FrameworkHandler.$$$reportNull$$$0(6);
        }
        return INTERESTED_METHOD_NAMES;
    }

    @Override
    public JSLiteralImplicitElementProvider createLiteralImplicitElementProvider(@NotNull String calledMethodName) {
        if (calledMethodName == null) {
            Ext4FrameworkHandler.$$$reportNull$$$0(7);
        }
        if (DEFINE.equals(calledMethodName)) {
            return new JSLiteralImplicitElementProvider(){

                @Override
                public void fillIndexingData(@NotNull JSLiteralExpression argument, @NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outIndexingData) {
                    JSQualifiedName className;
                    JSExpression[] arguments;
                    JSExpression expression;
                    if (argument == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (callExpression == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (outIndexingData == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if (JSSymbolUtil.isAccurateReferenceExpressionName(expression = callExpression.getMethodExpression(), EXT_DEFINE) && (arguments = callExpression.getArguments()).length >= 2 && arguments[0] == argument && (className = JSSymbolUtil.getLiteralValueAsQualifiedName(argument)) != null) {
                        2.addConstructorParameters(argument, className, outIndexingData);
                        JSProperty extendProperty = arguments[1] instanceof JSObjectLiteralExpression ? ((JSObjectLiteralExpression)arguments[1]).findProperty("extend") : null;
                        String baseClassName = null;
                        if (extendProperty == null) {
                            baseClassName = "Ext.Base";
                            outIndexingData.addBaseType(className.getQualifiedName(), baseClassName);
                        } else {
                            JSQualifiedName baseQName;
                            JSExpression value = extendProperty.getValue();
                            if (value instanceof JSLiteralExpression && (baseQName = JSSymbolUtil.getLiteralValueAsQualifiedName((JSLiteralExpression)value)) != null) {
                                baseClassName = baseQName.getQualifiedName();
                            }
                        }
                        if (baseClassName != null) {
                            outIndexingData.addBaseType(className + ".options", baseClassName + ".options");
                        }
                    }
                }

                private static void addConstructorParameters(@NotNull JSLiteralExpression argument, @NotNull JSQualifiedName className, @NotNull JSElementIndexingData outIndexingData) {
                    Collection<JSImplicitElement> elements;
                    if (argument == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    if (className == null) {
                        2.$$$reportNull$$$0(4);
                    }
                    if (outIndexingData == null) {
                        2.$$$reportNull$$$0(5);
                    }
                    if ((elements = outIndexingData.getImplicitElements()) != null) {
                        elements.removeIf(element -> className.equals(JSQualifiedNameImpl.buildProvidedNamespace(element)));
                    }
                    JSQualifiedNameImpl qName = JSQualifiedNameImpl.create(Ext4FrameworkHandler.CONFIG_OPTIONS_SUFFIX, className);
                    JSNamespace ns = JSNamedTypeFactory.createNamespace((JSQualifiedName)qName, JSContext.INSTANCE, (PsiElement)argument, true);
                    JSParameterTypeDecoratorImpl p = new JSParameterTypeDecoratorImpl(ns, true, false, true);
                    JSImplicitElementImpl.Builder builder2 = new JSImplicitElementImpl.Builder(className, (PsiElement)argument).setJSType(new JSFunctionTypeImpl(JSTypeSource.EMPTY, Collections.singletonList(p), null, null)).setType(JSImplicitElement.Type.Class);
                    outIndexingData.addImplicitElement(builder2.toImplicitElement());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "argument";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "callExpression";
                            break;
                        }
                        case 2: 
                        case 5: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outIndexingData";
                            break;
                        }
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "className";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/lang/javascript/frameworks/extjs/Ext4FrameworkHandler$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "fillIndexingData";
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[2] = "addConstructorParameters";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        return super.createLiteralImplicitElementProvider(calledMethodName);
    }

    @Override
    @Nullable
    public JSElementIndexingData processJSDocComment(@NotNull JSDocComment comment, @Nullable JSElementIndexingData outData) {
        if (comment == null) {
            Ext4FrameworkHandler.$$$reportNull$$$0(8);
        }
        for (JSDocTag tag : comment.getTags()) {
            String tagName = tag.getName();
            if (!"cfg".equals(tagName)) continue;
            JSImplicitElement element = Ext4FrameworkHandler.buildCfgElement(tag, comment);
            if (element == null) break;
            if (outData == null) {
                outData = new JSElementIndexingDataImpl();
            }
            outData.addImplicitElement(element);
            break;
        }
        return outData;
    }

    @Nullable
    private static JSImplicitElement buildCfgElement(@NotNull JSDocTag cfgTag, @NotNull JSDocComment comment) {
        PsiElement namedElement;
        Matcher matcher;
        if (cfgTag == null) {
            Ext4FrameworkHandler.$$$reportNull$$$0(9);
        }
        if (comment == null) {
            Ext4FrameworkHandler.$$$reportNull$$$0(10);
        }
        if (!(matcher = ourJSDocCfgPattern.matcher(cfgTag.getText())).matches()) {
            return null;
        }
        String cfgType = matcher.group(1);
        String cfgName = matcher.group(2);
        if (cfgName == null && (namedElement = JSDocumentationUtils.findAttachedElementFromComment(comment)) instanceof JSNamedElement) {
            cfgName = ((JSNamedElement)namedElement).getName();
        }
        if (cfgName == null) {
            return null;
        }
        JSArgumentList argList = (JSArgumentList)PsiTreeUtil.getParentOfType((PsiElement)comment, JSArgumentList.class);
        if (argList == null) {
            return null;
        }
        JSExpression[] arguments = argList.getArguments();
        if (arguments.length < 2) {
            return null;
        }
        JSExpression configObj = arguments[1];
        String className = Ext4FrameworkHandler.findExtClassName((PsiElement)configObj);
        if (className == null) {
            return null;
        }
        JSQualifiedNameImpl classQName = JSQualifiedNameImpl.fromQualifiedName(className);
        JSNamespace cfgNamespace = JSNamedTypeFactory.createNamespace((JSQualifiedName)JSQualifiedNameImpl.create(CONFIG_OPTIONS_SUFFIX, classQName), JSContext.INSTANCE, null, true);
        JSImplicitElementImpl.Builder builder2 = new JSImplicitElementImpl.Builder(cfgName, (PsiElement)comment).setType(JSImplicitElement.Type.Property).setNamespace(cfgNamespace).setJSType(JSTypeParser.createType(cfgType, JSTypeSource.EMPTY));
        return builder2.toImplicitElement();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outData";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/extjs/Ext4FrameworkHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calledMethodName";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cfgTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/extjs/Ext4FrameworkHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "interestedProperties";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "implicitProviderMethodNames";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "inheritanceMethodNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processProperty";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processCallExpression";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "shouldCreateStubForCallExpression";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createLiteralImplicitElementProvider";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processJSDocComment";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildCfgElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6 -> new IllegalStateException(string);
        };
    }
}

