/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.typescript;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSGenericParameterType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeGenericId;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericParameterImpl;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptGenericDeclarationTypeImpl
extends JSTypeBaseImpl
implements JSGenericParameterType {
    @NotNull
    private final JSTypeGenericId myId;
    @Nullable
    private final NotNullLazyValue<? extends JSType> myConstraintType;
    @Nullable
    private final NotNullLazyValue<? extends JSType> myDefaultType;
    private final boolean myConst;

    public TypeScriptGenericDeclarationTypeImpl(@NotNull JSTypeGenericId id, @Nullable NotNullLazyValue<? extends JSType> constraintType, @Nullable NotNullLazyValue<? extends JSType> defaultType, @NotNull JSTypeSource source, boolean aConst) {
        if (id == null) {
            TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(0);
        }
        if (source == null) {
            TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(1);
        }
        super(source);
        this.myId = id;
        this.myConstraintType = constraintType;
        this.myDefaultType = defaultType;
        this.myConst = aConst;
    }

    public TypeScriptGenericDeclarationTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(2);
        }
        if (inputStream == null) {
            TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(3);
        }
        super(source);
        this.myId = JSTypeSerializer.readGenericId(inputStream);
        JSType constraintType = JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.read(source, inputStream);
        this.myConstraintType = constraintType == null ? null : NotNullLazyValue.createConstantValue((Object)constraintType);
        JSType defaultType = JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.read(source, inputStream);
        this.myDefaultType = defaultType == null ? null : NotNullLazyValue.createConstantValue((Object)defaultType);
        this.myConst = JSTypeSerializer.readBoolean(inputStream);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(4);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeGenericId(this.myId, outputStream);
        JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.write(this.getConstraintType(), outputStream);
        JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.write(this.getDefaultType(), outputStream);
        JSTypeSerializer.writeBoolean(this.myConst, outputStream);
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform, @NotNull JSTypeSource newSource) {
        if (childTransform == null) {
            TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(5);
        }
        if (newSource == null) {
            TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(6);
        }
        JSType defaultType = this.getDefaultType();
        JSType newDefault = JSTypeUtils.transformTypeHierarchySafe(defaultType, childTransform);
        JSType constraintType = this.getConstraintType();
        JSType newConstraint = JSTypeUtils.transformTypeHierarchySafe(constraintType, childTransform);
        if (newDefault == defaultType && newConstraint == constraintType) {
            TypeScriptGenericDeclarationTypeImpl typeScriptGenericDeclarationTypeImpl = this;
            if (typeScriptGenericDeclarationTypeImpl == null) {
                TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(7);
            }
            return typeScriptGenericDeclarationTypeImpl;
        }
        return new TypeScriptGenericDeclarationTypeImpl(this.myId, (NotNullLazyValue<? extends JSType>)(newConstraint != null ? NotNullLazyValue.createConstantValue((Object)newConstraint) : null), (NotNullLazyValue<? extends JSType>)(newDefault != null ? NotNullLazyValue.createConstantValue((Object)newDefault) : null), newSource, this.myConst);
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(8);
        }
        return new TypeScriptGenericDeclarationTypeImpl(this.myId, this.myConstraintType, this.myDefaultType, source, this.myConst);
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(9);
        }
        if (processingContext == null) {
            TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(10);
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        JSType defaultType;
        JSType constraintType;
        if (visitor == null) {
            TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(11);
        }
        if ((constraintType = this.getConstraintType()) != null) {
            constraintType.accept(visitor);
        }
        if ((defaultType = this.getDefaultType()) != null) {
            defaultType.accept(visitor);
        }
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext context2, boolean allowResolve) {
        TypeScriptGenericDeclarationTypeImpl rType;
        if (type == null) {
            TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(12);
        }
        if (!Objects.equals((rType = (TypeScriptGenericDeclarationTypeImpl)type).getName(), this.getName())) {
            return false;
        }
        if (!JSType.isEquivalentToSafe(this.getConstraintType(), rType.getConstraintType(), context2, allowResolve)) {
            return false;
        }
        if (!JSType.isEquivalentToSafe(this.getDefaultType(), rType.getDefaultType(), context2, allowResolve)) {
            return false;
        }
        return this.myId.equals(rType.myId);
    }

    @Override
    protected int hashCodeImpl() {
        return Objects.hash(this.myId, this.getConstraintType(), this.getDefaultType());
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder2) {
        JSType constraintType;
        if (format == null) {
            TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(13);
        }
        if (builder2 == null) {
            TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(14);
        }
        if (this.myConst) {
            builder2.append("const ");
        }
        builder2.append(this.myId.getName());
        JSType defaultType = this.getDefaultType();
        if (defaultType != null) {
            builder2.append("=");
            defaultType.buildTypeText(format, builder2);
        }
        if ((constraintType = this.getConstraintType()) != null) {
            builder2.append(" extends ");
            constraintType.buildTypeText(format, builder2);
        }
    }

    @Override
    @Nullable
    public JSType getConstraintType() {
        return this.myConstraintType != null ? (JSType)this.myConstraintType.getValue() : null;
    }

    @Nullable
    public JSType getDefaultType() {
        return this.myDefaultType != null ? (JSType)this.myDefaultType.getValue() : null;
    }

    public boolean isConst() {
        return this.myConst;
    }

    @NotNull
    public String getName() {
        String string = this.myId.getName();
        if (string == null) {
            TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Override
    @NotNull
    public JSTypeGenericId getGenericId() {
        JSTypeGenericId jSTypeGenericId = this.myId;
        if (jSTypeGenericId == null) {
            TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(16);
        }
        return jSTypeGenericId;
    }

    @NotNull
    public JSGenericParameterType toGenericParameter() {
        return new TypeScriptGenericParameterImpl(this.myId, this.getSource(), this.getConstraintType(), this.myConst);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 7: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/typescript/TypeScriptGenericDeclarationTypeImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/typescript/TypeScriptGenericDeclarationTypeImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 7: 
            case 15: 
            case 16: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 15, 16 -> new IllegalStateException(string);
        };
    }
}

