/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.protocol;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.text.CharSequenceReader;
import java.io.Reader;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\u000bJ\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010!\u001a\u00020\u000bH\u0016R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\u0006\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\rR\u0011\u0010 \u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001b\u00a8\u0006#"}, d2={"Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceAnswer;", "", "s", "", "<init>", "(Ljava/lang/CharSequence;)V", "element", "Lcom/google/gson/JsonElement;", "(Lcom/google/gson/JsonElement;)V", "myElement", "command", "", "getCommand", "()Ljava/lang/String;", "seq", "", "getSeq", "()Ljava/lang/Integer;", "type", "getType", "Lcom/google/gson/JsonObject;", "getElement", "()Lcom/google/gson/JsonObject;", "getProperty", "name", "isSuccess", "", "()Z", "errorMessage", "getErrorMessage", "logIfError", "", "isEmpty", "toString", "Companion", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSLanguageServiceAnswer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSLanguageServiceAnswer.kt\ncom/intellij/lang/javascript/service/protocol/JSLanguageServiceAnswer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1#2:91\n*E\n"})
public final class JSLanguageServiceAnswer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsonElement myElement;
    @NotNull
    public static final String COMMAND = "command";
    @NotNull
    public static final String SEQ = "request_seq";
    @NotNull
    public static final String TYPE = "type";
    @NotNull
    public static final String NO_INFO_FLAG = "noInfo";

    public JSLanguageServiceAnswer(@NotNull CharSequence s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.myElement = new JsonParser().parse((Reader)new CharSequenceReader(s));
        boolean bl = this.myElement.isJsonObject();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    public JSLanguageServiceAnswer(@NotNull JsonElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.myElement = element;
    }

    @Nullable
    public final String getCommand() {
        JsonElement jsonElement = this.getElement().get(COMMAND);
        return jsonElement != null ? jsonElement.getAsString() : null;
    }

    @Nullable
    public final Integer getSeq() {
        JsonElement jsonElement = this.getElement().get(SEQ);
        return jsonElement != null ? Integer.valueOf(jsonElement.getAsInt()) : null;
    }

    @Nullable
    public final String getType() {
        JsonElement jsonElement = this.getElement().get(TYPE);
        return jsonElement != null ? jsonElement.getAsString() : null;
    }

    @NotNull
    public final JsonObject getElement() {
        JsonElement jsonElement = this.myElement;
        Intrinsics.checkNotNull((Object)jsonElement, (String)"null cannot be cast to non-null type com.google.gson.JsonObject");
        return (JsonObject)jsonElement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String getProperty(@NotNull String name) {
        JsonElement jsonElement;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        JsonElement jsonElement3 = this.getElement().get(name);
        jsonElement3 = jsonElement3;
        if (jsonElement2 == null) return null;
        JsonElement it = jsonElement = jsonElement3;
        boolean bl = false;
        if (!it.isJsonPrimitive()) return null;
        JsonElement jsonElement3 = jsonElement;
        jsonElement3 = jsonElement3;
        if (jsonElement4 == null) return null;
        String string = jsonElement3.getAsString();
        return string;
    }

    public final boolean isSuccess() {
        JsonElement successElement = this.getElement().get("success");
        return !(successElement instanceof JsonPrimitive) || !((JsonPrimitive)successElement).isBoolean() || ((JsonPrimitive)successElement).getAsBoolean();
    }

    @Nullable
    public final String getErrorMessage() {
        if (this.isSuccess()) {
            return null;
        }
        JsonElement messageElement = this.getElement().get("message");
        if (messageElement instanceof JsonPrimitive && ((JsonPrimitive)messageElement).isString() && !Intrinsics.areEqual((Object)"No content available.", (Object)((JsonPrimitive)messageElement).getAsString())) {
            return ((JsonPrimitive)messageElement).getAsString();
        }
        return null;
    }

    public final void logIfError() {
        String errorMessage = this.getErrorMessage();
        if (errorMessage != null) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                try {
                    JSLanguageServiceQueue.Holder.LOGGER.error((Throwable)new Exception(errorMessage));
                }
                catch (Throwable throwable) {}
            } else {
                JSLanguageServiceQueue.Holder.LOGGER.warn(errorMessage);
            }
        }
    }

    public final boolean isEmpty() {
        return this.getElement().has(NO_INFO_FLAG);
    }

    @NotNull
    public String toString() {
        return "JSLanguageCompilerAnswer{myElement=" + this.myElement + "}";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceAnswer$Companion;", "", "<init>", "()V", "COMMAND", "", "SEQ", "TYPE", "NO_INFO_FLAG", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

