/*
 * Decompiled with CFR 0.152.
 */
package training.ui;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.ui.OnboardingFeedbackFormKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\n\b\u0001\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0013\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\nJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Ltraining/ui/FeedbackOption;", "Ljavax/swing/JButton;", "text", "", "unselectedIcon", "Ljavax/swing/Icon;", "selectedIcon", "<init>", "(Ljava/lang/String;Ljavax/swing/Icon;Ljavax/swing/Icon;)V", "(Ljava/lang/String;)V", "(Ljavax/swing/Icon;Ljavax/swing/Icon;)V", "isChosen", "", "()Z", "setChosen", "(Z)V", "paint", "", "g", "Ljava/awt/Graphics;", "intellij.featuresTrainer"})
final class FeedbackOption
extends JButton {
    private boolean isChosen;

    public FeedbackOption(@NlsContexts.Label @Nullable String text, final @Nullable Icon unselectedIcon, final @Nullable Icon selectedIcon) {
        this.putClientProperty("styleTag", true);
        this.setFocusable(false);
        this.setAction(new AbstractAction(text){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.setChosen(!this.isChosen());
                if (this.isChosen()) {
                    this.setIcon(selectedIcon);
                } else {
                    this.setIcon(unselectedIcon);
                }
            }
        });
    }

    public final boolean isChosen() {
        return this.isChosen;
    }

    public final void setChosen(boolean bl) {
        this.isChosen = bl;
    }

    public FeedbackOption(@NlsContexts.Label @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this(text, null, null);
    }

    public FeedbackOption(@NotNull Icon unselectedIcon, @NotNull Icon selectedIcon) {
        Intrinsics.checkNotNullParameter((Object)unselectedIcon, (String)"unselectedIcon");
        Intrinsics.checkNotNullParameter((Object)selectedIcon, (String)"selectedIcon");
        this(null, OnboardingFeedbackFormKt.access$getLikenessIcon(unselectedIcon), OnboardingFeedbackFormKt.access$getLikenessIcon(selectedIcon));
    }

    @Override
    public void paint(@NotNull Graphics g) {
        JBColor jBColor;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        JBColor hoverBackgroundColor = new JBColor(new Color(0xDFDFDF), new Color(5001298));
        JBColor selectedBackgroundColor = new JBColor(new Color(0xFFFFFF), new Color(0x313335));
        JBColor unselectedForeground = new JBColor(new Color(0), new Color(0xBBBBBB));
        JBColor selectedForeground = new JBColor(new Color(0), new Color(0xFEFEFE));
        if (this.isChosen) {
            jBColor = selectedBackgroundColor;
        } else if (this.getMousePosition() != null) {
            jBColor = hoverBackgroundColor;
        } else {
            JBColor jBColor2 = JBColor.namedColor((String)"Panel.background", (Color)Color.WHITE);
            jBColor = jBColor2;
            Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"namedColor(...)");
        }
        JBColor backgroundColor = jBColor;
        JBColor foregroundColor = this.isChosen ? selectedForeground : unselectedForeground;
        this.putClientProperty("JButton.backgroundColor", backgroundColor);
        this.setForeground((Color)foregroundColor);
        super.paint(g);
    }
}

