/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.ref;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.python.django.util.DjangoUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.jetbrains.django.model.DjangoModel;
import com.jetbrains.django.model.applications.DjangoApplicationModel;
import com.jetbrains.django.model.applications.DjangoUnnamedApplicationModel;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.django.model.modelApi.DjangoModelClass;
import com.jetbrains.django.model.relationalKeys.DjangoKeyCallInfo;
import com.jetbrains.django.ref.DjangoItemFilter;
import com.jetbrains.django.ref.DjangoItemReference;
import com.jetbrains.django.ref.DjangoItemReferenceSet;
import com.jetbrains.django.util.DjangoPsiUtil;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyFileImpl;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoRelationsReferenceProvider
extends PsiReferenceProvider {
    private static final PsiElementPattern.Capture<PsiElement> LOG_CLASS_PATTERN = DjangoPsiUtil.valueInsideDictPattern((String)"class", (String)"LOGGING");

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PyCallExpression callExpression;
        if (element == null) {
            DjangoRelationsReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DjangoRelationsReferenceProvider.$$$reportNull$$$0(1);
        }
        if ((callExpression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyCallExpression.class)) == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                DjangoRelationsReferenceProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        DjangoKeyCallInfo callInfo = DjangoKeyCallInfo.getSimpleKeyCallInfo((PyCallExpression)callExpression, (TypeEvalContext)TypeEvalContext.codeAnalysis((Project)element.getProject(), null));
        if (callInfo == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                DjangoRelationsReferenceProvider.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (element.equals(callInfo.getDestClassExpression()) || element.equals(callInfo.getThroughClassExpression())) {
            PsiReference[] psiReferenceArray = new DjangoModelReferenceSet(element, DjangoItemFilter.CLASSES).getAllReferences();
            if (psiReferenceArray == null) {
                DjangoRelationsReferenceProvider.$$$reportNull$$$0(4);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            DjangoRelationsReferenceProvider.$$$reportNull$$$0(5);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/django/ref/DjangoRelationsReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/django/ref/DjangoRelationsReferenceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    private static final class DjangoModelReferenceSet
    extends DjangoItemReferenceSet {
        private DjangoModelReferenceSet(PsiElement element, DjangoItemFilter filter) {
            super(element, filter);
        }

        @NotNull
        public Collection<PsiFileSystemItem> getDefaultContexts() {
            ArrayList contexts = Lists.newArrayList((Iterable)super.getDefaultContexts());
            PyFileImpl file = (PyFileImpl)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PyFileImpl.class);
            if (file != null) {
                contexts.add(file);
            }
            ArrayList arrayList = contexts;
            if (arrayList == null) {
                DjangoModelReferenceSet.$$$reportNull$$$0(0);
            }
            return arrayList;
        }

        protected DjangoItemReference createDjangoReference(TextRange range, int index, String subreferenceText, boolean isLast) {
            return new DjangoModelItemReference(range, index, subreferenceText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/python/django/ref/DjangoRelationsReferenceProvider$DjangoModelReferenceSet", "getDefaultContexts"));
        }

        private final class DjangoModelItemReference
        extends DjangoItemReference {
            DjangoModelItemReference(TextRange range, int index, String subreferenceText) {
                super((DjangoItemReferenceSet)DjangoModelReferenceSet.this, range, index, subreferenceText);
            }

            protected boolean isAllowed(PsiElement child) {
                if (child instanceof PyClass) {
                    return DjangoModel.isDjangoModelDescendant((PyClass)((PyClass)child), null);
                }
                return super.isAllowed(child);
            }

            public PsiElement bindToElement(@NotNull PsiElement element) {
                PsiNamedElement namedElement;
                if (element == null) {
                    DjangoModelItemReference.$$$reportNull$$$0(0);
                }
                if ((namedElement = (PsiNamedElement)PyUtil.as((Object)element, PsiNamedElement.class)) != null) {
                    String appName;
                    QualifiedName modelName = QualifiedName.fromDottedString((String)this.myReferenceSet.getText());
                    if (namedElement instanceof PyClass && (appName = this.getApplicationNameFromModel(modelName, (PyClass)namedElement)) != null) {
                        return this.rename(appName, namedElement.getName());
                    }
                    return super.bindToElement(element);
                }
                throw new IncorrectOperationException("Element does not have a name");
            }

            @Nullable
            private String getApplicationNameFromModel(@NotNull QualifiedName qName, @NotNull PyClass model) {
                if (qName == null) {
                    DjangoModelItemReference.$$$reportNull$$$0(1);
                }
                if (model == null) {
                    DjangoModelItemReference.$$$reportNull$$$0(2);
                }
                if (qName.getComponentCount() != 2) {
                    return null;
                }
                DjangoModelApi api = (DjangoModelApi)DjangoModelApi.create((PyElement)model).getSuccessOrNull();
                if (api == null) {
                    return null;
                }
                String appName = qName.getFirstComponent();
                List applications = api.getApplications();
                if (applications.stream().map(o -> o.getLabel()).noneMatch(s -> s.equals(appName))) {
                    return null;
                }
                TypeEvalContext context = TypeEvalContext.userInitiated((Project)model.getProject(), (PsiFile)model.getContainingFile());
                for (DjangoApplicationModel application : applications) {
                    if (!application.getModelClasses(context).stream().anyMatch(o -> model.equals(o.getPyClass()))) continue;
                    return application.getLabel();
                }
                return null;
            }

            @NotNull
            protected Collection<PsiFileSystemItem> getContexts() {
                Collection contexts = super.getContexts();
                if (this.getContextReference() != null) {
                    ArrayList<PsiFileSystemItem> results = new ArrayList<PsiFileSystemItem>();
                    for (PsiFileSystemItem context : contexts) {
                        PyFile modelFile;
                        if (!(context instanceof PsiDirectory) || (modelFile = new DjangoUnnamedApplicationModel((PsiDirectory)context).getModel()) == null) continue;
                        results.add((PsiFileSystemItem)modelFile);
                    }
                    ArrayList<PsiFileSystemItem> arrayList = results;
                    if (arrayList == null) {
                        DjangoModelItemReference.$$$reportNull$$$0(3);
                    }
                    return arrayList;
                }
                Collection collection = contexts;
                if (collection == null) {
                    DjangoModelItemReference.$$$reportNull$$$0(4);
                }
                return collection;
            }

            protected ResolveResult[] innerResolve(boolean caseSensitive) {
                QualifiedName appQName;
                Module module;
                if ("self".equals(this.getText())) {
                    PyClass clazz = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PyClass.class);
                    if (clazz != null) {
                        return new ResolveResult[]{DjangoModelItemReference.createResolveResult((PsiElement)clazz)};
                    }
                    return ResolveResult.EMPTY_ARRAY;
                }
                if (this.isFirst() && !this.isLast() && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement())) != null && (appQName = DjangoUtil.appLabelToQName((Module)module, (String)this.getText())) != null) {
                    List results = PyResolveImportUtil.resolveQualifiedName((QualifiedName)appQName, (PyQualifiedNameResolveContext)PyResolveImportUtil.fromModule((Module)module));
                    ResolveResult[] resolveResults = new ResolveResult[results.size()];
                    for (int i = 0; i < results.size(); ++i) {
                        resolveResults[i] = new PsiElementResolveResult((PsiElement)results.get(i));
                    }
                    return resolveResults;
                }
                ResolveResult[] results = super.innerResolve(caseSensitive);
                if (results.length > 0) {
                    return results;
                }
                return (ResolveResult[])PyClassNameIndex.find((String)this.getText(), (Project)this.getElement().getProject(), (boolean)true).stream().map(PsiElementResolveResult::new).toArray(PsiElementResolveResult[]::new);
            }

            public Object @NotNull [] getVariants() {
                Object[] res = super.getVariants();
                if (this.isFirst()) {
                    ArrayList list = Lists.newArrayList((Object[])res);
                    list.add(LookupElementBuilder.create((String)"self"));
                    Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
                    if (module != null) {
                        for (String s : DjangoUtil.getInstalledAppLabels((Module)module)) {
                            list.add(LookupElementBuilder.create((String)s));
                        }
                        DjangoModelApi api = (DjangoModelApi)DjangoModelApi.create((Module)module).getSuccessOrNull();
                        if (api != null) {
                            StreamEx.of((Collection)api.getModelClasses(TypeEvalContext.userInitiated((Project)this.getElement().getProject(), null))).map(DjangoModelClass::getPyClass).map(LookupElementBuilder::create).into((Collection)list);
                        }
                    }
                    res = list.toArray();
                }
                if (res == null) {
                    DjangoModelItemReference.$$$reportNull$$$0(5);
                }
                return res;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3, 4, 5 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "qName";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "model";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/python/django/ref/DjangoRelationsReferenceProvider$DjangoModelReferenceSet$DjangoModelItemReference";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/python/django/ref/DjangoRelationsReferenceProvider$DjangoModelReferenceSet$DjangoModelItemReference";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getContexts";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVariants";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "bindToElement";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getApplicationNameFromModel";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3, 4, 5 -> new IllegalStateException(string);
                };
            }
        }
    }
}

