/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.ref.admin;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModDisplayMessage;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiBasedModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.python.django.ref.admin.DjangoAdminModelUtil;
import com.intellij.python.django.ref.admin.DjangoAdminRegisterActionBase;
import com.intellij.python.django.ref.admin.DjangoAdminRegisterInFileAction;
import com.intellij.python.django.ref.admin.DjangoAdminRegisterInNewFileAction;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.model.applications.DjangoUnnamedApplicationModel;
import com.jetbrains.django.model.applications.DjangoUnnamedApplicationModelUtil;
import com.jetbrains.django.model.modelApi.DjangoModelClass;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0014J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0014J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0002H\u0002J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J.\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0016\"\u0004\b\u0000\u0010\u0017*\b\u0012\u0004\u0012\u0002H\u00170\u00162\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00170\u0019H\u0002J \u0010\u001a\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010\u001d\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u00122\u0006\u0010!\u001a\u00020\u0002H\u0002\u00a8\u0006\""}, d2={"Lcom/intellij/python/django/ref/admin/DjangoAdminRegisterIntentionAction;", "Lcom/intellij/modcommand/PsiBasedModCommandAction;", "Lcom/intellij/psi/PsiElement;", "<init>", "()V", "getFamilyName", "", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "element", "perform", "Lcom/intellij/modcommand/ModCommand;", "isModelClassIdentifier", "", "registerAdminModelWithChooseAction", "modelClass", "Lcom/jetbrains/django/model/modelApi/DjangoModelClass;", "adminInitFile", "Lcom/intellij/psi/PsiFile;", "plusIfNotNull", "", "T", "block", "Lkotlin/Function0;", "registerAdminModelInFile", "adminModelFile", "Lcom/jetbrains/python/psi/PyFile;", "registerAdminModelInNewAdminFile", "moduleRootFolder", "Lcom/intellij/psi/PsiDirectory;", "getModelClass", "psiElement", "intellij.python.django"})
@SourceDebugExtension(value={"SMAP\nDjangoAdminRegisterIntentionAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DjangoAdminRegisterIntentionAction.kt\ncom/intellij/python/django/ref/admin/DjangoAdminRegisterIntentionAction\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,143:1\n66#2,2:144\n3829#3:146\n4344#3,2:147\n827#4:149\n855#4,2:150\n1557#4:152\n1628#4,3:153\n2632#4,3:157\n19#5:156\n*S KotlinDebug\n*F\n+ 1 DjangoAdminRegisterIntentionAction.kt\ncom/intellij/python/django/ref/admin/DjangoAdminRegisterIntentionAction\n*L\n78#1:144,2\n85#1:146\n85#1:147,2\n87#1:149\n87#1:150,2\n90#1:152\n90#1:153,3\n97#1:157,3\n138#1:156\n*E\n"})
public final class DjangoAdminRegisterIntentionAction
extends PsiBasedModCommandAction<PsiElement> {
    public DjangoAdminRegisterIntentionAction() {
        super(PsiElement.class);
    }

    @NotNull
    public String getFamilyName() {
        String string = DjangoBundle.message((String)"django.register.model.in.admin.intention.action", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!DjangoFacet.isPresent((PsiElement)element)) {
            return null;
        }
        if (!this.isModelClassIdentifier(element)) {
            return null;
        }
        return super.getPresentation(context, element);
    }

    @NotNull
    protected ModCommand perform(@NotNull ActionContext context, @NotNull PsiElement element) {
        ModCommand modCommand;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = element.getContainingFile().getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        DjangoUnnamedApplicationModel djangoUnnamedApplicationModel = DjangoUnnamedApplicationModelUtil.INSTANCE.createFromFileInsideApp(psiFile);
        if (djangoUnnamedApplicationModel == null) {
            ModCommand modCommand2 = ModCommand.nop();
            Intrinsics.checkNotNullExpressionValue((Object)modCommand2, (String)"nop(...)");
            return modCommand2;
        }
        DjangoUnnamedApplicationModel djangoAppModel = djangoUnnamedApplicationModel;
        PyFile djangoAppAdminModule = djangoAppModel.getAdmin();
        DjangoModelClass djangoModelClass = this.getModelClass(element);
        if (djangoModelClass == null) {
            ModCommand modCommand3 = ModCommand.nop();
            Intrinsics.checkNotNullExpressionValue((Object)modCommand3, (String)"nop(...)");
            return modCommand3;
        }
        DjangoModelClass modelClass = djangoModelClass;
        if (DjangoAdminModelUtil.INSTANCE.isModelAdminIsAlreadyDefinedInAdminModule(modelClass, djangoAppModel)) {
            String string = modelClass.getPyClass().getName();
            if (string == null) {
                string = "";
            }
            String adminClassName = DjangoAdminModelUtil.INSTANCE.generateAdminClassName(string);
            Object[] objectArray = new Object[]{adminClassName};
            return (ModCommand)new ModDisplayMessage(DjangoBundle.message((String)"django.register.model.in.admin.already.defined", (Object[])objectArray), ModDisplayMessage.MessageKind.INFORMATION);
        }
        if (djangoAppAdminModule == null) {
            PsiDirectory psiDirectory = djangoAppModel.getApplicationRootFolder();
            Intrinsics.checkNotNullExpressionValue((Object)psiDirectory, (String)"getApplicationRootFolder(...)");
            modCommand = this.registerAdminModelInNewAdminFile(context, modelClass, psiDirectory);
        } else {
            modCommand = Intrinsics.areEqual((Object)"__init__.py", (Object)djangoAppAdminModule.getName()) ? this.registerAdminModelWithChooseAction(modelClass, (PsiFile)djangoAppAdminModule) : this.registerAdminModelInFile(context, modelClass, djangoAppAdminModule);
        }
        return modCommand;
    }

    private final boolean isModelClassIdentifier(PsiElement $this$isModelClassIdentifier) {
        if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)$this$isModelClassIdentifier), (Object)PyTokenTypes.IDENTIFIER)) {
            return false;
        }
        PsiElement $this$parentOfType_u24default$iv = $this$isModelClassIdentifier;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        PyClass pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, PyClass.class, (boolean)true);
        if (pyClass == null) {
            return false;
        }
        PyClass pyClass2 = pyClass;
        TypeEvalContext context = TypeEvalContext.codeAnalysis((Project)$this$isModelClassIdentifier.getProject(), (PsiFile)$this$isModelClassIdentifier.getContainingFile());
        return DjangoModelClass.Companion.isModelClass(pyClass2, context);
    }

    /*
     * WARNING - void declaration
     */
    private final ModCommand registerAdminModelWithChooseAction(DjangoModelClass modelClass, PsiFile adminInitFile) {
        Collection<DjangoAdminRegisterInFileAction> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        void $this$filterTo$iv$iv;
        PsiDirectory psiDirectory = adminInitFile.getParent();
        if (psiDirectory == null) {
            ModCommand modCommand = ModCommand.nop();
            Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"nop(...)");
            return modCommand;
        }
        PsiDirectory adminDirectory = psiDirectory;
        PsiFile[] psiFileArray = adminDirectory.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)psiFileArray, (String)"getFiles(...)");
        Object $this$filter$iv = psiFileArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            PsiFile it = (PsiFile)element$iv$iv;
            boolean bl = false;
            if (!(it.getLanguage() instanceof PythonLanguage)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot22 = false;
        $this$filterTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            PsiFile it = (PsiFile)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)"__init__.py", (Object)it.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List availablePythonFiles = (List)destination$iv$iv;
        Iterable $i$f$filterNot22 = availablePythonFiles;
        DjangoAdminRegisterIntentionAction djangoAdminRegisterIntentionAction = this;
        String string = DjangoBundle.message((String)"django.popup.register.in.variant.title", (Object[])new Object[0]);
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiFile bl = (PsiFile)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(new DjangoAdminRegisterInFileAction((PsiFile)it, adminInitFile, modelClass));
        }
        collection = (List)destination$iv$iv2;
        ModCommand modCommand = ModCommand.chooseAction((String)string, djangoAdminRegisterIntentionAction.plusIfNotNull((List)collection, (Function0)() -> DjangoAdminRegisterIntentionAction.registerAdminModelWithChooseAction$lambda$4(modelClass, availablePythonFiles, adminDirectory, adminInitFile)));
        Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"chooseAction(...)");
        return modCommand;
    }

    private final <T> List<T> plusIfNotNull(List<? extends T> $this$plusIfNotNull, Function0<? extends T> block) {
        Object result = block.invoke();
        if (result == null) {
            return $this$plusIfNotNull;
        }
        return CollectionsKt.plus((Collection)$this$plusIfNotNull, (Object)result);
    }

    private final ModCommand registerAdminModelInFile(ActionContext context, DjangoModelClass modelClass, PyFile adminModelFile) {
        ModCommand modCommand = new DjangoAdminRegisterInFileAction((PsiFile)adminModelFile, null, modelClass).perform(context);
        Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"perform(...)");
        return modCommand;
    }

    private final ModCommand registerAdminModelInNewAdminFile(ActionContext context, DjangoModelClass modelClass, PsiDirectory moduleRootFolder) {
        ModCommand modCommand = new DjangoAdminRegisterInNewFileAction(moduleRootFolder, "admin.py", null, modelClass).perform(context);
        Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"perform(...)");
        return modCommand;
    }

    private final DjangoModelClass getModelClass(PsiElement psiElement) {
        if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)psiElement), (Object)PyTokenTypes.IDENTIFIER)) {
            return null;
        }
        PsiElement $this$asSafely$iv = psiElement.getParent();
        boolean $i$f$asSafely = false;
        PsiElement psiElement2 = $this$asSafely$iv;
        if (!(psiElement2 instanceof PyClass)) {
            psiElement2 = null;
        }
        PyClass pyClass = (PyClass)psiElement2;
        if (pyClass == null) {
            return null;
        }
        PyClass pyClass2 = pyClass;
        TypeEvalContext context = TypeEvalContext.codeAnalysis((Project)psiElement.getProject(), (PsiFile)psiElement.getContainingFile());
        Intrinsics.checkNotNull((Object)context);
        return DjangoModelClass.Companion.createIfModel(pyClass2, context);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final DjangoAdminRegisterActionBase registerAdminModelWithChooseAction$lambda$4(DjangoModelClass $modelClass, List $availablePythonFiles, PsiDirectory $adminDirectory, PsiFile $adminInitFile) {
        DjangoAdminRegisterInNewFileAction djangoAdminRegisterInNewFileAction;
        String newAdminFileName = DjangoAdminModelUtil.INSTANCE.generateDjangoModelClassNameToAdminFileName($modelClass);
        if (newAdminFileName != null) {
            boolean bl;
            block5: {
                Iterable $this$none$iv = $availablePythonFiles;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        PsiFile it = (PsiFile)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)newAdminFileName)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (bl) {
                djangoAdminRegisterInNewFileAction = new DjangoAdminRegisterInNewFileAction($adminDirectory, newAdminFileName, $adminInitFile, $modelClass);
                return djangoAdminRegisterInNewFileAction;
            }
        }
        djangoAdminRegisterInNewFileAction = null;
        return djangoAdminRegisterInNewFileAction;
    }
}

