/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DataGridBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.DataGridUIUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.NlsActions;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class EditValueAction
extends AnAction
implements DumbAware,
GridAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            EditValueAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public EditValueAction() {
        this.setEnabledInModalContext(true);
    }

    public void update(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            EditValueAction.$$$reportNull$$$0(1);
        }
        if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        String text = this.getText(!dataGrid.isEditable());
        String description = this.getDescription(!dataGrid.isEditable());
        boolean visible = dataGrid.isEditable() && e.isFromContextMenu();
        e.getPresentation().setText(text);
        e.getPresentation().setDescription(description);
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(this.isEnabled(dataGrid, (Component)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT)));
    }

    boolean isEnabled(@NotNull DataGrid grid, Component contextComponent) {
        if (grid == null) {
            EditValueAction.$$$reportNull$$$0(2);
        }
        return contextComponent != null && DataGridUIUtil.isInsideGrid(grid, contextComponent) && grid.isCellEditingAllowed() && grid.isReady() && !grid.isEditing() && EditValueAction.isSelectedColumnsEditable(grid);
    }

    private static boolean isSelectedColumnsEditable(@NotNull DataGrid grid) {
        GridModel model2;
        List columns;
        if (grid == null) {
            EditValueAction.$$$reportNull$$$0(3);
        }
        return JBIterable.from((Iterable)(columns = (model2 = grid.getDataModel(DataAccessType.DATABASE_DATA)).getColumns(grid.getSelectionModel().getSelectedColumns()))).filter(GridUtilCore::isRowId).size() == 0;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            EditValueAction.$$$reportNull$$$0(4);
        }
        if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null) {
            dataGrid.editSelectedCell();
        }
    }

    @NlsActions.ActionText
    protected String getText(boolean viewMode) {
        return DataGridBundle.message((String)"action.Console.TableResult.EditValue.adjusted.text", (Object[])new Object[]{viewMode ? 0 : 1});
    }

    @NlsActions.ActionDescription
    protected String getDescription(boolean viewMode) {
        return DataGridBundle.message((String)"action.Console.TableResult.EditValue.edit.selected.cell", (Object[])new Object[]{viewMode ? 0 : 1});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/EditValueAction";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/EditValueAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSelectedColumnsEditable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

