/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsUtils;
import com.intellij.javascript.debugger.console.ConsoleHtmlPanel;
import com.intellij.javascript.debugger.console.DOMNode;
import com.intellij.javascript.debugger.console.DeferredEntity;
import com.intellij.javascript.debugger.console.HistoryViewNavigator;
import com.intellij.javascript.debugger.console.HyperLink;
import com.intellij.javascript.debugger.console.JSBridge;
import com.intellij.javascript.debugger.console.MessagePrinter;
import com.intellij.javascript.debugger.console.MessageType;
import com.intellij.javascript.debugger.console.Node;
import com.intellij.javascript.debugger.console.PrintableEntity;
import com.intellij.javascript.debugger.console.ResourcesStaticServer;
import com.intellij.javascript.debugger.console.StylesConversionKt;
import com.intellij.javascript.debugger.console.TreeRoot;
import com.intellij.javascript.debugger.console.Variable;
import com.intellij.javascript.debugger.console.WebConsoleFilterForm;
import com.intellij.javascript.debugger.console.WebConsoleViewSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.DeferredIcon;
import com.intellij.ui.JBColor;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.impl.ui.tree.nodes.MessageTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.SafeContinuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 f2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002fgB\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010*\u001a\u00020+J\u000e\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020.J\u0006\u0010/\u001a\u00020+J\b\u00100\u001a\u00020+H\u0002J\u0012\u00101\u001a\u00020+2\b\b\u0002\u00102\u001a\u00020\u001aH\u0002J\b\u00103\u001a\u000204H\u0002J\b\u00105\u001a\u00020+H\u0002J\b\u00106\u001a\u00020\u001aH\u0016J\u0010\u00107\u001a\u00020+2\u0006\u00108\u001a\u00020\u001aH\u0016J\b\u00109\u001a\u00020+H\u0016J\u0016\u0010:\u001a\u00020+2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u000e0<H\u0016J\u0010\u0010:\u001a\u00020+2\u0006\u0010=\u001a\u00020\u000eH\u0016J\u001c\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020!0#2\u0006\u0010?\u001a\u00020\u000eH\u0002J\u0017\u0010@\u001a\u0004\u0018\u00010%2\u0006\u0010A\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\bBJ\u0010\u0010C\u001a\u00020\u00152\u0006\u0010?\u001a\u00020\u000eH\u0002J\b\u0010D\u001a\u00020+H\u0016J\b\u0010E\u001a\u00020+H\u0016J\u001e\u0010F\u001a\u00020\u001a2\u0006\u0010G\u001a\u00020\u001f2\u0006\u0010H\u001a\u00020\u001aH\u0096@\u00a2\u0006\u0002\u0010IJ\u001c\u0010J\u001a\u00020+2\u0012\u0010K\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020!0#H\u0002J\b\u0010L\u001a\u00020+H\u0016J\b\u0010M\u001a\u00020+H\u0016J\u000e\u0010N\u001a\u00020+2\u0006\u0010O\u001a\u00020PJ\u000e\u0010Q\u001a\u00020+2\u0006\u0010O\u001a\u00020PJ\u0016\u0010R\u001a\u00020+2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020+0$H\u0002J\u0016\u0010T\u001a\u00020+2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020+0$H\u0016J+\u0010V\u001a\u0004\u0018\u00010!2\u0006\u0010W\u001a\u00020\u001f2\u0012\u0010X\u001a\n\u0012\u0006\b\u0001\u0012\u00020!0 \"\u00020!H\u0002\u00a2\u0006\u0002\u0010YJ\b\u0010Z\u001a\u00020+H\u0016J\b\u0010[\u001a\u00020+H\u0016J\b\u0010\\\u001a\u00020+H\u0016J \u0010]\u001a\u00020+2\u0006\u0010^\u001a\u00020_2\u0006\u0010`\u001a\u00020\u001f2\u0006\u0010a\u001a\u00020\u001fH\u0016J\u0018\u0010b\u001a\u00020+2\u0006\u0010c\u001a\u00020\u001f2\u0006\u0010d\u001a\u00020\u001aH\u0016J\b\u0010e\u001a\u00020+H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u001c\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u001f\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020!0 0\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\"\u001a\u0016\u0012\u0004\u0012\u00020\u001f\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010%0$0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010&\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006h"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleHistoryView;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/javascript/debugger/console/MessagePrinter;", "Lcom/intellij/javascript/debugger/console/HistoryViewNavigator;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/javascript/debugger/console/WebConsoleViewSettings;", "htmlPanel", "Lcom/intellij/javascript/debugger/console/ConsoleHtmlPanel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/javascript/debugger/console/WebConsoleViewSettings;Lcom/intellij/javascript/debugger/console/ConsoleHtmlPanel;)V", "systemMessageCache", "Ljava/util/ArrayList;", "Lcom/intellij/javascript/debugger/console/PrintableEntity;", "Lkotlin/collections/ArrayList;", "getSystemMessageCache$intellij_javascript_debugger", "()Ljava/util/ArrayList;", "jsBridge", "Lcom/intellij/javascript/debugger/console/WebConsoleHistoryView$JSBridgeImpl;", "stylesRegistered", "", "lastId", "colorScheme", "Lcom/intellij/openapi/editor/colors/impl/DelegateColorScheme;", "stickToEnd", "", "batchRequests", "batch", "", "Lkotlin/Pair;", "", "", "", "iconCache", "", "Lkotlin/Function0;", "Ljavax/swing/Icon;", "component", "Ljava/awt/Component;", "getComponent", "()Ljava/awt/Component;", "openDevtools", "", "updateFromFilterSettingsUI", "filterForm", "Lcom/intellij/javascript/debugger/console/WebConsoleFilterForm;", "resetAllFilters", "attachStyles", "updateStyles", "forceUpdate", "getConsoleFont", "Ljava/awt/Font;", "updateLafStyles", "isStickToEnd", "setStickToEnd", "state", "clear", "print", "tokens", "", "token", "prepareJSProps", "printable", "getCachedIcon", "filename", "getCachedIcon$intellij_javascript_debugger", "cachePrintable", "scrollToEnd", "increaseLastMessageRepeatCount", "findText", "text", "caseSensitive", "(Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resolveDeferred", "resolvedJsProps", "selectNextFindItem", "selectPrevFindItem", "addKeyListener", "keyAdapter", "Ljava/awt/event/KeyAdapter;", "removeKeyListener", "runWhenPageReady", "function", "runInBatch", "block", "callJS", "method", "args", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", "dispose", "startTrace", "endTrace", "startMessage", "type", "Lcom/intellij/javascript/debugger/console/MessageType;", "level", "source", "startGroup", "groupName", "collapsed", "endGroup", "Companion", "JSBridgeImpl", "intellij.javascript.debugger"})
@SourceDebugExtension(value={"SMAP\nWebConsoleHistoryView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebConsoleHistoryView.kt\ncom/intellij/javascript/debugger/console/WebConsoleHistoryView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,496:1\n1557#2:497\n1628#2,3:498\n1863#2,2:501\n*S KotlinDebug\n*F\n+ 1 WebConsoleHistoryView.kt\ncom/intellij/javascript/debugger/console/WebConsoleHistoryView\n*L\n220#1:497\n220#1:498,3\n220#1:501,2\n*E\n"})
public final class WebConsoleHistoryView
implements Disposable,
MessagePrinter,
HistoryViewNavigator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final WebConsoleViewSettings settings;
    @NotNull
    private final ConsoleHtmlPanel htmlPanel;
    @NotNull
    private final ArrayList<PrintableEntity> systemMessageCache;
    @NotNull
    private final JSBridgeImpl jsBridge;
    private int stylesRegistered;
    private int lastId;
    @NotNull
    private final DelegateColorScheme colorScheme;
    private boolean stickToEnd;
    private volatile boolean batchRequests;
    @NotNull
    private final List<Pair<String, Object[]>> batch;
    @NotNull
    private final Map<String, Function0<Icon>> iconCache;
    @NotNull
    private static final Logger log;
    @NotNull
    private static final Gson gson;

    public WebConsoleHistoryView(@NotNull Project project, @NotNull WebConsoleViewSettings settings, @NotNull ConsoleHtmlPanel htmlPanel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)htmlPanel, (String)"htmlPanel");
        this.project = project;
        this.settings = settings;
        this.htmlPanel = htmlPanel;
        this.systemMessageCache = new ArrayList();
        this.jsBridge = new JSBridgeImpl(this);
        this.stickToEnd = true;
        this.batch = new ArrayList();
        this.iconCache = new HashMap();
        Disposer.register((Disposable)this, (Disposable)this.htmlPanel);
        this.htmlPanel.load(ResourcesStaticServer.Companion.getMainUrl());
        this.colorScheme = ConsoleViewUtil.updateConsoleColorScheme((EditorColorsScheme)EditorColorsManager.getInstance().getGlobalScheme());
        if (UISettings.Companion.getInstance().getPresentationMode()) {
            this.colorScheme.setEditorFontSize((int)UISettingsUtils.Companion.getInstance().getPresentationModeFontSize());
        }
        Color color = this.colorScheme.getDefaultBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getDefaultBackground(...)");
        this.htmlPanel.setBackground(color);
        this.htmlPanel.onInit((Function0<Unit>)((Function0)() -> WebConsoleHistoryView._init_$lambda$0(this)));
        MessageBusConnection connection = this.project.getMessageBus().connect((Disposable)this.htmlPanel);
        Topic topic = EditorColorsManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, arg_0 -> WebConsoleHistoryView._init_$lambda$2(this, arg_0));
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)connection);
        Topic topic2 = LafManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        messageBusConnection.subscribe(topic2, arg_0 -> WebConsoleHistoryView._init_$lambda$4(this, arg_0));
    }

    @NotNull
    public final ArrayList<PrintableEntity> getSystemMessageCache$intellij_javascript_debugger() {
        return this.systemMessageCache;
    }

    @NotNull
    public final Component getComponent() {
        return this.htmlPanel.getComponent();
    }

    public final void openDevtools() {
        this.htmlPanel.openDevtools();
    }

    public final void updateFromFilterSettingsUI(@NotNull WebConsoleFilterForm filterForm) {
        Intrinsics.checkNotNullParameter((Object)filterForm, (String)"filterForm");
        this.settings.setShowErrors(filterForm.isShowErrors());
        this.settings.setShowWarnings(filterForm.isShowWarnings());
        this.settings.setShowInfo(filterForm.isShowInfo());
        this.settings.setShowLog(filterForm.isShowLog());
        this.settings.setShowDebug(filterForm.isShowDebug());
        this.settings.setShowNetwork(filterForm.isShowNetwork());
        this.runWhenPageReady((Function0<Unit>)((Function0)() -> WebConsoleHistoryView.updateFromFilterSettingsUI$lambda$5(this)));
    }

    public final void resetAllFilters() {
        this.settings.setShowErrors(true);
        this.settings.setShowWarnings(true);
        this.settings.setShowInfo(true);
        this.settings.setShowLog(true);
        this.settings.setShowDebug(false);
        this.settings.setShowNetwork(true);
        this.runWhenPageReady((Function0<Unit>)((Function0)() -> WebConsoleHistoryView.resetAllFilters$lambda$6(this)));
    }

    private final void attachStyles() {
        String lafCss = JBColor.isBright() ? "light.css" : "darcula.css";
        this.htmlPanel.executeScript("window._lafStyle = document.createElement(\"link\");\nwindow._lafStyle.rel = 'stylesheet';\nwindow._lafStyle.type = 'text/css';\nwindow._lafStyle.href = '" + lafCss + "';\ndocument.getElementsByTagName('head')[0].appendChild(window._lafStyle)");
        this.htmlPanel.executeScript("window._styles = document.createElement('style');\nwindow._styles.type = 'text/css';\ndocument.getElementsByTagName('head')[0].appendChild(window._styles);");
    }

    private final void updateStyles(boolean forceUpdate) {
        int size = ConsoleViewContentType.getRegisteredTypes().size();
        if (this.stylesRegistered != size || forceUpdate) {
            FontMetrics fontMetrics = this.getComponent().getFontMetrics(this.getConsoleFont());
            EditorColorsScheme editorColorsScheme = (EditorColorsScheme)this.colorScheme;
            Intrinsics.checkNotNull((Object)fontMetrics);
            String styleSheetContent = StylesConversionKt.convertIDEStylesToCss("message-wrapper", editorColorsScheme, fontMetrics, this.settings);
            this.htmlPanel.executeScript("window._styles.innerHTML = `" + styleSheetContent + "`;");
            this.htmlPanel.executeScript("updateIcons();");
            this.stylesRegistered = size;
        }
    }

    static /* synthetic */ void updateStyles$default(WebConsoleHistoryView webConsoleHistoryView, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        webConsoleHistoryView.updateStyles(bl);
    }

    private final Font getConsoleFont() {
        Font font = this.colorScheme.getFont(EditorFontType.CONSOLE_PLAIN);
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        Font schemeFont = font;
        return new Font(schemeFont.getFontName(), schemeFont.getStyle(), Math.round((float)this.colorScheme.getConsoleFontSize() / UISettings.Companion.getDefFontScale()));
    }

    private final void updateLafStyles() {
        String lafCss = JBColor.isBright() ? "light.css" : "darcula.css";
        this.htmlPanel.executeScript("window._lafStyle.href = '" + lafCss + "';");
    }

    @Override
    public boolean isStickToEnd() {
        return this.stickToEnd;
    }

    @Override
    public void setStickToEnd(boolean state) {
        this.stickToEnd = state;
        this.runWhenPageReady((Function0<Unit>)((Function0)() -> WebConsoleHistoryView.setStickToEnd$lambda$7(this, state)));
    }

    @Override
    public void clear() {
        this.runWhenPageReady((Function0<Unit>)((Function0)() -> WebConsoleHistoryView.clear$lambda$8(this)));
        this.systemMessageCache.clear();
        this.lastId = 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void print(@NotNull List<? extends PrintableEntity> tokens) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        Iterable $this$map$iv = tokens;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            PrintableEntity printableEntity = (PrintableEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean $i$f$print$stub_for_inlining = false;
            boolean bl = false;
            collection.add(this.prepareJSProps((PrintableEntity)p0));
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map it = (Map)element$iv;
            boolean bl = false;
            Object[] objectArray = new Object[]{it};
            this.callJS("print", objectArray);
        }
    }

    @Override
    public void print(@NotNull PrintableEntity token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Object[] objectArray = new Object[]{this.prepareJSProps(token)};
        this.callJS("print", objectArray);
    }

    private final Map<String, Object> prepareJSProps(PrintableEntity printable) {
        Pair pair = printable instanceof DeferredEntity ? ((DeferredEntity)printable).get() : new Pair((Object)printable, (Object)false);
        PrintableEntity readyPrintable = (PrintableEntity)pair.component1();
        boolean deferred = (Boolean)pair.component2();
        Map<String, Object> jsProps = readyPrintable.getJSProps();
        int id = this.cachePrintable(readyPrintable);
        Integer n = id;
        jsProps.put("id", n);
        if (readyPrintable instanceof Node && ((Node)readyPrintable).hasIcon()) {
            jsProps.put("iconURL", ResourcesStaticServer.Companion.cacheIconId$intellij_javascript_debugger(this, id + ".png"));
        }
        if (deferred) {
            jsProps.put("deferred", true);
            AppUIUtil.invokeOnEdt(() -> WebConsoleHistoryView.prepareJSProps$lambda$12(printable, this, id));
        }
        return jsProps;
    }

    @Nullable
    public final Icon getCachedIcon$intellij_javascript_debugger(@NotNull String filename) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Integer n = StringsKt.toIntOrNull((String)StringsKt.substringBeforeLast$default((String)filename, (String)".png", null, (int)2, null));
        if (n != null) {
            Icon icon2;
            int id = ((Number)n).intValue();
            boolean bl = false;
            PrintableEntity printableEntity = this.systemMessageCache.get(id);
            Node node = printableEntity instanceof Node ? (Node)printableEntity : null;
            Icon icon3 = icon2 = node != null ? node.getIcon() : null;
            icon = icon2 instanceof DeferredIcon ? (Icon)ActionsKt.runReadAction(() -> WebConsoleHistoryView.getCachedIcon$lambda$14$lambda$13(icon2)) : icon2;
        } else {
            icon = null;
        }
        return icon;
    }

    private final int cachePrintable(PrintableEntity printable) {
        if (printable instanceof Node || printable instanceof HyperLink) {
            this.systemMessageCache.add(printable);
            this.lastId = this.systemMessageCache.size();
            return this.lastId - 1;
        }
        return -1;
    }

    @Override
    public void scrollToEnd() {
        this.runWhenPageReady((Function0<Unit>)((Function0)() -> WebConsoleHistoryView.scrollToEnd$lambda$15(this)));
    }

    @Override
    public void increaseLastMessageRepeatCount() {
        this.runWhenPageReady((Function0<Unit>)((Function0)() -> WebConsoleHistoryView.increaseLastMessageRepeatCount$lambda$16(this)));
    }

    @Override
    @Nullable
    public Object findText(@NotNull String text, boolean caseSensitive, @NotNull Continuation<? super Boolean> $completion) {
        Continuation<? super Boolean> continuation = $completion;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation cont = (Continuation)safeContinuation;
        boolean bl = false;
        this.runWhenPageReady((Function0<Unit>)((Function0)new Function0<Unit>(this, text, caseSensitive, (Continuation<? super Boolean>)cont){
            final /* synthetic */ WebConsoleHistoryView this$0;
            final /* synthetic */ String $text;
            final /* synthetic */ boolean $caseSensitive;
            final /* synthetic */ Continuation<Boolean> $cont;
            {
                this.this$0 = $receiver;
                this.$text = $text;
                this.$caseSensitive = $caseSensitive;
                this.$cont = $cont;
            }

            public final void invoke() {
                Object[] objectArray = new Object[]{this.$text, this.$caseSensitive};
                WebConsoleHistoryView.access$getHtmlPanel$p(this.this$0).callJS("findText", objectArray, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this.$cont){
                    final /* synthetic */ Continuation<Boolean> $cont;
                    {
                        this.$cont = $cont;
                    }

                    public final void invoke(String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$cont.resumeWith(Result.constructor-impl((Object)Boolean.parseBoolean(it)));
                    }
                }));
            }
        }));
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    private final void resolveDeferred(Map<String, Object> resolvedJsProps) {
        this.runWhenPageReady((Function0<Unit>)((Function0)() -> WebConsoleHistoryView.resolveDeferred$lambda$18(this, resolvedJsProps)));
    }

    @Override
    public void selectNextFindItem() {
        this.runWhenPageReady((Function0<Unit>)((Function0)() -> WebConsoleHistoryView.selectNextFindItem$lambda$19(this)));
    }

    @Override
    public void selectPrevFindItem() {
        this.runWhenPageReady((Function0<Unit>)((Function0)() -> WebConsoleHistoryView.selectPrevFindItem$lambda$20(this)));
    }

    public final void addKeyListener(@NotNull KeyAdapter keyAdapter) {
        Intrinsics.checkNotNullParameter((Object)keyAdapter, (String)"keyAdapter");
        this.htmlPanel.addKeyListener(keyAdapter);
    }

    public final void removeKeyListener(@NotNull KeyAdapter keyAdapter) {
        Intrinsics.checkNotNullParameter((Object)keyAdapter, (String)"keyAdapter");
        this.htmlPanel.removeKeyListener(keyAdapter);
    }

    private final void runWhenPageReady(Function0<Unit> function) {
        this.htmlPanel.runWhenPageReady(function);
    }

    @Override
    public void runInBatch(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.runWhenPageReady((Function0<Unit>)((Function0)() -> WebConsoleHistoryView.runInBatch$lambda$21(this, block)));
    }

    private final Object callJS(String method, Object ... args) {
        if (!this.batchRequests) {
            this.htmlPanel.callJS(method, Arrays.copyOf(args, args.length));
            return Unit.INSTANCE;
        }
        this.batch.add((Pair<String, Object[]>)new Pair((Object)method, (Object)args));
        return null;
    }

    public void dispose() {
        this.systemMessageCache.clear();
        this.iconCache.clear();
        ResourcesStaticServer.Companion.clearConsoleCaches$intellij_javascript_debugger(this);
    }

    @Override
    public void startTrace() {
        this.callJS("startTrace", new Object[0]);
    }

    @Override
    public void endTrace() {
        this.callJS("endTrace", new Object[0]);
    }

    @Override
    public void startMessage(@NotNull MessageType type, @NotNull String level, @NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Object[] objectArray = new Object[]{type.getType(), level, source};
        this.callJS("startMessage", objectArray);
    }

    @Override
    public void startGroup(@NotNull String groupName, boolean collapsed) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        Object[] objectArray = new Object[]{groupName, collapsed};
        this.callJS("startGroup", objectArray);
    }

    @Override
    public void endGroup() {
        this.callJS("endGroup", new Object[0]);
    }

    private static final Unit _init_$lambda$0(WebConsoleHistoryView this$0) {
        this$0.htmlPanel.setBridge(this$0.jsBridge);
        this$0.attachStyles();
        WebConsoleHistoryView.updateStyles$default(this$0, false, 1, null);
        Object[] objectArray = new Object[]{Registry.Companion.get("js.debugger.webconsole.maxRenderedCount").asInteger()};
        this$0.callJS("setMaxRenderedCount", objectArray);
        log.info("WebConsole page initialization complete");
        return Unit.INSTANCE;
    }

    private static final Unit lambda$2$lambda$1(EditorColorsScheme $scheme, WebConsoleHistoryView this$0) {
        if ($scheme != null) {
            this$0.colorScheme.setDelegate($scheme);
            ConsoleHtmlPanel consoleHtmlPanel = this$0.htmlPanel;
            Color color = this$0.colorScheme.getDefaultBackground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getDefaultBackground(...)");
            consoleHtmlPanel.setBackground(color);
        }
        this$0.updateStyles(true);
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$2(WebConsoleHistoryView this$0, EditorColorsScheme scheme) {
        this$0.runWhenPageReady((Function0<Unit>)((Function0)() -> WebConsoleHistoryView.lambda$2$lambda$1(scheme, this$0)));
    }

    private static final Unit lambda$4$lambda$3(WebConsoleHistoryView this$0) {
        this$0.updateLafStyles();
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$4(WebConsoleHistoryView this$0, LafManager it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.runWhenPageReady((Function0<Unit>)((Function0)() -> WebConsoleHistoryView.lambda$4$lambda$3(this$0)));
    }

    private static final Unit updateFromFilterSettingsUI$lambda$5(WebConsoleHistoryView this$0) {
        this$0.updateStyles(true);
        return Unit.INSTANCE;
    }

    private static final Unit resetAllFilters$lambda$6(WebConsoleHistoryView this$0) {
        this$0.updateStyles(true);
        return Unit.INSTANCE;
    }

    private static final Unit setStickToEnd$lambda$7(WebConsoleHistoryView this$0, boolean $state) {
        Object[] objectArray = new Object[]{$state};
        this$0.callJS("setStickToEnd", objectArray);
        return Unit.INSTANCE;
    }

    private static final Unit clear$lambda$8(WebConsoleHistoryView this$0) {
        this$0.callJS("clear", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit prepareJSProps$lambda$12$lambda$10(WebConsoleHistoryView this$0, int $id, PrintableEntity resolved) {
        Intrinsics.checkNotNull((Object)resolved);
        Map<String, Object> resolvedJsProps = this$0.prepareJSProps(resolved);
        Integer n = $id;
        resolvedJsProps.put("deferredID", n);
        this$0.resolveDeferred(resolvedJsProps);
        return Unit.INSTANCE;
    }

    private static final Unit prepareJSProps$lambda$12$lambda$11(Function1 $tmp0, Object p0) {
        return (Unit)$tmp0.invoke(p0);
    }

    private static final void prepareJSProps$lambda$12(PrintableEntity $printable, WebConsoleHistoryView this$0, int $id) {
        Intrinsics.checkNotNull((Object)$printable, (String)"null cannot be cast to non-null type com.intellij.javascript.debugger.console.DeferredEntity");
        ((DeferredEntity)$printable).getPromise().then(arg_0 -> WebConsoleHistoryView.prepareJSProps$lambda$12$lambda$11(arg_0 -> WebConsoleHistoryView.prepareJSProps$lambda$12$lambda$10(this$0, $id, arg_0), arg_0));
    }

    private static final Icon getCachedIcon$lambda$14$lambda$13(Icon $icon) {
        return ((DeferredIcon)$icon).evaluate();
    }

    private static final Unit scrollToEnd$lambda$15(WebConsoleHistoryView this$0) {
        this$0.htmlPanel.callJS("scrollDown", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit increaseLastMessageRepeatCount$lambda$16(WebConsoleHistoryView this$0) {
        this$0.callJS("increaseLastMessageRepeatCount", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit resolveDeferred$lambda$18(WebConsoleHistoryView this$0, Map $resolvedJsProps) {
        Object[] objectArray = new Object[]{$resolvedJsProps};
        this$0.callJS("resolveDeferred", objectArray);
        return Unit.INSTANCE;
    }

    private static final Unit selectNextFindItem$lambda$19(WebConsoleHistoryView this$0) {
        this$0.htmlPanel.callJS("findNext", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit selectPrevFindItem$lambda$20(WebConsoleHistoryView this$0) {
        this$0.htmlPanel.callJS("findPrev", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit runInBatch$lambda$21(WebConsoleHistoryView this$0, Function0 $block) {
        this$0.batchRequests = true;
        $block.invoke();
        WebConsoleHistoryView.updateStyles$default(this$0, false, 1, null);
        if (this$0.isStickToEnd()) {
            this$0.callJS("scrollDown", new Object[0]);
        }
        this$0.batchRequests = false;
        this$0.htmlPanel.runRequestsBatch(this$0.batch);
        this$0.batch.clear();
        return Unit.INSTANCE;
    }

    static {
        Logger logger = Logger.getInstance(WebConsoleHistoryView.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
        Gson gson = new GsonBuilder().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        WebConsoleHistoryView.gson = gson;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleHistoryView$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "gson", "Lcom/google/gson/Gson;", "intellij.javascript.debugger"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\tH\u0002J \u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J/\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\t2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"H\u0002\u00a2\u0006\u0002\u0010#J\u0018\u0010$\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00020\tH\u0002J%\u0010%\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\t2\u000e\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0\u001fH\u0002\u00a2\u0006\u0002\u0010'J\u0012\u0010(\u001a\u00020\u00072\b\u0010)\u001a\u0004\u0018\u00010*H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleHistoryView$JSBridgeImpl;", "Lcom/intellij/javascript/debugger/console/JSBridge;", "webConsoleHistoryView", "Lcom/intellij/javascript/debugger/console/WebConsoleHistoryView;", "<init>", "(Lcom/intellij/javascript/debugger/console/WebConsoleHistoryView;)V", "navigate", "", "id", "", "treeListeners", "", "Ljavax/swing/event/TreeModelListener;", "expand", "callbackId", "highlight", "hideHighlight", "expandDOM", "printableInfo", "Lcom/intellij/javascript/debugger/console/DOMNode;", "expandVariable", "variableNode", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XDebuggerTreeNode;", "collapse", "messageNodeCallback", "updateStickToEnd", "stickToEnd", "", "nodeLinkClick", "addChildren", "children", "", "", "childIndices", "", "(I[Ljava/lang/Object;[I)V", "removeChildren", "invokeCallback", "args", "(I[Ljava/lang/Object;)V", "log", "text", "", "intellij.javascript.debugger"})
    @SourceDebugExtension(value={"SMAP\nWebConsoleHistoryView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebConsoleHistoryView.kt\ncom/intellij/javascript/debugger/console/WebConsoleHistoryView$JSBridgeImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,496:1\n1567#2:497\n1598#2,4:498\n37#3,2:502\n11255#4:504\n11366#4,4:505\n*S KotlinDebug\n*F\n+ 1 WebConsoleHistoryView.kt\ncom/intellij/javascript/debugger/console/WebConsoleHistoryView$JSBridgeImpl\n*L\n401#1:497\n401#1:498,4\n431#1:502,2\n472#1:504\n472#1:505,4\n*E\n"})
    public static final class JSBridgeImpl
    implements JSBridge {
        @NotNull
        private final WebConsoleHistoryView webConsoleHistoryView;
        @NotNull
        private final Map<Integer, TreeModelListener> treeListeners;

        public JSBridgeImpl(@NotNull WebConsoleHistoryView webConsoleHistoryView) {
            Intrinsics.checkNotNullParameter((Object)webConsoleHistoryView, (String)"webConsoleHistoryView");
            this.webConsoleHistoryView = webConsoleHistoryView;
            this.treeListeners = new LinkedHashMap();
        }

        @Override
        public void navigate(int id) {
            block0: {
                PrintableEntity printableEntity = this.webConsoleHistoryView.getSystemMessageCache$intellij_javascript_debugger().get(id);
                Intrinsics.checkNotNull((Object)printableEntity, (String)"null cannot be cast to non-null type com.intellij.javascript.debugger.console.HyperLink");
                HyperLink printableInfo = (HyperLink)printableEntity;
                HyperlinkInfo hyperlinkInfo = printableInfo.getHyperlink();
                if (hyperlinkInfo == null) break block0;
                HyperlinkInfo it = hyperlinkInfo;
                boolean bl = false;
                ApplicationManager.getApplication().invokeLater(() -> JSBridgeImpl.navigate$lambda$1$lambda$0(it, this));
            }
        }

        @Override
        public void expand(int id, int callbackId) {
            PrintableEntity printableEntity = this.webConsoleHistoryView.getSystemMessageCache$intellij_javascript_debugger().get(id);
            Intrinsics.checkNotNullExpressionValue((Object)printableEntity, (String)"get(...)");
            PrintableEntity printableInfo = printableEntity;
            if (printableInfo instanceof Variable) {
                this.expandVariable(((Variable)printableInfo).getVariable(), id, callbackId);
            } else if (printableInfo instanceof TreeRoot) {
                this.expandVariable(((TreeRoot)printableInfo).getRoot(), id, callbackId);
            } else if (printableInfo instanceof DOMNode) {
                this.expandDOM((DOMNode)printableInfo, callbackId);
            }
        }

        @Override
        public void highlight(int id) {
            PrintableEntity printableEntity = this.webConsoleHistoryView.getSystemMessageCache$intellij_javascript_debugger().get(id);
            Intrinsics.checkNotNull((Object)printableEntity, (String)"null cannot be cast to non-null type com.intellij.javascript.debugger.console.DOMNode");
            DOMNode printableInfo = (DOMNode)printableEntity;
            printableInfo.getProvider().highlight(printableInfo.getNode());
        }

        @Override
        public void hideHighlight(int id) {
            PrintableEntity printableEntity = this.webConsoleHistoryView.getSystemMessageCache$intellij_javascript_debugger().get(id);
            Intrinsics.checkNotNull((Object)printableEntity, (String)"null cannot be cast to non-null type com.intellij.javascript.debugger.console.DOMNode");
            DOMNode printableInfo = (DOMNode)printableEntity;
            printableInfo.getProvider().hideHighlight(printableInfo.getNode());
        }

        /*
         * WARNING - void declaration
         */
        private final void expandDOM(DOMNode printableInfo, int callbackId) {
            Collection<Pair> collection;
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            List<DOMNode> children = printableInfo.getChildren();
            Object[] objectArray = new Object[2];
            objectArray[0] = true;
            Iterable iterable = children;
            int n = 1;
            Object[] objectArray2 = objectArray;
            boolean $i$f$mapIndexed = false;
            void var8_9 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void ind;
                void it;
                int n2;
                if ((n2 = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                DOMNode dOMNode = (DOMNode)item$iv$iv;
                int n3 = n2;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Pair((Object)this.webConsoleHistoryView.prepareJSProps((PrintableEntity)it), (Object)((int)ind)));
            }
            collection = (List)destination$iv$iv;
            objectArray2[n] = collection;
            Object[] args = objectArray;
            this.invokeCallback(callbackId, args);
        }

        private final void expandVariable(XDebuggerTreeNode variableNode, int id, int callbackId) {
            TreeModelListener listener2 = new TreeModelListener(variableNode, this, callbackId){
                final /* synthetic */ XDebuggerTreeNode $variableNode;
                final /* synthetic */ JSBridgeImpl this$0;
                final /* synthetic */ int $callbackId;
                {
                    this.$variableNode = $variableNode;
                    this.this$0 = $receiver;
                    this.$callbackId = $callbackId;
                }

                public void treeNodesInserted(TreeModelEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (Intrinsics.areEqual((Object)e.getTreePath().getLastPathComponent(), (Object)this.$variableNode.getPath().getLastPathComponent())) {
                        Object[] objectArray = e.getChildren();
                        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getChildren(...)");
                        JSBridgeImpl.access$addChildren(this.this$0, this.$callbackId, objectArray, e.getChildIndices());
                    }
                }

                public void treeStructureChanged(TreeModelEvent e) {
                }

                public void treeNodesChanged(TreeModelEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (Intrinsics.areEqual((Object)e.getTreePath().getLastPathComponent(), (Object)this.$variableNode.getPath().getLastPathComponent()) && e.getChildIndices() != null) {
                        int[] nArray = e.getChildIndices();
                        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getChildIndices(...)");
                        JSBridgeImpl.access$removeChildren(this.this$0, nArray, this.$callbackId);
                        Object[] objectArray = e.getChildren();
                        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getChildren(...)");
                        JSBridgeImpl.access$addChildren(this.this$0, this.$callbackId, objectArray, e.getChildIndices());
                    }
                }

                public void treeNodesRemoved(TreeModelEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (Intrinsics.areEqual((Object)e.getTreePath().getLastPathComponent(), (Object)this.$variableNode.getPath().getLastPathComponent())) {
                        int[] nArray = e.getChildIndices();
                        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getChildIndices(...)");
                        JSBridgeImpl.access$removeChildren(this.this$0, nArray, this.$callbackId);
                    }
                }
            };
            Integer n = id;
            this.treeListeners.put(n, listener2);
            List list = variableNode.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] children = thisCollection$iv.toArray(new Object[0]);
            variableNode.getTree().getTreeModel().addTreeModelListener(listener2);
            JSBridgeImpl.addChildren$default(this, callbackId, children, null, 4, null);
        }

        @Override
        public void collapse(int id) {
            PrintableEntity printableEntity = this.webConsoleHistoryView.getSystemMessageCache$intellij_javascript_debugger().get(id);
            Intrinsics.checkNotNullExpressionValue((Object)printableEntity, (String)"get(...)");
            PrintableEntity printableInfo = printableEntity;
            XDebuggerTreeNode variableNode = printableInfo instanceof TreeRoot ? ((TreeRoot)printableInfo).getRoot() : ((Variable)printableInfo).getVariable();
            variableNode.getTree().getTreeModel().removeTreeModelListener(this.treeListeners.get(id));
            this.treeListeners.remove(id);
        }

        @Override
        public void messageNodeCallback(int id) {
            TreeNode parent;
            PrintableEntity printableEntity = this.webConsoleHistoryView.getSystemMessageCache$intellij_javascript_debugger().get(id);
            Intrinsics.checkNotNull((Object)printableEntity, (String)"null cannot be cast to non-null type com.intellij.javascript.debugger.console.Variable");
            Variable printableInfo = (Variable)printableEntity;
            XDebuggerTreeNode xDebuggerTreeNode = printableInfo.getVariable();
            Intrinsics.checkNotNull((Object)xDebuggerTreeNode, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.ui.tree.nodes.MessageTreeNode");
            MessageTreeNode node = (MessageTreeNode)xDebuggerTreeNode;
            if (node.isEllipsis() && (parent = node.getParent()) instanceof XValueContainerNode) {
                ((XValueContainerNode)parent).startComputingChildren();
            }
        }

        @Override
        public void updateStickToEnd(boolean stickToEnd) {
            this.webConsoleHistoryView.stickToEnd = stickToEnd;
        }

        @Override
        public void nodeLinkClick(int id) {
            PrintableEntity printableEntity = this.webConsoleHistoryView.getSystemMessageCache$intellij_javascript_debugger().get(id);
            Intrinsics.checkNotNull((Object)printableEntity, (String)"null cannot be cast to non-null type com.intellij.javascript.debugger.console.Variable");
            Variable printableInfo = (Variable)printableEntity;
            XDebuggerTreeNode node = printableInfo.getVariable();
            AppUIUtil.invokeOnEdt(() -> JSBridgeImpl.nodeLinkClick$lambda$3(node, this));
        }

        /*
         * WARNING - void declaration
         */
        private final void addChildren(int callbackId, Object[] children, int[] childIndices) {
            Collection<Pair> collection;
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            Object[] objectArray = new Object[2];
            objectArray[0] = true;
            Object[] objectArray2 = children;
            int n = 1;
            Object[] objectArray3 = objectArray;
            boolean $i$f$mapIndexed = false;
            void var8_9 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$mapIndexed$iv).length);
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void ind;
                void it;
                int n2 = index$iv$iv++;
                void var15_16 = item$iv$iv;
                int n3 = n2;
                collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode");
                XDebuggerTreeNode child = (XDebuggerTreeNode)it;
                String string = child.getText().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
                Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"NORMAL_OUTPUT");
                Variable printable = new Variable(string, consoleViewContentType, child, child.getText());
                Map jsMessage = this.webConsoleHistoryView.prepareJSProps(printable);
                collection.add(new Pair((Object)jsMessage, (Object)(childIndices != null ? Integer.valueOf(childIndices[ind]) : null)));
            }
            collection = (List)destination$iv$iv;
            objectArray3[n] = collection;
            Object[] args = objectArray;
            this.invokeCallback(callbackId, args);
        }

        static /* synthetic */ void addChildren$default(JSBridgeImpl jSBridgeImpl, int n, Object[] objectArray, int[] nArray, int n2, Object object) {
            if ((n2 & 4) != 0) {
                nArray = null;
            }
            jSBridgeImpl.addChildren(n, objectArray, nArray);
        }

        private final void removeChildren(int[] children, int callbackId) {
            Object[] objectArray = new Serializable[]{Boolean.valueOf(false), children};
            Object[] args = objectArray;
            this.invokeCallback(callbackId, args);
        }

        private final void invokeCallback(int callbackId, Object[] args) {
            this.webConsoleHistoryView.htmlPanel.runWhenPageReady((Function0<Unit>)((Function0)() -> JSBridgeImpl.invokeCallback$lambda$5(this, callbackId, args)));
        }

        @Override
        public void log(@Nullable String text) {
            Logger.getInstance(JSBridgeImpl.class).warn(text);
        }

        private static final void navigate$lambda$1$lambda$0(HyperlinkInfo $it, JSBridgeImpl this$0) {
            $it.navigate(this$0.webConsoleHistoryView.project);
        }

        private static final void nodeLinkClick$lambda$3(XDebuggerTreeNode $node, JSBridgeImpl this$0) {
            XDebuggerTreeNodeHyperlink xDebuggerTreeNodeHyperlink = $node.getLink();
            Intrinsics.checkNotNull((Object)xDebuggerTreeNodeHyperlink);
            xDebuggerTreeNodeHyperlink.onClick(new MouseEvent(this$0.webConsoleHistoryView.getComponent(), 0, 0L, 0, 0, 0, 1, false));
        }

        private static final Unit invokeCallback$lambda$5(JSBridgeImpl this$0, int $callbackId, Object[] $args) {
            this$0.webConsoleHistoryView.htmlPanel.executeScript("window.callback(" + $callbackId + ", " + gson.toJson((Object)$args) + ");");
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ void access$addChildren(JSBridgeImpl $this, int callbackId, Object[] children, int[] childIndices) {
            $this.addChildren(callbackId, children, childIndices);
        }

        public static final /* synthetic */ void access$removeChildren(JSBridgeImpl $this, int[] children, int callbackId) {
            $this.removeChildren(children, callbackId);
        }
    }
}

