/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.util;

import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.profiles.InlinedCountingConditionProfile;
import com.oracle.truffle.js.runtime.util.InlinedProfileBuilder;
import java.util.Arrays;
import java.util.Objects;

public interface InlinedProfileBag {

    public static final class Builder
    extends InlinedProfileBuilder
    implements AutoCloseable {
        private final InlineSupport.InlineTarget inlineTarget;
        private final int[] stateFieldBits;
        private int stateFieldIndex;
        private int intFieldIndex;

        public Builder(InlineSupport.InlineTarget inlineTarget, int ... requiredStateBits) {
            super(null, 0, 0);
            this.inlineTarget = Objects.requireNonNull(inlineTarget);
            this.stateFieldBits = requiredStateBits;
            this.stateFieldIndex = -1;
            this.intFieldIndex = requiredStateBits.length;
        }

        public Builder() {
            this.inlineTarget = null;
            this.stateFieldBits = null;
        }

        @Override
        protected void advanceStateField(int bits) {
            do {
                this.stateFieldOffset = 0;
                ++this.stateFieldIndex;
                this.stateFieldLength = this.stateFieldBits[this.stateFieldIndex];
                this.stateField = this.inlineTarget.getState(this.stateFieldIndex, this.stateFieldLength);
            } while (this.stateFieldLength < bits);
        }

        public InlinedCountingConditionProfile countingConditionProfile() {
            if (this.isUncached()) {
                return InlinedCountingConditionProfile.getUncached();
            }
            return InlinedCountingConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedCountingConditionProfile.class, this.inlineTarget.getPrimitive(this.intFieldIndex++, InlineSupport.IntField.class), this.inlineTarget.getPrimitive(this.intFieldIndex++, InlineSupport.IntField.class)));
        }

        @Override
        public void close() {
            assert (this.isUncached() || this.totalUsedBits == Arrays.stream(this.stateFieldBits).sum()) : this.totalUsedBits;
        }
    }
}

