/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pycharm.pro.customization.python.resourceRoots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.pycharm.pro.customization.python.resourceRoots.PyResourceRootProvider;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import com.intellij.util.containers.MultiMap;
import com.intellij.webcore.resourceRoots.WebResourcesPathsConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PyResourceRefactoringListenerProvider
implements RefactoringElementListenerProvider {
    PyResourceRefactoringListenerProvider() {
    }

    @Nullable
    public RefactoringElementListener getListener(PsiElement element) {
        if (!PyResourceRootProvider.isResourceRoot(element)) {
            return null;
        }
        VirtualFile file = ((PsiDirectory)element).getVirtualFile();
        WebResourcesPathsConfiguration.State state = WebResourcesPathsConfiguration.getInstance((Project)element.getProject()).getState();
        if (state == null) {
            return null;
        }
        Map entries = state.contentEntries;
        for (String entry : entries.keySet()) {
            WebResourcesPathsConfiguration.ContentEntryData data2 = (WebResourcesPathsConfiguration.ContentEntryData)entries.get(entry);
            if (!data2.resourceRoots.contains(file.getUrl())) continue;
            return new PyResourceRefactoringListener(entry, file.getUrl());
        }
        return null;
    }

    static class PyResourceRefactoringListener
    extends RefactoringElementAdapter {
        private final String myEntryUrl;
        private final String myFileUrl;
        MultiMap<String, String> myOldResourceRoots;

        PyResourceRefactoringListener(String entryUrl, String fileUrl) {
            this.myEntryUrl = entryUrl;
            this.myFileUrl = fileUrl;
        }

        protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
            if (newElement == null) {
                PyResourceRefactoringListener.$$$reportNull$$$0(0);
            }
            WebResourcesPathsConfiguration config = WebResourcesPathsConfiguration.getInstance((Project)newElement.getProject());
            this.myOldResourceRoots = config.getResourceRoots();
            MultiMap newResourceRoots = new MultiMap();
            for (String entryUrl : this.myOldResourceRoots.keySet()) {
                if (!entryUrl.equals(this.myEntryUrl)) {
                    newResourceRoots.put((Object)entryUrl, this.myOldResourceRoots.get((Object)entryUrl));
                    continue;
                }
                ArrayList<String> files = new ArrayList<String>();
                for (String fileUrl : this.myOldResourceRoots.get((Object)entryUrl)) {
                    String ancestor = VfsUtilCore.urlToPath((String)this.myFileUrl);
                    String child = VfsUtilCore.urlToPath((String)fileUrl);
                    if (child.equals(ancestor) || FileUtil.isAncestor((String)ancestor, (String)child, (boolean)false)) {
                        files.add(PyResourceRefactoringListener.getNewName((PsiDirectory)newElement, ancestor, child));
                        continue;
                    }
                    files.add(fileUrl);
                }
                newResourceRoots.put((Object)entryUrl, files);
            }
            config.setResourceRoots(newResourceRoots);
        }

        @NotNull
        private static String getNewName(@NotNull PsiDirectory newElement, String ancestor, String child) {
            if (newElement == null) {
                PyResourceRefactoringListener.$$$reportNull$$$0(1);
            }
            VirtualFile newFile = newElement.getVirtualFile();
            String relativePath = child.substring(ancestor.length());
            String newPath = FileUtil.join((String[])new String[]{newFile.getPath(), relativePath.startsWith(File.separator) ? relativePath.substring(1) : relativePath});
            String string = VfsUtilCore.pathToUrl((String)(newPath.endsWith(File.separator) ? newPath.substring(0, newPath.length() - 1) : newPath));
            if (string == null) {
                PyResourceRefactoringListener.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
            if (newElement == null) {
                PyResourceRefactoringListener.$$$reportNull$$$0(3);
            }
            if (oldQualifiedName == null) {
                PyResourceRefactoringListener.$$$reportNull$$$0(4);
            }
            if (this.myOldResourceRoots != null) {
                WebResourcesPathsConfiguration.getInstance((Project)newElement.getProject()).setResourceRoots(this.myOldResourceRoots);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/pycharm/pro/customization/python/resourceRoots/PyResourceRefactoringListenerProvider$PyResourceRefactoringListener";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldQualifiedName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/pycharm/pro/customization/python/resourceRoots/PyResourceRefactoringListenerProvider$PyResourceRefactoringListener";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNewName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "elementRenamedOrMoved";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getNewName";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "undoElementMovedOrRenamed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

