/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.tables.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.scientific.tables.DSTableBundle;
import com.intellij.scientific.tables.DSTableDataManager;
import com.intellij.scientific.tables.DataId;
import com.intellij.scientific.tables.api.DSPanelInfo;
import com.intellij.scientific.tables.api.DSSessionListener;
import com.intellij.scientific.tables.api.DSTableCommandExecutor;
import com.intellij.scientific.tables.api.DSTableOutputData;
import com.intellij.scientific.tables.editor.DSTableEditorPanelInfo;
import com.intellij.scientific.tables.editor.DSTableVirtualFile;
import com.intellij.scientific.tables.editor.DsTablePanel;
import com.intellij.scientific.tables.panel.PrepareForOuterScrollPane;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0002J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0017\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/scientific/tables/editor/DsTablePanel;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "tableVirtualFile", "Lcom/intellij/scientific/tables/editor/DSTableVirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/scientific/tables/editor/DSTableVirtualFile;)V", "getTableVirtualFile", "()Lcom/intellij/scientific/tables/editor/DSTableVirtualFile;", "dataId", "Lcom/intellij/scientific/tables/DataId;", "sessionListener", "Lcom/intellij/scientific/tables/api/DSSessionListener;", "panelInfo", "Lcom/intellij/scientific/tables/api/DSPanelInfo;", "showData", "", "updateData", "addTableAndLoadDataSynchronized", "disposePreviousDataId", "initSessionListener", "dispose", "intellij.scientific.tables"})
public final class DsTablePanel
extends SimpleToolWindowPanel
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final DSTableVirtualFile tableVirtualFile;
    @Nullable
    private DataId dataId;
    @Nullable
    private DSSessionListener sessionListener;
    @Nullable
    private DSPanelInfo panelInfo;

    public DsTablePanel(@NotNull Project project, @NotNull DSTableVirtualFile tableVirtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)tableVirtualFile), (String)"tableVirtualFile");
        super(true);
        this.project = project;
        this.tableVirtualFile = tableVirtualFile;
        ApplicationManager.getApplication().executeOnPooledThread(() -> DsTablePanel._init_$lambda$0(this));
    }

    @NotNull
    public final DSTableVirtualFile getTableVirtualFile() {
        return this.tableVirtualFile;
    }

    private final void showData() {
        DSTableEditorPanelInfo panelInfo = new DSTableEditorPanelInfo((JPanel)((Object)this), null, null, false, null, this, false, false, true, false, null, 1092, null);
        this.panelInfo = panelInfo;
        this.addContainerListener(PrepareForOuterScrollPane.INSTANCE);
        this.addTableAndLoadDataSynchronized(panelInfo);
    }

    private final void updateData() {
        DSPanelInfo dSPanelInfo = this.panelInfo;
        if (dSPanelInfo == null) {
            return;
        }
        DSPanelInfo panelInfo = dSPanelInfo;
        this.addContainerListener(PrepareForOuterScrollPane.INSTANCE);
        this.addTableAndLoadDataSynchronized(panelInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addTableAndLoadDataSynchronized(DSPanelInfo panelInfo) {
        DsTablePanel dsTablePanel = this;
        synchronized (dsTablePanel) {
            boolean bl = false;
            this.disposePreviousDataId();
            Project project = this.project;
            String string = DSTableBundle.message("ds.table.loading.table.data", new Object[0]);
            new Task.Backgroundable(this, panelInfo, project, string){
                final /* synthetic */ DsTablePanel this$0;
                final /* synthetic */ DSPanelInfo $panelInfo;
                {
                    this.this$0 = $receiver;
                    this.$panelInfo = $panelInfo;
                    super($super_call_param$1, $super_call_param$2, true);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    Project project = this.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    DSTableDataManager dSTableDataManager = DSTableDataManager.Companion.getInstance(project);
                    Project project2 = this.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                    DSTableCommandExecutor dSTableCommandExecutor = this.this$0.getTableVirtualFile().getCommandExecutor();
                    DSTableOutputData dSTableOutputData = this.this$0.getTableVirtualFile().getOutputData();
                    Intrinsics.checkNotNull((Object)dSTableOutputData);
                    DataId newDataId = dSTableDataManager.addNewTableData(project2, dSTableCommandExecutor, dSTableOutputData, this.$panelInfo, this.this$0.getTableVirtualFile().isDynamicTable(), this.this$0.getTableVirtualFile().getFormat());
                    DsTablePanel dsTablePanel = this.this$0;
                    DsTablePanel dsTablePanel2 = this.this$0;
                    DsTablePanel dsTablePanel3 = dsTablePanel;
                    synchronized (dsTablePanel3) {
                        boolean bl = false;
                        DataId dataId = DsTablePanel.access$getDataId$p(dsTablePanel2);
                        if (newDataId.getId() > (dataId != null ? dataId.getId() : 0)) {
                            DsTablePanel.access$setDataId$p(dsTablePanel2, newDataId);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }.queue();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void disposePreviousDataId() {
        block0: {
            DataId dataId = this.dataId;
            if (dataId == null) break block0;
            DataId it = dataId;
            boolean bl = false;
            DSTableDataManager.Companion.getInstance(this.project).removeData(it);
        }
    }

    private final void initSessionListener(Project project) {
        block0: {
            DSSessionListener listener2 = new DSSessionListener(this, project){
                final /* synthetic */ DsTablePanel this$0;
                final /* synthetic */ Project $project;
                {
                    this.this$0 = $receiver;
                    this.$project = $project;
                }

                public void frameChanged() {
                    DsTablePanel.access$updateData(this.this$0);
                }

                public void sessionStopped() {
                    ApplicationManager.getApplication().invokeLater(() -> initSessionListener.listener.1.sessionStopped$lambda$0(this.$project, this.this$0));
                }

                private static final void sessionStopped$lambda$0(Project $project, DsTablePanel this$0) {
                    FileEditorManager instance = FileEditorManager.getInstance((Project)$project);
                    if (instance.isFileOpen((VirtualFile)this$0.getTableVirtualFile())) {
                        instance.closeFile((VirtualFile)this$0.getTableVirtualFile());
                    }
                }
            };
            this.sessionListener = listener2;
            DSTableCommandExecutor dSTableCommandExecutor = this.tableVirtualFile.getCommandExecutor();
            if (dSTableCommandExecutor == null) break block0;
            dSTableCommandExecutor.addSessionListener(listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        DsTablePanel dsTablePanel = this;
        synchronized (dsTablePanel) {
            Unit unit;
            Object it;
            boolean bl = false;
            DataId dataId = this.dataId;
            if (dataId != null) {
                it = dataId;
                boolean bl2 = false;
                DSTableDataManager.Companion.getInstance(this.project).removeData((DataId)it);
            }
            this.dataId = null;
            DSSessionListener dSSessionListener = this.sessionListener;
            if (dSSessionListener != null) {
                it = dSSessionListener;
                boolean bl3 = false;
                DSTableCommandExecutor dSTableCommandExecutor = this.tableVirtualFile.getCommandExecutor();
                if (dSTableCommandExecutor != null) {
                    dSTableCommandExecutor.removeSessionListener((DSSessionListener)it);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
    }

    private static final void _init_$lambda$0(DsTablePanel this$0) {
        this$0.showData();
        this$0.initSessionListener(this$0.project);
    }

    public static final /* synthetic */ void access$updateData(DsTablePanel $this) {
        $this.updateData();
    }

    public static final /* synthetic */ DataId access$getDataId$p(DsTablePanel $this) {
        return $this.dataId;
    }

    public static final /* synthetic */ void access$setDataId$p(DsTablePanel $this, DataId dataId) {
        $this.dataId = dataId;
    }
}

