/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.tables.panel.filtering;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.DataGridRequestPlace;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Key;
import com.intellij.scientific.tables.DSDataHookUp;
import com.intellij.scientific.tables.DSFilteringModel;
import com.intellij.scientific.tables.api.FilterExpression;
import com.intellij.scientific.tables.panel.filtering.DSFilterView;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\b\u0010\u0013\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/scientific/tables/panel/filtering/DSFilterController;", "", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "<init>", "(Lcom/intellij/database/datagrid/DataGrid;)V", "dataHookup", "Lcom/intellij/scientific/tables/DSDataHookUp;", "filteringModel", "Lcom/intellij/scientific/tables/DSFilteringModel;", "filteringView", "Lcom/intellij/scientific/tables/panel/filtering/DSFilterView;", "applyAction", "", "deleteAction", "isFiltersApplied", "", "createFiltersPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "updateTable", "Companion", "intellij.scientific.tables"})
public final class DSFilterController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataGrid grid;
    @NotNull
    private final DSDataHookUp dataHookup;
    @NotNull
    private final DSFilteringModel filteringModel;
    @NotNull
    private final DSFilterView filteringView;
    @JvmField
    @NotNull
    public static final Key<DSFilterController> DS_TABLES_FILTER_CONTROLLER = new Key("DS_TABLES_FILTER_CONTROLLER");

    public DSFilterController(@NotNull DataGrid grid2) {
        DSFilterView dSFilterView;
        Intrinsics.checkNotNullParameter((Object)grid2, (String)"grid");
        this.grid = grid2;
        GridDataHookUp gridDataHookUp = this.grid.getDataHookup();
        Intrinsics.checkNotNull((Object)gridDataHookUp, (String)"null cannot be cast to non-null type com.intellij.scientific.tables.DSDataHookUp");
        this.dataHookup = (DSDataHookUp)gridDataHookUp;
        this.filteringModel = this.dataHookup.getDSFilteringModel();
        this.filteringView = new DSFilterView(this.grid, this.filteringModel.getColumns(), this.filteringModel.getComparisonTypes());
        DSFilterView $this$_init__u24lambda_u244 = dSFilterView = this.filteringView;
        boolean bl = false;
        $this$_init__u24lambda_u244.addOnApplyAction((Function0<Unit>)((Function0)() -> DSFilterController.lambda$4$lambda$0(this)));
        $this$_init__u24lambda_u244.addOnDeleteAction((Function0<Unit>)((Function0)() -> DSFilterController.lambda$4$lambda$1(this)));
        $this$_init__u24lambda_u244.addOnCancelAction((Function0<Unit>)((Function0)() -> DSFilterController.lambda$4$lambda$2(this)));
        $this$_init__u24lambda_u244.addOnAddFilterAction((Function0<Unit>)((Function0)() -> DSFilterController.lambda$4$lambda$3(this)));
        this.grid.putUserData(DS_TABLES_FILTER_CONTROLLER, (Object)this);
        this.grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).addListener((GridModel.Listener)new GridModel.Listener<GridRow, GridColumn>(){

            public void columnsAdded(ModelIndexSet<GridColumn> columnsIndexSet) {
                if (columnsIndexSet != null) {
                    filteringView.columnsAddedToTable(filteringModel.getColumns(columnsIndexSet));
                }
            }

            public void columnsRemoved(ModelIndexSet<GridColumn> columns) {
            }

            public void rowsAdded(ModelIndexSet<GridRow> rows) {
            }

            public void rowsRemoved(ModelIndexSet<GridRow> rows) {
            }

            public void cellsUpdated(ModelIndexSet<GridRow> rows, ModelIndexSet<GridColumn> columns, GridRequestSource.RequestPlace place) {
            }
        }, (Disposable)this.grid);
    }

    private final void applyAction() {
        FilterExpression filters = this.filteringView.getFilters();
        this.filteringModel.setFilters(filters);
        this.updateTable();
        this.filteringView.closePopUp();
    }

    private final void deleteAction() {
        this.filteringView.clearFilters();
        this.filteringModel.clearFilters();
        this.updateTable();
        this.filteringView.closePopUp();
    }

    public final boolean isFiltersApplied() {
        return this.filteringModel.getAppliedFilters() != null;
    }

    @Nullable
    public final JBPopup createFiltersPopup() {
        if (this.filteringView.isPopupOpened()) {
            return null;
        }
        FilterExpression appliedFilters = this.filteringModel.getAppliedFilters();
        return this.filteringView.createPopUp(appliedFilters);
    }

    private final void updateTable() {
        this.dataHookup.getLoader().loadFirstPage(new GridRequestSource((GridRequestSource.RequestPlace)new DataGridRequestPlace((CoreGrid)this.grid)));
    }

    private static final Unit lambda$4$lambda$0(DSFilterController this$0) {
        this$0.applyAction();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$4$lambda$1(DSFilterController this$0) {
        this$0.deleteAction();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$4$lambda$2(DSFilterController this$0) {
        this$0.filteringView.closePopUp();
        return Unit.INSTANCE;
    }

    private static final Unit lambda$4$lambda$3(DSFilterController this$0) {
        this$0.filteringView.addNewFilter();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/scientific/tables/panel/filtering/DSFilterController$Companion;", "", "<init>", "()V", "DS_TABLES_FILTER_CONTROLLER", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/scientific/tables/panel/filtering/DSFilterController;", "intellij.scientific.tables"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

