/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc3;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlite.ExtendedCommand;
import org.sqlite.SQLiteConnection;
import org.sqlite.core.CoreStatement;
import org.sqlite.core.DB;

public abstract class JDBC3Statement
extends CoreStatement {
    private int queryTimeout = 0;
    protected long updateCount;
    protected boolean exhaustedResults = false;

    protected JDBC3Statement(SQLiteConnection conn) {
        super(conn);
    }

    public void close() throws SQLException {
        this.clearGeneratedKeys();
        this.internalClose();
    }

    public boolean execute(String sql) throws SQLException {
        this.internalClose();
        return this.withConnectionTimeout(() -> {
            ExtendedCommand.SQLExtension ext = ExtendedCommand.parse(sql);
            if (ext != null) {
                ext.execute(this.conn.getDatabase());
                return false;
            }
            this.sql = sql;
            SQLiteConnection sQLiteConnection = this.conn;
            synchronized (sQLiteConnection) {
                this.conn.getDatabase().prepare(this);
                boolean result2 = this.exec();
                this.updateGeneratedKeys();
                this.updateCount = this.getDatabase().changes();
                this.exhaustedResults = false;
                return result2;
            }
        });
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(sql);
    }

    @Override
    public ResultSet executeQuery(String sql, boolean closeStmt) throws SQLException {
        this.rs.closeStmt = closeStmt;
        return this.executeQuery(sql);
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.internalClose();
        this.sql = sql;
        return this.withConnectionTimeout(() -> {
            this.conn.getDatabase().prepare(this);
            if (!this.exec()) {
                this.internalClose();
                throw new SQLException("query does not return ResultSet", "SQLITE_DONE", 101);
            }
            this.exhaustedResults = false;
            return this.getResultSet();
        });
    }

    public int executeUpdate(String sql) throws SQLException {
        return (int)this.executeLargeUpdate(sql);
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeUpdate(sql);
    }

    public long executeLargeUpdate(String sql) throws SQLException {
        this.internalClose();
        this.sql = sql;
        return this.withConnectionTimeout(() -> {
            DB db = this.conn.getDatabase();
            long changes = 0L;
            ExtendedCommand.SQLExtension ext = ExtendedCommand.parse(sql);
            if (ext != null) {
                ext.execute(db);
            } else {
                try {
                    DB dB = db;
                    synchronized (dB) {
                        changes = db.total_changes();
                        int statusCode = db._exec(sql);
                        if (statusCode != 0) {
                            throw DB.newSQLException(statusCode, "");
                        }
                        this.updateGeneratedKeys();
                        changes = db.total_changes() - changes;
                    }
                }
                finally {
                    this.internalClose();
                }
            }
            return changes;
        });
    }

    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeLargeUpdate(sql);
    }

    public ResultSet getResultSet() throws SQLException {
        this.checkOpen();
        if (this.exhaustedResults) {
            return null;
        }
        if (this.rs.isOpen()) {
            throw new SQLException("ResultSet already requested");
        }
        if (this.pointer.safeRunInt(DB::column_count) == 0) {
            return null;
        }
        if (this.rs.colsMeta == null) {
            this.rs.colsMeta = this.pointer.safeRun(DB::column_names);
        }
        this.rs.cols = this.rs.colsMeta;
        this.rs.emptyResultSet = !this.resultsWaiting;
        this.rs.open = true;
        this.resultsWaiting = false;
        return (ResultSet)((Object)this.rs);
    }

    public int getUpdateCount() throws SQLException {
        return (int)this.getLargeUpdateCount();
    }

    public long getLargeUpdateCount() throws SQLException {
        DB db = this.conn.getDatabase();
        if (!(this.pointer.isClosed() || this.rs.isOpen() || this.resultsWaiting || this.pointer.safeRunInt(DB::column_count) != 0)) {
            return this.updateCount;
        }
        return -1L;
    }

    public void addBatch(String sql) throws SQLException {
        this.internalClose();
        if (this.batch == null || this.batchPos + 1 >= this.batch.length) {
            Object[] nb = new Object[Math.max(10, this.batchPos * 2)];
            if (this.batch != null) {
                System.arraycopy(this.batch, 0, nb, 0, this.batch.length);
            }
            this.batch = nb;
        }
        this.batch[this.batchPos++] = sql;
    }

    public void clearBatch() throws SQLException {
        this.batchPos = 0;
        if (this.batch != null) {
            for (int i = 0; i < this.batch.length; ++i) {
                this.batch[i] = null;
            }
        }
    }

    public int[] executeBatch() throws SQLException {
        return Arrays.stream(this.executeLargeBatch()).mapToInt(l -> (int)l).toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] executeLargeBatch() throws SQLException {
        DB db;
        this.internalClose();
        if (this.batch == null || this.batchPos == 0) {
            return new long[0];
        }
        long[] changes = new long[this.batchPos];
        DB dB = db = this.conn.getDatabase();
        synchronized (dB) {
            try {
                for (int i = 0; i < changes.length; ++i) {
                    try {
                        this.sql = (String)this.batch[i];
                        db.prepare(this);
                        changes[i] = db.executeUpdate(this, null);
                        continue;
                    }
                    catch (SQLException e) {
                        throw new BatchUpdateException("batch entry " + i + ": " + e.getMessage(), null, 0, changes, (Throwable)e);
                    }
                    finally {
                        if (this.pointer != null) {
                            this.pointer.close();
                        }
                    }
                }
            }
            finally {
                this.clearBatch();
            }
        }
        return changes;
    }

    public void setCursorName(String name) {
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    public void cancel() throws SQLException {
        this.conn.getDatabase().interrupt();
    }

    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw new SQLException("query timeout must be >= 0");
        }
        this.queryTimeout = seconds;
    }

    public int getMaxRows() throws SQLException {
        return (int)this.rs.maxRows;
    }

    public long getLargeMaxRows() throws SQLException {
        return this.rs.maxRows;
    }

    public void setMaxRows(int max) throws SQLException {
        this.setLargeMaxRows(max);
    }

    public void setLargeMaxRows(long max) throws SQLException {
        if (max < 0L) {
            throw new SQLException("max row count must be >= 0");
        }
        this.rs.maxRows = max;
    }

    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException("max field size " + max + " cannot be negative");
        }
    }

    public int getFetchSize() throws SQLException {
        return ((ResultSet)((Object)this.rs)).getFetchSize();
    }

    public void setFetchSize(int r) throws SQLException {
        ((ResultSet)((Object)this.rs)).setFetchSize(r);
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public void setFetchDirection(int direction) throws SQLException {
        switch (direction) {
            case 1000: 
            case 1001: 
            case 1002: {
                break;
            }
            default: {
                throw new SQLException("Unknown fetch direction " + direction + ". Must be one of FETCH_FORWARD, FETCH_REVERSE, or FETCH_UNKNOWN in java.sql.ResultSet");
            }
        }
    }

    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    public boolean getMoreResults(int current) throws SQLException {
        this.checkOpen();
        if (current == 2 || current == 3) {
            throw new SQLFeatureNotSupportedException("Argument not supported: Statement.KEEP_CURRENT_RESULT or Statement.CLOSE_ALL_RESULTS");
        }
        if (current != 1) {
            throw new SQLException("Invalid argument");
        }
        this.rs.close();
        this.updateCount = -1L;
        this.exhaustedResults = true;
        return false;
    }

    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    public int getResultSetType() throws SQLException {
        return 1003;
    }

    public void setEscapeProcessing(boolean enable) {
    }

    protected SQLException unsupported() {
        return new SQLFeatureNotSupportedException("not implemented by SQLite JDBC driver");
    }

    public boolean execute(String sql, int[] colinds) throws SQLException {
        throw this.unsupported();
    }

    public boolean execute(String sql, String[] colnames) throws SQLException {
        throw this.unsupported();
    }

    public int executeUpdate(String sql, int[] colinds) throws SQLException {
        throw this.unsupported();
    }

    public int executeUpdate(String sql, String[] cols) throws SQLException {
        throw this.unsupported();
    }

    public long executeLargeUpdate(String sql, int[] colinds) throws SQLException {
        throw this.unsupported();
    }

    public long executeLargeUpdate(String sql, String[] cols) throws SQLException {
        throw this.unsupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T withConnectionTimeout(SQLCallable<T> callable) throws SQLException {
        int origBusyTimeout = this.conn.getBusyTimeout();
        if (this.queryTimeout > 0) {
            this.conn.setBusyTimeout(1000 * this.queryTimeout);
        }
        try {
            T t = callable.call();
            return t;
        }
        finally {
            if (this.queryTimeout > 0) {
                this.conn.setBusyTimeout(origBusyTimeout);
            }
        }
    }

    @FunctionalInterface
    protected static interface SQLCallable<T> {
        public T call() throws SQLException;
    }

    static class BackupObserver
    implements DB.ProgressObserver {
        private static final Logger logger = LoggerFactory.getLogger(BackupObserver.class);

        BackupObserver() {
        }

        @Override
        public void progress(int remaining, int pageCount) {
            logger.info("remaining:{}, page count:{}", (Object)remaining, (Object)pageCount);
        }
    }
}

