/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.connections.management;

import com.intellij.jupyter.core.fus.JupyterFeaturesCollector;
import com.intellij.jupyter.core.fus.JupyterInstallSource;
import com.intellij.jupyter.core.jupyter.server.ui.JupyterServerToolWindowKt;
import com.intellij.jupyter.py.connections.management.Notebook6PackageException;
import com.intellij.jupyter.py.utils.JupyterPyBundle;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Version;
import com.jetbrains.python.packaging.PyPackageInstallUtils;
import com.jetbrains.python.packaging.common.PythonPackage;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.PySdkUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/jupyter/py/connections/management/JupyterManagementUtils;", "", "<init>", "()V", "NOTEBOOK_DEFAULT_COMMAND", "", "JUPYTER_LAB_DEFAULT_COMMAND", "NOTEBOOK_PACKAGE", "SETUP_TOOLS_PACKAGE", "JUPYTER_LAB_PACKAGE", "detectDefaultCommand", "project", "Lcom/intellij/openapi/project/Project;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "tryInstall", "", "notifyThatNotebooksIsDownloading", "", "notifyThatJupyterPackageDownloadIsFinished", "intellij.jupyter.py"})
public final class JupyterManagementUtils {
    @NotNull
    public static final JupyterManagementUtils INSTANCE = new JupyterManagementUtils();
    @NotNull
    private static final String NOTEBOOK_DEFAULT_COMMAND = "notebook --no-browser";
    @NotNull
    private static final String JUPYTER_LAB_DEFAULT_COMMAND = "jupyterlab --no-browser";
    @NlsSafe
    @NotNull
    public static final String NOTEBOOK_PACKAGE = "notebook";
    @NotNull
    public static final String SETUP_TOOLS_PACKAGE = "setuptools";
    @NotNull
    private static final String JUPYTER_LAB_PACKAGE = "jupyterlab";

    private JupyterManagementUtils() {
    }

    @NotNull
    public final String detectDefaultCommand(@Nullable Project project, @NotNull Sdk sdk, boolean tryInstall) {
        Version versionOfNotebookPackage;
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        if (project == null) {
            return NOTEBOOK_DEFAULT_COMMAND;
        }
        Version versionOfJupyterLabPackage = PyPackageInstallUtils.INSTANCE.getPackageVersion(project, sdk, JUPYTER_LAB_PACKAGE);
        if (versionOfJupyterLabPackage != null) {
            return JUPYTER_LAB_DEFAULT_COMMAND;
        }
        Version version = versionOfNotebookPackage = PyPackageInstallUtils.INSTANCE.getPackageVersion(project, sdk, NOTEBOOK_PACKAGE);
        boolean bl = version != null ? version.isOrGreaterThan(Integer.valueOf(7)) : false;
        if (bl) {
            return NOTEBOOK_DEFAULT_COMMAND;
        }
        Version version2 = versionOfNotebookPackage;
        boolean bl2 = version2 != null ? version2.lessThan(Integer.valueOf(7)) : false;
        if (bl2) {
            LanguageLevel languageLevel = PySdkUtil.getLanguageLevelForSdk((Sdk)sdk);
            Intrinsics.checkNotNullExpressionValue((Object)languageLevel, (String)"getLanguageLevelForSdk(...)");
            LanguageLevel pythonVersion = languageLevel;
            boolean hasSetuptools = PyPackageInstallUtils.INSTANCE.getPackageVersion(project, sdk, SETUP_TOOLS_PACKAGE) != null;
            boolean is311rMore = pythonVersion.isAtLeast(LanguageLevel.PYTHON311);
            if (!hasSetuptools && is311rMore) {
                String string = pythonVersion.toPythonVersion();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toPythonVersion(...)");
                String string2 = versionOfNotebookPackage.toCompactString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toCompactString(...)");
                throw new Notebook6PackageException(project, sdk, string, string2);
            }
            return NOTEBOOK_DEFAULT_COMMAND;
        }
        if (!tryInstall) {
            return NOTEBOOK_DEFAULT_COMMAND;
        }
        CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends PythonPackage>>, Object>(project, sdk, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ Sdk $sdk;
            {
                this.$project = $project;
                this.$sdk = $sdk;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        JupyterManagementUtils.access$notifyThatNotebooksIsDownloading(JupyterManagementUtils.INSTANCE, this.$project);
                        this.label = 1;
                        v0 = PyPackageInstallUtils.installPackage-yxL6bBk$default((PyPackageInstallUtils)PyPackageInstallUtils.INSTANCE, (Project)this.$project, (Sdk)this.$sdk, (String)"notebook", null, (Continuation)((Continuation)this), (int)8, null);
                        if (v0 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = ((Result)$result).unbox-impl();
lbl14:
                        // 2 sources

                        var2_3 = v0;
                        v1 = Result.exceptionOrNull-impl((Object)var2_3);
                        if (v1 != null) {
                            var3_4 = v1;
                            $i$a$-onFailure-JupyterManagementUtils$detectDefaultCommand$1$1 = false;
                            JupyterFeaturesCollector.Companion.jupyterPackageInstallResult(JupyterInstallSource.RUN_DIALOG, false);
                        }
                        var3_4 = this.$project;
                        if (Result.isSuccess-impl((Object)var2_3)) {
                            (List)var2_3;
                            $i$a$-onSuccess-JupyterManagementUtils$detectDefaultCommand$1$2 = false;
                            JupyterFeaturesCollector.Companion.jupyterPackageInstallResult(JupyterInstallSource.RUN_DIALOG, true);
                            JupyterManagementUtils.access$notifyThatJupyterPackageDownloadIsFinished(JupyterManagementUtils.INSTANCE, (Project)var3_4);
                        }
                        ResultKt.throwOnFailure((Object)var2_3);
                        return var2_3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends PythonPackage>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        return this.detectDefaultCommand(project, sdk, false);
    }

    public static /* synthetic */ String detectDefaultCommand$default(JupyterManagementUtils jupyterManagementUtils, Project project, Sdk sdk, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return jupyterManagementUtils.detectDefaultCommand(project, sdk, bl);
    }

    private final void notifyThatNotebooksIsDownloading(Project project) {
        Object[] objectArray = new Object[]{NOTEBOOK_PACKAGE};
        String message2 = JupyterPyBundle.message("jupyter.server.download.package.started", objectArray);
        JupyterServerToolWindowKt.getJUPYTER_NOTIFICATION_GROUP().createNotification(message2, NotificationType.INFORMATION).notify(project);
        JupyterServerToolWindowKt.getEVENT_LOG_NOTIFICATION_GROUP().createNotification(message2, NotificationType.INFORMATION).notify(project);
    }

    private final void notifyThatJupyterPackageDownloadIsFinished(Project project) {
        Object[] objectArray = new Object[]{NOTEBOOK_PACKAGE};
        String message2 = JupyterPyBundle.message("jupyter.server.download.package.finished", objectArray);
        JupyterServerToolWindowKt.getJUPYTER_NOTIFICATION_GROUP().createNotification(message2, NotificationType.INFORMATION).notify(project);
    }

    public static final /* synthetic */ void access$notifyThatNotebooksIsDownloading(JupyterManagementUtils $this, Project project) {
        $this.notifyThatNotebooksIsDownloading(project);
    }

    public static final /* synthetic */ void access$notifyThatJupyterPackageDownloadIsFinished(JupyterManagementUtils $this, Project project) {
        $this.notifyThatJupyterPackageDownloadIsFinished(project);
    }
}

