/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.jupyterConsole.actions;

import com.intellij.codeWithMe.ClientId;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.JupyterConsoleUtil;
import com.intellij.jupyter.core.jupyter.editor.JupyterFileEditor;
import com.intellij.jupyter.core.jupyter.helper.JupyterDataContextExtensionsKt;
import com.intellij.jupyter.py.jupyterConsole.JupyterConsoleService;
import com.intellij.jupyter.py.jupyterConsole.JupyterConsoleView;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.context.NotebookDataContext;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/jupyter/py/jupyterConsole/actions/JupyterConsoleInsertToMainNotebookAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "getMainEditor", "Lcom/intellij/openapi/editor/Editor;", "consoleView", "Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleView;", "getConsoleVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterConsoleInsertToMainNotebookAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterConsoleInsertToMainNotebookAction.kt\ncom/intellij/jupyter/py/jupyterConsole/actions/JupyterConsoleInsertToMainNotebookAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,58:1\n1#2:59\n40#3,3:60\n*S KotlinDebug\n*F\n+ 1 JupyterConsoleInsertToMainNotebookAction.kt\ncom/intellij/jupyter/py/jupyterConsole/actions/JupyterConsoleInsertToMainNotebookAction\n*L\n44#1:60,3\n*E\n"})
public final class JupyterConsoleInsertToMainNotebookAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VirtualFile consoleVirtualFile = this.getConsoleVirtualFile(e);
        if (consoleVirtualFile == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (Intrinsics.areEqual((Object)consoleVirtualFile.getUserData(JupyterConsoleUtil.INSTANCE.getJUPYTER_CONSOLE_KEY()), (Object)true)) {
            e.getPresentation().setEnabledAndVisible(true);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile virtualFile;
        String text;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                DataContext dataContext = e.getDataContext();
                Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
                NotebookCellLines.Interval interval = NotebookDataContext.INSTANCE.getSelectedCellInterval(dataContext);
                if (interval == null) {
                    return;
                }
                NotebookCellLines.Interval cell = interval;
                DataContext dataContext2 = e.getDataContext();
                Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
                EditorImpl editorImpl = JupyterDataContextExtensionsKt.getJupyterEditor((DataContext)dataContext2);
                if (editorImpl == null) {
                    return;
                }
                EditorImpl editor = editorImpl;
                text = cell.getContentText((Editor)editor);
                virtualFile = this.getConsoleVirtualFile(e);
                if (virtualFile == null) break block7;
                VirtualFile virtualFile2 = virtualFile;
                BackedNotebookVirtualFile.Companion companion = BackedNotebookVirtualFile.Companion;
                VirtualFile p0 = virtualFile2;
                boolean $i$f$actionPerformed$stub_for_inlining = false;
                boolean bl = false;
                BackedNotebookVirtualFile backedNotebookVirtualFile = companion.takeIfBacked(p0);
                virtualFile = backedNotebookVirtualFile;
                if (backedNotebookVirtualFile != null) break block8;
            }
            return;
        }
        VirtualFile virtualFile3 = virtualFile;
        boolean $i$f$service = false;
        Class<JupyterConsoleService> serviceClass$iv = JupyterConsoleService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        JupyterConsoleView jupyterConsoleView = ((JupyterConsoleService)object).getConsoleView((BackedNotebookVirtualFile)virtualFile3);
        if (jupyterConsoleView == null) {
            return;
        }
        JupyterConsoleView consoleView = jupyterConsoleView;
        consoleView.addNewCell(text, this.getMainEditor(consoleView));
    }

    private final Editor getMainEditor(JupyterConsoleView consoleView) {
        FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)consoleView.getProject()).getEditors(consoleView.getRealNotebookVirtualFile().getFile());
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getEditors(...)");
        FileEditor editor = (FileEditor)ArraysKt.first((Object[])fileEditorArray);
        if (editor instanceof JupyterFileEditor) {
            return ((JupyterFileEditor)editor).getEditor();
        }
        return null;
    }

    private final VirtualFile getConsoleVirtualFile(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterDataContextExtensionsKt.getJupyterNotebookFile((DataContext)dataContext);
        return backedNotebookVirtualFile != null ? backedNotebookVirtualFile.getFile() : null;
    }
}

