/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.ui.remote.providers;

import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.CachingFileContentsApi;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.ContentsApiModel;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.DirectoryModel;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.FileContentsApi;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.FileContentsApiKt;
import com.intellij.jupyter.core.jupyter.connections.filecontentsapi.LeafContentsApiModel;
import com.intellij.jupyter.py.remote.vfs.JupyterRemoteVfsUtilKt;
import com.intellij.jupyter.py.ui.remote.providers.RemoteFileExistsCheckResult;
import com.intellij.notebooks.core.jupyter.JupyterRemotePath;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\u0006"}, d2={"isRemoteFileExists", "Lcom/intellij/jupyter/py/ui/remote/providers/RemoteFileExistsCheckResult;", "remoteDirectory", "Lcom/intellij/notebooks/core/jupyter/JupyterRemotePath;", "fileName", "", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nFileExistsHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileExistsHandler.kt\ncom/intellij/jupyter/py/ui/remote/providers/FileExistsHandlerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n1755#2,3:142\n*S KotlinDebug\n*F\n+ 1 FileExistsHandler.kt\ncom/intellij/jupyter/py/ui/remote/providers/FileExistsHandlerKt\n*L\n129#1:142,3\n*E\n"})
public final class FileExistsHandlerKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final RemoteFileExistsCheckResult isRemoteFileExists(JupyterRemotePath remoteDirectory, String fileName) {
        RemoteFileExistsCheckResult remoteFileExistsCheckResult;
        ContentsApiModel node;
        CachingFileContentsApi cachingFileContentsApi = JupyterRemoteVfsUtilKt.getFileContentsApi(remoteDirectory);
        ContentsApiModel contentsApiModel = node = cachingFileContentsApi != null ? FileContentsApiKt.getFileNode((FileContentsApi)((FileContentsApi)cachingFileContentsApi), (String)remoteDirectory.getJupyterPath(), (boolean)true) : null;
        if (node == null) {
            remoteFileExistsCheckResult = RemoteFileExistsCheckResult.UNKNOWN;
            return remoteFileExistsCheckResult;
        }
        if (node instanceof DirectoryModel) {
            boolean bl;
            block7: {
                Collection collection = ((DirectoryModel)node).getContent();
                Intrinsics.checkNotNull((Object)collection);
                Iterable $this$any$iv = collection;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v4 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ContentsApiModel childModel = (ContentsApiModel)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)childModel.getName(), (Object)fileName)) continue;
                        v4 = true;
                        break block7;
                    }
                    v4 = bl = false;
                }
            }
            if (bl) {
                remoteFileExistsCheckResult = RemoteFileExistsCheckResult.YES;
                return remoteFileExistsCheckResult;
            } else {
                if (bl) throw new NoWhenBranchMatchedException();
                remoteFileExistsCheckResult = RemoteFileExistsCheckResult.NO;
            }
            return remoteFileExistsCheckResult;
        }
        if (!(node instanceof LeafContentsApiModel)) throw new NoWhenBranchMatchedException();
        remoteFileExistsCheckResult = Intrinsics.areEqual((Object)((LeafContentsApiModel)node).getName(), (Object)fileName) ? RemoteFileExistsCheckResult.YES : RemoteFileExistsCheckResult.NO;
        return remoteFileExistsCheckResult;
    }

    public static final /* synthetic */ RemoteFileExistsCheckResult access$isRemoteFileExists(JupyterRemotePath remoteDirectory, String fileName) {
        return FileExistsHandlerKt.isRemoteFileExists(remoteDirectory, fileName);
    }
}

