/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.ui.remote.refactoring.ui;

import com.intellij.jupyter.py.JupyterRemoteBundle;
import com.intellij.jupyter.py.ui.remote.JupyterRemoteCompositeNode;
import com.intellij.jupyter.py.ui.remote.JupyterRemoteFileNode;
import com.intellij.jupyter.py.ui.remote.JupyterRemoteLoadingNode;
import com.intellij.jupyter.py.ui.remote.JupyterRemoteNode;
import com.intellij.notebooks.core.jupyter.remote.vfs.JupyterRemoteFileSystem;
import com.intellij.notebooks.jupyter.core.jupyter.JupyterFileType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001'B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u0011H\u0016J\b\u0010\u001d\u001a\u00020\u0019H\u0014J\u001a\u0010\u001e\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\f\u00a2\u0006\u0002\b\u00130\u001fH\u0014\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\"H\u0014J\u0006\u0010#\u001a\u00020\u0019J\b\u0010$\u001a\u00020\u0019H\u0014J\b\u0010%\u001a\u00020\"H\u0014J\b\u0010&\u001a\u00020\bH\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\n \u000e*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0012\u001a\u00070\b\u00a2\u0006\u0002\b\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006("}, d2={"Lcom/intellij/jupyter/py/ui/remote/refactoring/ui/JupyterRemoteFileRenameDialog;", "Lcom/intellij/refactoring/ui/RefactoringDialog;", "project", "Lcom/intellij/openapi/project/Project;", "node", "Lcom/intellij/jupyter/py/ui/remote/JupyterRemoteNode;", "callback", "Ljava/util/function/Consumer;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/py/ui/remote/JupyterRemoteNode;Ljava/util/function/Consumer;)V", "renameAction", "Ljavax/swing/Action;", "oldName", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "inputText", "Lcom/intellij/ui/EditorTextField;", "newName", "Lorg/jetbrains/annotations/NotNull;", "getNewName", "()Ljava/lang/String;", "createCenterPanel", "", "doAction", "", "createNorthPanel", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "createDefaultActions", "createActions", "", "()[Ljavax/swing/Action;", "hasHelpAction", "", "doRenameAction", "validateButtons", "areButtonsValid", "getTitleText", "RenameAction", "intellij.jupyter.py"})
public final class JupyterRemoteFileRenameDialog
extends RefactoringDialog {
    @NotNull
    private final JupyterRemoteNode node;
    @NotNull
    private final Consumer<String> callback;
    @Nullable
    private Action renameAction;
    private final String oldName;
    @NotNull
    private final EditorTextField inputText;

    /*
     * WARNING - void declaration
     */
    public JupyterRemoteFileRenameDialog(@NotNull Project project, @NotNull JupyterRemoteNode node, @NotNull Consumer<String> callback) {
        Editor editor;
        void $this$inputText_u24lambda_u240;
        EditorTextField editorTextField;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)node), (String)"node");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        super(project, false);
        this.node = node;
        this.callback = callback;
        this.oldName = (String)this.node.getValue();
        EditorTextField editorTextField2 = editorTextField = new EditorTextField(this.oldName);
        JupyterRemoteFileRenameDialog jupyterRemoteFileRenameDialog = this;
        boolean bl = false;
        $this$inputText_u24lambda_u240.addDocumentListener(new DocumentListener(this){
            final /* synthetic */ JupyterRemoteFileRenameDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.this$0.validateButtons();
            }
        });
        $this$inputText_u24lambda_u240.addNotify();
        String string = this.oldName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"oldName");
        int extensionOffset = StringsKt.substringBeforeLast$default((String)string, (String)".", null, (int)2, null).length();
        Editor editor2 = $this$inputText_u24lambda_u240.getEditor();
        if (editor2 != null && (editor2 = editor2.getSelectionModel()) != null) {
            editor2.setSelection(0, extensionOffset);
        }
        if ((editor = $this$inputText_u24lambda_u240.getEditor()) != null && (editor = editor.getCaretModel()) != null) {
            editor.moveToOffset(extensionOffset);
        }
        jupyterRemoteFileRenameDialog.inputText = editorTextField;
        this.setTitle(this.getTitleText());
        this.validateButtons();
        this.init();
    }

    private final String getNewName() {
        String string = this.inputText.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @Nullable
    protected Void createCenterPanel() {
        return null;
    }

    protected void doAction() {
        this.callback.accept(this.inputText.getText());
        this.close(0);
    }

    @NotNull
    protected JComponent createNorthPanel() {
        BorderLayoutPanel borderLayoutPanel;
        Object[] objectArray = new Object[]{this.oldName};
        JLabel heading = new JLabel(JupyterRemoteBundle.message("Jupyter.remote.refactoring.renaming.to", objectArray));
        BorderLayoutPanel $this$createNorthPanel_u24lambda_u241 = borderLayoutPanel = new BorderLayoutPanel(0, 8);
        boolean bl = false;
        $this$createNorthPanel_u24lambda_u241.add((Component)heading, (Object)"North");
        $this$createNorthPanel_u24lambda_u241.add((Component)this.inputText, (Object)"Center");
        BorderLayoutPanel panel = borderLayoutPanel;
        return (JComponent)panel;
    }

    @NotNull
    public EditorTextField getPreferredFocusedComponent() {
        return this.inputText;
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.renameAction = new RenameAction();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getCancelAction(), this.renameAction};
        return actionArray;
    }

    protected boolean hasHelpAction() {
        return false;
    }

    public final void doRenameAction() {
        this.doAction();
    }

    protected void validateButtons() {
        block0: {
            super.validateButtons();
            Action action = this.renameAction;
            if (action == null) break block0;
            action.setEnabled(this.areButtonsValid());
        }
    }

    protected boolean areButtonsValid() {
        return !Intrinsics.areEqual((Object)this.getNewName(), (Object)this.oldName) && JupyterRemoteFileSystem.Companion.getInstance().isValidName(this.getNewName());
    }

    @NlsContexts.DialogTitle
    @Nls
    private final String getTitleText() {
        String string;
        JupyterRemoteNode jupyterRemoteNode = this.node;
        if (jupyterRemoteNode instanceof JupyterRemoteFileNode) {
            FileTypeManager fileTypeManager = FileTypeManager.getInstance();
            String string2 = ((JupyterRemoteFileNode)this.node).getFileName();
            Intrinsics.checkNotNull((Object)string2);
            string = Intrinsics.areEqual((Object)fileTypeManager.getFileTypeByFileName(string2), (Object)JupyterFileType.INSTANCE) ? JupyterRemoteBundle.message("Jupyter.remote.refactoring.rename.notebook", new Object[0]) : JupyterRemoteBundle.message("Jupyter.remote.refactoring.rename.file", new Object[0]);
        } else if (jupyterRemoteNode instanceof JupyterRemoteCompositeNode) {
            string = JupyterRemoteBundle.message("Jupyter.remote.refactoring.rename.directory", new Object[0]);
        } else {
            if (jupyterRemoteNode instanceof JupyterRemoteLoadingNode) {
                throw new IllegalStateException("Renaming a loading node.");
            }
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/py/ui/remote/refactoring/ui/JupyterRemoteFileRenameDialog$RenameAction;", "Ljavax/swing/AbstractAction;", "<init>", "(Lcom/intellij/jupyter/py/ui/remote/refactoring/ui/JupyterRemoteFileRenameDialog;)V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "intellij.jupyter.py"})
    public final class RenameAction
    extends AbstractAction {
        public RenameAction() {
            super(JupyterRemoteBundle.message("Jupyter.remote.refactoring.rename", new Object[0]));
            this.putValue("DefaultAction", true);
        }

        @Override
        public void actionPerformed(@Nullable ActionEvent e) {
            JupyterRemoteFileRenameDialog.this.doRenameAction();
        }
    }
}

