/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\u001a6\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002\u001a \u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0006H\u0002\u001a4\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000f"}, d2={"calcControlPoints", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "start", "end", "curvature", "", "angle", "ncp", "", "calcOrigin", "ps", "pe", "origin", "curve", "commons"})
@SourceDebugExtension(value={"SMAP\nCurve.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Curve.kt\norg/jetbrains/letsPlot/commons/intern/util/CurveKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n1549#2:145\n1620#2,3:146\n1549#2:150\n1620#2,3:151\n1549#2:154\n1620#2,3:155\n1549#2:158\n1620#2,3:159\n1#3:149\n*S KotlinDebug\n*F\n+ 1 Curve.kt\norg/jetbrains/letsPlot/commons/intern/util/CurveKt\n*L\n78#1:145\n78#1:146,3\n90#1:150\n90#1:151,3\n97#1:154\n97#1:155,3\n104#1:158\n104#1:159,3\n*E\n"})
public final class CurveKt {
    @NotNull
    public static final List<DoubleVector> curve(@NotNull DoubleVector start2, @NotNull DoubleVector end, double curvature, double angle, int ncp) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        List<DoubleVector> controlPoints = CurveKt.calcControlPoints(start2, end, curvature, angle, ncp);
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)start2), (Iterable)controlPoints), (Iterable)CollectionsKt.listOf((Object)end));
    }

    /*
     * WARNING - void declaration
     */
    private static final List<DoubleVector> calcControlPoints(DoubleVector start2, DoubleVector end, double curvature, double angle, int ncp) {
        Iterable $this$mapTo$iv$iv;
        Collection<DoubleVector> collection;
        ArrayList<Double> $this$mapTo$iv$iv2;
        void $this$map$iv;
        block9: {
            block8: {
                if (curvature == 0.0) break block8;
                double d = Math.abs(angle);
                if (1.0 <= d ? d <= 179.0 : false) break block9;
            }
            return CollectionsKt.emptyList();
        }
        DoubleVector mid = start2.add(end).mul(0.5);
        DoubleVector d = end.subtract(start2);
        double rAngle = MathKt.toRadians(angle);
        DoubleVector corner = mid.add(start2.subtract(mid).rotate(rAngle));
        double beta = -Math.atan(MathKt.lineSlope(start2, corner));
        DoubleVector doubleVector = start2.add(d.rotate(beta));
        double scaleX = MathKt.lineSlope(start2, doubleVector);
        double ratio = (double)2 * Math.pow(Math.sin(Math.atan(curvature)), 2);
        double origin = curvature - curvature / ratio;
        DoubleVector ps = new DoubleVector(start2.getX() * scaleX, start2.getY());
        DoubleVector oxy = CurveKt.calcOrigin(ps, new DoubleVector(doubleVector.getX() * scaleX, doubleVector.getY()), origin);
        double dir = Math.signum(curvature);
        double maxTheta = Math.PI + Math.signum(origin * dir) * (double)2 * Math.atan(Math.abs(origin));
        Iterable iterable = (Iterable)RangesKt.until((int)0, (int)(ncp + 2));
        int $i$f$map = 0;
        void var30_22 = $this$map$iv;
        ArrayList<Double> destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        int $i$f$mapTo = 0;
        Iterator iterator2 = $this$mapTo$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            collection = destination$iv$iv22;
            boolean bl = false;
            collection.add((DoubleVector)((Object)Double.valueOf((double)it * dir * maxTheta / (double)(ncp + 1))));
        }
        List theta = CollectionsKt.dropLast((List)CollectionsKt.drop((Iterable)destination$iv$iv22, (int)1), (int)1);
        $i$f$map = theta.size();
        $this$mapTo$iv$iv2 = new ArrayList<Double>($i$f$map);
        int destination$iv$iv22 = 0;
        while (destination$iv$iv22 < $i$f$map) {
            void index;
            int n = $i$f$mapTo = destination$iv$iv22++;
            collection = $this$mapTo$iv$iv2;
            boolean bl = false;
            ((ArrayList)collection).add((DoubleVector)((Object)Integer.valueOf((int)index)));
        }
        List indices = $this$mapTo$iv$iv2;
        DoubleVector p = ps.subtract(oxy);
        Iterable $this$map$iv2 = indices;
        boolean $i$f$map2 = false;
        Iterable index = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void index2;
            int n = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(oxy.add(p.rotate(((Number)theta.get((int)index2)).doubleValue())));
        }
        $this$map$iv2 = (List)destination$iv$iv;
        $i$f$map2 = false;
        $this$mapTo$iv$iv = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DoubleVector index2 = (DoubleVector)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DoubleVector(it.getX() / scaleX, it.getY()));
        }
        List cp = (List)destination$iv$iv;
        $this$map$iv2 = indices;
        $i$f$map2 = false;
        $this$mapTo$iv$iv = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void index3;
            int it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(start2.add(((DoubleVector)cp.get((int)index3)).subtract(start2).rotate(-beta)));
        }
        return (List)destination$iv$iv;
    }

    private static final DoubleVector calcOrigin(DoubleVector ps, DoubleVector pe, double origin) {
        DoubleVector mid = ps.add(pe).mul(0.5);
        DoubleVector d = pe.subtract(ps);
        double slope = MathKt.lineSlope(ps, pe);
        double oSlope = (double)-1 / slope;
        double d2 = slope;
        double tmpOX = !(!Double.isInfinite(d2) && !Double.isNaN(d2)) ? 0.0 : (!(!Double.isInfinite(d2 = oSlope) && !Double.isNaN(d2)) ? origin * d.getX() / (double)2 : origin * d.getX() / (double)2);
        double d3 = slope;
        double tmpOY = !(!Double.isInfinite(d3) && !Double.isNaN(d3)) ? origin * d.getY() / (double)2 : (!(!Double.isInfinite(d3 = oSlope) && !Double.isNaN(d3)) ? 0.0 : origin * d.getY() / (double)2);
        return new DoubleVector(mid.getX() + tmpOY, mid.getY() - tmpOX);
    }
}

