/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.aes.AesScaling;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.TextLegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.HintColorUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.TextUtil;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.core.plot.base.render.svg.MultilineLabel;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Text;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetCollector;
import org.jetbrains.letsPlot.core.plot.base.tooltip.TipLayoutHint;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\b\u0016\u0018\u0000 02\u00020\u0001:\u00010B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0014J:\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020+2\u0006\u0010!\u001a\u00020\"2\b\u0010,\u001a\u0004\u0018\u00010(H\u0016J\u001a\u0010-\u001a\u00020\u00062\b\u0010.\u001a\u0004\u0018\u00010\u00052\u0006\u0010/\u001a\u00020\"H\u0002R(\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013\u00a8\u00061"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/TextGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "()V", "formatter", "Lkotlin/Function1;", "", "", "getFormatter", "()Lkotlin/jvm/functions/Function1;", "setFormatter", "(Lkotlin/jvm/functions/Function1;)V", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "naValue", "getNaValue", "()Ljava/lang/String;", "setNaValue", "(Ljava/lang/String;)V", "sizeUnit", "getSizeUnit", "setSizeUnit", "buildIntern", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "buildTextComponent", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGElement;", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "location", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "text", "sizeUnitRatio", "", "boundsCenter", "toString", "label", "geomContext", "Companion", "plot-base"})
public class TextGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Function1<Object, String> formatter;
    @NotNull
    private String naValue = "n/a";
    @Nullable
    private String sizeUnit;
    @NotNull
    public static final String DEF_NA_VALUE = "n/a";
    public static final boolean HANDLES_GROUPS = false;
    private static final double BASELINE_TEXT_WIDTH = 6.0;

    @Nullable
    public final Function1<Object, String> getFormatter() {
        return this.formatter;
    }

    public final void setFormatter(@Nullable Function1<Object, String> function1) {
        this.formatter = function1;
    }

    @NotNull
    public final String getNaValue() {
        return this.naValue;
    }

    public final void setNaValue(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.naValue = string;
    }

    @Nullable
    public final String getSizeUnit() {
        return this.sizeUnit;
    }

    public final void setSizeUnit(@Nullable String string) {
        this.sizeUnit = string;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return new TextLegendKeyElementFactory();
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        GeomHelper helper2 = new GeomHelper(pos, coord, ctx2);
        GeomTargetCollector targetCollector = this.getGeomTargetCollector(ctx2);
        Function1<DataPointAesthetics, List<Color>> colorsByDataPoint = HintColorUtil.INSTANCE.createColorMarkerMapper(GeomKind.TEXT, ctx2);
        DoubleRectangle doubleRectangle = coord.toClient(ctx2.getAesBounds());
        DoubleVector aesBoundsCenter = doubleRectangle != null ? doubleRectangle.getCenter() : null;
        for (DataPointAesthetics p : aesthetics2.dataPoints()) {
            double d;
            Double x2 = p.x();
            Double y2 = p.y();
            String text2 = this.toString(p.label(), ctx2);
            if (!SeriesUtil.INSTANCE.allFinite(x2, y2) || !(((CharSequence)text2).length() > 0)) continue;
            Double d2 = x2;
            Intrinsics.checkNotNull((Object)d2);
            double d3 = d2;
            Double d4 = y2;
            Intrinsics.checkNotNull((Object)d4);
            DoubleVector point2 = new DoubleVector(d3, d4);
            DoubleVector loc = helper2.toClient(point2, p);
            if (loc == null) continue;
            if (this.sizeUnit == null) {
                d = 1.0;
            } else {
                String string = this.sizeUnit;
                Intrinsics.checkNotNull((Object)string);
                d = TextGeom.Companion.getSizeUnitRatio(point2, coord, string);
            }
            double sizeUnitRatio = d;
            SvgGElement g = this.buildTextComponent(p, loc, text2, sizeUnitRatio, ctx2, aesBoundsCenter);
            root.add(g);
            targetCollector.addPoint(p.index(), loc, sizeUnitRatio * AesScaling.INSTANCE.textSize(p) / (double)2, new GeomTargetCollector.TooltipParams(null, null, null, (List)colorsByDataPoint.invoke((Object)p), 7, null), TipLayoutHint.Kind.CURSOR_TOOLTIP);
        }
    }

    @NotNull
    public SvgGElement buildTextComponent(@NotNull DataPointAesthetics p, @NotNull DoubleVector location2, @NotNull String text2, double sizeUnitRatio, @NotNull GeomContext ctx2, @Nullable DoubleVector boundsCenter) {
        double d;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        MultilineLabel label2 = new MultilineLabel(text2);
        TextUtil.INSTANCE.decorate(label2, p, sizeUnitRatio, true);
        Text.HorizontalAnchor hAnchor = TextUtil.INSTANCE.hAnchor(p, location2, boundsCenter);
        label2.setHorizontalAnchor(hAnchor);
        double fontSize = TextUtil.INSTANCE.fontSize(p, sizeUnitRatio);
        double textHeight = TextUtil.INSTANCE.measure(text2, p, ctx2, sizeUnitRatio).getY();
        switch (WhenMappings.$EnumSwitchMapping$0[TextUtil.INSTANCE.vAnchor(p, location2, boundsCenter).ordinal()]) {
            case 1: {
                d = location2.getY() + fontSize * 0.7;
                break;
            }
            case 2: {
                d = location2.getY() - textHeight + fontSize;
                break;
            }
            case 3: {
                d = location2.getY() - textHeight / (double)2 + fontSize * 0.8;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        double yPosition = d;
        DoubleVector textLocation = new DoubleVector(location2.getX(), yPosition);
        label2.moveTo(textLocation);
        SvgGElement g = new SvgGElement();
        g.children().add(label2.getRootGroup());
        SvgUtils.INSTANCE.transformRotate(g, TextUtil.INSTANCE.angle(p), location2.getX(), location2.getY());
        return g;
    }

    private final String toString(Object label2, GeomContext geomContext) {
        if (label2 == null) {
            return this.naValue;
        }
        Function1<Object, String> function1 = this.formatter;
        if (function1 == null) {
            function1 = geomContext.getDefaultFormatter(Aes.Companion.getLABEL());
        }
        Function1<Object, String> formatter2 = function1;
        return (String)formatter2.invoke(label2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/TextGeom$Companion;", "", "()V", "BASELINE_TEXT_WIDTH", "", "DEF_NA_VALUE", "", "HANDLES_GROUPS", "", "getSizeUnitRatio", "p", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "axis", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        private final double getSizeUnitRatio(DoubleVector p, CoordinateSystem coord, String axis) {
            double d;
            DoubleVector unitSquareSize = coord.unitSize(p);
            String string = axis.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String string2 = string;
            if (Intrinsics.areEqual((Object)string2, (Object)"x")) {
                d = unitSquareSize.getX();
            } else if (Intrinsics.areEqual((Object)string2, (Object)"y")) {
                d = unitSquareSize.getY();
            } else {
                throw new IllegalStateException(("Size unit value must be either 'x' or 'y', but was " + axis + '.').toString());
            }
            double unitSize = d;
            return unitSize / 6.0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Text.VerticalAnchor.values().length];
            try {
                nArray[Text.VerticalAnchor.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Text.VerticalAnchor.BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Text.VerticalAnchor.CENTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

