/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.builder.layout.AxisLayoutInfoQuad;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b!\u0018\u00002\u00020\u0001B\u0081\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u001a\b\u0002\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00100\u000f\u0012\u0016\b\u0002\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0010\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\u0006\u0010)\u001a\u00020\u0012J\u0006\u0010*\u001a\u00020\u0012J\u0006\u0010+\u001a\u00020\u0012J\u0006\u0010,\u001a\u00020\u0012J\u000e\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u0003J\u000e\u0010/\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u0003J\u0016\u00100\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ6\u00101\u001a\u00020\u00002\u0018\u00102\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00100\u000f2\u0014\u00103\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0010J\u0006\u00104\u001a\u00020\u0000J\u000e\u00105\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R#\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001f\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001eR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010#\u00a8\u00066"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutInfo;", "", "offset", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "geomWithAxisBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "geomOuterBounds", "geomInnerBounds", "geomContentBounds", "axisInfos", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutInfoQuad;", "hAxisShown", "", "vAxisShown", "facetXLabels", "", "Lkotlin/Pair;", "", "", "facetYLabel", "trueIndex", "", "(Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutInfoQuad;ZZLjava/util/List;Lkotlin/Pair;I)V", "getAxisInfos", "()Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutInfoQuad;", "getFacetXLabels", "()Ljava/util/List;", "getFacetYLabel", "()Lkotlin/Pair;", "getGeomContentBounds", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "getGeomInnerBounds", "getGeomOuterBounds", "getGeomWithAxisBounds", "getHAxisShown", "()Z", "getOffset", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getTrueIndex", "()I", "getVAxisShown", "axisThicknessX", "axisThicknessY", "geomOuterHeight", "geomOuterWidth", "getAbsoluteBounds", "tilesOrigin", "getAbsoluteOuterGeomBounds", "withAxisShown", "withFacetLabels", "xLabels", "yLabel", "withNormalizedOrigin", "withOffset", "plot-builder"})
public final class TileLayoutInfo {
    @NotNull
    private final DoubleVector offset;
    @NotNull
    private final DoubleRectangle geomWithAxisBounds;
    @NotNull
    private final DoubleRectangle geomOuterBounds;
    @NotNull
    private final DoubleRectangle geomInnerBounds;
    @NotNull
    private final DoubleRectangle geomContentBounds;
    @NotNull
    private final AxisLayoutInfoQuad axisInfos;
    @NotNull
    private final List<Pair<String, Double>> facetXLabels;
    @Nullable
    private final Pair<String, Double> facetYLabel;
    private final int trueIndex;
    private final boolean hAxisShown;
    private final boolean vAxisShown;

    public TileLayoutInfo(@NotNull DoubleVector offset2, @NotNull DoubleRectangle geomWithAxisBounds, @NotNull DoubleRectangle geomOuterBounds, @NotNull DoubleRectangle geomInnerBounds, @NotNull DoubleRectangle geomContentBounds, @NotNull AxisLayoutInfoQuad axisInfos, boolean hAxisShown, boolean vAxisShown, @NotNull List<Pair<String, Double>> facetXLabels, @Nullable Pair<String, Double> facetYLabel, int trueIndex) {
        Intrinsics.checkNotNullParameter((Object)offset2, (String)"offset");
        Intrinsics.checkNotNullParameter((Object)geomWithAxisBounds, (String)"geomWithAxisBounds");
        Intrinsics.checkNotNullParameter((Object)geomOuterBounds, (String)"geomOuterBounds");
        Intrinsics.checkNotNullParameter((Object)geomInnerBounds, (String)"geomInnerBounds");
        Intrinsics.checkNotNullParameter((Object)geomContentBounds, (String)"geomContentBounds");
        Intrinsics.checkNotNullParameter((Object)axisInfos, (String)"axisInfos");
        Intrinsics.checkNotNullParameter(facetXLabels, (String)"facetXLabels");
        this.offset = offset2;
        this.geomWithAxisBounds = geomWithAxisBounds;
        this.geomOuterBounds = geomOuterBounds;
        this.geomInnerBounds = geomInnerBounds;
        this.geomContentBounds = geomContentBounds;
        this.axisInfos = axisInfos;
        this.facetXLabels = facetXLabels;
        this.facetYLabel = facetYLabel;
        this.trueIndex = trueIndex;
        this.hAxisShown = (this.axisInfos.getTop() != null || this.axisInfos.getBottom() != null) && hAxisShown;
        this.vAxisShown = (this.axisInfos.getLeft() != null || this.axisInfos.getRight() != null) && vAxisShown;
    }

    public /* synthetic */ TileLayoutInfo(DoubleVector doubleVector, DoubleRectangle doubleRectangle, DoubleRectangle doubleRectangle2, DoubleRectangle doubleRectangle3, DoubleRectangle doubleRectangle4, AxisLayoutInfoQuad axisLayoutInfoQuad, boolean bl, boolean bl2, List list2, Pair pair2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x100) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n2 & 0x200) != 0) {
            pair2 = null;
        }
        this(doubleVector, doubleRectangle, doubleRectangle2, doubleRectangle3, doubleRectangle4, axisLayoutInfoQuad, bl, bl2, list2, (Pair<String, Double>)pair2, n);
    }

    @NotNull
    public final DoubleVector getOffset() {
        return this.offset;
    }

    @NotNull
    public final DoubleRectangle getGeomWithAxisBounds() {
        return this.geomWithAxisBounds;
    }

    @NotNull
    public final DoubleRectangle getGeomOuterBounds() {
        return this.geomOuterBounds;
    }

    @NotNull
    public final DoubleRectangle getGeomInnerBounds() {
        return this.geomInnerBounds;
    }

    @NotNull
    public final DoubleRectangle getGeomContentBounds() {
        return this.geomContentBounds;
    }

    @NotNull
    public final AxisLayoutInfoQuad getAxisInfos() {
        return this.axisInfos;
    }

    @NotNull
    public final List<Pair<String, Double>> getFacetXLabels() {
        return this.facetXLabels;
    }

    @Nullable
    public final Pair<String, Double> getFacetYLabel() {
        return this.facetYLabel;
    }

    public final int getTrueIndex() {
        return this.trueIndex;
    }

    public final boolean getHAxisShown() {
        return this.hAxisShown;
    }

    public final boolean getVAxisShown() {
        return this.vAxisShown;
    }

    @NotNull
    public final DoubleRectangle getAbsoluteBounds(@NotNull DoubleVector tilesOrigin) {
        Intrinsics.checkNotNullParameter((Object)tilesOrigin, (String)"tilesOrigin");
        DoubleVector offset2 = tilesOrigin.add(this.offset);
        return this.geomWithAxisBounds.add(offset2);
    }

    @NotNull
    public final DoubleRectangle getAbsoluteOuterGeomBounds(@NotNull DoubleVector tilesOrigin) {
        Intrinsics.checkNotNullParameter((Object)tilesOrigin, (String)"tilesOrigin");
        DoubleVector offset2 = tilesOrigin.add(this.offset);
        return this.geomOuterBounds.add(offset2);
    }

    public final double axisThicknessX() {
        return this.geomWithAxisBounds.getBottom() - this.geomOuterBounds.getBottom();
    }

    public final double axisThicknessY() {
        return this.geomOuterBounds.getLeft() - this.geomWithAxisBounds.getLeft();
    }

    public final double geomOuterWidth() {
        return this.geomOuterBounds.getWidth();
    }

    public final double geomOuterHeight() {
        return this.geomOuterBounds.getHeight();
    }

    @NotNull
    public final TileLayoutInfo withOffset(@NotNull DoubleVector offset2) {
        Intrinsics.checkNotNullParameter((Object)offset2, (String)"offset");
        return new TileLayoutInfo(offset2, this.geomWithAxisBounds, this.geomOuterBounds, this.geomInnerBounds, this.geomContentBounds, this.axisInfos, this.hAxisShown, this.vAxisShown, this.facetXLabels, this.facetYLabel, this.trueIndex);
    }

    @NotNull
    public final TileLayoutInfo withFacetLabels(@NotNull List<Pair<String, Double>> xLabels, @Nullable Pair<String, Double> yLabel) {
        Intrinsics.checkNotNullParameter(xLabels, (String)"xLabels");
        return new TileLayoutInfo(this.offset, this.geomWithAxisBounds, this.geomOuterBounds, this.geomInnerBounds, this.geomContentBounds, this.axisInfos, this.hAxisShown, this.vAxisShown, xLabels, yLabel, this.trueIndex);
    }

    @NotNull
    public final TileLayoutInfo withAxisShown(boolean hAxisShown, boolean vAxisShown) {
        return new TileLayoutInfo(this.offset, this.geomWithAxisBounds, this.geomOuterBounds, this.geomInnerBounds, this.geomContentBounds, this.axisInfos, hAxisShown, vAxisShown, this.facetXLabels, this.facetYLabel, this.trueIndex);
    }

    @NotNull
    public final TileLayoutInfo withNormalizedOrigin() {
        DoubleVector geomWithAxisOrigin = this.geomWithAxisBounds.getOrigin();
        DoubleRectangle geomWithAxisBounds = this.geomWithAxisBounds.subtract(geomWithAxisOrigin);
        DoubleRectangle geomOuterBounds = this.geomOuterBounds.subtract(geomWithAxisOrigin);
        DoubleRectangle geomInnerBounds = this.geomInnerBounds.subtract(geomWithAxisOrigin);
        DoubleRectangle geomContentBounds = this.geomContentBounds.subtract(geomWithAxisOrigin);
        return new TileLayoutInfo(this.offset, geomWithAxisBounds, geomOuterBounds, geomInnerBounds, geomContentBounds, this.axisInfos, this.hAxisShown, this.vAxisShown, this.facetXLabels, this.facetYLabel, this.trueIndex);
    }
}

