/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.project;

import com.intellij.lang.puppet.project.PuppetEntity;
import com.intellij.lang.puppet.project.PuppetModule;
import com.intellij.lang.puppet.project.PuppetProjectManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class PuppetProjectModel {
    private static final Logger LOG = Logger.getInstance(PuppetProjectModel.class);
    private final ReentrantReadWriteLock myLock = new ReentrantReadWriteLock(true);
    private final Map<VirtualFile, PuppetEntity> myRootsMap = new HashMap<VirtualFile, PuppetEntity>();
    private final MultiMap<VirtualFile, VirtualFile> myImplicitRootsMap = new MultiMap();
    private Runnable myChangeListener;

    void clear() {
        if ((Integer)this.write(() -> {
            int rootsNumber = this.myRootsMap.size() + this.myImplicitRootsMap.size();
            this.myRootsMap.clear();
            this.myImplicitRootsMap.clear();
            return rootsNumber;
        }) > 0) {
            this.onChange();
        }
    }

    @NotNull
    public List<VirtualFile> getAllRoots() {
        List list = (List)this.read(() -> new ArrayList<VirtualFile>(this.myRootsMap.keySet()));
        if (list == null) {
            PuppetProjectModel.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public List<PuppetModule> getAllModules() {
        List list = (List)this.read(() -> ContainerUtil.mapNotNull(this.myRootsMap.values(), entity -> entity instanceof PuppetModule ? (PuppetModule)entity : null));
        if (list == null) {
            PuppetProjectModel.$$$reportNull$$$0(1);
        }
        return list;
    }

    @TestOnly
    public Pair<Map<VirtualFile, PuppetEntity>, MultiMap<VirtualFile, VirtualFile>> getRootsData() {
        return (Pair)this.read(() -> Pair.create(new HashMap<VirtualFile, PuppetEntity>(this.myRootsMap), (Object)new MultiMap(this.myImplicitRootsMap)));
    }

    void addEntity(@NotNull PuppetEntity entity) {
        if (entity == null) {
            PuppetProjectModel.$$$reportNull$$$0(2);
        }
        LOG.debug("Adding entity " + entity);
        if (((Boolean)this.write(() -> {
            if (entity.equals(this.myRootsMap.get(entity.getRoot()))) {
                return false;
            }
            this.myRootsMap.put(entity.getRoot(), entity);
            return true;
        })).booleanValue()) {
            this.onChange();
        }
    }

    void removeRoot(@NotNull VirtualFile root) {
        if (root == null) {
            PuppetProjectModel.$$$reportNull$$$0(3);
        }
        LOG.debug("Removing root: " + root);
        if (((Boolean)this.write(() -> {
            if (!this.myRootsMap.containsKey(root)) {
                return false;
            }
            this.myRootsMap.remove(root);
            Iterator iterator = this.myImplicitRootsMap.get((Object)root).iterator();
            while (iterator.hasNext()) {
                this.myRootsMap.remove(iterator.next());
                iterator.remove();
            }
            return true;
        })).booleanValue()) {
            this.onChange();
        }
    }

    private void onChange() {
        Runnable listener = this.myChangeListener;
        if (listener != null) {
            listener.run();
        }
    }

    void addImplicitEntity(@NotNull PuppetEntity entity, @NotNull VirtualFile parentEntityRoot) {
        if (entity == null) {
            PuppetProjectModel.$$$reportNull$$$0(4);
        }
        if (parentEntityRoot == null) {
            PuppetProjectModel.$$$reportNull$$$0(5);
        }
        LOG.debug("Adding implicit entity " + entity + " for parent entityRoot " + parentEntityRoot);
        this.write(() -> {
            this.myImplicitRootsMap.putValue((Object)parentEntityRoot, (Object)entity.getRoot());
            this.addEntity(entity);
        });
    }

    @Nullable
    public PuppetEntity getPuppetModuleOrEnvironment(@Nullable VirtualFile root) {
        if (root == null) {
            return null;
        }
        return (PuppetEntity)this.read(() -> this.myRootsMap.get(root));
    }

    public void setChangeListener(@Nullable Runnable changeListener) {
        this.myChangeListener = changeListener;
    }

    private <T> T read(@NotNull Computable<T> computable) {
        if (computable == null) {
            PuppetProjectModel.$$$reportNull$$$0(6);
        }
        this.myLock.readLock().lock();
        try {
            Object object = computable.compute();
            return (T)object;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    private void write(@NotNull Runnable runnable) {
        if (runnable == null) {
            PuppetProjectModel.$$$reportNull$$$0(7);
        }
        this.write(() -> {
            runnable.run();
            return null;
        });
    }

    private <T> T write(@NotNull Computable<T> computable) {
        if (computable == null) {
            PuppetProjectModel.$$$reportNull$$$0(8);
        }
        this.myLock.writeLock().lock();
        try {
            Object object = computable.compute();
            return (T)object;
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    @NotNull
    public static PuppetProjectModel getInstance(@NotNull Project project) {
        if (project == null) {
            PuppetProjectModel.$$$reportNull$$$0(9);
        }
        PuppetProjectModel puppetProjectModel = PuppetProjectManager.getInstance(project).getModel();
        if (puppetProjectModel == null) {
            PuppetProjectModel.$$$reportNull$$$0(10);
        }
        return puppetProjectModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/project/PuppetProjectModel";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentEntityRoot";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllRoots";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllModules";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/project/PuppetProjectModel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addEntity";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeRoot";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addImplicitEntity";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

