/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.PresentableId;
import com.intellij.remote.RemoteCredentialException;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.SshConfigCredentialsHolder;
import com.intellij.remote.ext.CredentialsEditor;
import com.intellij.remote.ext.CredentialsLanguageContribution;
import com.intellij.remote.ext.PathsBrowserDialogProvider;
import com.intellij.remote.ext.RemoteCredentialsHandler;
import com.intellij.remote.ext.SshConfigCredentialsHandler;
import com.intellij.remote.ui.BundleAccessor;
import com.intellij.remote.ui.CredentialsEditorProvider;
import com.intellij.remote.ui.RemoteSdkEditorForm;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.ui.unified.SshUiData;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import com.jetbrains.plugins.remotesdk.SshConfigCredentialsEditor;
import com.jetbrains.plugins.remotesdk.SshConfigCredentialsLanguageContribution;
import com.jetbrains.plugins.remotesdk.ui.SshBrowseActionListenerUtil;
import java.util.function.Supplier;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshConfigCredentialsType
extends CredentialsType<SshConfigCredentialsHolder>
implements CredentialsEditorProvider,
PathsBrowserDialogProvider {
    private static final Key<SshConfigCredentialsHolder> SSH_CONFIG_BASED_CREDENTIALS = Key.create((String)"SSH_CONFIG_BASED_CREDENTIALS");

    public static SshConfigCredentialsType getInstance() {
        return (SshConfigCredentialsType)((Object)EP_NAME.findExtensionOrFail(SshConfigCredentialsType.class));
    }

    protected SshConfigCredentialsType() {
        super(RemoteSdkBundle.message("ssh.configuration.credential.type.name", new Object[0]), "sshConfig://");
    }

    public static RemoteCredentials createRemoteCredentials(Project project, SshConfigCredentialsHolder credentials) {
        PresentableId sshId = credentials.getSshId();
        if (sshId == null) {
            throw new RemoteCredentialException(RemoteSdkBundle.message("exception.ssh.configuration.is.not.provided", new Object[0]));
        }
        SshUiData sshUiData = SshConfigManager.getInstance((Project)project).findCurrentData(sshId);
        if (sshUiData == null) {
            throw new RemoteCredentialException(RemoteSdkBundle.message("exception.can.t.get.remote.credentials.for.ssh.configuration.0", sshId));
        }
        return sshUiData.copyToCredentials();
    }

    public Key<SshConfigCredentialsHolder> getCredentialsKey() {
        return SSH_CONFIG_BASED_CREDENTIALS;
    }

    public RemoteCredentialsHandler getHandler(SshConfigCredentialsHolder credentials) {
        return new SshConfigCredentialsHandler(credentials);
    }

    public SshConfigCredentialsHolder createCredentials() {
        return new SshConfigCredentialsHolder();
    }

    public boolean isAvailable(CredentialsLanguageContribution languageContribution) {
        return languageContribution instanceof SshConfigCredentialsLanguageContribution;
    }

    public CredentialsEditor<SshConfigCredentialsHolder> createEditor(@Nullable Project project, CredentialsLanguageContribution languageContribution, @NotNull RemoteSdkEditorForm parentForm) {
        if (parentForm == null) {
            SshConfigCredentialsType.$$$reportNull$$$0(0);
        }
        return new SshConfigCredentialsEditor(project, parentForm);
    }

    public String getDefaultInterpreterPath(BundleAccessor bundleAccessor) {
        return bundleAccessor.message("remote.interpreter.default.interpreter.path", new Object[0]);
    }

    public void showPathsBrowserDialog(@Nullable Project project, @NotNull JTextField textField, @NotNull @NlsContexts.DialogTitle String dialogTitle, @NotNull Supplier<? extends RemoteSdkAdditionalData> supplier) {
        if (textField == null) {
            SshConfigCredentialsType.$$$reportNull$$$0(1);
        }
        if (dialogTitle == null) {
            SshConfigCredentialsType.$$$reportNull$$$0(2);
        }
        if (supplier == null) {
            SshConfigCredentialsType.$$$reportNull$$$0(3);
        }
        SshBrowseActionListenerUtil.showBrowseDialog(project, textField, dialogTitle, false, supplier);
    }

    public int getWeight() {
        return 10;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentForm";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialogTitle";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/remotesdk/SshConfigCredentialsType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createEditor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showPathsBrowserDialog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

